/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.support.metrics.submitters;

import io.confluent.support.metrics.common.kafka.ZkClientProvider;
import io.confluent.support.metrics.submitters.KafkaSubmitter;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Mockito;

public class KafkaSubmitterTest {
    private static ZkClientProvider zkClientProvider;

    @BeforeClass
    public static void startCluster() {
        zkClientProvider = (ZkClientProvider)Mockito.mock(ZkClientProvider.class);
    }

    @Test
    public void testInvalidArgumentsForConstructorNullServer() {
        ZkClientProvider nullServer = null;
        String anyTopic = "valueNotRelevant";
        try {
            new KafkaSubmitter(nullServer, anyTopic);
            Assert.fail((String)"IllegalArgumentException expected because server is null");
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("must specify zkClientProvider"));
        }
    }

    @Test
    public void testInvalidArgumentsForConstructorNullTopic() {
        String nullTopic = null;
        try {
            new KafkaSubmitter(zkClientProvider, nullTopic);
            Assert.fail((String)"IllegalArgumentException expected because topic is null");
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("must specify topic"));
        }
    }

    @Test
    public void testInvalidArgumentsForConstructorEmptyTopic() {
        String emptyTopic = "";
        try {
            new KafkaSubmitter(zkClientProvider, emptyTopic);
            Assert.fail((String)"IllegalArgumentException expected because topic is the empty string");
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("must specify topic"));
        }
    }

    @Test
    public void testSubmitIgnoresNullInput() {
        String anyTopic = "valueNotRelevant";
        KafkaSubmitter k = new KafkaSubmitter(zkClientProvider, anyTopic);
        Producer producer = (Producer)Mockito.mock(Producer.class);
        byte[] nullData = null;
        k.submit(nullData, producer);
        Mockito.verifyZeroInteractions((Object[])new Object[]{producer});
    }

    @Test
    public void testSubmitIgnoresEmptyInput() {
        String anyTopic = "valueNotRelevant";
        KafkaSubmitter k = new KafkaSubmitter(zkClientProvider, anyTopic);
        Producer producer = (Producer)Mockito.mock(Producer.class);
        byte[] emptyData = new byte[]{};
        k.submit(emptyData, producer);
        Mockito.verifyZeroInteractions((Object[])new Object[]{producer});
    }

    @Test
    public void testSubmit() {
        String anyTopic = "valueNotRelevant";
        KafkaSubmitter k = new KafkaSubmitter(zkClientProvider, anyTopic);
        Producer producer = (Producer)Mockito.mock(Producer.class);
        byte[] anyData = "anyData".getBytes();
        k.submit(anyData, producer);
        ((Producer)Mockito.verify((Object)producer)).send((ProducerRecord)Mockito.any(ProducerRecord.class));
    }
}

