/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.support.metrics.submitters;

import io.confluent.support.metrics.BaseSupportConfig;
import io.confluent.support.metrics.submitters.ConfluentSubmitter;
import io.confluent.support.metrics.submitters.ResponseHandler;
import io.confluent.support.metrics.utils.CustomerIdExamples;
import io.confluent.support.metrics.utils.StringUtils;
import org.apache.http.HttpResponse;
import org.junit.Assert;
import org.junit.Test;

public class ConfluentSubmitterTest {
    private String customerId = "anonymous";

    @Test
    public void testInvalidArgumentsForConstructorNullEndpoints() {
        String httpEndpoint = null;
        String httpsEndpoint = null;
        try {
            new ConfluentSubmitter(this.customerId, httpEndpoint, httpsEndpoint);
            Assert.fail((String)"IllegalArgumentException expected because endpoints are null");
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("must specify endpoints"));
        }
    }

    @Test
    public void testInvalidArgumentsForConstructorEmptyEndpoints() {
        String httpEndpoint = "";
        String httpsEndpoint = "";
        try {
            new ConfluentSubmitter(this.customerId, httpEndpoint, httpsEndpoint);
            Assert.fail((String)"IllegalArgumentException expected because endpoints are empty");
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("must specify endpoints"));
        }
    }

    @Test
    public void testInvalidArgumentsForConstructorNullEmptyEndpoints() {
        String httpEndpoint = null;
        String httpsEndpoint = "";
        try {
            new ConfluentSubmitter(this.customerId, httpEndpoint, httpsEndpoint);
            Assert.fail((String)"IllegalArgumentException expected because endpoints are null/empty");
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("must specify endpoints"));
        }
    }

    @Test
    public void testInvalidArgumentsForConstructorEmptyNullEndpoints() {
        String httpEndpoint = "";
        String httpsEndpoint = null;
        try {
            new ConfluentSubmitter(this.customerId, httpEndpoint, httpsEndpoint);
            Assert.fail((String)"IllegalArgumentException expected because endpoints are empty/null");
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("must specify endpoints"));
        }
    }

    @Test
    public void testValidArgumentsForConstructor() {
        String httpEndpoint = "http://example.com";
        String httpsEndpoint = "https://example.com";
        new ConfluentSubmitter(this.customerId, httpEndpoint, httpsEndpoint);
    }

    @Test
    public void testValidArgumentsForPhoneHomeConstructorWithoutCustomerId() {
        ConfluentSubmitter submitter = new ConfluentSubmitter("test-component", null);
        Assert.assertTrue((boolean)StringUtils.isNullOrEmpty((CharSequence)submitter.getProxy()));
        Assert.assertEquals((Object)BaseSupportConfig.getEndpoint((boolean)false, (String)"anonymous", (String)"test-component"), (Object)submitter.getEndpointHTTP());
        Assert.assertEquals((Object)BaseSupportConfig.getEndpoint((boolean)true, (String)"anonymous", (String)"test-component"), (Object)submitter.getEndpointHTTPS());
    }

    @Test
    public void testValidArgumentsForPhoneHomeConstructorWithCustomerId() {
        String customerId = "c0";
        ResponseHandler responseHandler = new ResponseHandler(){

            public void handle(HttpResponse response) {
            }
        };
        ConfluentSubmitter submitter = new ConfluentSubmitter("c0", "test-component", responseHandler);
        Assert.assertTrue((boolean)StringUtils.isNullOrEmpty((CharSequence)submitter.getProxy()));
        Assert.assertEquals((Object)BaseSupportConfig.getEndpoint((boolean)false, (String)"c0", (String)"test-component"), (Object)submitter.getEndpointHTTP());
        Assert.assertEquals((Object)BaseSupportConfig.getEndpoint((boolean)true, (String)"c0", (String)"test-component"), (Object)submitter.getEndpointHTTPS());
    }

    @Test
    public void testInvalidArgumentsForConstructorInvalidHttpEndpoint() {
        String httpEndpoint = "invalid URL";
        String httpsEndpoint = "https://example.com";
        try {
            new ConfluentSubmitter(this.customerId, httpEndpoint, httpsEndpoint);
            Assert.fail((String)"IllegalArgumentException expected because endpoints are invalid");
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)e.getMessage().startsWith("invalid HTTP endpoint"));
        }
    }

    @Test
    public void testInvalidArgumentsForConstructorInvalidHttpsEndpoint() {
        String httpEndpoint = "http://example.com";
        String httpsEndpoint = "invalid URL";
        try {
            new ConfluentSubmitter(this.customerId, httpEndpoint, httpsEndpoint);
            Assert.fail((String)"IllegalArgumentException expected because endpoints are invalid");
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)e.getMessage().startsWith("invalid HTTPS endpoint"));
        }
    }

    @Test
    public void testInvalidArgumentsForConstructorMismatchedEndpoints() {
        String httpEndpoint = "http://example.com";
        String httpsEndpoint = "https://example.com";
        try {
            new ConfluentSubmitter(this.customerId, httpsEndpoint, httpEndpoint);
            Assert.fail((String)"IllegalArgumentException expected because endpoints were provided in the wrong order");
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)e.getMessage().startsWith("invalid HTTP endpoint"));
        }
    }

    @Test
    public void testInvalidArgumentsForConstructorCustomerIdInvalid() {
        String httpEndpoint = "http://example.com";
        String httpsEndpoint = "https://example.com";
        for (String invalidCustomerId : CustomerIdExamples.INVALID_CUSTOMER_IDS) {
            try {
                new ConfluentSubmitter(invalidCustomerId, httpEndpoint, httpsEndpoint);
                Assert.fail((String)"IllegalArgumentException expected because customer ID is invalid");
            }
            catch (IllegalArgumentException e) {
                Assert.assertTrue((boolean)e.getMessage().startsWith("invalid customer ID"));
            }
        }
    }

    @Test
    public void testInvalidArgumentsForConstructorAnonymousIdInvalid() {
        String httpEndpoint = "http://example.com";
        String httpsEndpoint = "https://example.com";
        for (String invalidCustomerId : CustomerIdExamples.INVALID_ANONYMOUS_IDS) {
            try {
                new ConfluentSubmitter(invalidCustomerId, httpEndpoint, httpsEndpoint);
                Assert.fail((String)"IllegalArgumentException expected because customer ID is invalid");
            }
            catch (IllegalArgumentException e) {
                Assert.assertTrue((boolean)e.getMessage().startsWith("invalid customer ID"));
            }
        }
    }

    @Test
    public void testInvalidArgumentsForConstructorWithProxy() {
        String httpEndpoint = "http://example.com";
        String httpsEndpoint = "https://example.com";
        String proxyURI = null;
        ConfluentSubmitter submitter = new ConfluentSubmitter(this.customerId, httpEndpoint, httpsEndpoint, proxyURI, null);
        Assert.assertTrue((submitter.getProxy() == null ? 1 : 0) != 0);
        proxyURI = "https://proxy.example.com";
        submitter = new ConfluentSubmitter(this.customerId, httpEndpoint, httpsEndpoint, proxyURI, null);
        Assert.assertEquals((Object)proxyURI, (Object)submitter.getProxy());
    }
}

