/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.support.metrics.common.kafka;

import io.confluent.support.metrics.common.kafka.EmbeddedKafkaCluster;
import io.confluent.support.metrics.common.kafka.KafkaUtilities;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Random;
import kafka.server.KafkaServer;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.common.TopicPartition;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import scala.collection.JavaConverters;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Set;

public class KafkaUtilitiesTest {
    private static final KafkaZkClient MOCK_ZK_CLIENT = (KafkaZkClient)Mockito.mock(KafkaZkClient.class);
    private static final int ANY_MAX_NUM_SERVERS = 2;
    private static final String ANY_TOPIC = "valueNotRelevant";
    private static final int ANY_PARTITIONS = 1;
    private static final int ANY_REPLICATION = 1;
    private static final long ANY_RETENTION_MS = 1000L;
    private static final long ONE_YEAR_RETENTION = 31536000000L;
    private static final String[] EXAMPLE_TOPICS = new String[]{"__confluent.support.metrics", "ANY_TOPIC", "basketball"};

    @Test
    public void getNumTopicsThrowsIAEWhenKafkaZkClientIsNull() {
        KafkaUtilities kUtil = new KafkaUtilities();
        try {
            kUtil.getNumTopics(null);
            Assert.fail((String)"IllegalArgumentException expected because zkClient is null");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void getNumTopicsReturnsMinusOneOnError() {
        KafkaUtilities kUtil = new KafkaUtilities();
        KafkaZkClient zkClient = (KafkaZkClient)Mockito.mock(KafkaZkClient.class);
        Mockito.when((Object)zkClient.getAllTopicsInCluster()).thenThrow(new Throwable[]{new RuntimeException("exception intentionally thrown by test")});
        Assert.assertEquals((long)-1L, (long)kUtil.getNumTopics(zkClient));
    }

    @Test
    public void getNumTopicsReturnsZeroWhenThereAreNoTopics() {
        KafkaUtilities kUtil = new KafkaUtilities();
        KafkaZkClient zkClient = (KafkaZkClient)Mockito.mock(KafkaZkClient.class);
        Mockito.when((Object)zkClient.getAllTopicsInCluster()).thenReturn((Object)((Set)JavaConverters.asScalaSetConverter(Collections.emptySet()).asScala()).toSet());
        Assert.assertEquals((long)0L, (long)kUtil.getNumTopics(zkClient));
    }

    @Test
    public void getNumTopicsReturnsCorrectNumber() {
        KafkaUtilities kUtil = new KafkaUtilities();
        KafkaZkClient zkClient = (KafkaZkClient)Mockito.mock(KafkaZkClient.class);
        HashSet<String> topics = new HashSet<String>();
        topics.add("topic1");
        topics.add("topic2");
        Mockito.when((Object)zkClient.getAllTopicsInCluster()).thenReturn((Object)((Set)JavaConverters.asScalaSetConverter(topics).asScala()).toSet());
        Assert.assertEquals((long)topics.size(), (long)kUtil.getNumTopics(zkClient));
    }

    @Test
    public void getBootstrapServersThrowsIAEWhenKafkaZkClientIsNull() {
        KafkaUtilities kUtil = new KafkaUtilities();
        try {
            kUtil.getBootstrapServers(null, 2);
            Assert.fail((String)"IllegalArgumentException expected because zkClient is null");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void getBootstrapServersThrowsIAEWhenMaxNumServersIsZero() {
        KafkaUtilities kUtil = new KafkaUtilities();
        int zeroMaxNumServers = 0;
        try {
            kUtil.getBootstrapServers(MOCK_ZK_CLIENT, zeroMaxNumServers);
            Assert.fail((String)"IllegalArgumentException expected because max number of servers is zero");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getBootstrapServersReturnsEmptyListWhenThereAreNoLiveBrokers() {
        KafkaUtilities kUtil = new KafkaUtilities();
        KafkaZkClient zkClient = (KafkaZkClient)Mockito.mock(KafkaZkClient.class);
        ArrayList empty = new ArrayList();
        Mockito.when((Object)zkClient.getAllBrokersInCluster()).thenReturn((Object)((Buffer)JavaConverters.asScalaBufferConverter(empty).asScala()).toSeq());
        Assert.assertTrue((boolean)kUtil.getBootstrapServers(zkClient, 2).isEmpty());
    }

    @Test
    public void createTopicThrowsIAEWhenKafkaZkClientIsNull() {
        KafkaUtilities kUtil = new KafkaUtilities();
        try {
            kUtil.createAndVerifyTopic(null, ANY_TOPIC, 1, 1, 1000L);
            Assert.fail((String)"IllegalArgumentException expected because zkClient is null");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void createTopicThrowsIAEWhenTopicIsNull() {
        KafkaUtilities kUtil = new KafkaUtilities();
        String nullTopic = null;
        try {
            kUtil.createAndVerifyTopic(MOCK_ZK_CLIENT, nullTopic, 1, 1, 1000L);
            Assert.fail((String)"IllegalArgumentException expected because topic is null");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createTopicThrowsIAEWhenTopicIsEmpty() {
        KafkaUtilities kUtil = new KafkaUtilities();
        String emptyTopic = "";
        try {
            kUtil.createAndVerifyTopic(MOCK_ZK_CLIENT, emptyTopic, 1, 1, 1000L);
            Assert.fail((String)"IllegalArgumentException expected because topic is empty");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createTopicThrowsIAEWhenNumberOfPartitionsIsZero() {
        KafkaUtilities kUtil = new KafkaUtilities();
        int zeroPartitions = 0;
        try {
            kUtil.createAndVerifyTopic(MOCK_ZK_CLIENT, ANY_TOPIC, zeroPartitions, 1, 1000L);
            Assert.fail((String)"IllegalArgumentException expected because number of partitions is zero");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createTopicThrowsIAEWhenReplicationFactorIsZero() {
        KafkaUtilities kUtil = new KafkaUtilities();
        int zeroReplication = 0;
        try {
            kUtil.createAndVerifyTopic(MOCK_ZK_CLIENT, ANY_TOPIC, 1, zeroReplication, 1000L);
            Assert.fail((String)"IllegalArgumentException expected because replication factor is zero");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createTopicThrowsIAEWhenRetentionMsIsZero() {
        KafkaUtilities kUtil = new KafkaUtilities();
        long zeroRetentionMs = 0L;
        try {
            kUtil.createAndVerifyTopic(MOCK_ZK_CLIENT, ANY_TOPIC, 1, 1, zeroRetentionMs);
            Assert.fail((String)"IllegalArgumentException expected because retention.ms is zero");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void verifySupportTopicThrowsIAEWhenKafkaZkClientIsNull() {
        KafkaUtilities kUtil = new KafkaUtilities();
        try {
            kUtil.verifySupportTopic(null, ANY_TOPIC, 1, 1);
            Assert.fail((String)"IllegalArgumentException expected because zkClient is null");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void verifySupportTopicThrowsIAEWhenTopicIsNull() {
        KafkaUtilities kUtil = new KafkaUtilities();
        String nullTopic = null;
        try {
            kUtil.verifySupportTopic(MOCK_ZK_CLIENT, nullTopic, 1, 1);
            Assert.fail((String)"IllegalArgumentException expected because topic is null");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void verifySupportTopicThrowsIAEWhenTopicIsEmpty() {
        KafkaUtilities kUtil = new KafkaUtilities();
        String emptyTopic = "";
        try {
            kUtil.verifySupportTopic(MOCK_ZK_CLIENT, emptyTopic, 1, 1);
            Assert.fail((String)"IllegalArgumentException expected because topic is empty");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void verifySupportTopicThrowsIAEWhenNumberOfPartitionsIsZero() {
        KafkaUtilities kUtil = new KafkaUtilities();
        int zeroPartitions = 0;
        try {
            kUtil.verifySupportTopic(MOCK_ZK_CLIENT, ANY_TOPIC, zeroPartitions, 1);
            Assert.fail((String)"IllegalArgumentException expected because number of partitions is zero");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void verifySupportTopicThrowsIAEWhenReplicationFactorIsZero() {
        KafkaUtilities kUtil = new KafkaUtilities();
        int zeroReplication = 0;
        try {
            kUtil.verifySupportTopic(MOCK_ZK_CLIENT, ANY_TOPIC, 1, zeroReplication);
            Assert.fail((String)"IllegalArgumentException expected because replication factor is zero");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void underreplicatedTopicsCanBeCreatedAndVerified() {
        KafkaUtilities kUtil = new KafkaUtilities();
        EmbeddedKafkaCluster cluster = new EmbeddedKafkaCluster();
        int numBrokers = 1;
        int partitions = numBrokers + 1;
        int replication = numBrokers + 1;
        cluster.startCluster(numBrokers);
        KafkaServer broker = cluster.getBroker(0);
        KafkaZkClient zkClient = broker.zkClient();
        for (String topic : EXAMPLE_TOPICS) {
            Assert.assertTrue((boolean)kUtil.createAndVerifyTopic(zkClient, topic, partitions, replication, 31536000000L));
            Assert.assertEquals((Object)KafkaUtilities.VerifyTopicState.Less, (Object)kUtil.verifySupportTopic(zkClient, topic, partitions, replication));
        }
        Assert.assertEquals((long)EXAMPLE_TOPICS.length, (long)kUtil.getNumTopics(zkClient));
        cluster.stopCluster();
        zkClient.close();
    }

    @Test
    public void underreplicatedTopicsCanBeRecreatedAndVerified() {
        KafkaUtilities kUtil = new KafkaUtilities();
        EmbeddedKafkaCluster cluster = new EmbeddedKafkaCluster();
        int numBrokers = 1;
        int partitions = numBrokers + 1;
        int replication = numBrokers + 1;
        cluster.startCluster(numBrokers);
        KafkaServer broker = cluster.getBroker(0);
        KafkaZkClient zkClient = broker.zkClient();
        for (String topic : EXAMPLE_TOPICS) {
            Assert.assertTrue((boolean)kUtil.createAndVerifyTopic(zkClient, topic, partitions, replication, 31536000000L));
            Assert.assertTrue((boolean)kUtil.createAndVerifyTopic(zkClient, topic, partitions, replication, 31536000000L));
            Assert.assertEquals((Object)KafkaUtilities.VerifyTopicState.Less, (Object)kUtil.verifySupportTopic(zkClient, topic, partitions, replication));
        }
        Assert.assertEquals((long)EXAMPLE_TOPICS.length, (long)kUtil.getNumTopics(zkClient));
        cluster.stopCluster();
    }

    @Test
    public void createTopicFailsWhenThereAreNoLiveBrokers() {
        KafkaUtilities kUtil = new KafkaUtilities();
        EmbeddedKafkaCluster cluster = new EmbeddedKafkaCluster();
        cluster.startCluster(1);
        KafkaServer broker = cluster.getBroker(0);
        KafkaZkClient defunctZkClient = broker.zkClient();
        cluster.stopCluster();
        Assert.assertFalse((boolean)kUtil.createAndVerifyTopic(defunctZkClient, ANY_TOPIC, 1, 1, 1000L));
    }

    @Test
    public void replicatedTopicsCanBeCreatedAndVerified() {
        KafkaUtilities kUtil = new KafkaUtilities();
        EmbeddedKafkaCluster cluster = new EmbeddedKafkaCluster();
        int numBrokers = 3;
        cluster.startCluster(numBrokers);
        KafkaServer broker = cluster.getBroker(0);
        KafkaZkClient zkClient = broker.zkClient();
        Random random = new Random();
        int replication = numBrokers;
        for (String topic : EXAMPLE_TOPICS) {
            int morePartitionsThanBrokers = random.nextInt(10) + numBrokers + 1;
            Assert.assertTrue((boolean)kUtil.createAndVerifyTopic(zkClient, topic, morePartitionsThanBrokers, replication, 31536000000L));
            Assert.assertEquals((Object)KafkaUtilities.VerifyTopicState.Exactly, (Object)kUtil.verifySupportTopic(zkClient, topic, morePartitionsThanBrokers, replication));
        }
        cluster.stopCluster();
    }

    @Test
    public void leaderIsElectedAfterCreateTopicReturns() {
        KafkaUtilities kUtil = new KafkaUtilities();
        EmbeddedKafkaCluster cluster = new EmbeddedKafkaCluster();
        int numBrokers = 3;
        cluster.startCluster(numBrokers);
        KafkaServer broker = cluster.getBroker(0);
        KafkaZkClient zkClient = broker.zkClient();
        int replication = numBrokers;
        Assert.assertTrue((boolean)kUtil.createAndVerifyTopic(zkClient, ANY_TOPIC, 1, replication, 31536000000L));
        Assert.assertTrue((boolean)zkClient.getLeaderForPartition(new TopicPartition(ANY_TOPIC, 0)).isDefined());
    }
}

