/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.support.metrics.common;

import io.confluent.support.metrics.common.Filter;
import java.util.HashSet;
import java.util.Properties;
import org.junit.Assert;
import org.junit.Test;

public class FilterTest {
    @Test
    public void doesNotAcceptNullInput() {
        Properties nullProperties = null;
        Filter f = new Filter();
        try {
            f.apply(nullProperties);
            Assert.fail((String)"IllegalArgumentException expected because input is null");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void emptyInputResultsInEmptyOutput() {
        Properties emptyProperties = new Properties();
        Filter f = new Filter();
        Properties filtered = f.apply(emptyProperties);
        Assert.assertEquals((long)0L, (long)filtered.size());
    }

    @Test
    public void filtersNothingByDefault() {
        Properties anyProperties = System.getProperties();
        Filter f = new Filter();
        Properties filtered = f.apply(anyProperties);
        Assert.assertEquals((Object)anyProperties, (Object)filtered);
        Assert.assertEquals((long)anyProperties.size(), (long)filtered.size());
    }

    @Test
    public void filtersMatchingKey() {
        Properties properties = new Properties();
        properties.put("one", (Object)1);
        properties.put("two", (Object)2);
        HashSet<String> removeOneKey = new HashSet<String>();
        removeOneKey.add("one");
        Filter f = new Filter(removeOneKey);
        Properties filtered = f.apply(properties);
        Assert.assertEquals((long)(properties.size() - 1), (long)filtered.size());
        Assert.assertFalse((boolean)filtered.containsKey("one"));
        Assert.assertTrue((boolean)filtered.containsKey("two"));
        Assert.assertEquals((Object)properties.get("two"), (Object)filtered.get("two"));
    }

    @Test
    public void filtersMatchingKeys() {
        Properties properties = new Properties();
        properties.put("one", (Object)1);
        properties.put("two", (Object)2);
        properties.put("three", (Object)3);
        properties.put("four", (Object)4);
        properties.put("five", (Object)5);
        HashSet<String> removeAllKeys = new HashSet<String>();
        for (Object key : properties.keySet()) {
            removeAllKeys.add(key.toString());
        }
        Filter f = new Filter(removeAllKeys);
        Properties filtered = f.apply(properties);
        Assert.assertEquals((long)0L, (long)filtered.size());
    }

    @Test
    public void doesNotFilterMismatchingKeys() {
        Properties properties = new Properties();
        properties.put("one", (Object)1);
        properties.put("two", (Object)2);
        HashSet<String> keysToRemove = new HashSet<String>();
        keysToRemove.add("three");
        Filter f = new Filter(keysToRemove);
        Properties filtered = f.apply(properties);
        Assert.assertEquals((long)properties.size(), (long)filtered.size());
        Assert.assertTrue((boolean)filtered.containsKey("one"));
        Assert.assertTrue((boolean)filtered.containsKey("two"));
    }
}

