/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.support.metrics;

import io.confluent.support.metrics.PhoneHomeConfig;
import java.util.Properties;
import org.junit.Assert;
import org.junit.Test;

public class PhoneHomeConfigTest {
    private static final String EXPECTED_SECURE_ENDPOINT = "https://version-check.confluent.io";
    private static final String EXPECTED_INSECURE_ENDPOINT = "http://version-check.confluent.io";

    @Test
    public void testProductionEndpoints() {
        Properties overrideProps = new Properties();
        overrideProps.setProperty("confluent.support.customer.id", "c11");
        overrideProps.getProperty("confluent.support.metrics.topic", "topic");
        PhoneHomeConfig config = new PhoneHomeConfig(overrideProps, "TestComponent");
        Assert.assertEquals((Object)"", (Object)config.getKafkaTopic());
        Assert.assertEquals((Object)"anonymous", (Object)config.getCustomerId());
        Assert.assertEquals((Object)"https://version-check.confluent.io/TestComponent/anon", (Object)config.getEndpointHTTPS());
        Assert.assertEquals((Object)"http://version-check.confluent.io/TestComponent/anon", (Object)config.getEndpointHTTP());
    }

    @Test
    public void testTestEndpoints() {
        Properties overrideProps = new Properties();
        overrideProps.setProperty("confluent.support.customer.id", "c0");
        PhoneHomeConfig config = new PhoneHomeConfig(overrideProps, "TestComponent");
        Assert.assertEquals((Object)"", (Object)config.getKafkaTopic());
        Assert.assertEquals((Object)"c0", (Object)config.getCustomerId());
        Assert.assertEquals((Object)"https://version-check.confluent.io/TestComponent/test", (Object)config.getEndpointHTTPS());
        Assert.assertEquals((Object)"http://version-check.confluent.io/TestComponent/test", (Object)config.getEndpointHTTP());
    }

    @Test
    public void testInsecureEndpointDisabled() {
        Properties overrideProps = new Properties();
        overrideProps.setProperty("confluent.support.metrics.endpoint.insecure.enable", "false");
        PhoneHomeConfig config = new PhoneHomeConfig(overrideProps, "TestComponent");
        Assert.assertEquals((Object)"anonymous", (Object)config.getCustomerId());
        Assert.assertEquals((Object)"https://version-check.confluent.io/TestComponent/anon", (Object)config.getEndpointHTTPS());
        Assert.assertEquals((Object)"", (Object)config.getEndpointHTTP());
    }
}

