/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.support.metrics;

import io.confluent.support.metrics.BaseSupportConfig;
import io.confluent.support.metrics.utils.CustomerIdExamples;
import java.io.IOException;
import java.util.Arrays;
import java.util.Properties;
import java.util.stream.Stream;
import kafka.server.KafkaConfig;
import org.junit.Assert;
import org.junit.Test;

public class BaseSupportConfigTest {
    @Test
    public void testValidCustomer() {
        for (String validId : CustomerIdExamples.VALID_CUSTOMER_IDS) {
            Assert.assertTrue((String)(validId + " is an invalid customer identifier"), (boolean)BaseSupportConfig.isConfluentCustomer((String)validId));
        }
    }

    @Test
    public void testValidNewCustomer() {
        String[] validNewCustomerIds;
        for (String validId : validNewCustomerIds = (String[])Stream.concat(Arrays.stream(CustomerIdExamples.VALID_CASE_SENSISTIVE_NEW_CUSTOMER_IDS), Arrays.stream(CustomerIdExamples.VALID_CASE_INSENSISTIVE_NEW_CUSTOMER_IDS)).toArray(String[]::new)) {
            Assert.assertTrue((String)(validId + " is an invalid new customer identifier"), (boolean)BaseSupportConfig.isConfluentCustomer((String)validId));
        }
    }

    @Test
    public void testInvalidCustomer() {
        String[] invalidIds;
        for (String invalidCustomerId : invalidIds = (String[])Stream.concat(Arrays.stream(CustomerIdExamples.INVALID_CUSTOMER_IDS), Arrays.stream(CustomerIdExamples.VALID_ANONYMOUS_IDS)).toArray(String[]::new)) {
            Assert.assertFalse((String)(invalidCustomerId + " is a valid customer identifier"), (boolean)BaseSupportConfig.isConfluentCustomer((String)invalidCustomerId));
        }
    }

    @Test
    public void testValidAnonymousUser() {
        for (String validId : CustomerIdExamples.VALID_ANONYMOUS_IDS) {
            Assert.assertTrue((String)(validId + " is an invalid anonymous user identifier"), (boolean)BaseSupportConfig.isAnonymousUser((String)validId));
        }
    }

    @Test
    public void testInvalidAnonymousUser() {
        String[] invalidIds;
        for (String invalidId : invalidIds = (String[])Stream.concat(Arrays.stream(CustomerIdExamples.INVALID_ANONYMOUS_IDS), Arrays.stream(CustomerIdExamples.VALID_CUSTOMER_IDS)).toArray(String[]::new)) {
            Assert.assertFalse((String)(invalidId + " is a valid anonymous user identifier"), (boolean)BaseSupportConfig.isAnonymousUser((String)invalidId));
        }
    }

    @Test
    public void testCustomerIdValidSettings() {
        String[] validValues;
        for (String validValue : validValues = (String[])Stream.concat(Arrays.stream(CustomerIdExamples.VALID_ANONYMOUS_IDS), Arrays.stream(CustomerIdExamples.VALID_CUSTOMER_IDS)).toArray(String[]::new)) {
            Assert.assertTrue((String)(validValue + " is an invalid value for " + "confluent.support.customer.id"), (boolean)BaseSupportConfig.isSyntacticallyCorrectCustomerId((String)validValue));
            Assert.assertFalse((String)(validValue + " is case-sensitive customer ID."), (boolean)BaseSupportConfig.isCaseSensitiveCustomerId((String)validValue));
        }
    }

    @Test
    public void testCustomerIdInvalidSettings() {
        String[] invalidValues;
        for (String invalidValue : invalidValues = (String[])Stream.concat(Arrays.stream(CustomerIdExamples.INVALID_ANONYMOUS_IDS), Arrays.stream(CustomerIdExamples.INVALID_CUSTOMER_IDS)).toArray(String[]::new)) {
            Assert.assertFalse((String)(invalidValue + " is a valid value for " + "confluent.support.customer.id"), (boolean)BaseSupportConfig.isSyntacticallyCorrectCustomerId((String)invalidValue));
        }
    }

    @Test
    public void testCaseInsensitiveNewCustomerIds() {
        for (String validValue : CustomerIdExamples.VALID_CASE_INSENSISTIVE_NEW_CUSTOMER_IDS) {
            Assert.assertFalse((String)(validValue + " is case-sensitive customer ID."), (boolean)BaseSupportConfig.isCaseSensitiveCustomerId((String)validValue));
        }
    }

    @Test
    public void testCaseSensitiveNewCustomerIds() {
        for (String validValue : CustomerIdExamples.VALID_CASE_SENSISTIVE_NEW_CUSTOMER_IDS) {
            Assert.assertTrue((String)(validValue + " is case-insensitive customer ID."), (boolean)BaseSupportConfig.isCaseSensitiveCustomerId((String)validValue));
        }
    }

    @Test
    public void proactiveSupportConfigIsValidKafkaConfig() throws IOException {
        Properties brokerConfiguration = this.defaultBrokerConfiguration();
        KafkaConfig cfg = KafkaConfig.fromProps((Properties)brokerConfiguration);
        Assert.assertEquals((long)0L, (long)cfg.brokerId());
        Assert.assertTrue((boolean)cfg.zkConnect().startsWith("localhost:"));
    }

    private Properties defaultBrokerConfiguration() throws IOException {
        Properties brokerConfiguration = new Properties();
        brokerConfiguration.load(BaseSupportConfigTest.class.getResourceAsStream("/default-server.properties"));
        return brokerConfiguration;
    }

    @Test
    public void canParseProactiveSupportConfiguration() throws IOException {
        Properties brokerConfiguration = this.defaultBrokerConfiguration();
        TestSupportConfig supportConfig = new TestSupportConfig(brokerConfiguration);
        Assert.assertTrue((boolean)supportConfig.getMetricsEnabled());
        Assert.assertEquals((Object)"c0", (Object)supportConfig.getCustomerId());
        Assert.assertTrue((boolean)supportConfig.isProactiveSupportEnabled());
    }

    @Test
    public void testGetDefaultProps() {
        Properties overrideProps = new Properties();
        TestSupportConfig supportConfig = new TestSupportConfig(overrideProps);
        Assert.assertTrue((boolean)supportConfig.getMetricsEnabled());
        Assert.assertEquals((Object)"anonymous", (Object)supportConfig.getCustomerId());
        Assert.assertEquals((long)86400000L, (long)supportConfig.getReportIntervalMs());
        Assert.assertEquals((Object)"__confluent.support.metrics", (Object)supportConfig.getKafkaTopic());
        Assert.assertTrue((boolean)supportConfig.isHttpEnabled());
        Assert.assertTrue((boolean)supportConfig.isHttpsEnabled());
        Assert.assertTrue((boolean)supportConfig.isProactiveSupportEnabled());
        Assert.assertEquals((Object)"", (Object)supportConfig.getProxy());
        Assert.assertEquals((Object)"http://support-metrics.confluent.io/anon", (Object)supportConfig.getEndpointHTTP());
        Assert.assertEquals((Object)"https://support-metrics.confluent.io/anon", (Object)supportConfig.getEndpointHTTPS());
    }

    @Test
    public void testMergeAndValidatePropsFilterDisallowedKeys() {
        Properties overrideProps = new Properties();
        overrideProps.setProperty("confluent.support.metrics.endpoint.insecure", "anyValue");
        overrideProps.setProperty("confluent.support.metrics.endpoint.secure", "anyValue");
        TestSupportConfig supportConfig = new TestSupportConfig(overrideProps);
        Assert.assertEquals((Object)"http://support-metrics.confluent.io/anon", (Object)supportConfig.getEndpointHTTP());
        Assert.assertEquals((Object)"https://support-metrics.confluent.io/anon", (Object)supportConfig.getEndpointHTTPS());
    }

    @Test
    public void testMergeAndValidatePropsDisableEndpoints() {
        Properties overrideProps = new Properties();
        overrideProps.setProperty("confluent.support.metrics.endpoint.insecure.enable", "false");
        overrideProps.setProperty("confluent.support.metrics.endpoint.secure.enable", "false");
        TestSupportConfig supportConfig = new TestSupportConfig(overrideProps);
        Assert.assertTrue((boolean)supportConfig.getEndpointHTTP().isEmpty());
        Assert.assertTrue((boolean)supportConfig.getEndpointHTTPS().isEmpty());
    }

    @Test
    public void testOverrideReportInterval() {
        Properties overrideProps = new Properties();
        int reportIntervalHours = 1;
        overrideProps.setProperty("confluent.support.metrics.report.interval.hours", String.valueOf(reportIntervalHours));
        TestSupportConfig supportConfig = new TestSupportConfig(overrideProps);
        Assert.assertEquals((long)(reportIntervalHours * 60 * 60 * 1000), (long)supportConfig.getReportIntervalMs());
    }

    @Test
    public void testOverrideTopic() {
        Properties overrideProps = new Properties();
        overrideProps.setProperty("confluent.support.metrics.topic", "__another_example_topic");
        TestSupportConfig supportConfig = new TestSupportConfig(overrideProps);
        Assert.assertEquals((Object)"__another_example_topic", (Object)supportConfig.getKafkaTopic());
    }

    @Test
    public void isProactiveSupportEnabledFull() {
        Properties serverProperties = new Properties();
        serverProperties.setProperty("confluent.support.metrics.enable", "true");
        TestSupportConfig supportConfig = new TestSupportConfig(serverProperties);
        Assert.assertTrue((boolean)supportConfig.isProactiveSupportEnabled());
    }

    @Test
    public void isProactiveSupportDisabledFull() {
        Properties serverProperties = new Properties();
        serverProperties.setProperty("confluent.support.metrics.enable", "false");
        serverProperties.setProperty("confluent.support.metrics.topic", "anyTopic");
        serverProperties.setProperty("confluent.support.metrics.endpoint.insecure.enable", "true");
        serverProperties.setProperty("confluent.support.metrics.endpoint.secure.enable", "true");
        TestSupportConfig supportConfig = new TestSupportConfig(serverProperties);
        Assert.assertFalse((boolean)supportConfig.isProactiveSupportEnabled());
    }

    @Test
    public void isProactiveSupportEnabledTopicOnly() {
        Properties serverProperties = new Properties();
        serverProperties.setProperty("confluent.support.metrics.topic", "anyTopic");
        TestSupportConfig supportConfig = new TestSupportConfig(serverProperties);
        Assert.assertTrue((boolean)supportConfig.isProactiveSupportEnabled());
    }

    @Test
    public void isProactiveSupportEnabledHTTPOnly() {
        Properties serverProperties = new Properties();
        serverProperties.setProperty("confluent.support.metrics.endpoint.insecure.enable", "true");
        TestSupportConfig supportConfig = new TestSupportConfig(serverProperties);
        Assert.assertTrue((boolean)supportConfig.isProactiveSupportEnabled());
    }

    @Test
    public void isProactiveSupportEnabledHTTPSOnly() {
        Properties serverProperties = new Properties();
        serverProperties.setProperty("confluent.support.metrics.endpoint.secure.enable", "true");
        TestSupportConfig supportConfig = new TestSupportConfig(serverProperties);
        Assert.assertTrue((boolean)supportConfig.isProactiveSupportEnabled());
    }

    @Test
    public void proactiveSupportIsDisabledByDefaultWhenBrokerConfigurationIsEmpty() {
        Properties serverProperties = new Properties();
        TestSupportConfig supportConfig = new TestSupportConfig(serverProperties);
        Assert.assertTrue((boolean)supportConfig.isProactiveSupportEnabled());
    }

    public class TestSupportConfig
    extends BaseSupportConfig {
        public TestSupportConfig(Properties originals) {
            super(originals);
        }

        protected String getAnonymousEndpoint(boolean secure) {
            if (!secure) {
                return "http://support-metrics.confluent.io/anon";
            }
            return "https://support-metrics.confluent.io/anon";
        }

        protected String getTestEndpoint(boolean secure) {
            if (!secure) {
                return "http://support-metrics.confluent.io/test";
            }
            return "https://support-metrics.confluent.io/test";
        }

        protected String getCustomerEndpoint(boolean secure) {
            if (!secure) {
                return "http://support-metrics.confluent.io/submit";
            }
            return "https://support-metrics.confluent.io/submit";
        }
    }
}

