/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rest.handlers;

import io.confluent.rest.handlers.SniHandler;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.http.HttpStatus;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.HandlerWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrefixSniHandler
extends HandlerWrapper {
    private static final Logger log = LoggerFactory.getLogger(PrefixSniHandler.class);
    private static final String DOT_SEPARATOR = ".";
    private static final String DASH_SEPARATOR = "-";
    private final String sniPrefix;

    public PrefixSniHandler(String prefix) {
        this.sniPrefix = prefix;
    }

    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String hostHeader = request.getServerName();
        String sniServerName = SniHandler.getSniServerName(baseRequest);
        log.debug("host header: {}, full sni: {}", (Object)hostHeader, (Object)sniServerName);
        if (sniServerName != null && sniServerName.startsWith(this.sniPrefix)) {
            String prefix = PrefixSniHandler.getFirstPart(sniServerName);
            if (prefix == null || !hostHeader.startsWith(prefix + DOT_SEPARATOR) && !hostHeader.startsWith(prefix + DASH_SEPARATOR)) {
                log.warn("SNI prefix check failed, host header: {}, sni tenantId: {}, full sni: {}", new Object[]{hostHeader, prefix, sniServerName});
                baseRequest.setHandled(true);
                response.sendError(HttpStatus.Code.MISDIRECTED_REQUEST.getCode(), HttpStatus.Code.MISDIRECTED_REQUEST.getMessage());
            }
        } else if (sniServerName != null && !sniServerName.equals(hostHeader)) {
            log.warn("SNI check failed, host header: {}, full sni: {}", (Object)hostHeader, (Object)sniServerName);
            baseRequest.setHandled(true);
            response.sendError(HttpStatus.Code.MISDIRECTED_REQUEST.getCode(), HttpStatus.Code.MISDIRECTED_REQUEST.getMessage());
        }
        super.handle(target, baseRequest, request, response);
    }

    private static String getFirstPart(String hostname) {
        if (hostname == null) {
            return null;
        }
        int dotIndex = hostname.indexOf(DOT_SEPARATOR);
        return dotIndex == -1 ? null : hostname.substring(0, dotIndex);
    }
}

