/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rest;

import io.confluent.rest.RestConfig;
import io.confluent.rest.ratelimit.NetworkTrafficRateLimiter;
import io.confluent.rest.ratelimit.NetworkTrafficRateLimiterFactory;
import java.net.Socket;
import java.nio.ByteBuffer;
import org.eclipse.jetty.io.NetworkTrafficListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RateLimitNetworkTrafficListener
implements NetworkTrafficListener {
    private static final Logger log = LoggerFactory.getLogger(RateLimitNetworkTrafficListener.class);
    private final NetworkTrafficRateLimiter rateLimiter;

    public RateLimitNetworkTrafficListener(RestConfig restConfig) {
        this.rateLimiter = NetworkTrafficRateLimiterFactory.create(restConfig);
    }

    public void incoming(Socket socket, ByteBuffer bytes) {
        int cost = bytes.limit() - bytes.position();
        if (cost > 0) {
            log.debug("Applying network traffic rate limit on socket: {} with cost: {}", (Object)socket, (Object)cost);
            this.rateLimiter.rateLimit(cost);
        }
    }
}

