/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rest.handlers;

import java.io.IOException;
import java.util.List;
import javax.net.ssl.ExtendedSSLSession;
import javax.net.ssl.SNIHostName;
import javax.net.ssl.SNIServerName;
import javax.net.ssl.SSLSession;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.http.HttpStatus;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.ssl.SslConnection;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.HandlerWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SniHandler
extends HandlerWrapper {
    private static final Logger log = LoggerFactory.getLogger(SniHandler.class);

    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String serverName = request.getServerName();
        String sniServerName = SniHandler.getSniServerName(baseRequest);
        if (sniServerName != null && !sniServerName.equals(serverName)) {
            log.debug("Sni check failed, host header: {}, sni value: {}", (Object)serverName, (Object)sniServerName);
            baseRequest.setHandled(true);
            response.sendError(HttpStatus.Code.MISDIRECTED_REQUEST.getCode(), HttpStatus.Code.MISDIRECTED_REQUEST.getMessage());
        }
        super.handle(target, baseRequest, request, response);
    }

    private static String getSniServerName(Request baseRequest) {
        List<SNIServerName> servers;
        SSLSession session;
        EndPoint endpoint = baseRequest.getHttpChannel().getEndPoint();
        if (endpoint instanceof SslConnection.DecryptedEndPoint && (session = ((SslConnection.DecryptedEndPoint)endpoint).getSslConnection().getSSLEngine().getSession()) instanceof ExtendedSSLSession && (servers = ((ExtendedSSLSession)session).getRequestedServerNames()) != null) {
            return servers.stream().findAny().filter(SNIHostName.class::isInstance).map(SNIHostName.class::cast).map(SNIHostName::getAsciiName).orElse(null);
        }
        return null;
    }
}

