/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rest;

import io.confluent.rest.FileWatcher;
import io.confluent.rest.SslConfig;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SslFactory {
    private static final Logger log = LoggerFactory.getLogger(SslFactory.class);

    private SslFactory() {
    }

    public static SslContextFactory createSslContextFactory(SslConfig sslConfig) {
        SslContextFactory.Server sslContextFactory = new SslContextFactory.Server();
        if (!sslConfig.getKeyStorePath().isEmpty()) {
            sslContextFactory.setKeyStorePath(sslConfig.getKeyStorePath());
            sslContextFactory.setKeyStorePassword(sslConfig.getKeyStorePassword());
            sslContextFactory.setKeyManagerPassword(sslConfig.getKeyManagerPassword());
            sslContextFactory.setKeyStoreType(sslConfig.getKeyStoreType());
            if (!sslConfig.getKeyManagerFactoryAlgorithm().isEmpty()) {
                sslContextFactory.setKeyManagerFactoryAlgorithm(sslConfig.getKeyManagerFactoryAlgorithm());
            }
            if (sslConfig.getReloadOnKeyStoreChange()) {
                Path watchLocation = Paths.get(sslConfig.getReloadOnKeyStoreChangePath(), new String[0]);
                try {
                    FileWatcher.onFileChange(watchLocation, () -> {
                        sslContextFactory.setKeyStorePath(sslConfig.getKeyStorePath());
                        sslContextFactory.reload(scf -> log.info("SSL cert auto reload begun: " + scf.getKeyStorePath()));
                        log.info("SSL cert auto reload complete");
                    });
                    log.info("Enabled SSL cert auto reload for: " + watchLocation);
                }
                catch (IOException e) {
                    log.error("Cannot enable SSL cert auto reload", (Throwable)e);
                }
            }
        }
        SslFactory.configureClientAuth(sslContextFactory, sslConfig);
        if (!sslConfig.getIncludeProtocols().isEmpty()) {
            sslContextFactory.setIncludeProtocols(sslConfig.getIncludeProtocols().toArray(new String[0]));
        }
        if (!sslConfig.getIncludeCipherSuites().isEmpty()) {
            sslContextFactory.setIncludeCipherSuites(sslConfig.getIncludeCipherSuites().toArray(new String[0]));
        }
        sslContextFactory.setEndpointIdentificationAlgorithm(sslConfig.getEndpointIdentificationAlgorithm());
        if (!sslConfig.getTrustStorePath().isEmpty()) {
            sslContextFactory.setTrustStorePath(sslConfig.getTrustStorePath());
            sslContextFactory.setTrustStorePassword(sslConfig.getTrustStorePassword());
            sslContextFactory.setTrustStoreType(sslConfig.getTrustStoreType());
            if (!sslConfig.getTrustManagerFactoryAlgorithm().isEmpty()) {
                sslContextFactory.setTrustManagerFactoryAlgorithm(sslConfig.getTrustManagerFactoryAlgorithm());
            }
        }
        sslContextFactory.setProtocol(sslConfig.getProtocol());
        if (!sslConfig.getProvider().isEmpty()) {
            sslContextFactory.setProvider(sslConfig.getProvider());
        }
        sslContextFactory.setRenegotiationAllowed(false);
        return sslContextFactory;
    }

    private static void configureClientAuth(SslContextFactory.Server sslContextFactory, SslConfig config) {
        switch (config.getClientAuth()) {
            case NEED: {
                sslContextFactory.setNeedClientAuth(true);
                break;
            }
            case WANT: {
                sslContextFactory.setWantClientAuth(true);
                break;
            }
        }
    }
}

