/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rest.metrics;

import io.confluent.rest.annotations.PerformanceMetric;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.core.Response;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.CompoundStat;
import org.apache.kafka.common.metrics.MeasurableStat;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.Avg;
import org.apache.kafka.common.metrics.stats.CumulativeCount;
import org.apache.kafka.common.metrics.stats.Max;
import org.apache.kafka.common.metrics.stats.Percentile;
import org.apache.kafka.common.metrics.stats.Percentiles;
import org.apache.kafka.common.metrics.stats.Rate;
import org.apache.kafka.common.metrics.stats.SampledStat;
import org.apache.kafka.common.metrics.stats.WindowedCount;
import org.apache.kafka.common.utils.Time;
import org.glassfish.jersey.server.ContainerRequest;
import org.glassfish.jersey.server.ContainerResponse;
import org.glassfish.jersey.server.model.Resource;
import org.glassfish.jersey.server.model.ResourceMethod;
import org.glassfish.jersey.server.monitoring.ApplicationEvent;
import org.glassfish.jersey.server.monitoring.ApplicationEventListener;
import org.glassfish.jersey.server.monitoring.RequestEvent;
import org.glassfish.jersey.server.monitoring.RequestEventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricsResourceMethodApplicationListener
implements ApplicationEventListener {
    private static final Logger log = LoggerFactory.getLogger(MetricsResourceMethodApplicationListener.class);
    public static final String REQUEST_TAGS_PROP_KEY = "_request_tags";
    protected static final String HTTP_STATUS_CODE_TAG = "http_status_code";
    protected static final String[] HTTP_STATUS_CODE_TEXT = new String[]{"unknown", "1xx", "2xx", "3xx", "4xx", "5xx", "429"};
    private static final int PERCENTILE_NUM_BUCKETS = 200;
    private static final double PERCENTILE_MAX_LATENCY_IN_MS = TimeUnit.SECONDS.toMillis(10L);
    private static final long SENSOR_EXPIRY_SECONDS = TimeUnit.HOURS.toSeconds(1L);
    private final Metrics metrics;
    private final String metricGrpPrefix;
    private final Map<String, String> metricTags;
    private final Time time;
    private final Map<Method, RequestScopedMetrics> methodMetrics = new HashMap<Method, RequestScopedMetrics>();

    public MetricsResourceMethodApplicationListener(Metrics metrics, String metricGrpPrefix, Map<String, String> metricTags, Time time) {
        this.metrics = metrics;
        this.metricGrpPrefix = metricGrpPrefix;
        this.metricTags = metricTags != null ? metricTags : Collections.emptyMap();
        this.time = time;
    }

    public void onEvent(ApplicationEvent event) {
        if (event.getType() == ApplicationEvent.Type.INITIALIZATION_FINISHED) {
            MethodMetrics m = new MethodMetrics(null, null, this.metrics, this.metricGrpPrefix, this.metricTags, Collections.emptyMap());
            this.methodMetrics.put(null, new RequestScopedMetrics(m, new ConstructionContext(this)));
            for (Resource resource : event.getResourceModel().getResources()) {
                for (ResourceMethod method : resource.getAllMethods()) {
                    this.register(method);
                }
                for (Resource childResource : resource.getChildResources()) {
                    for (ResourceMethod method : childResource.getAllMethods()) {
                        this.register(method);
                    }
                }
            }
        }
    }

    private void register(ResourceMethod method) {
        Method definitionMethod = method.getInvocable().getDefinitionMethod();
        if (definitionMethod.isAnnotationPresent(PerformanceMetric.class)) {
            PerformanceMetric annotation = definitionMethod.getAnnotation(PerformanceMetric.class);
            MethodMetrics m = new MethodMetrics(method, annotation, this.metrics, this.metricGrpPrefix, this.metricTags, Collections.emptyMap());
            ConstructionContext context = new ConstructionContext(method, annotation, this);
            this.methodMetrics.put(definitionMethod, new RequestScopedMetrics(m, context));
        }
    }

    public RequestEventListener onRequest(RequestEvent event) {
        return new MetricsRequestEventListener(this.methodMetrics, this.time);
    }

    private static class MetricsRequestEventListener
    implements RequestEventListener {
        private final Time time;
        private final Map<Method, RequestScopedMetrics> metrics;
        private long started;
        private CountingInputStream wrappedRequestStream;
        private CountingOutputStream wrappedResponseStream;

        public MetricsRequestEventListener(Map<Method, RequestScopedMetrics> metrics, Time time) {
            this.metrics = metrics;
            this.time = time;
        }

        public void onEvent(RequestEvent event) {
            if (event.getType() == RequestEvent.Type.MATCHING_START) {
                this.started = this.time.milliseconds();
                ContainerRequest request = event.getContainerRequest();
                this.wrappedRequestStream = new CountingInputStream(request.getEntityStream());
                request.setEntityStream((InputStream)this.wrappedRequestStream);
            } else if (event.getType() == RequestEvent.Type.RESP_FILTERS_START) {
                ContainerResponse response = event.getContainerResponse();
                this.wrappedResponseStream = new CountingOutputStream(response.getEntityStream());
                response.setEntityStream((OutputStream)this.wrappedResponseStream);
            } else if (event.getType() == RequestEvent.Type.FINISHED) {
                MethodMetrics metrics;
                long elapsed = this.time.milliseconds() - this.started;
                long requestSize = this.wrappedRequestStream != null ? this.wrappedRequestStream.size() : 0L;
                long responseSize = this.wrappedResponseStream != null ? this.wrappedResponseStream.size() : 0L;
                if (event.getException() != null) {
                    this.metrics.get(null).metrics().exception(event);
                    metrics = this.getMethodMetrics(event);
                    if (metrics != null) {
                        metrics.exception(event);
                    }
                }
                this.metrics.get(null).metrics().finished(requestSize, responseSize, elapsed);
                metrics = this.getMethodMetrics(event);
                if (metrics != null) {
                    metrics.finished(requestSize, responseSize, elapsed);
                }
            }
        }

        private MethodMetrics getMethodMetrics(RequestEvent event) {
            ResourceMethod method = event.getUriInfo().getMatchedResourceMethod();
            if (method == null) {
                return null;
            }
            RequestScopedMetrics metrics = this.metrics.get(method.getInvocable().getDefinitionMethod());
            if (metrics == null) {
                return null;
            }
            Object tagsObj = event.getContainerRequest().getProperty(MetricsResourceMethodApplicationListener.REQUEST_TAGS_PROP_KEY);
            if (tagsObj == null) {
                return metrics.metrics();
            }
            if (!(tagsObj instanceof Map)) {
                throw new ClassCastException("Expected the value for property _request_tags to be a " + Map.class + ", but it is " + tagsObj.getClass());
            }
            Map tags = (Map)tagsObj;
            return metrics.metrics(tags);
        }

        private static class CountingOutputStream
        extends FilterOutputStream {
            private long count = 0L;

            public CountingOutputStream(OutputStream os) {
                super(os);
            }

            public long size() {
                return this.count;
            }

            @Override
            public void write(int b) throws IOException {
                ++this.count;
                this.out.write(b);
            }

            @Override
            public void write(byte[] bytes) throws IOException {
                this.count += (long)bytes.length;
                this.out.write(bytes);
            }

            @Override
            public void write(byte[] bytes, int off, int len) throws IOException {
                this.count += (long)len;
                this.out.write(bytes, off, len);
            }
        }

        private static class CountingInputStream
        extends FilterInputStream {
            private long count = 0L;
            private long mark = 0L;

            public CountingInputStream(InputStream is) {
                super(is);
            }

            public long size() {
                return this.count;
            }

            @Override
            public int read() throws IOException {
                int b = super.read();
                ++this.count;
                return b;
            }

            @Override
            public int read(byte[] bytes, int off, int len) throws IOException {
                int nread = super.read(bytes, off, len);
                if (nread > 0) {
                    this.count += (long)nread;
                }
                return nread;
            }

            @Override
            public long skip(long l) throws IOException {
                long skipped = super.skip(l);
                this.count += skipped;
                return skipped;
            }

            @Override
            public synchronized void mark(int i) {
                super.mark(i);
                this.mark = this.count;
            }

            @Override
            public synchronized void reset() throws IOException {
                super.reset();
                this.count = this.mark;
            }
        }
    }

    private static class MethodMetrics {
        private final Sensor requestSizeSensor;
        private final Sensor responseSizeSensor;
        private final Sensor requestLatencySensor;
        private final Sensor errorSensor;
        private final Map<String, Sensor> errorSensorByStatus = new HashMap<String, Sensor>(HTTP_STATUS_CODE_TEXT.length);

        public MethodMetrics(ResourceMethod method, PerformanceMetric annotation, Metrics metrics, String metricGrpPrefix, Map<String, String> metricTags, Map<String, String> requestTags) {
            String metricGrpName = metricGrpPrefix + "-metrics";
            TreeMap<String, String> allTags = new TreeMap<String, String>(metricTags);
            allTags.putAll(requestTags);
            this.requestSizeSensor = metrics.sensor(MethodMetrics.getName(method, annotation, "request-size", requestTags), null, SENSOR_EXPIRY_SECONDS, Sensor.RecordingLevel.INFO, (Sensor[])null);
            MetricName metricName = new MetricName(MethodMetrics.getName(method, annotation, "request-count"), metricGrpName, "The request count using a windowed counter", allTags);
            this.requestSizeSensor.add(metricName, (MeasurableStat)new WindowedCount());
            metricName = new MetricName(MethodMetrics.getName(method, annotation, "request-rate"), metricGrpName, "The average number of HTTP requests per second.", allTags);
            this.requestSizeSensor.add(metricName, (MeasurableStat)new Rate((SampledStat)new WindowedCount()));
            metricName = new MetricName(MethodMetrics.getName(method, annotation, "request-total"), metricGrpName, "The request count using a cumulative counter", allTags);
            this.requestSizeSensor.add(metricName, (MeasurableStat)new CumulativeCount());
            metricName = new MetricName(MethodMetrics.getName(method, annotation, "request-byte-rate"), metricGrpName, "Bytes/second of incoming requests", allTags);
            this.requestSizeSensor.add(metricName, (MeasurableStat)new Avg());
            metricName = new MetricName(MethodMetrics.getName(method, annotation, "request-size-avg"), metricGrpName, "The average request size in bytes", allTags);
            this.requestSizeSensor.add(metricName, (MeasurableStat)new Avg());
            metricName = new MetricName(MethodMetrics.getName(method, annotation, "request-size-max"), metricGrpName, "The maximum request size in bytes", allTags);
            this.requestSizeSensor.add(metricName, (MeasurableStat)new Max());
            this.responseSizeSensor = metrics.sensor(MethodMetrics.getName(method, annotation, "response-size", requestTags), null, SENSOR_EXPIRY_SECONDS, Sensor.RecordingLevel.INFO, (Sensor[])null);
            metricName = new MetricName(MethodMetrics.getName(method, annotation, "response-rate"), metricGrpName, "The average number of HTTP responses per second.", allTags);
            this.responseSizeSensor.add(metricName, (MeasurableStat)new Rate((SampledStat)new WindowedCount()));
            metricName = new MetricName(MethodMetrics.getName(method, annotation, "response-byte-rate"), metricGrpName, "Bytes/second of outgoing responses", allTags);
            this.responseSizeSensor.add(metricName, (MeasurableStat)new Avg());
            metricName = new MetricName(MethodMetrics.getName(method, annotation, "response-size-avg"), metricGrpName, "The average response size in bytes", allTags);
            this.responseSizeSensor.add(metricName, (MeasurableStat)new Avg());
            metricName = new MetricName(MethodMetrics.getName(method, annotation, "response-size-max"), metricGrpName, "The maximum response size in bytes", allTags);
            this.responseSizeSensor.add(metricName, (MeasurableStat)new Max());
            this.requestLatencySensor = metrics.sensor(MethodMetrics.getName(method, annotation, "request-latency", requestTags), null, SENSOR_EXPIRY_SECONDS, Sensor.RecordingLevel.INFO, (Sensor[])null);
            metricName = new MetricName(MethodMetrics.getName(method, annotation, "request-latency-avg"), metricGrpName, "The average request latency in ms", allTags);
            this.requestLatencySensor.add(metricName, (MeasurableStat)new Avg());
            metricName = new MetricName(MethodMetrics.getName(method, annotation, "request-latency-max"), metricGrpName, "The maximum request latency in ms", allTags);
            this.requestLatencySensor.add(metricName, (MeasurableStat)new Max());
            Percentiles percs = new Percentiles(800, 0.0, PERCENTILE_MAX_LATENCY_IN_MS, Percentiles.BucketSizing.LINEAR, new Percentile[]{new Percentile(new MetricName(MethodMetrics.getName(method, annotation, "request-latency-95"), metricGrpName, "The 95th percentile request latency in ms", allTags), 95.0), new Percentile(new MetricName(MethodMetrics.getName(method, annotation, "request-latency-99"), metricGrpName, "The 99th percentile request latency in ms", allTags), 99.0)});
            this.requestLatencySensor.add((CompoundStat)percs);
            this.setErrorSensorByStatus(method, annotation, metrics, requestTags, metricGrpName, allTags);
            this.errorSensor = metrics.sensor(MethodMetrics.getName(method, annotation, "errors", requestTags), null, SENSOR_EXPIRY_SECONDS, Sensor.RecordingLevel.INFO, (Sensor[])null);
            metricName = new MetricName(MethodMetrics.getName(method, annotation, "request-error-rate"), metricGrpName, "The average number of requests per second that resulted in HTTP error responses", allTags);
            this.errorSensor.add(metricName, (MeasurableStat)new Rate());
            metricName = new MetricName(MethodMetrics.getName(method, annotation, "request-error-count"), metricGrpName, "A windowed count of requests that resulted in HTTP error responses", allTags);
            this.errorSensor.add(metricName, (MeasurableStat)new WindowedCount());
            metricName = new MetricName(MethodMetrics.getName(method, annotation, "request-error-total"), metricGrpName, "A cumulative count of requests that resulted in HTTP error responses", allTags);
            this.errorSensor.add(metricName, (MeasurableStat)new CumulativeCount());
        }

        private void setErrorSensorByStatus(ResourceMethod method, PerformanceMetric annotation, Metrics metrics, Map<String, String> requestTags, String metricGrpName, Map<String, String> allTags) {
            for (int i = 0; i < HTTP_STATUS_CODE_TEXT.length; ++i) {
                Sensor sensor = metrics.sensor(MethodMetrics.getName(method, annotation, "errors" + i, requestTags), null, SENSOR_EXPIRY_SECONDS, Sensor.RecordingLevel.INFO, (Sensor[])null);
                TreeMap<String, String> tags = new TreeMap<String, String>(allTags);
                tags.put(MetricsResourceMethodApplicationListener.HTTP_STATUS_CODE_TAG, HTTP_STATUS_CODE_TEXT[i]);
                MetricName metricName = new MetricName(MethodMetrics.getName(method, annotation, "request-error-rate"), metricGrpName, "The average number of requests per second that resulted in HTTP error responses with code " + HTTP_STATUS_CODE_TEXT[i], tags);
                sensor.add(metricName, (MeasurableStat)new Rate());
                metricName = new MetricName(MethodMetrics.getName(method, annotation, "request-error-count"), metricGrpName, "A windowed count of requests that resulted in an HTTP error response with code - " + HTTP_STATUS_CODE_TEXT[i], tags);
                sensor.add(metricName, (MeasurableStat)new WindowedCount());
                metricName = new MetricName(MethodMetrics.getName(method, annotation, "request-error-total"), metricGrpName, "A cumulative count of requests that resulted in an HTTP error response with code - " + HTTP_STATUS_CODE_TEXT[i], tags);
                sensor.add(metricName, (MeasurableStat)new CumulativeCount());
                this.errorSensorByStatus.put(HTTP_STATUS_CODE_TEXT[i], sensor);
            }
        }

        public void finished(long requestSize, long responseSize, long latencyMs) {
            this.requestSizeSensor.record((double)requestSize);
            this.responseSizeSensor.record((double)responseSize);
            this.requestLatencySensor.record((double)latencyMs);
        }

        public void exception(RequestEvent event) {
            if (event.getContainerResponse() != null) {
                Response.StatusType status = event.getContainerResponse().getStatusInfo();
                String statusText = MethodMetrics.getHttpStatusText(status);
                this.errorSensorByStatus.get(statusText).record();
                if (status.equals(Response.Status.TOO_MANY_REQUESTS)) {
                    this.errorSensorByStatus.get("429").record();
                }
            } else {
                this.errorSensorByStatus.get("unknown").record();
            }
            this.errorSensor.record();
        }

        private static String getHttpStatusText(Response.StatusType statusType) {
            switch (statusType.getFamily()) {
                case INFORMATIONAL: {
                    return "1xx";
                }
                case SUCCESSFUL: {
                    return "2xx";
                }
                case REDIRECTION: {
                    return "3xx";
                }
                case CLIENT_ERROR: {
                    return "4xx";
                }
                case SERVER_ERROR: {
                    return "5xx";
                }
            }
            return "unknown";
        }

        private static String getName(ResourceMethod method, PerformanceMetric annotation, String metric) {
            return MethodMetrics.getName(method, annotation, metric, null);
        }

        private static String getName(ResourceMethod method, PerformanceMetric annotation, String metric, Map<String, String> requestTags) {
            StringBuilder builder = new StringBuilder();
            boolean prefixed = false;
            if (annotation != null && !annotation.value().equals("__DEFAULT_NAME__")) {
                builder.append(annotation.value());
                builder.append('.');
                prefixed = true;
            }
            if (!prefixed && method != null) {
                String className = method.getInvocable().getDefinitionMethod().getDeclaringClass().getSimpleName();
                String methodName = method.getInvocable().getDefinitionMethod().getName();
                builder.append(className);
                builder.append('.');
                builder.append(methodName);
                builder.append('.');
            }
            builder.append(metric);
            if (requestTags != null) {
                requestTags.forEach((k, v) -> builder.append(".").append((String)k).append("=").append((String)v));
            }
            return builder.toString();
        }
    }

    private static class ConstructionContext {
        private final ResourceMethod method;
        private final PerformanceMetric performanceMetric;
        private final Map<String, String> metricTags;
        private final String metricGrpPrefix;
        private final Metrics metrics;

        public ConstructionContext(MetricsResourceMethodApplicationListener methodAppListener) {
            this(null, null, methodAppListener);
        }

        public ConstructionContext(ResourceMethod method, PerformanceMetric performanceMetric, MetricsResourceMethodApplicationListener methodAppListener) {
            this.method = method;
            this.performanceMetric = performanceMetric;
            this.metrics = methodAppListener.metrics;
            this.metricTags = methodAppListener.metricTags;
            this.metricGrpPrefix = methodAppListener.metricGrpPrefix;
        }
    }

    private static class RequestScopedMetrics {
        private final MethodMetrics methodMetrics;
        private final ConstructionContext context;
        private final Map<SortedMap<String, String>, MethodMetrics> requestMetrics = new ConcurrentHashMap<SortedMap<String, String>, MethodMetrics>();

        public RequestScopedMetrics(MethodMetrics metrics, ConstructionContext context) {
            this.methodMetrics = metrics;
            this.context = context;
        }

        public MethodMetrics metrics() {
            return this.methodMetrics;
        }

        public MethodMetrics metrics(Map<String, String> requestTags) {
            TreeMap<String, String> key = new TreeMap<String, String>(requestTags);
            return this.requestMetrics.computeIfAbsent(key, k -> new MethodMetrics(this.context.method, this.context.performanceMetric, this.context.metrics, this.context.metricGrpPrefix, this.context.metricTags, (Map<String, String>)k));
        }
    }
}

