/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.streams.serde.protobuf;

import com.google.protobuf.ByteString;
import com.google.protobuf.Descriptors;
import com.google.protobuf.DynamicMessage;
import com.google.protobuf.Message;
import io.confluent.kafka.schemaregistry.client.MockSchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.schemaregistry.protobuf.ProtobufSchema;
import io.confluent.kafka.streams.serdes.protobuf.KafkaProtobufSerde;
import java.util.HashMap;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class KafkaProtobufSerdeTest {
    private static final String ANY_TOPIC = "any-topic";
    private static final String recordSchemaString = "syntax = \"proto3\";\n\noption java_package = \"io.confluent.kafka.serializers.protobuf.test\";\noption java_outer_classname = \"TestMessageProtos\";\n\nimport \"google/protobuf/descriptor.proto\";\n\nmessage TestMessage {\n    string test_string = 1 [json_name = \"test_str\"];\n    bool test_bool = 2;\n    bytes test_bytes = 3;\n    double test_double = 4;\n    float test_float = 5;\n    fixed32 test_fixed32 = 6;\n    fixed64 test_fixed64 = 7;\n    int32 test_int32 = 8;\n    int64 test_int64 = 9;\n    sfixed32 test_sfixed32 = 10;\n    sfixed64 test_sfixed64 = 11;\n    sint32 test_sint32 = 12;\n    sint64 test_sint64 = 13;\n    uint32 test_uint32 = 14;\n    uint64 test_uint64 = 15;\n}\n";
    private static final ProtobufSchema recordSchema = new ProtobufSchema("syntax = \"proto3\";\n\noption java_package = \"io.confluent.kafka.serializers.protobuf.test\";\noption java_outer_classname = \"TestMessageProtos\";\n\nimport \"google/protobuf/descriptor.proto\";\n\nmessage TestMessage {\n    string test_string = 1 [json_name = \"test_str\"];\n    bool test_bool = 2;\n    bytes test_bytes = 3;\n    double test_double = 4;\n    float test_float = 5;\n    fixed32 test_fixed32 = 6;\n    fixed64 test_fixed64 = 7;\n    int32 test_int32 = 8;\n    int64 test_int64 = 9;\n    sfixed32 test_sfixed32 = 10;\n    sfixed64 test_sfixed64 = 11;\n    sint32 test_sint32 = 12;\n    sint64 test_sint64 = 13;\n    uint32 test_uint32 = 14;\n    uint64 test_uint64 = 15;\n}\n");

    private DynamicMessage createDynamicMessage() {
        DynamicMessage.Builder builder = recordSchema.newMessageBuilder();
        Descriptors.Descriptor desc = builder.getDescriptorForType();
        Descriptors.FieldDescriptor fd = desc.findFieldByName("test_string");
        builder.setField(fd, (Object)"string");
        fd = desc.findFieldByName("test_bool");
        builder.setField(fd, (Object)true);
        fd = desc.findFieldByName("test_bytes");
        builder.setField(fd, (Object)ByteString.copyFromUtf8((String)"hello"));
        fd = desc.findFieldByName("test_double");
        builder.setField(fd, (Object)800.25);
        fd = desc.findFieldByName("test_float");
        builder.setField(fd, (Object)Float.valueOf(23.4f));
        fd = desc.findFieldByName("test_fixed32");
        builder.setField(fd, (Object)32);
        fd = desc.findFieldByName("test_fixed64");
        builder.setField(fd, (Object)64L);
        fd = desc.findFieldByName("test_int32");
        builder.setField(fd, (Object)32);
        fd = desc.findFieldByName("test_int64");
        builder.setField(fd, (Object)64L);
        fd = desc.findFieldByName("test_sfixed32");
        builder.setField(fd, (Object)32);
        fd = desc.findFieldByName("test_sfixed64");
        builder.setField(fd, (Object)64L);
        fd = desc.findFieldByName("test_sint32");
        builder.setField(fd, (Object)32);
        fd = desc.findFieldByName("test_sint64");
        builder.setField(fd, (Object)64L);
        fd = desc.findFieldByName("test_uint32");
        builder.setField(fd, (Object)32);
        fd = desc.findFieldByName("test_uint64");
        builder.setField(fd, (Object)64L);
        return builder.build();
    }

    private static KafkaProtobufSerde<Message> createConfiguredSerdeForRecordValues() {
        MockSchemaRegistryClient schemaRegistryClient = new MockSchemaRegistryClient();
        KafkaProtobufSerde serde = new KafkaProtobufSerde((SchemaRegistryClient)schemaRegistryClient);
        HashMap<String, String> serdeConfig = new HashMap<String, String>();
        serdeConfig.put("schema.registry.url", "fake");
        serde.configure(serdeConfig, false);
        return serde;
    }

    @Test
    public void shouldRoundTripRecords() {
        KafkaProtobufSerde<Message> serde = KafkaProtobufSerdeTest.createConfiguredSerdeForRecordValues();
        DynamicMessage record = this.createDynamicMessage();
        Message roundtrippedRecord = (Message)serde.deserializer().deserialize(ANY_TOPIC, serde.serializer().serialize(ANY_TOPIC, (Object)record));
        Assert.assertThat((Object)roundtrippedRecord, (Matcher)CoreMatchers.equalTo((Object)record));
        serde.close();
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldFailWhenInstantiatedWithNullSchemaRegistryClient() {
        new KafkaProtobufSerde((SchemaRegistryClient)null);
    }
}

