/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.maven;

import io.confluent.kafka.schemaregistry.CompatibilityLevel;
import io.confluent.kafka.schemaregistry.maven.SchemaRegistryTest;
import io.confluent.kafka.schemaregistry.maven.TestLocalCompatibilityMojo;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import org.apache.maven.plugin.MojoExecutionException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestLocalCompatibilityMojoTest
extends SchemaRegistryTest {
    TestLocalCompatibilityMojo mojo;
    final String schema1 = "schema1";
    final String schema2 = "schema2";
    final String schema3 = "schema3";
    final String schema4 = "schema4";
    final String schema6 = "schema6";
    final String schema7 = "schema7";
    final String schema8 = "schema8";
    final String schema10 = "schema10";
    final String schema11 = "schema11";
    final String schema12 = "schema12";
    final String schema13 = "schema13";
    final String schema14 = "schema14";
    String fileExtension;

    @Before
    public void createMojoAndFiles() {
        this.mojo = new TestLocalCompatibilityMojo();
        this.makeFiles();
        for (int i = 1; i <= 9; ++i) {
            this.mojo.schemaTypes.put("schema" + i, "AVRO");
        }
        this.mojo.schemaTypes.put("schema10", "JSON");
        this.mojo.schemaTypes.put("schema13", "JSON");
        this.mojo.schemaTypes.put("schema14", "JSON");
    }

    private void makeFile(String schemaString, String name) {
        Throwable throwable;
        FileWriter writer;
        try {
            writer = new FileWriter(this.tempDirectory + "/" + name);
            throwable = null;
            try {
                writer.write(schemaString);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (writer != null) {
                    if (throwable != null) {
                        try {
                            writer.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        writer.close();
                    }
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (name.contains("1.avsc") || name.contains("2.avsc")) {
            try {
                writer = new FileWriter(this.tempDirectory + "/schema12Folder/" + name);
                throwable = null;
                try {
                    writer.write(schemaString);
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (writer != null) {
                        if (throwable != null) {
                            try {
                                writer.close();
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                        } else {
                            writer.close();
                        }
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void makeFiles() {
        File newFolder = new File(this.tempDirectory.toString() + "/schema12Folder");
        if (newFolder.mkdir()) {
            System.out.println("New Folder avro created successfully.");
        }
        String schemaString1 = "{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"string\",\"name\":\"f1\"}]}";
        this.makeFile(schemaString1, "schema1.avsc");
        String schemaString2 = "{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"string\",\"name\":\"f1\"}, {\"type\":\"string\",\"name\":\"f2\", \"default\": \"foo\"}]}";
        this.makeFile(schemaString2, "schema2.avsc");
        String schemaString3 = "{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"string\",\"name\":\"f1\"}, {\"type\":\"string\",\"name\":\"f2\"}]}";
        this.makeFile(schemaString3, "schema3.avsc");
        String schemaString4 = "{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"string\",\"name\":\"f1_new\", \"aliases\": [\"f1\"]}]}";
        this.makeFile(schemaString4, "schema4.avsc");
        String schemaString6 = "{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":[\"null\", \"string\"],\"name\":\"f1\", \"doc\":\"doc of f1\"}]}";
        this.makeFile(schemaString6, "schema6.avsc");
        String schemaString7 = "{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":[\"null\", \"string\", \"int\"],\"name\":\"f1\", \"doc\":\"doc of f1\"}]}";
        this.makeFile(schemaString7, "schema7.avsc");
        String schemaString8 = "{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"string\",\"name\":\"f1\"}, {\"type\":\"string\",\"name\":\"f2\", \"default\": \"foo\"}]}, {\"type\":\"string\",\"name\":\"f3\", \"default\": \"bar\"}]}";
        this.makeFile(schemaString8, "schema8.avsc");
        String schemaString10 = "{\n  \"type\": \"object\",\n  \"properties\": {\n    \"foo\": { \"type\": \"string\" },\n    \"bar\": { \"type\": \"string\" }\n  }\n}";
        this.makeFile(schemaString10, "schema10.json");
        String schemaString11 = "{\n  \"type\": \"object\",\n  \"properties\": {\n    \"foo\": { \"type\": \"string\" },\n    \"bar\": { \"type\": \"string\" }\n  },\n  \"additionalProperties\": false\n}";
        this.makeFile(schemaString11, "schema11.json");
        String schemaString12 = "{\n  \"type\": \"object\",\n  \"properties\": {\n    \"foo\": { \"type\": \"string\" },\n    \"bar\": { \"type\": \"string\" }\n  },\n  \"additionalProperties\": { \"type\": \"string\" }\n}";
        this.makeFile(schemaString12, "schema12.json");
        String schemaString13 = "{\n  \"type\": \"object\",\n  \"properties\": {\n    \"foo\": { \"type\": \"string\" },\n    \"bar\": { \"type\": \"string\" },\n    \"zap\": { \"type\": \"string\" }\n  },\n  \"additionalProperties\": { \"type\": \"string\" }\n}";
        this.makeFile(schemaString13, "schema13.json");
        String schemaString14 = "{\n  \"type\": \"object\",\n  \"properties\": {\n    \"foo\": { \"type\": \"string\" },\n    \"bar\": { \"type\": \"string\" },\n    \"zap\": { \n      \"oneOf\": [ { \"type\": \"string\" }, { \"type\": \"integer\" } ] \n    }\n  },\n  \"additionalProperties\": { \"type\": \"string\" }\n}";
        this.makeFile(schemaString14, "schema14.json");
    }

    private void setMojo(String schema, String previousSchemas) {
        this.mojo.schemas = Collections.singletonMap(schema, new File(this.tempDirectory + "/" + schema + this.fileExtension));
        this.mojo.previousSchemaPaths = new HashMap();
        File temp = new File(this.tempDirectory + "/" + previousSchemas);
        if (temp.isDirectory()) {
            this.mojo.previousSchemaPaths.put(schema, new File(this.tempDirectory + "/" + previousSchemas));
        } else {
            this.mojo.previousSchemaPaths.put(schema, new File(this.tempDirectory + "/" + previousSchemas + this.fileExtension));
        }
    }

    private boolean isCompatible(String schema, String previousSchemas, CompatibilityLevel compatibilityLevel) throws MojoExecutionException {
        this.setMojo(schema, previousSchemas);
        this.mojo.compatibilityLevels.put(schema, compatibilityLevel);
        this.mojo.execute();
        return true;
    }

    @Test
    public void testBasicBackwardsCompatibility() throws MojoExecutionException {
        this.fileExtension = ".avsc";
        Assert.assertTrue((String)"adding a field with default is a backward compatible change", (boolean)this.isCompatible("schema2", "schema1", CompatibilityLevel.BACKWARD));
        Assert.assertThrows((String)"adding a field w/o default is not a backward compatible change", MojoExecutionException.class, () -> this.isCompatible("schema3", "schema1", CompatibilityLevel.BACKWARD));
        Assert.assertTrue((String)"changing field name with alias is a backward compatible change", (boolean)this.isCompatible("schema4", "schema1", CompatibilityLevel.BACKWARD));
        Assert.assertTrue((String)"evolving a field type to a union is a backward compatible change", (boolean)this.isCompatible("schema6", "schema1", CompatibilityLevel.BACKWARD));
        Assert.assertThrows((String)"removing a type from a union is not a backward compatible change", MojoExecutionException.class, () -> this.isCompatible("schema1", "schema6", CompatibilityLevel.BACKWARD));
        Assert.assertTrue((String)"adding a new type in union is a backward compatible change", (boolean)this.isCompatible("schema7", "schema6", CompatibilityLevel.BACKWARD));
        Assert.assertThrows((String)"removing a type from a union is not a backward compatible change", MojoExecutionException.class, () -> this.isCompatible("schema6", "schema7", CompatibilityLevel.BACKWARD));
        this.mojo.schemaTypes.put("schema10", "JSON");
        this.mojo.schemaTypes.put("schema13", "JSON");
        this.mojo.schemaTypes.put("schema14", "JSON");
        this.fileExtension = ".json";
        Assert.assertTrue((String)"setting additional properties to true from false is a backward compatible change", (boolean)this.isCompatible("schema10", "schema11", CompatibilityLevel.BACKWARD));
        Assert.assertTrue((String)"adding property of string type (same as additional properties type) is a backward compatible change", (boolean)this.isCompatible("schema13", "schema12", CompatibilityLevel.BACKWARD));
        Assert.assertTrue((String)"adding property of string or int type (string is additional properties type) is a backward compatible change", (boolean)this.isCompatible("schema14", "schema12", CompatibilityLevel.BACKWARD));
    }

    @Test
    public void testBasicBackwardsTransitiveCompatibility() throws MojoExecutionException {
        this.fileExtension = ".avsc";
        Assert.assertTrue((String)"adding a field with default is a backward compatible change", (boolean)this.isCompatible("schema2", "schema1", CompatibilityLevel.BACKWARD_TRANSITIVE));
        Assert.assertTrue((String)"removing a default is a compatible change, but not transitively", (boolean)this.isCompatible("schema3", "schema2", CompatibilityLevel.BACKWARD_TRANSITIVE));
        Assert.assertThrows((String)"removing a default is not a transitively compatible change", MojoExecutionException.class, () -> this.isCompatible("schema3", "schema12Folder", CompatibilityLevel.BACKWARD_TRANSITIVE));
        Assert.assertTrue((String)"Checking if schema8 is backward compatible with schema1 and schema2 present in avro folder", (boolean)this.isCompatible("schema8", "schema12Folder", CompatibilityLevel.BACKWARD_TRANSITIVE));
    }

    @Test
    public void testBasicForwardsCompatibility() throws MojoExecutionException {
        this.fileExtension = ".avsc";
        Assert.assertTrue((String)"adding a field is a forward compatible change", (boolean)this.isCompatible("schema2", "schema1", CompatibilityLevel.FORWARD));
        Assert.assertTrue((String)"adding a field is a forward compatible change", (boolean)this.isCompatible("schema3", "schema1", CompatibilityLevel.FORWARD));
        Assert.assertTrue((String)"adding a field is a forward compatible change", (boolean)this.isCompatible("schema3", "schema2", CompatibilityLevel.FORWARD));
        Assert.assertTrue((String)"adding a field is a forward compatible change", (boolean)this.isCompatible("schema2", "schema3", CompatibilityLevel.FORWARD));
        this.fileExtension = ".avsc";
        Assert.assertThrows(MojoExecutionException.class, () -> this.isCompatible("schema1", "schema12Folder", CompatibilityLevel.FORWARD));
        this.fileExtension = ".json";
        this.mojo.schemaTypes.put("schema11", "JSON");
        this.mojo.schemaTypes.put("schema12", "JSON");
        this.mojo.schemaTypes.put("schema13", "JSON");
        Assert.assertTrue((String)"setting additional properties to false from true is a forward compatible change", (boolean)this.isCompatible("schema11", "schema10", CompatibilityLevel.FORWARD));
        Assert.assertTrue((String)"removing property of string type (same as additional properties type) is a backward compatible change", (boolean)this.isCompatible("schema13", "schema12", CompatibilityLevel.FORWARD));
        Assert.assertTrue((String)"removing property of string or int type (string is additional properties type) is a backward compatible change", (boolean)this.isCompatible("schema12", "schema14", CompatibilityLevel.FORWARD));
    }

    @Test
    public void testBasicForwardsTransitiveCompatibility() throws MojoExecutionException {
        this.fileExtension = ".avsc";
        Assert.assertTrue((String)"adding default to a field is a compatible change", (boolean)this.isCompatible("schema2", "schema3", CompatibilityLevel.FORWARD_TRANSITIVE));
        Assert.assertTrue((String)"removing a field with a default is a compatible change", (boolean)this.isCompatible("schema1", "schema2", CompatibilityLevel.FORWARD_TRANSITIVE));
    }

    @Test
    public void testBasicFullCompatibility() throws MojoExecutionException {
        this.fileExtension = ".avsc";
        Assert.assertTrue((String)"adding a field with default is a backward and a forward compatible change", (boolean)this.isCompatible("schema2", "schema1", CompatibilityLevel.FULL));
        Assert.assertThrows(MojoExecutionException.class, () -> this.isCompatible("schema3", "schema12Folder", CompatibilityLevel.FULL));
    }

    @Test
    public void testBasicFullTransitiveCompatibility() throws MojoExecutionException {
        this.fileExtension = ".avsc";
        Assert.assertTrue((String)"iteratively adding fields with defaults is a compatible change", (boolean)this.isCompatible("schema8", "schema12Folder", CompatibilityLevel.FULL_TRANSITIVE));
        Assert.assertTrue((String)"adding default to a field is a compatible change", (boolean)this.isCompatible("schema2", "schema3", CompatibilityLevel.FULL_TRANSITIVE));
        Assert.assertTrue((String)"removing a field with a default is a compatible change", (boolean)this.isCompatible("schema1", "schema2", CompatibilityLevel.FULL_TRANSITIVE));
        Assert.assertTrue((String)"adding a field with default is a compatible change", (boolean)this.isCompatible("schema2", "schema1", CompatibilityLevel.FULL_TRANSITIVE));
        Assert.assertTrue((String)"removing a default from a field compatible change", (boolean)this.isCompatible("schema3", "schema2", CompatibilityLevel.FULL_TRANSITIVE));
        Assert.assertThrows((String)"transitively adding a field without a default is not a compatible change", MojoExecutionException.class, () -> this.isCompatible("schema3", "schema12Folder", CompatibilityLevel.FULL_TRANSITIVE));
    }
}

