/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.maven;

import io.confluent.kafka.schemaregistry.ParsedSchema;
import io.confluent.kafka.schemaregistry.avro.AvroSchema;
import io.confluent.kafka.schemaregistry.client.MockSchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.rest.exceptions.RestClientException;
import io.confluent.kafka.schemaregistry.maven.SchemaRegistryTest;
import io.confluent.kafka.schemaregistry.maven.SetCompatibilityMojo;
import java.io.IOException;
import org.apache.avro.Schema;
import org.apache.maven.plugin.MojoExecutionException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SetCompatibilityMojoTest
extends SchemaRegistryTest {
    SetCompatibilityMojo mojo;

    @Before
    public void createMojoAndFiles() {
        this.mojo = new SetCompatibilityMojo();
        this.mojo.client((SchemaRegistryClient)new MockSchemaRegistryClient());
    }

    @Test
    public void specificSubjects() throws IOException, RestClientException, MojoExecutionException {
        String keySubject = String.format("TestSubject-key", new Object[0]);
        Schema keySchema = Schema.create((Schema.Type)Schema.Type.STRING);
        this.mojo.client().register(keySubject, (ParsedSchema)new AvroSchema(keySchema));
        Assert.assertThrows((String)"Checking that compatibility hasn't been set", RestClientException.class, () -> this.mojo.client().getCompatibility(keySubject));
        this.mojo.compatibilityLevels.put(keySubject, "BACKWARD");
        this.mojo.execute();
        assert (this.mojo.getConfig(keySubject).equals("BACKWARD"));
        this.mojo.compatibilityLevels.replace(keySubject, "BACKWARD", "FULL");
        this.mojo.execute();
        assert (this.mojo.getConfig(keySubject).equals("FULL"));
        this.mojo.compatibilityLevels.put("__GLOBAL", "BACKWARD_TRANSITIVE");
        this.mojo.execute();
        assert (this.mojo.getConfig(null).equals("BACKWARD_TRANSITIVE"));
    }
}

