/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.maven;

import io.confluent.kafka.schemaregistry.ParsedSchema;
import io.confluent.kafka.schemaregistry.avro.AvroSchema;
import io.confluent.kafka.schemaregistry.client.MockSchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.rest.exceptions.RestClientException;
import io.confluent.kafka.schemaregistry.maven.DownloadSchemaRegistryMojo;
import io.confluent.kafka.schemaregistry.maven.SchemaRegistryTest;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.avro.Schema;
import org.junit.Before;
import org.junit.Test;

public class DownloadSchemaRegistryMojoTest
extends SchemaRegistryTest {
    DownloadSchemaRegistryMojo mojo;

    @Before
    public void createMojo() {
        this.mojo = new DownloadSchemaRegistryMojo();
        this.mojo.client((SchemaRegistryClient)new MockSchemaRegistryClient());
    }

    @Test
    public void specificSubjects() throws IOException, RestClientException {
        boolean version = true;
        ArrayList files = new ArrayList();
        this.mojo.subjectPatterns.clear();
        for (int i = 0; i < 100; ++i) {
            String keySubject = String.format("TestSubject%03d-key", i);
            String valueSubject = String.format("TestSubject%03d-value", i);
            Schema keySchema = Schema.create((Schema.Type)Schema.Type.STRING);
            Schema valueSchema = Schema.createUnion(Arrays.asList(Schema.create((Schema.Type)Schema.Type.STRING), Schema.create((Schema.Type)Schema.Type.NULL)));
            this.mojo.client().register(keySubject, (ParsedSchema)new AvroSchema(keySchema));
            this.mojo.client().register(valueSubject, (ParsedSchema)new AvroSchema(valueSchema));
            File keySchemaFile = new File(this.tempDirectory, keySubject + ".avsc");
            File valueSchemaFile = new File(this.tempDirectory, valueSubject + ".avsc");
            if (i % 10 != 0) continue;
            this.mojo.client().getSchemaMetadata(keySubject, 1);
            this.mojo.client().getLatestSchemaMetadata(keySubject);
            this.mojo.client().getSchemaMetadata(valueSubject, 1);
            this.mojo.client().getLatestSchemaMetadata(valueSubject);
        }
    }
}

