/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.maven;

import io.confluent.kafka.schemaregistry.ParsedSchema;
import io.confluent.kafka.schemaregistry.avro.AvroSchema;
import io.confluent.kafka.schemaregistry.client.MockSchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.rest.exceptions.RestClientException;
import io.confluent.kafka.schemaregistry.maven.SchemaRegistryTest;
import io.confluent.kafka.schemaregistry.maven.TestCompatibilitySchemaRegistryMojo;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedHashMap;
import org.apache.avro.Schema;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsEqual;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestCompatibilitySchemaRegistryMojoTest
extends SchemaRegistryTest {
    TestCompatibilitySchemaRegistryMojo mojo;

    @Before
    public void createMojo() {
        this.mojo = new TestCompatibilitySchemaRegistryMojo();
        this.mojo.client((SchemaRegistryClient)new MockSchemaRegistryClient());
    }

    @Test
    public void register() throws IOException, MojoFailureException, MojoExecutionException, RestClientException {
        LinkedHashMap<String, Boolean> expectedVersions = new LinkedHashMap<String, Boolean>();
        LinkedHashMap<String, File> subjectToFile = new LinkedHashMap<String, File>();
        for (int i = 0; i < 100; ++i) {
            String keySubject = String.format("TestSubject%03d-Key", i);
            String valueSubject = String.format("TestSubject%03d-Value", i);
            Schema keySchema = Schema.create((Schema.Type)Schema.Type.STRING);
            Schema valueSchema = Schema.createUnion(Arrays.asList(Schema.create((Schema.Type)Schema.Type.STRING), Schema.create((Schema.Type)Schema.Type.NULL)));
            this.mojo.client().register(keySubject, (ParsedSchema)new AvroSchema(keySchema));
            this.mojo.client().register(valueSubject, (ParsedSchema)new AvroSchema(valueSchema));
            File keySchemaFile = new File(this.tempDirectory, keySubject + ".avsc");
            File valueSchemaFile = new File(this.tempDirectory, valueSubject + ".avsc");
            this.writeSchema(keySchemaFile, keySchema);
            this.writeSchema(valueSchemaFile, valueSchema);
            subjectToFile.put(keySubject, keySchemaFile);
            expectedVersions.put(keySubject, true);
            subjectToFile.put(valueSubject, valueSchemaFile);
            expectedVersions.put(valueSubject, true);
        }
        this.mojo.subjects = subjectToFile;
        this.mojo.execute();
        Assert.assertThat((Object)this.mojo.schemaCompatibility, (Matcher)IsEqual.equalTo(expectedVersions));
    }

    @Test(expected=IllegalStateException.class)
    public void malformedSchema() throws IOException, MojoFailureException, MojoExecutionException, RestClientException {
        LinkedHashMap<String, File> subjectToFile = new LinkedHashMap<String, File>();
        for (int i = 0; i < 100; ++i) {
            String keySubject = String.format("TestSubject%03d-Key", i);
            String valueSubject = String.format("TestSubject%03d-Value", i);
            Schema keySchema = Schema.create((Schema.Type)Schema.Type.STRING);
            Schema valueSchema = Schema.createUnion(Arrays.asList(Schema.create((Schema.Type)Schema.Type.STRING), Schema.create((Schema.Type)Schema.Type.NULL)));
            this.mojo.client().register(keySubject, (ParsedSchema)new AvroSchema(keySchema));
            this.mojo.client().register(valueSubject, (ParsedSchema)new AvroSchema(valueSchema));
            File keySchemaFile = new File(this.tempDirectory, keySubject + ".avsc");
            File valueSchemaFile = new File(this.tempDirectory, valueSubject + ".avsc");
            if (i % 7 == 0) {
                this.writeMalformedFile(keySchemaFile);
                this.writeMalformedFile(valueSchemaFile);
            } else {
                this.writeSchema(keySchemaFile, keySchema);
                this.writeSchema(valueSchemaFile, valueSchema);
            }
            subjectToFile.put(keySubject, keySchemaFile);
            subjectToFile.put(valueSubject, valueSchemaFile);
        }
        this.mojo.subjects = subjectToFile;
        this.mojo.execute();
    }

    @Test(expected=IllegalStateException.class)
    public void missingSchemas() throws IOException, MojoFailureException, MojoExecutionException, RestClientException {
        LinkedHashMap<String, File> subjectToFile = new LinkedHashMap<String, File>();
        for (int i = 0; i < 100; ++i) {
            String keySubject = String.format("TestSubject%03d-Key", i);
            String valueSubject = String.format("TestSubject%03d-Value", i);
            Schema keySchema = Schema.create((Schema.Type)Schema.Type.STRING);
            Schema valueSchema = Schema.createUnion(Arrays.asList(Schema.create((Schema.Type)Schema.Type.STRING), Schema.create((Schema.Type)Schema.Type.NULL)));
            this.mojo.client().register(keySubject, (ParsedSchema)new AvroSchema(keySchema));
            this.mojo.client().register(valueSubject, (ParsedSchema)new AvroSchema(valueSchema));
            File keySchemaFile = new File(this.tempDirectory, keySubject + ".avsc");
            File valueSchemaFile = new File(this.tempDirectory, valueSubject + ".avsc");
            if (i % 7 == 0) {
                this.writeSchema(keySchemaFile, keySchema);
                this.writeSchema(valueSchemaFile, valueSchema);
            }
            subjectToFile.put(keySubject, keySchemaFile);
            subjectToFile.put(valueSubject, valueSchemaFile);
        }
        this.mojo.subjects = subjectToFile;
        this.mojo.execute();
    }

    @Test
    public void incompatibleSchemas() throws IOException, MojoFailureException, MojoExecutionException, RestClientException {
        LinkedHashMap<String, Boolean> expectedVersions = new LinkedHashMap<String, Boolean>();
        LinkedHashMap<String, File> subjectToFile = new LinkedHashMap<String, File>();
        for (int i = 0; i < 100; ++i) {
            String keySubject = String.format("TestSubject%03d-Key", i);
            String valueSubject = String.format("TestSubject%03d-Value", i);
            Schema keySchema = Schema.create((Schema.Type)Schema.Type.STRING);
            Schema valueSchema = Schema.createUnion(Arrays.asList(Schema.create((Schema.Type)Schema.Type.STRING), Schema.create((Schema.Type)Schema.Type.NULL)));
            this.mojo.client().register(keySubject, (ParsedSchema)new AvroSchema(keySchema));
            this.mojo.client().register(valueSubject, (ParsedSchema)new AvroSchema(valueSchema));
            File keySchemaFile = new File(this.tempDirectory, keySubject + ".avsc");
            File valueSchemaFile = new File(this.tempDirectory, valueSubject + ".avsc");
            subjectToFile.put(keySubject, keySchemaFile);
            boolean keyCompatible = true;
            boolean valueCompatible = true;
            if (i % 7 == 0) {
                keyCompatible = false;
                valueCompatible = false;
                keySchema = Schema.create((Schema.Type)Schema.Type.INT);
                valueSchema = Schema.create((Schema.Type)Schema.Type.BYTES);
            }
            this.writeSchema(keySchemaFile, keySchema);
            this.writeSchema(valueSchemaFile, valueSchema);
            expectedVersions.put(keySubject, keyCompatible);
            subjectToFile.put(valueSubject, valueSchemaFile);
            expectedVersions.put(valueSubject, valueCompatible);
        }
        this.mojo.subjects = subjectToFile;
        try {
            this.mojo.execute();
            Assert.fail((String)"IllegalState exception should have been thrown.");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        Assert.assertThat((Object)this.mojo.schemaCompatibility, (Matcher)IsEqual.equalTo(expectedVersions));
    }
}

