/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.maven;

import io.confluent.kafka.schemaregistry.client.MockSchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.schemaregistry.maven.RegisterSchemaRegistryMojo;
import io.confluent.kafka.schemaregistry.maven.SchemaRegistryTest;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedHashMap;
import org.apache.avro.Schema;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsEqual;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class RegisterSchemaRegistryMojoTest
extends SchemaRegistryTest {
    RegisterSchemaRegistryMojo mojo;

    @Before
    public void createMojo() {
        this.mojo = new RegisterSchemaRegistryMojo();
        this.mojo.client((SchemaRegistryClient)new MockSchemaRegistryClient());
    }

    @Test
    public void register() throws IOException, MojoFailureException, MojoExecutionException {
        LinkedHashMap<String, Integer> expectedVersions = new LinkedHashMap<String, Integer>();
        LinkedHashMap<String, File> subjectToFile = new LinkedHashMap<String, File>();
        int version = 1;
        for (int i = 0; i < 100; ++i) {
            String keySubject = String.format("TestSubject%03d-key", i);
            String valueSubject = String.format("TestSubject%03d-value", i);
            Schema keySchema = Schema.create((Schema.Type)Schema.Type.STRING);
            Schema valueSchema = Schema.createUnion(Arrays.asList(Schema.create((Schema.Type)Schema.Type.STRING), Schema.create((Schema.Type)Schema.Type.NULL)));
            File keySchemaFile = new File(this.tempDirectory, keySubject + ".avsc");
            File valueSchemaFile = new File(this.tempDirectory, valueSubject + ".avsc");
            this.writeSchema(keySchemaFile, keySchema);
            this.writeSchema(valueSchemaFile, valueSchema);
            subjectToFile.put(keySubject, keySchemaFile);
            expectedVersions.put(keySubject, version++);
            subjectToFile.put(valueSubject, valueSchemaFile);
            expectedVersions.put(valueSubject, version++);
        }
        this.mojo.subjects = subjectToFile;
        this.mojo.execute();
        Assert.assertThat((Object)this.mojo.schemaVersions, (Matcher)IsEqual.equalTo(expectedVersions));
    }

    @Test(expected=IllegalStateException.class)
    public void malformedSchema() throws IOException, MojoFailureException, MojoExecutionException {
        LinkedHashMap<String, Integer> expectedVersions = new LinkedHashMap<String, Integer>();
        LinkedHashMap<String, File> subjectToFile = new LinkedHashMap<String, File>();
        int version = 1;
        for (int i = 0; i < 100; ++i) {
            String keySubject = String.format("TestSubject%03d-key", i);
            String valueSubject = String.format("TestSubject%03d-value", i);
            Schema keySchema = Schema.create((Schema.Type)Schema.Type.STRING);
            Schema valueSchema = Schema.createUnion(Arrays.asList(Schema.create((Schema.Type)Schema.Type.STRING), Schema.create((Schema.Type)Schema.Type.NULL)));
            File keySchemaFile = new File(this.tempDirectory, keySubject + ".avsc");
            File valueSchemaFile = new File(this.tempDirectory, valueSubject + ".avsc");
            if (i % 7 == 0) {
                this.writeMalformedFile(keySchemaFile);
                this.writeMalformedFile(valueSchemaFile);
            }
            subjectToFile.put(keySubject, keySchemaFile);
            expectedVersions.put(keySubject, version++);
            subjectToFile.put(valueSubject, valueSchemaFile);
            expectedVersions.put(valueSubject, version++);
        }
        this.mojo.subjects = subjectToFile;
        this.mojo.execute();
    }

    @Test(expected=IllegalStateException.class)
    public void missingSchemas() throws IOException, MojoFailureException, MojoExecutionException {
        LinkedHashMap<String, Integer> expectedVersions = new LinkedHashMap<String, Integer>();
        LinkedHashMap<String, File> subjectToFile = new LinkedHashMap<String, File>();
        int version = 1;
        for (int i = 0; i < 100; ++i) {
            String keySubject = String.format("TestSubject%03d-key", i);
            String valueSubject = String.format("TestSubject%03d-value", i);
            Schema keySchema = Schema.create((Schema.Type)Schema.Type.STRING);
            Schema valueSchema = Schema.createUnion(Arrays.asList(Schema.create((Schema.Type)Schema.Type.STRING), Schema.create((Schema.Type)Schema.Type.NULL)));
            File keySchemaFile = new File(this.tempDirectory, keySubject + ".avsc");
            File valueSchemaFile = new File(this.tempDirectory, valueSubject + ".avsc");
            if (i % 7 == 0) {
                this.writeSchema(keySchemaFile, keySchema);
                this.writeSchema(valueSchemaFile, valueSchema);
            }
            subjectToFile.put(keySubject, keySchemaFile);
            expectedVersions.put(keySubject, version++);
            subjectToFile.put(valueSubject, valueSchemaFile);
            expectedVersions.put(valueSubject, version++);
        }
        this.mojo.subjects = subjectToFile;
        this.mojo.execute();
    }
}

