/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.serializers.protobuf;

import com.google.protobuf.Descriptors;
import com.google.protobuf.DynamicMessage;
import com.google.protobuf.Message;
import com.google.protobuf.Timestamp;
import io.confluent.kafka.schemaregistry.client.MockSchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.serializers.protobuf.KafkaProtobufDeserializer;
import io.confluent.kafka.serializers.protobuf.KafkaProtobufSerializer;
import io.confluent.kafka.serializers.protobuf.test.DependencyTestProto;
import io.confluent.kafka.serializers.protobuf.test.EnumReferenceOuter;
import io.confluent.kafka.serializers.protobuf.test.EnumRootOuter;
import io.confluent.kafka.serializers.protobuf.test.NestedTestProto;
import io.confluent.kafka.serializers.protobuf.test.TestMessageProtos;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.junit.Assert;
import org.junit.Test;

public class KafkaProtobufSerializerTest {
    private final SchemaRegistryClient schemaRegistry;
    private final KafkaProtobufSerializer protobufSerializer;
    private final KafkaProtobufDeserializer protobufDeserializer;
    private final KafkaProtobufDeserializer deriveTypeDeserializer;
    private final KafkaProtobufDeserializer testMessageDeserializer;
    private final KafkaProtobufDeserializer nestedMessageDeserializer;
    private final KafkaProtobufDeserializer dependencyMessageDeserializer;
    private final KafkaProtobufDeserializer enumRefDeserializer;
    private final KafkaProtobufDeserializer innerMessageDeserializer;
    private final String topic;
    private static final String TEST_MSG_STRING = "Hello World";
    private static final TestMessageProtos.TestMessage HELLO_WORLD_MESSAGE = TestMessageProtos.TestMessage.newBuilder().setTestString("Hello World").setTestInt32(123).build();
    private static final TestMessageProtos.TestMessage2 HELLO_WORLD_MESSAGE2 = TestMessageProtos.TestMessage2.newBuilder().setTestString("Hello World").setTestInt32(123).build();
    private static final NestedTestProto.UserId USER_ID = NestedTestProto.UserId.newBuilder().setKafkaUserId("user1").build();
    private static final NestedTestProto.ComplexType COMPLEX_TYPE = NestedTestProto.ComplexType.newBuilder().setOneId("complex").setIsActive(true).build();
    private static final Timestamp TS = Timestamp.newBuilder().setSeconds(1000L).setNanos(2000).build();
    private static final NestedTestProto.NestedMessage NESTED_MESSAGE = NestedTestProto.NestedMessage.newBuilder().setUserId(USER_ID).setIsActive(true).addExperimentsActive("first").addExperimentsActive("second").setUpdatedAt(TS).setStatus(NestedTestProto.Status.ACTIVE).setComplexType(COMPLEX_TYPE).putMapType("key1", "value1").putMapType("key2", "value2").build();
    private static final DependencyTestProto.DependencyMessage DEPENDENCY_MESSAGE = DependencyTestProto.DependencyMessage.newBuilder().setNestedMessage(NESTED_MESSAGE).setIsActive(true).setTestMesssage(HELLO_WORLD_MESSAGE).build();
    private static final EnumReferenceOuter.EnumReference ENUM_REF = EnumReferenceOuter.EnumReference.newBuilder().setEnumRoot(EnumRootOuter.EnumRoot.GOODBYE).build();
    private static final NestedTestProto.NestedMessage.InnerMessage INNER_MESSAGE = NestedTestProto.NestedMessage.InnerMessage.newBuilder().setId("inner").build();

    public KafkaProtobufSerializerTest() {
        Properties serializerConfig = new Properties();
        serializerConfig.put("auto.register.schemas", (Object)true);
        serializerConfig.put("schema.registry.url", "bogus");
        this.schemaRegistry = new MockSchemaRegistryClient();
        this.protobufSerializer = new KafkaProtobufSerializer(this.schemaRegistry, new HashMap<Object, Object>(serializerConfig));
        this.protobufDeserializer = new KafkaProtobufDeserializer(this.schemaRegistry);
        Properties deriveTypeDeserializerConfig = new Properties();
        deriveTypeDeserializerConfig.put("schema.registry.url", "bogus");
        deriveTypeDeserializerConfig.put("derive.type", (Object)true);
        this.deriveTypeDeserializer = new KafkaProtobufDeserializer(this.schemaRegistry, new HashMap<Object, Object>(deriveTypeDeserializerConfig), null);
        Properties testMessageDeserializerConfig = new Properties();
        testMessageDeserializerConfig.put("schema.registry.url", "bogus");
        this.testMessageDeserializer = new KafkaProtobufDeserializer(this.schemaRegistry, new HashMap<Object, Object>(testMessageDeserializerConfig), TestMessageProtos.TestMessage.class);
        Properties nestedMessageDeserializerConfig = new Properties();
        nestedMessageDeserializerConfig.put("schema.registry.url", "bogus");
        this.nestedMessageDeserializer = new KafkaProtobufDeserializer(this.schemaRegistry, new HashMap<Object, Object>(nestedMessageDeserializerConfig), NestedTestProto.NestedMessage.class);
        Properties dependencyMessageDeserializerConfig = new Properties();
        dependencyMessageDeserializerConfig.put("schema.registry.url", "bogus");
        this.dependencyMessageDeserializer = new KafkaProtobufDeserializer(this.schemaRegistry, new HashMap<Object, Object>(dependencyMessageDeserializerConfig), DependencyTestProto.DependencyMessage.class);
        Properties enumRefDeserializerConfig = new Properties();
        enumRefDeserializerConfig.put("schema.registry.url", "bogus");
        this.enumRefDeserializer = new KafkaProtobufDeserializer(this.schemaRegistry, new HashMap<Object, Object>(enumRefDeserializerConfig), EnumReferenceOuter.EnumReference.class);
        Properties innerMessageDeserializerConfig = new Properties();
        innerMessageDeserializerConfig.put("schema.registry.url", "bogus");
        this.innerMessageDeserializer = new KafkaProtobufDeserializer(this.schemaRegistry, new HashMap<Object, Object>(innerMessageDeserializerConfig), NestedTestProto.NestedMessage.InnerMessage.class);
        this.topic = "test";
    }

    public static Object getField(DynamicMessage message, String fieldName) {
        for (Map.Entry entry : message.getAllFields().entrySet()) {
            if (!((Descriptors.FieldDescriptor)entry.getKey()).getName().equals(fieldName)) continue;
            return entry.getValue();
        }
        return null;
    }

    @Test
    public void testKafkaProtobufSerializer() {
        byte[] bytes = this.protobufSerializer.serialize(this.topic, (Message)HELLO_WORLD_MESSAGE);
        Assert.assertEquals((Object)HELLO_WORLD_MESSAGE, (Object)this.testMessageDeserializer.deserialize(this.topic, bytes));
        bytes = this.protobufSerializer.serialize(this.topic, (Message)HELLO_WORLD_MESSAGE);
        Assert.assertEquals((Object)HELLO_WORLD_MESSAGE, (Object)this.deriveTypeDeserializer.deserialize(this.topic, bytes));
        bytes = this.protobufSerializer.serialize(this.topic, (Message)HELLO_WORLD_MESSAGE);
        DynamicMessage message = (DynamicMessage)this.protobufDeserializer.deserialize(this.topic, bytes);
        Assert.assertEquals((Object)HELLO_WORLD_MESSAGE.getTestString(), (Object)KafkaProtobufSerializerTest.getField(message, "test_string"));
        Assert.assertEquals((Object)HELLO_WORLD_MESSAGE.getTestInt32(), (Object)KafkaProtobufSerializerTest.getField(message, "test_int32"));
        bytes = this.protobufSerializer.serialize(this.topic, (Message)message);
        Assert.assertEquals((Object)HELLO_WORLD_MESSAGE, (Object)this.testMessageDeserializer.deserialize(this.topic, bytes));
        bytes = this.protobufSerializer.serialize(this.topic, (Message)message);
        Assert.assertEquals((Object)HELLO_WORLD_MESSAGE, (Object)this.deriveTypeDeserializer.deserialize(this.topic, bytes));
        bytes = this.protobufSerializer.serialize(this.topic, (Message)message);
        message = (DynamicMessage)this.protobufDeserializer.deserialize(this.topic, bytes);
        Assert.assertEquals((Object)HELLO_WORLD_MESSAGE.getTestString(), (Object)KafkaProtobufSerializerTest.getField(message, "test_string"));
        Assert.assertEquals((Object)HELLO_WORLD_MESSAGE.getTestInt32(), (Object)KafkaProtobufSerializerTest.getField(message, "test_int32"));
        bytes = this.protobufSerializer.serialize(this.topic, (Message)HELLO_WORLD_MESSAGE2);
        Assert.assertEquals((Object)HELLO_WORLD_MESSAGE2, (Object)this.deriveTypeDeserializer.deserialize(this.topic, bytes));
        bytes = this.protobufSerializer.serialize(this.topic, (Message)HELLO_WORLD_MESSAGE2);
        message = (DynamicMessage)this.protobufDeserializer.deserialize(this.topic, bytes);
        Assert.assertEquals((Object)HELLO_WORLD_MESSAGE2.getTestString(), (Object)KafkaProtobufSerializerTest.getField(message, "test_string"));
        Assert.assertEquals((Object)HELLO_WORLD_MESSAGE2.getTestInt32(), (Object)KafkaProtobufSerializerTest.getField(message, "test_int32"));
        bytes = this.protobufSerializer.serialize(this.topic, (Message)message);
        Assert.assertEquals((Object)HELLO_WORLD_MESSAGE2, (Object)this.deriveTypeDeserializer.deserialize(this.topic, bytes));
        bytes = this.protobufSerializer.serialize(this.topic, (Message)message);
        message = (DynamicMessage)this.protobufDeserializer.deserialize(this.topic, bytes);
        Assert.assertEquals((Object)HELLO_WORLD_MESSAGE2.getTestString(), (Object)KafkaProtobufSerializerTest.getField(message, "test_string"));
        Assert.assertEquals((Object)HELLO_WORLD_MESSAGE2.getTestInt32(), (Object)KafkaProtobufSerializerTest.getField(message, "test_int32"));
        bytes = this.protobufSerializer.serialize(this.topic, (Message)NESTED_MESSAGE);
        Assert.assertEquals((Object)NESTED_MESSAGE, (Object)this.nestedMessageDeserializer.deserialize(this.topic, bytes));
        bytes = this.protobufSerializer.serialize(this.topic, (Message)NESTED_MESSAGE);
        Assert.assertEquals((Object)NESTED_MESSAGE, (Object)this.deriveTypeDeserializer.deserialize(this.topic, bytes));
        bytes = this.protobufSerializer.serialize(this.topic, (Message)NESTED_MESSAGE);
        message = (DynamicMessage)this.protobufDeserializer.deserialize(this.topic, bytes);
        Assert.assertEquals((Object)NESTED_MESSAGE.getUserId().getKafkaUserId(), (Object)KafkaProtobufSerializerTest.getField((DynamicMessage)KafkaProtobufSerializerTest.getField(message, "user_id"), "kafka_user_id"));
        bytes = this.protobufSerializer.serialize(this.topic, (Message)message);
        Assert.assertEquals((Object)NESTED_MESSAGE, (Object)this.nestedMessageDeserializer.deserialize(this.topic, bytes));
        bytes = this.protobufSerializer.serialize(this.topic, (Message)message);
        Assert.assertEquals((Object)NESTED_MESSAGE, (Object)this.deriveTypeDeserializer.deserialize(this.topic, bytes));
        bytes = this.protobufSerializer.serialize(this.topic, (Message)message);
        message = (DynamicMessage)this.protobufDeserializer.deserialize(this.topic, bytes);
        Assert.assertEquals((Object)NESTED_MESSAGE.getUserId().getKafkaUserId(), (Object)KafkaProtobufSerializerTest.getField((DynamicMessage)KafkaProtobufSerializerTest.getField(message, "user_id"), "kafka_user_id"));
        bytes = this.protobufSerializer.serialize(this.topic, null);
        Assert.assertEquals(null, (Object)this.protobufDeserializer.deserialize(this.topic, bytes));
    }

    @Test
    public void testDependency() {
        byte[] bytes = this.protobufSerializer.serialize(this.topic, (Message)DEPENDENCY_MESSAGE);
        Assert.assertEquals((Object)DEPENDENCY_MESSAGE, (Object)this.dependencyMessageDeserializer.deserialize(this.topic, bytes));
        bytes = this.protobufSerializer.serialize(this.topic, (Message)DEPENDENCY_MESSAGE);
        DynamicMessage message = (DynamicMessage)this.protobufDeserializer.deserialize(this.topic, bytes);
        Assert.assertEquals((Object)DEPENDENCY_MESSAGE.getNestedMessage().getUserId().getKafkaUserId(), (Object)KafkaProtobufSerializerTest.getField((DynamicMessage)KafkaProtobufSerializerTest.getField((DynamicMessage)KafkaProtobufSerializerTest.getField(message, "nested_message"), "user_id"), "kafka_user_id"));
    }

    @Test
    public void testEnumRoot() {
        byte[] bytes = this.protobufSerializer.serialize(this.topic, (Message)ENUM_REF);
        Assert.assertEquals((Object)ENUM_REF, (Object)this.enumRefDeserializer.deserialize(this.topic, bytes));
        bytes = this.protobufSerializer.serialize(this.topic, (Message)ENUM_REF);
        DynamicMessage message = (DynamicMessage)this.protobufDeserializer.deserialize(this.topic, bytes);
        Assert.assertEquals((Object)ENUM_REF.getEnumRoot().name(), (Object)((Descriptors.EnumValueDescriptor)KafkaProtobufSerializerTest.getField(message, "enum_root")).getName());
    }

    @Test
    public void testInner() {
        byte[] bytes = this.protobufSerializer.serialize(this.topic, (Message)INNER_MESSAGE);
        Assert.assertEquals((Object)INNER_MESSAGE, (Object)this.innerMessageDeserializer.deserialize(this.topic, bytes));
        bytes = this.protobufSerializer.serialize(this.topic, (Message)INNER_MESSAGE);
        DynamicMessage message = (DynamicMessage)this.protobufDeserializer.deserialize(this.topic, bytes);
        Assert.assertEquals((Object)INNER_MESSAGE.getId(), (Object)KafkaProtobufSerializerTest.getField(message, "id"));
    }
}

