/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.storage.partitioner;

import io.confluent.connect.storage.StorageSinkTestBase;
import io.confluent.connect.storage.partitioner.DefaultPartitioner;
import java.util.HashMap;
import java.util.LinkedHashMap;
import org.apache.kafka.connect.sink.SinkRecord;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.junit.Test;

public class DefaultPartitionerTest
extends StorageSinkTestBase {
    @Test
    public void testDefaultPartitioner() {
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("directory.delim", "/");
        DefaultPartitioner partitioner = new DefaultPartitioner();
        partitioner.configure(config);
        String timeZoneString = (String)config.get("timezone");
        long timestamp = new DateTime(2014, 2, 1, 3, 0, 0, 0, DateTimeZone.forID((String)timeZoneString)).getMillis();
        SinkRecord sinkRecord = this.createSinkRecord(timestamp);
        String encodedPartition = partitioner.encodePartition(sinkRecord);
        LinkedHashMap<String, Integer> m = new LinkedHashMap<String, Integer>();
        m.put("partition", 12);
        MatcherAssert.assertThat((Object)encodedPartition, (Matcher)CoreMatchers.is((Object)this.generateEncodedPartitionFromMap(m)));
    }
}

