/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.storage.partitioner;

import io.confluent.connect.storage.StorageSinkTestBase;
import io.confluent.connect.storage.errors.PartitionException;
import io.confluent.connect.storage.partitioner.FieldPartitioner;
import io.confluent.connect.storage.partitioner.PartitionerConfig;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.sink.SinkRecord;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;

public class FieldPartitionerTest
extends StorageSinkTestBase {
    private <T> FieldPartitioner<T> getFieldPartitioner(String ... fields) {
        HashMap<String, Object> config = new HashMap<String, Object>();
        config.put("directory.delim", "/");
        config.put("partition.field.name", Arrays.asList(fields));
        config.put("partitioner.class", PartitionerConfig.PARTITIONER_CLASS_DEFAULT);
        FieldPartitioner partitioner = new FieldPartitioner();
        partitioner.configure(config);
        return partitioner;
    }

    private <T> String getEncodedPatitionerPath(FieldPartitioner<T> partitioner) {
        SinkRecord sinkRecord = this.createSinkRecord(12L);
        return partitioner.encodePartition(sinkRecord);
    }

    @Test
    public void testBoolPartition() {
        String fieldName = "boolean";
        FieldPartitioner partitioner = this.getFieldPartitioner(fieldName);
        String path = this.getEncodedPatitionerPath(partitioner);
        LinkedHashMap<String, Boolean> m = new LinkedHashMap<String, Boolean>();
        m.put(fieldName, true);
        MatcherAssert.assertThat((Object)path, (Matcher)CoreMatchers.is((Object)this.generateEncodedPartitionFromMap(m)));
    }

    @Test
    public void testNumberPartition() {
        String fieldName = "int";
        FieldPartitioner intPartitioner = this.getFieldPartitioner(fieldName);
        String path = this.getEncodedPatitionerPath(intPartitioner);
        LinkedHashMap<String, Number> m = new LinkedHashMap<String, Number>();
        m.put(fieldName, 12);
        MatcherAssert.assertThat((Object)path, (Matcher)CoreMatchers.is((Object)this.generateEncodedPartitionFromMap(m)));
        fieldName = "long";
        FieldPartitioner longPartitioner = this.getFieldPartitioner(fieldName);
        path = this.getEncodedPatitionerPath(longPartitioner);
        m = new LinkedHashMap();
        m.put(fieldName, 12L);
        MatcherAssert.assertThat((Object)path, (Matcher)CoreMatchers.is((Object)this.generateEncodedPartitionFromMap(m)));
    }

    @Test
    public void testFloatPartition() throws PartitionException {
        String fieldName = "float";
        FieldPartitioner partitioner = this.getFieldPartitioner(fieldName);
        Exception e = (Exception)Assert.assertThrows(PartitionException.class, () -> this.getEncodedPatitionerPath(partitioner));
        Assert.assertEquals((Object)"Error encoding partition.", (Object)e.getMessage());
    }

    @Test
    public void testDoublePartition() throws PartitionException {
        String fieldName = "double";
        FieldPartitioner partitioner = this.getFieldPartitioner(fieldName);
        Exception e = (Exception)Assert.assertThrows(PartitionException.class, () -> this.getEncodedPatitionerPath(partitioner));
        Assert.assertEquals((Object)"Error encoding partition.", (Object)e.getMessage());
    }

    @Test
    public void testStringPartition() {
        String fieldName = "string";
        FieldPartitioner partitioner = this.getFieldPartitioner(fieldName);
        String path = this.getEncodedPatitionerPath(partitioner);
        LinkedHashMap<String, String> m = new LinkedHashMap<String, String>();
        m.put(fieldName, "def");
        MatcherAssert.assertThat((Object)path, (Matcher)CoreMatchers.is((Object)this.generateEncodedPartitionFromMap(m)));
    }

    @Test
    public void testNotStructPartition() throws PartitionException {
        String fieldName = "foo";
        FieldPartitioner partitioner = this.getFieldPartitioner(fieldName);
        SinkRecord sinkRecord = new SinkRecord("test-topic", 12, Schema.STRING_SCHEMA, null, Schema.STRING_SCHEMA, (Object)fieldName, 0L);
        Exception e = (Exception)Assert.assertThrows(PartitionException.class, () -> partitioner.encodePartition(sinkRecord));
        Assert.assertEquals((Object)"Error encoding partition.", (Object)e.getMessage());
    }

    @Test
    public void testMultiPartition() {
        FieldPartitioner partitioner = this.getFieldPartitioner("string", "int");
        String path = this.getEncodedPatitionerPath(partitioner);
        LinkedHashMap<String, Object> m = new LinkedHashMap<String, Object>();
        m.put("string", "def");
        m.put("int", 12);
        MatcherAssert.assertThat((Object)path, (Matcher)CoreMatchers.is((Object)this.generateEncodedPartitionFromMap(m)));
        partitioner = this.getFieldPartitioner("int", "string");
        path = this.getEncodedPatitionerPath(partitioner);
        m = new LinkedHashMap();
        m.put("int", 12);
        m.put("string", "def");
        MatcherAssert.assertThat((Object)path, (Matcher)CoreMatchers.is((Object)this.generateEncodedPartitionFromMap(m)));
    }
}

