/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.storage.partitioner;

import io.confluent.connect.storage.StorageSinkTestBase;
import io.confluent.connect.storage.partitioner.DailyPartitioner;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import org.apache.kafka.connect.sink.SinkRecord;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.junit.Test;

public class DailyPartitionerTest
extends StorageSinkTestBase {
    protected static final DateTimeZone DATE_TIME_ZONE = DateTimeZone.forID((String)"America/Los_Angeles");

    @Test
    public void testDailyPartitioner() {
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("directory.delim", "/");
        config.put("timestamp.extractor", "Record");
        config.put("locale", Locale.US.toString());
        config.put("timezone", DATE_TIME_ZONE.toString());
        DailyPartitioner partitioner = new DailyPartitioner();
        partitioner.configure(config);
        String timeZoneString = (String)config.get("timezone");
        int year = 2014;
        int month = 2;
        int day = 1;
        long timestamp = new DateTime(year, month, day, 3, 0, 0, 0, DateTimeZone.forID((String)timeZoneString)).getMillis();
        SinkRecord sinkRecord = this.createSinkRecord(timestamp);
        String encodedPartition = partitioner.encodePartition(sinkRecord);
        LinkedHashMap<String, Object> m = new LinkedHashMap<String, Object>();
        m.put("year", year);
        m.put("month", String.format("%02d", month));
        m.put("day", String.format("%02d", day));
        MatcherAssert.assertThat((Object)encodedPartition, (Matcher)CoreMatchers.is((Object)this.generateEncodedPartitionFromMap(m)));
    }
}

