/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.storage.partitioner;

import io.confluent.connect.storage.StorageSinkTestBase;
import io.confluent.connect.storage.errors.PartitionException;
import io.confluent.connect.storage.partitioner.TimeBasedPartitioner;
import io.confluent.connect.storage.util.DateTimeUtils;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.connect.connector.ConnectRecord;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.data.Timestamp;
import org.apache.kafka.connect.errors.ConnectException;
import org.apache.kafka.connect.sink.SinkRecord;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.DateTimeFormatterBuilder;
import org.joda.time.format.ISODateTimeFormat;
import org.junit.Assert;
import org.junit.Test;

public class TimeBasedPartitionerTest
extends StorageSinkTestBase {
    private static final String TIME_ZONE = "America/Los_Angeles";
    private static final DateTimeZone DATE_TIME_ZONE = DateTimeZone.forID((String)"America/Los_Angeles");
    private static final String PATH_FORMAT = "'year'=YYYY/'month'=M/'day'=d/'hour'=H/";
    private static final int YEAR = 2015;
    private static final int MONTH = 4;
    private static final int DAY = 2;
    private static final int HOUR = 1;
    public static final DateTime DATE_TIME = new DateTime(2015, 4, 2, 1, 0, DATE_TIME_ZONE);

    @Test
    public void testGetDurationMs() {
        BiHourlyPartitioner partitioner = (BiHourlyPartitioner)this.configurePartitioner(new BiHourlyPartitioner(), null, null);
        MatcherAssert.assertThat((Object)partitioner.getPartitionDurationMs(), (Matcher)CoreMatchers.is((Object)BiHourlyPartitioner.partitionDurationMs));
    }

    @Test
    public void testNonPostitiveDuration() {
        HashMap<String, Long> config = new HashMap<String, Long>();
        config.put("partition.duration.ms", -1L);
        Exception e = (Exception)Assert.assertThrows(ConfigException.class, () -> this.configurePartitioner(new TimeBasedPartitioner(), null, config));
        MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.startsWith((String)"Invalid value -1 for configuration partition.duration.ms"));
    }

    @Test
    public void testGetPathFormat() {
        BiHourlyPartitioner partitioner = (BiHourlyPartitioner)this.configurePartitioner(new BiHourlyPartitioner(), null, null);
        MatcherAssert.assertThat((Object)partitioner.getPathFormat(), (Matcher)CoreMatchers.is((Object)PATH_FORMAT));
    }

    @Test
    public void testGeneratePartitionedPath() throws Exception {
        BiHourlyPartitioner partitioner = (BiHourlyPartitioner)this.configurePartitioner(new BiHourlyPartitioner(), null, null);
        SinkRecord sinkRecord = this.getSinkRecord();
        String encodedPartition = partitioner.encodePartition(sinkRecord);
        String topic = "topic";
        String path = partitioner.generatePartitionedPath("topic", encodedPartition);
        Assert.assertEquals((Object)"topic/year=2015/month=4/day=2/hour=0/", (Object)path);
    }

    @Test
    public void testInvalidPathFormat() {
        String configKey = "path.format";
        String pathFormat = "year='YYYY'/month='MM'";
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("path.format", "year='YYYY'/month='MM'");
        Exception e = (Exception)Assert.assertThrows(ConfigException.class, () -> this.configurePartitioner(new TimeBasedPartitioner(), null, config));
        MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.startsWith((String)String.format("Invalid value %s for configuration %s", "year='YYYY'/month='MM'", "path.format")));
    }

    @Test
    public void testNullPathFormat() {
        TimeBasedPartitioner partitioner = new TimeBasedPartitioner();
        Map<String, Object> config = this.createConfig(null);
        String configKey = "path.format";
        String msg = "Path format cannot be empty.";
        Object path = null;
        config.put("path.format", path);
        Exception e = (Exception)Assert.assertThrows(ConfigException.class, () -> partitioner.configure(config));
        Assert.assertEquals((Object)String.format("Invalid value %s for configuration %s: Path format cannot be empty.", path, "path.format"), (Object)e.getMessage());
    }

    @Test
    public void testEmptyPathFormat() {
        TimeBasedPartitioner partitioner = new TimeBasedPartitioner();
        Map<String, Object> config = this.createConfig(null);
        String configKey = "path.format";
        String msg = "Path format cannot be empty.";
        String path = "";
        config.put("path.format", path);
        Exception e = (Exception)Assert.assertThrows(ConfigException.class, () -> partitioner.configure(config));
        Assert.assertEquals((Object)String.format("Invalid value %s for configuration %s: Path format cannot be empty.", path, "path.format"), (Object)e.getMessage());
    }

    @Test
    public void testRootPathFormat() {
        String configKey = "path.format";
        String msg = "Path format cannot be empty.";
        String path = "/";
        Map<String, Object> config = this.createConfig(null);
        config.put("path.format", path);
        Exception e = (Exception)Assert.assertThrows(ConfigException.class, () -> this.configurePartitioner(new TimeBasedPartitioner(), null, config));
        Assert.assertEquals((Object)String.format("Invalid value %s for configuration %s: Path format cannot be empty.", path, "path.format"), (Object)e.getMessage());
    }

    @Test
    public void testPathFormatEndDelim() {
        Map<String, Object> config = this.createConfig(null);
        config.put("path.format", "'year='YYYY/");
        TimeBasedPartitioner partitioner = this.configurePartitioner(new TimeBasedPartitioner(), null, config);
        Assert.assertEquals((Object)"'year='YYYY", (Object)partitioner.getPathFormat());
    }

    @Test
    public void testNullLocale() {
        TimeBasedPartitioner partitioner = new TimeBasedPartitioner();
        Map<String, Object> config = this.createConfig(null);
        String configKey = "locale";
        String msg = "Locale cannot be empty.";
        Object localeString = null;
        config.put("locale", localeString);
        Exception e = (Exception)Assert.assertThrows(ConfigException.class, () -> partitioner.configure(config));
        Assert.assertEquals((Object)String.format("Invalid value %s for configuration %s: Locale cannot be empty.", localeString, "locale"), (Object)e.getMessage());
    }

    @Test
    public void testEmptyLocale() {
        TimeBasedPartitioner partitioner = new TimeBasedPartitioner();
        Map<String, Object> config = this.createConfig(null);
        String configKey = "locale";
        String msg = "Locale cannot be empty.";
        String localeString = "";
        config.put("locale", localeString);
        Exception e = (Exception)Assert.assertThrows(ConfigException.class, () -> partitioner.configure(config));
        Assert.assertEquals((Object)String.format("Invalid value %s for configuration %s: Locale cannot be empty.", localeString, "locale"), (Object)e.getMessage());
    }

    @Test
    public void testNullTimezone() {
        TimeBasedPartitioner partitioner = new TimeBasedPartitioner();
        Map<String, Object> config = this.createConfig(null);
        String configKey = "timezone";
        String msg = "Timezone cannot be empty.";
        Object timeZoneString = null;
        config.put("timezone", timeZoneString);
        Exception e = (Exception)Assert.assertThrows(ConfigException.class, () -> partitioner.configure(config));
        Assert.assertEquals((Object)String.format("Invalid value %s for configuration %s: Timezone cannot be empty.", timeZoneString, "timezone"), (Object)e.getMessage());
    }

    @Test
    public void testEmptyTimezone() {
        TimeBasedPartitioner partitioner = new TimeBasedPartitioner();
        Map<String, Object> config = this.createConfig(null);
        String configKey = "timezone";
        String msg = "Timezone cannot be empty.";
        String timeZoneString = "";
        config.put("timezone", timeZoneString);
        Exception e = (Exception)Assert.assertThrows(ConfigException.class, () -> partitioner.configure(config));
        Assert.assertEquals((Object)String.format("Invalid value %s for configuration %s: Timezone cannot be empty.", timeZoneString, "timezone"), (Object)e.getMessage());
    }

    @Test
    public void testInvalidTimestampExtractor() {
        String extractorClassName = "Future";
        extractorClassName = TimeBasedPartitioner.class.getName() + "$" + extractorClassName + "TimestampExtractor";
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("timestamp.extractor", extractorClassName);
        Exception e = (Exception)Assert.assertThrows(ConfigException.class, () -> this.configurePartitioner(new TimeBasedPartitioner(), null, config));
        Assert.assertEquals((Object)("Invalid timestamp extractor: " + extractorClassName), (Object)e.getMessage());
    }

    @Test
    public void testUnassignableTimestampExtractor() {
        String extractorClassName = DateTimeUtils.class.getName();
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("timestamp.extractor", extractorClassName);
        Exception e = (Exception)Assert.assertThrows(ConnectException.class, () -> this.configurePartitioner(new TimeBasedPartitioner(), null, config));
        Assert.assertEquals((Object)String.format("Class %s does not implement TimestampExtractor", extractorClassName), (Object)e.getMessage());
    }

    @Test
    public void testRemovePathFormatEndDelim() {
        HashMap<String, Object> config = new HashMap<String, Object>();
        config.put("path.format", "'year='YYYY/");
        TimeBasedPartitioner partitioner = this.configurePartitioner(new TimeBasedPartitioner(), null, config);
        MatcherAssert.assertThat((Object)partitioner.getPathFormat(), (Matcher)CoreMatchers.is((Object)"'year='YYYY"));
    }

    @Test
    public void testRecordTimeExtractorNullSinkRecordTime() {
        SinkRecord r = this.createValuedSinkRecord(Schema.STRING_SCHEMA, "foo", null);
        Exception e = (Exception)Assert.assertThrows(ConnectException.class, () -> this.getEncodedPartition(null, r));
        MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.startsWith((String)"Unable to determine timestamp using timestamp.extractor"));
    }

    @Test
    public void testRecordFieldNotStructOrMap() {
        Schema valueSchema = Schema.STRING_SCHEMA;
        SinkRecord r = this.createValuedSinkRecord(valueSchema, "foo", 0L);
        Exception e = (Exception)Assert.assertThrows(PartitionException.class, () -> this.getEncodedPartition("bar", r));
        Assert.assertEquals((Object)"Error encoding partition.", (Object)e.getMessage());
    }

    @Test
    public void testNullSinkRecordTime() {
        SinkRecord r = new SinkRecord("test-topic", 12, null, null, Schema.STRING_SCHEMA, (Object)"foo", 0L);
        Exception e = (Exception)Assert.assertThrows(ConnectException.class, () -> this.getEncodedPartition(null, r));
        MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.startsWith((String)"Unable to determine timestamp using timestamp.extractor"));
    }

    @Test
    public void testIntTimeExtract() {
        TimeBasedPartitioner partitioner = this.configurePartitioner(new TimeBasedPartitioner(), "int", null);
        String path = this.getPartitionedPath(partitioner);
        long timeGranularityMs = (Long)partitioner.config.get("partition.duration.ms");
        long partitionMs = TimeBasedPartitioner.getPartition((long)timeGranularityMs, (long)12L, (DateTimeZone)DATE_TIME_ZONE);
        DateTime dt = new DateTime(partitionMs, DATE_TIME_ZONE);
        this.validatePathFromDateTime(path, (ReadableInstant)dt, "test-topic");
    }

    @Test
    public void testLongTimeExtract() {
        TimeBasedPartitioner partitioner = this.configurePartitioner(new TimeBasedPartitioner(), "long", null);
        String path = this.getPartitionedPath(partitioner);
        long timeGranularityMs = (Long)partitioner.config.get("partition.duration.ms");
        long partitionMs = TimeBasedPartitioner.getPartition((long)timeGranularityMs, (long)12L, (DateTimeZone)DATE_TIME_ZONE);
        DateTime dt = new DateTime(partitionMs, DATE_TIME_ZONE);
        this.validatePathFromDateTime(path, (ReadableInstant)dt, "test-topic");
    }

    @Test
    public void testFloatTimeExtract() {
        String fieldName = "float";
        Exception e = (Exception)Assert.assertThrows(PartitionException.class, () -> this.getEncodedPartition(fieldName));
        Assert.assertEquals((Object)("Error extracting timestamp from record field: " + fieldName), (Object)e.getMessage());
    }

    @Test
    public void testDoubleTimeExtract() {
        String fieldName = "double";
        Exception e = (Exception)Assert.assertThrows(PartitionException.class, () -> this.getEncodedPartition(fieldName));
        Assert.assertEquals((Object)("Error extracting timestamp from record field: " + fieldName), (Object)e.getMessage());
    }

    @Test
    public void testStructRecordFieldArrayExtraction() {
        String fieldName = "array";
        SchemaBuilder fieldSchema = SchemaBuilder.array((Schema)Schema.INT64_SCHEMA);
        long millis = DATE_TIME.getMillis();
        List<Long> value = Collections.singletonList(millis);
        SchemaBuilder valueSchema = SchemaBuilder.struct().field("array", (Schema)fieldSchema);
        Struct struct = new Struct((Schema)valueSchema).put("array", value);
        SinkRecord sinkRecord = this.createValuedSinkRecord((Schema)valueSchema, struct, millis);
        Exception e = (Exception)Assert.assertThrows(PartitionException.class, () -> this.getEncodedPartition("array", sinkRecord));
        Assert.assertEquals((Object)"Error extracting timestamp from record field: array", (Object)e.getMessage());
    }

    @Test
    public void testMapRecordFieldArrayExtraction() {
        String fieldName = "array";
        SchemaBuilder fieldSchema = SchemaBuilder.array((Schema)Schema.INT64_SCHEMA);
        long millis = DATE_TIME.getMillis();
        List<Long> value = Collections.singletonList(millis);
        HashMap<String, List<Long>> m = new HashMap<String, List<Long>>();
        m.put("array", value);
        SchemaBuilder mapSchema = SchemaBuilder.map((Schema)Schema.STRING_SCHEMA, (Schema)fieldSchema);
        SinkRecord sinkRecord = this.createValuedSinkRecord((Schema)mapSchema, m, millis);
        Exception e = (Exception)Assert.assertThrows(PartitionException.class, () -> this.getEncodedPartition("array", sinkRecord));
        Assert.assertEquals((Object)"Error extracting timestamp from record field: array", (Object)e.getMessage());
    }

    @Test
    public void testInvalidStringTimeStructExtract() {
        String fieldName = "string";
        SinkRecord sinkRecord = this.createSinkRecord(DATE_TIME.getMillis());
        Struct struct = (Struct)sinkRecord.value();
        MatcherAssert.assertThat((Object)String.valueOf(struct.get(fieldName)), (Matcher)CoreMatchers.is((Object)"def"));
        Exception e = (Exception)Assert.assertThrows(IllegalArgumentException.class, () -> this.getEncodedPartition(fieldName, sinkRecord));
        MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.startsWith((String)"Invalid format"));
    }

    @Test
    public void testInvalidStringTimeMapExtract() {
        String fieldName = "string";
        Schema keySchema = Schema.STRING_SCHEMA;
        Schema valueSchema = this.createNewSchema();
        SchemaBuilder mapSchema = SchemaBuilder.map((Schema)keySchema, (Schema)valueSchema);
        HashMap<String, Struct> m = new HashMap<String, Struct>();
        m.put("header", this.createRecord(valueSchema));
        SinkRecord sinkRecord = this.createValuedSinkRecord((Schema)mapSchema, m, DATE_TIME.getMillis());
        Struct nestedValue = (Struct)((Map)sinkRecord.value()).get("header");
        MatcherAssert.assertThat((Object)nestedValue.get(fieldName), (Matcher)CoreMatchers.is((Object)"abc"));
        Exception e = (Exception)Assert.assertThrows(IllegalArgumentException.class, () -> this.getEncodedPartition(String.format("header.%s", fieldName), sinkRecord));
        MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.startsWith((String)"Invalid format"));
    }

    @Test
    public void testStringTimeExtract() {
        DateTimeFormatter fmt = ISODateTimeFormat.dateTime();
        String timeStr = fmt.print((ReadableInstant)DATE_TIME);
        String timeFieldName = "timestamp";
        SchemaBuilder schema = SchemaBuilder.struct().name("record").field(timeFieldName, Schema.STRING_SCHEMA);
        Struct s = new Struct((Schema)schema).put(timeFieldName, (Object)timeStr);
        SinkRecord record = new SinkRecord("test-topic", 12, null, null, (Schema)schema, (Object)s, 0L, Long.valueOf(DATE_TIME.getMillis()), TimestampType.LOG_APPEND_TIME);
        String encodedPartition = this.getEncodedPartition(timeFieldName, record);
        this.validateEncodedPartition(encodedPartition);
    }

    @Test
    public void testNumericRecordFieldTimeMap() {
        String timeField = "timestamp";
        TimeBasedPartitioner partitioner = this.configurePartitioner(new TimeBasedPartitioner(), timeField, null);
        MatcherAssert.assertThat((Object)partitioner.getTimestampExtractor(), (Matcher)CoreMatchers.instanceOf(TimeBasedPartitioner.RecordFieldTimestampExtractor.class));
        Number ts = Integer.MAX_VALUE;
        this.testMapNumericTimestampPartitionEncoding(partitioner, timeField, ts, Schema.INT32_SCHEMA, new DateTime((long)((Number)ts).intValue()));
        ts = DATE_TIME.getMillis();
        this.testMapNumericTimestampPartitionEncoding(partitioner, timeField, ts, Schema.INT64_SCHEMA, DATE_TIME);
    }

    @Test
    public void testRecordFieldTimeDateExtractor() {
        String timeField = "timestamp";
        TimeBasedPartitioner partitioner = this.configurePartitioner(new TimeBasedPartitioner(), timeField, null);
        MatcherAssert.assertThat((Object)partitioner.getTimestampExtractor(), (Matcher)CoreMatchers.instanceOf(TimeBasedPartitioner.RecordFieldTimestampExtractor.class));
        DateTime moment = new DateTime(2015, 4, 2, 1, 0, 0, 0, DateTimeZone.forID((String)TIME_ZONE));
        String expectedPartition = "year=2015/month=4/day=2/hour=1";
        long rawTimestamp = moment.getMillis();
        SinkRecord sinkRecord = this.createSinkRecord(rawTimestamp);
        String encodedPartition = partitioner.encodePartition(sinkRecord);
        Assert.assertEquals((Object)expectedPartition, (Object)encodedPartition);
        String timestamp = ISODateTimeFormat.dateTimeNoMillis().print((ReadableInstant)moment);
        sinkRecord = this.createSinkRecord(Schema.STRING_SCHEMA, timestamp);
        encodedPartition = partitioner.encodePartition(sinkRecord);
        Assert.assertEquals((Object)expectedPartition, (Object)encodedPartition);
        timestamp = ISODateTimeFormat.dateTime().print((ReadableInstant)moment);
        sinkRecord = this.createSinkRecord(Schema.STRING_SCHEMA, timestamp);
        encodedPartition = partitioner.encodePartition(sinkRecord);
        Assert.assertEquals((Object)expectedPartition, (Object)encodedPartition);
        sinkRecord = this.createSinkRecord(Timestamp.SCHEMA, moment.toDate());
        encodedPartition = partitioner.encodePartition(sinkRecord);
        Assert.assertEquals((Object)expectedPartition, (Object)encodedPartition);
        int shortTimestamp = (int)new DateTime(1970, 1, 1, 0, 0, 0, 0, DateTimeZone.forID((String)TIME_ZONE)).getMillis();
        sinkRecord = this.createSinkRecord(Schema.INT32_SCHEMA, shortTimestamp);
        encodedPartition = partitioner.encodePartition(sinkRecord);
        Assert.assertEquals((Object)"year=1970/month=1/day=1/hour=0", (Object)encodedPartition);
        sinkRecord = this.createSinkRecord(rawTimestamp);
        String structEncodedPartition = partitioner.encodePartition(sinkRecord);
        this.validateEncodedPartition(structEncodedPartition);
        String mapEncodedPartition = this.testMapNumericTimestampPartitionEncoding(partitioner, timeField, DATE_TIME.toDate(), Timestamp.SCHEMA, DATE_TIME);
        MatcherAssert.assertThat((Object)structEncodedPartition, (Matcher)CoreMatchers.is((Object)mapEncodedPartition));
    }

    @Test
    public void testNestedRecordFieldTimeExtractor() throws Exception {
        TimeBasedPartitioner partitioner = this.configurePartitioner(new TimeBasedPartitioner(), "nested.timestamp", null);
        MatcherAssert.assertThat((Object)partitioner.getTimestampExtractor(), (Matcher)CoreMatchers.instanceOf(TimeBasedPartitioner.RecordFieldTimestampExtractor.class));
        long timestamp = DATE_TIME.getMillis();
        SinkRecord sinkRecord = this.createSinkRecordWithNestedTimestampField(timestamp);
        String encodedPartition = partitioner.encodePartition(sinkRecord);
        this.validateEncodedPartition(encodedPartition);
    }

    @Test
    public void testRecordFieldTimeStringExtractor() {
        DateTimeFormatter fmt = ISODateTimeFormat.dateTime();
        long millis = DATE_TIME.getMillis();
        String timeStr = fmt.print(millis);
        String timeFieldName = "timestamp";
        TimeBasedPartitioner partitioner = this.configurePartitioner(new TimeBasedPartitioner(), timeFieldName, null);
        MatcherAssert.assertThat((Object)partitioner.getTimestampExtractor(), (Matcher)CoreMatchers.instanceOf(TimeBasedPartitioner.RecordFieldTimestampExtractor.class));
        SchemaBuilder schema = SchemaBuilder.struct().name("record").field(timeFieldName, Schema.STRING_SCHEMA);
        Struct s = new Struct((Schema)schema).put(timeFieldName, (Object)timeStr);
        SinkRecord sinkRecord = this.createValuedSinkRecord((Schema)schema, s, millis);
        String encodedPartition = partitioner.encodePartition(sinkRecord);
        this.validateEncodedPartition(encodedPartition);
        SchemaBuilder mapSchema = SchemaBuilder.map((Schema)Schema.STRING_SCHEMA, (Schema)schema);
        HashMap<String, Struct> header = new HashMap<String, Struct>();
        header.put("header", s);
        sinkRecord = this.createValuedSinkRecord((Schema)mapSchema, header, millis);
        encodedPartition = this.getEncodedPartition(String.format("header.%s", timeFieldName), sinkRecord);
        this.validateEncodedPartition(encodedPartition);
    }

    private void validateTimestampAsMillisRecordExtracted(long millis) {
        String timeStr = String.valueOf(millis);
        String timeFieldName = "timestamp";
        TimeBasedPartitioner partitioner = this.configurePartitioner(new TimeBasedPartitioner(), timeFieldName, null);
        SchemaBuilder schema = SchemaBuilder.struct().name("record").field(timeFieldName, Schema.STRING_SCHEMA);
        Struct s = new Struct((Schema)schema).put(timeFieldName, (Object)timeStr);
        SinkRecord sinkRecord = this.createValuedSinkRecord((Schema)schema, s, millis);
        Long extractedTimestamp = partitioner.getTimestampExtractor().extract((ConnectRecord)sinkRecord);
        MatcherAssert.assertThat((Object)extractedTimestamp, (Matcher)CoreMatchers.is((Object)millis));
    }

    @Test
    public void testRecordFieldTimeAsMillisMinValueStringExtractorRecord() {
        long millis = Long.MIN_VALUE;
        this.validateTimestampAsMillisRecordExtracted(millis);
    }

    @Test
    public void testRecordFieldTimeAsMillisNegativeValueStringExtractorRecord() {
        long millis = -1L;
        this.validateTimestampAsMillisRecordExtracted(millis);
    }

    @Test
    public void testRecordFieldTimeAsMillisZeroStringExtractorRecord() {
        long millis = 0L;
        this.validateTimestampAsMillisRecordExtracted(millis);
    }

    @Test
    public void testRecordFieldTimeAsMillisStringExtractorRecord() {
        long millis = DATE_TIME.getMillis();
        this.validateTimestampAsMillisRecordExtracted(millis);
    }

    @Test
    public void testRecordFieldTimeAsMillisMaxValueStringExtractorRecord() {
        long millis = Long.MAX_VALUE;
        this.validateTimestampAsMillisRecordExtracted(millis);
    }

    private void validateTimestampAsMillisMapExtracted(long millis) {
        String timeStr = String.valueOf(millis);
        String timeFieldName = "timestamp";
        TimeBasedPartitioner partitioner = this.configurePartitioner(new TimeBasedPartitioner(), timeFieldName, null);
        SchemaBuilder mapSchema = SchemaBuilder.map((Schema)Schema.STRING_SCHEMA, (Schema)Schema.STRING_SCHEMA);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(timeFieldName, timeStr);
        SinkRecord sinkRecord = this.createValuedSinkRecord((Schema)mapSchema, map, millis);
        Long extractedTimestamp = partitioner.getTimestampExtractor().extract((ConnectRecord)sinkRecord);
        MatcherAssert.assertThat((Object)extractedTimestamp, (Matcher)CoreMatchers.is((Object)millis));
    }

    @Test
    public void testRecordFieldTimeAsMillisMinValueStringExtractorMap() {
        long millis = Long.MIN_VALUE;
        this.validateTimestampAsMillisMapExtracted(millis);
    }

    @Test
    public void testRecordFieldTimeAsMillisNegativeValueStringExtractorMap() {
        long millis = -1L;
        this.validateTimestampAsMillisMapExtracted(millis);
    }

    @Test
    public void testRecordFieldTimeAsMillisZeroStringExtractorMap() {
        long millis = 0L;
        this.validateTimestampAsMillisMapExtracted(millis);
    }

    @Test
    public void testRecordFieldTimeAsMillisStringExtractorMap() {
        Long millis = DATE_TIME.getMillis();
        this.validateTimestampAsMillisMapExtracted(millis);
    }

    @Test
    public void testRecordFieldTimeAsMillisMaxValueStringExtractorMap() {
        long millis = Long.MAX_VALUE;
        this.validateTimestampAsMillisMapExtracted(millis);
    }

    @Test
    public void testRecordTimeExtractor() throws Exception {
        TimeBasedPartitioner partitioner = this.configurePartitioner(new TimeBasedPartitioner(), null, null);
        MatcherAssert.assertThat((Object)partitioner.getTimestampExtractor(), (Matcher)CoreMatchers.instanceOf(TimeBasedPartitioner.RecordTimestampExtractor.class));
        SinkRecord sinkRecord = this.getSinkRecord();
        MatcherAssert.assertThat((Object)sinkRecord.timestamp(), (Matcher)CoreMatchers.is((Object)DATE_TIME.getMillis()));
        String encodedPartition = partitioner.encodePartition(sinkRecord);
        this.validateEncodedPartition(encodedPartition);
        encodedPartition = partitioner.encodePartition(sinkRecord, 123L);
        this.validateEncodedPartition(encodedPartition);
    }

    @Test
    public void testWallclockTimeExtractor() {
        long now = 15778800000L;
        TimeBasedPartitioner partitioner = this.configurePartitioner(new TimeBasedPartitioner(), null, Collections.singletonMap("timestamp.extractor", "Wallclock"));
        MatcherAssert.assertThat((Object)partitioner.getTimestampExtractor(), (Matcher)CoreMatchers.instanceOf(TimeBasedPartitioner.WallclockTimestampExtractor.class));
        SinkRecord sinkRecord = this.getSinkRecord();
        String encodedPartition = partitioner.encodePartition(sinkRecord, now);
        this.validatePathFromDateTime(encodedPartition, (ReadableInstant)new DateTime(now, DATE_TIME_ZONE));
    }

    private <T> String testMapNumericTimestampPartitionEncoding(TimeBasedPartitioner<T> partitioner, String timeField, Object timestamp, Schema valueSchema, DateTime dateToValidate) {
        Schema keySchema = Schema.STRING_SCHEMA;
        SchemaBuilder mapSchema = SchemaBuilder.map((Schema)keySchema, (Schema)valueSchema);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(timeField, timestamp);
        Long timestampValue = null;
        if (timestamp instanceof Number) {
            timestampValue = ((Number)timestamp).longValue();
        } else if (timestamp instanceof Date) {
            timestampValue = ((Date)timestamp).getTime();
        }
        MatcherAssert.assertThat((String)"Number or Date timestamp received", (Object)timestampValue, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        SinkRecord sinkRecord = this.createValuedSinkRecord((Schema)mapSchema, map, timestampValue);
        String encodedPartition = partitioner.encodePartition(sinkRecord);
        this.validatePathFromDateTime(encodedPartition, (ReadableInstant)dateToValidate);
        return encodedPartition;
    }

    private Map<String, Object> createConfig(String timeFieldName) {
        HashMap<String, Object> config = new HashMap<String, Object>();
        config.put("directory.delim", "/");
        config.put("timestamp.extractor", "Record" + (timeFieldName == null ? "" : "Field"));
        config.put("partition.duration.ms", TimeUnit.HOURS.toMillis(1L));
        config.put("path.format", PATH_FORMAT);
        config.put("locale", Locale.US.toString());
        config.put("timezone", DATE_TIME_ZONE.toString());
        if (timeFieldName != null) {
            config.put("timestamp.field", timeFieldName);
        }
        return config;
    }

    private <T> TimeBasedPartitioner<T> configurePartitioner(TimeBasedPartitioner<T> partitioner, String timeField, Map<String, Object> configOverride) {
        if (partitioner == null) {
            partitioner = new TimeBasedPartitioner();
        }
        Map<String, Object> config = this.createConfig(timeField);
        if (configOverride != null) {
            for (Map.Entry<String, Object> e : configOverride.entrySet()) {
                config.put(e.getKey(), e.getValue());
            }
        }
        partitioner.configure(config);
        return partitioner;
    }

    private SinkRecord getSinkRecord() {
        long timestamp = new DateTime(2015, 4, 2, 1, 0, 0, 0, DateTimeZone.forID((String)TIME_ZONE)).getMillis();
        return this.createSinkRecord(timestamp);
    }

    private SinkRecord createSinkRecord(Schema timestampSchema, Object timestamp) {
        Schema schema = this.createSchemaWithTimestampField(timestampSchema);
        Struct record = this.createRecordWithTimestampField(schema, timestamp);
        return new SinkRecord("test-topic", 12, Schema.STRING_SCHEMA, null, schema, (Object)record, 0L, Long.valueOf(timestamp instanceof Long ? ((Long)timestamp).longValue() : Time.SYSTEM.milliseconds()), TimestampType.CREATE_TIME);
    }

    private SinkRecord createSchemalessSinkRecord(Object timestamp) {
        HashMap<String, Object> record = new HashMap<String, Object>();
        record.put("timestamp", timestamp);
        return new SinkRecord("test-topic", 12, null, null, null, record, 0L, Long.valueOf(timestamp instanceof Long ? ((Long)timestamp).longValue() : Time.SYSTEM.milliseconds()), TimestampType.CREATE_TIME);
    }

    protected SinkRecord createSinkRecordWithNestedTimestampField(long timestamp) {
        Struct record = this.createRecordWithNestedTimestampField(timestamp);
        return new SinkRecord("test-topic", 12, Schema.STRING_SCHEMA, null, record.schema(), (Object)record, 0L, Long.valueOf(timestamp), TimestampType.CREATE_TIME);
    }

    private String getPartitionedPath(TimeBasedPartitioner<String> partitioner) {
        SinkRecord sinkRecord = this.getSinkRecord();
        String encodedPartition = partitioner.encodePartition(sinkRecord);
        return partitioner.generatePartitionedPath("test-topic", encodedPartition);
    }

    private SinkRecord createValuedSinkRecord(Schema valueSchema, Object value, Long timestamp) {
        return new SinkRecord("test-topic", 12, null, null, valueSchema, value, 0L, timestamp, timestamp == null ? TimestampType.NO_TIMESTAMP_TYPE : TimestampType.LOG_APPEND_TIME);
    }

    private String getEncodedPartition(String timeFieldName, SinkRecord r) {
        TimeBasedPartitioner partitioner = this.configurePartitioner(new TimeBasedPartitioner(), timeFieldName, null);
        return partitioner.encodePartition(r);
    }

    private String getEncodedPartition(String timeFieldName) {
        return this.getEncodedPartition(timeFieldName, this.getSinkRecord());
    }

    private void validateEncodedPartition(String encodedPartition) {
        this.validatePathFromDateTime(encodedPartition, (ReadableInstant)DATE_TIME, null);
    }

    private void validatePathFromDateTime(String path, ReadableInstant i) {
        this.validatePathFromDateTime(path, i, null);
    }

    private void validatePathFromDateTime(String path, ReadableInstant i, String topic) {
        int yearLength = 4;
        int monthLength = 1;
        int dayLength = 1;
        int hourLength = 1;
        String expectedPath = new DateTimeFormatterBuilder().appendLiteral((topic == null ? "" : "test-topic/") + "year=").appendYear(yearLength, yearLength).appendLiteral("/month=").appendMonthOfYear(monthLength).appendLiteral("/day=").appendDayOfMonth(dayLength).appendLiteral("/hour=").appendHourOfDay(hourLength).toFormatter().withLocale(Locale.US).withZone(DATE_TIME_ZONE).print(i);
        MatcherAssert.assertThat((Object)path, (Matcher)CoreMatchers.is((Object)expectedPath));
    }

    private static class BiHourlyPartitioner
    extends TimeBasedPartitioner<String> {
        private static long partitionDurationMs = TimeUnit.HOURS.toMillis(2L);

        private BiHourlyPartitioner() {
        }

        public String getPathFormat() {
            return TimeBasedPartitionerTest.PATH_FORMAT;
        }

        public void configure(Map<String, Object> config) {
            super.configure(config);
            this.init(partitionDurationMs, this.getPathFormat(), Locale.ENGLISH, DATE_TIME_ZONE, config);
        }
    }
}

