/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.storage.partitioner;

import io.confluent.connect.storage.StorageSinkTestBase;
import io.confluent.connect.storage.common.GenericRecommender;
import io.confluent.connect.storage.partitioner.PartitionerConfig;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class PartitionerConfigTest
extends StorageSinkTestBase {
    @Before
    public void setup() {
        this.properties = super.createProps();
    }

    @Test(expected=ConfigException.class)
    public void testInvalidTimezoneThrowsException() {
        this.properties.put("timezone", "LLL");
        new PartitionerConfig(PartitionerConfig.newConfigDef((ConfigDef.Recommender)new GenericRecommender()), this.properties);
    }

    @Test
    public void testValidTimezoneAccepted() {
        this.properties.put("timezone", "CET");
        new PartitionerConfig(PartitionerConfig.newConfigDef((ConfigDef.Recommender)new GenericRecommender()), this.properties);
    }

    @Test
    public void testTimezoneValidatedExceptionMessage() {
        this.properties.put("timezone", "LLL");
        String expectedError = String.format("Invalid value LLL for configuration %s: The datetime zone id 'LLL' is not recognised", "timezone");
        try {
            new PartitionerConfig(PartitionerConfig.newConfigDef((ConfigDef.Recommender)new GenericRecommender()), this.properties);
        }
        catch (ConfigException e) {
            Assert.assertEquals((Object)expectedError, (Object)e.getMessage());
        }
    }
}

