/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.storage.partitioner;

import io.confluent.connect.storage.StorageSinkTestBase;
import io.confluent.connect.storage.partitioner.HourlyPartitioner;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import org.apache.kafka.connect.sink.SinkRecord;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.junit.Test;

public class HourlyPartitionerTest
extends StorageSinkTestBase {
    protected static final DateTimeZone DATE_TIME_ZONE = DateTimeZone.forID((String)"America/Los_Angeles");

    @Test
    public void testHourlyPartitioner() {
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("directory.delim", "/");
        config.put("timestamp.extractor", "Record");
        config.put("locale", Locale.US.toString());
        config.put("timezone", DATE_TIME_ZONE.toString());
        HourlyPartitioner partitioner = new HourlyPartitioner();
        partitioner.configure(config);
        String timeZoneString = (String)config.get("timezone");
        int year = 2014;
        int month = 2;
        int day = 1;
        int hour = 3;
        long timestamp = new DateTime(year, month, day, hour, 0, 0, 0, DateTimeZone.forID((String)timeZoneString)).getMillis();
        SinkRecord sinkRecord = this.createSinkRecord(timestamp);
        String encodedPartition = partitioner.encodePartition(sinkRecord);
        LinkedHashMap<String, Object> m = new LinkedHashMap<String, Object>();
        m.put("year", year);
        m.put("month", String.format("%02d", month));
        m.put("day", String.format("%02d", day));
        m.put("hour", String.format("%02d", hour));
        MatcherAssert.assertThat((Object)encodedPartition, (Matcher)CoreMatchers.is((Object)this.generateEncodedPartitionFromMap(m)));
    }
}

