/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.storage.schema;

import io.confluent.connect.storage.schema.StorageSchemaCompatibility;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.errors.ConnectException;
import org.apache.kafka.connect.sink.SinkRecord;
import org.apache.kafka.connect.source.SourceRecord;
import org.junit.Assert;
import org.junit.Test;

public class StorageSchemaCompatibilityTest {
    private final StorageSchemaCompatibility none = StorageSchemaCompatibility.NONE;
    private final StorageSchemaCompatibility backward = StorageSchemaCompatibility.BACKWARD;
    private final StorageSchemaCompatibility forward = StorageSchemaCompatibility.FORWARD;
    private final StorageSchemaCompatibility full = StorageSchemaCompatibility.FULL;
    private static final Schema SCHEMA_A = StorageSchemaCompatibilityTest.buildIntSchema("a", 2).build();
    private static final Schema SCHEMA_A_COPY = StorageSchemaCompatibilityTest.buildIntSchema("a", 2).build();
    private static final Schema SCHEMA_A_RENAMED = StorageSchemaCompatibilityTest.buildIntSchema("b", 2).build();
    private static final Schema SCHEMA_A_OPTIONAL = StorageSchemaCompatibilityTest.buildIntSchema("a", 2).optional().build();
    private static final Schema SCHEMA_A_OLDER_VERSION = StorageSchemaCompatibilityTest.buildIntSchema("a", 1).build();
    private static final Schema SCHEMA_A_NEWER_VERSION = StorageSchemaCompatibilityTest.buildIntSchema("a", 3).build();
    private static final Schema SCHEMA_A_PARAMETERED = StorageSchemaCompatibilityTest.buildIntSchema("a", 2).parameter("x", "y").build();
    private static final Schema SCHEMA_A_RETYPED = StorageSchemaCompatibilityTest.buildStringSchema("a", 1).build();
    private static final Schema SCHEMA_A_WITH_DOC = StorageSchemaCompatibilityTest.buildIntSchema("a", 2).doc("doc").build();
    private static final Schema SCHEMA_B = StorageSchemaCompatibilityTest.buildStructSchema("b", 2).build();
    private static final Schema SCHEMA_B_COPY = StorageSchemaCompatibilityTest.buildStructSchema("b", 2).build();
    private static final Schema SCHEMA_B_RENAMED = StorageSchemaCompatibilityTest.buildStructSchema("c", 2).build();
    private static final Schema SCHEMA_B_OPTIONAL = StorageSchemaCompatibilityTest.buildStructSchema("b", 2).optional().build();
    private static final Schema SCHEMA_B_OLDER_VERSION = StorageSchemaCompatibilityTest.buildStructSchema("b", 1).build();
    private static final Schema SCHEMA_B_NEWER_VERSION = StorageSchemaCompatibilityTest.buildStructSchema("b", 3).build();
    private static final Schema SCHEMA_B_PARAMETERED = StorageSchemaCompatibilityTest.buildStructSchema("b", 2).parameter("x", "y").build();
    private static final Schema SCHEMA_B_RETYPED = StorageSchemaCompatibilityTest.buildStringSchema("b", 2).build();
    private static final Schema SCHEMA_B_WITH_DOC = StorageSchemaCompatibilityTest.buildStructSchema("b", 2).doc("doc").build();
    private static final Schema SCHEMA_B_EXTRA_REQUIRED_FIELD = StorageSchemaCompatibilityTest.buildStructSchema("b", 2).field("extra", Schema.STRING_SCHEMA).build();
    private static final Schema SCHEMA_B_EXTRA_OPTIONAL_FIELD = StorageSchemaCompatibilityTest.buildStructSchema("b", 2).field("extra", Schema.OPTIONAL_STRING_SCHEMA).build();

    private static SchemaBuilder buildStringSchema(String name, int version) {
        return SchemaBuilder.string().version(Integer.valueOf(version)).name(name);
    }

    private static SchemaBuilder buildIntSchema(String name, int version) {
        return SchemaBuilder.int32().version(Integer.valueOf(version)).name(name);
    }

    private static SchemaBuilder buildStructSchema(String name, int version) {
        return SchemaBuilder.struct().name(name).version(Integer.valueOf(version)).field("b", Schema.BOOLEAN_SCHEMA).field("i", Schema.INT32_SCHEMA).field("d", Schema.FLOAT64_SCHEMA).field("s", Schema.OPTIONAL_STRING_SCHEMA).field("x", SchemaBuilder.struct().field("inner1", Schema.BOOLEAN_SCHEMA).build());
    }

    @Test
    public void noneCompatibilityShouldConsiderSameVersionsAsUnchanged() {
        this.assertUnchanged(this.none, SCHEMA_A, SCHEMA_A_COPY);
        this.assertUnchanged(this.none, SCHEMA_B, SCHEMA_B_COPY);
    }

    @Test
    public void noneCompatibilityShouldConsiderDifferentVersionsAsChanged() {
        this.assertChanged(this.none, SCHEMA_A, SCHEMA_A_NEWER_VERSION);
        this.assertChanged(this.none, SCHEMA_A, SCHEMA_A_OLDER_VERSION);
        this.assertChanged(this.none, SCHEMA_B, SCHEMA_B_OLDER_VERSION);
        this.assertChanged(this.none, SCHEMA_B, SCHEMA_B_PARAMETERED);
    }

    @Test
    public void noneCompatibilityShouldConsiderAnyDifferencesAsChanged() {
        this.assertChanged(this.none, SCHEMA_A, SCHEMA_A_RENAMED);
        this.assertChanged(this.none, SCHEMA_A, SCHEMA_A_RETYPED);
        this.assertChanged(this.none, SCHEMA_A, SCHEMA_A_PARAMETERED);
        this.assertChanged(this.none, SCHEMA_A, SCHEMA_A_WITH_DOC);
        this.assertChanged(this.none, SCHEMA_A, SCHEMA_A_OPTIONAL);
        this.assertChanged(this.none, SCHEMA_B, SCHEMA_B_RENAMED);
        this.assertChanged(this.none, SCHEMA_B, SCHEMA_B_RETYPED);
        this.assertChanged(this.none, SCHEMA_B, SCHEMA_B_PARAMETERED);
        this.assertChanged(this.none, SCHEMA_B, SCHEMA_B_WITH_DOC);
        this.assertChanged(this.none, SCHEMA_B, SCHEMA_B_OPTIONAL);
        this.assertChanged(this.none, SCHEMA_B, SCHEMA_B_EXTRA_REQUIRED_FIELD);
        this.assertChanged(this.none, SCHEMA_B, SCHEMA_B_EXTRA_OPTIONAL_FIELD);
        this.assertUnchanged(this.none, SCHEMA_A, SCHEMA_A);
        this.assertUnchanged(this.none, SCHEMA_A, SCHEMA_A_COPY);
        this.assertUnchanged(this.none, SCHEMA_B, SCHEMA_B);
        this.assertUnchanged(this.none, SCHEMA_B, SCHEMA_B_COPY);
    }

    @Test
    public void backwardCompatibilityShouldConsiderOlderSchemaVersionsAsChanged() {
        this.assertChanged(this.backward, SCHEMA_A, SCHEMA_A_OLDER_VERSION);
        this.assertChanged(this.backward, SCHEMA_B, SCHEMA_B_OLDER_VERSION);
    }

    @Test
    public void backwardCompatibilityShouldConsiderSameOrNewerSchemaVersionsAsUnchanged() {
        this.assertUnchanged(this.backward, SCHEMA_A, SCHEMA_A_COPY);
        this.assertUnchanged(this.backward, SCHEMA_B, SCHEMA_B_COPY);
        this.assertUnchanged(this.backward, SCHEMA_A, SCHEMA_A_NEWER_VERSION);
        this.assertUnchanged(this.backward, SCHEMA_B, SCHEMA_B_NEWER_VERSION);
    }

    @Test
    public void forwardCompatibilityShouldConsiderNewerSchemaVersionsAsChanged() {
        this.assertChanged(this.forward, SCHEMA_A, SCHEMA_A_NEWER_VERSION);
        this.assertChanged(this.forward, SCHEMA_B, SCHEMA_B_NEWER_VERSION);
    }

    @Test
    public void forwardCompatibilityShouldConsiderSameOrOlderSchemaVersionsAsUnchanged() {
        this.assertUnchanged(this.forward, SCHEMA_A, SCHEMA_A_COPY);
        this.assertUnchanged(this.forward, SCHEMA_B, SCHEMA_B_COPY);
        this.assertUnchanged(this.forward, SCHEMA_A, SCHEMA_A_OLDER_VERSION);
        this.assertUnchanged(this.forward, SCHEMA_B, SCHEMA_B_OLDER_VERSION);
    }

    @Test
    public void fullCompatibilityShouldConsiderOlderSchemaVersionsAsChanged() {
        this.assertChanged(this.full, SCHEMA_A, SCHEMA_A_OLDER_VERSION);
        this.assertChanged(this.full, SCHEMA_B, SCHEMA_B_OLDER_VERSION);
    }

    @Test
    public void fullCompatibilityShouldConsiderSameOrNewerSchemaVersionsAsUnchanged() {
        this.assertUnchanged(this.full, SCHEMA_A, SCHEMA_A_COPY);
        this.assertUnchanged(this.full, SCHEMA_B, SCHEMA_B_COPY);
        this.assertUnchanged(this.full, SCHEMA_A, SCHEMA_A_NEWER_VERSION);
        this.assertUnchanged(this.full, SCHEMA_B, SCHEMA_B_NEWER_VERSION);
    }

    @Test
    public void allCompatibilitiesShouldConsiderSameOrEqualSchemasAsUnchanged() {
        this.assertUnchanged(this.none, SCHEMA_A, SCHEMA_A);
        this.assertUnchanged(this.none, SCHEMA_A, SCHEMA_A_COPY);
        this.assertUnchanged(this.none, SCHEMA_B, SCHEMA_B);
        this.assertUnchanged(this.none, SCHEMA_B, SCHEMA_B_COPY);
        this.assertUnchanged(this.backward, SCHEMA_A, SCHEMA_A);
        this.assertUnchanged(this.backward, SCHEMA_A, SCHEMA_A_COPY);
        this.assertUnchanged(this.backward, SCHEMA_B, SCHEMA_B);
        this.assertUnchanged(this.backward, SCHEMA_B, SCHEMA_B_COPY);
        this.assertUnchanged(this.forward, SCHEMA_A, SCHEMA_A);
        this.assertUnchanged(this.forward, SCHEMA_A, SCHEMA_A_COPY);
        this.assertUnchanged(this.forward, SCHEMA_B, SCHEMA_B);
        this.assertUnchanged(this.forward, SCHEMA_B, SCHEMA_B_COPY);
        this.assertUnchanged(this.full, SCHEMA_A, SCHEMA_A);
        this.assertUnchanged(this.full, SCHEMA_A, SCHEMA_A_COPY);
        this.assertUnchanged(this.full, SCHEMA_B, SCHEMA_B);
        this.assertUnchanged(this.full, SCHEMA_B, SCHEMA_B_COPY);
    }

    @Test
    public void allCompatibilitiesShouldConsiderDifferentSchemaNamesAsChanged() {
        this.assertChanged(this.none, SCHEMA_A, SCHEMA_A_RENAMED);
        this.assertChanged(this.backward, SCHEMA_A, SCHEMA_A_RENAMED);
        this.assertChanged(this.forward, SCHEMA_A, SCHEMA_A_RENAMED);
        this.assertChanged(this.full, SCHEMA_A, SCHEMA_A_RENAMED);
        this.assertChanged(this.none, SCHEMA_B, SCHEMA_B_RENAMED);
        this.assertChanged(this.backward, SCHEMA_B, SCHEMA_B_RENAMED);
        this.assertChanged(this.forward, SCHEMA_B, SCHEMA_B_RENAMED);
        this.assertChanged(this.full, SCHEMA_B, SCHEMA_B_RENAMED);
    }

    @Test
    public void allCompatibilitiesShouldConsiderDifferentSchemaTypesAsChanged() {
        this.assertChanged(this.none, SCHEMA_A, SCHEMA_A_RETYPED);
        this.assertChanged(this.backward, SCHEMA_A, SCHEMA_A_RETYPED);
        this.assertChanged(this.forward, SCHEMA_A, SCHEMA_A_RETYPED);
        this.assertChanged(this.full, SCHEMA_A, SCHEMA_A_RETYPED);
        this.assertChanged(this.none, SCHEMA_B, SCHEMA_B_RETYPED);
        this.assertChanged(this.backward, SCHEMA_B, SCHEMA_B_RETYPED);
        this.assertChanged(this.forward, SCHEMA_B, SCHEMA_B_RETYPED);
        this.assertChanged(this.full, SCHEMA_B, SCHEMA_B_RETYPED);
    }

    @Test
    public void allCompatibilitiesShouldConsiderDifferentSchemaParametersAsChanged() {
        this.assertChanged(this.none, SCHEMA_A, SCHEMA_A_PARAMETERED);
        this.assertChanged(this.backward, SCHEMA_A, SCHEMA_A_PARAMETERED);
        this.assertChanged(this.forward, SCHEMA_A, SCHEMA_A_PARAMETERED);
        this.assertChanged(this.full, SCHEMA_A, SCHEMA_A_PARAMETERED);
        this.assertChanged(this.none, SCHEMA_B, SCHEMA_B_PARAMETERED);
        this.assertChanged(this.backward, SCHEMA_B, SCHEMA_B_PARAMETERED);
        this.assertChanged(this.forward, SCHEMA_B, SCHEMA_B_PARAMETERED);
        this.assertChanged(this.full, SCHEMA_B, SCHEMA_B_PARAMETERED);
    }

    @Test
    public void backwardCompatibilityShouldConsiderDifferentSchemaDocsAsUnchanged() {
        this.assertUnchanged(this.backward, SCHEMA_A, SCHEMA_A_WITH_DOC);
        this.assertUnchanged(this.backward, SCHEMA_B, SCHEMA_B_WITH_DOC);
    }

    @Test
    public void forwardCompatibilityShouldConsiderDifferentSchemaDocsAsUnchanged() {
        this.assertUnchanged(this.forward, SCHEMA_A, SCHEMA_A_WITH_DOC);
        this.assertUnchanged(this.forward, SCHEMA_B, SCHEMA_B_WITH_DOC);
    }

    @Test
    public void fullCompatibilityShouldConsiderDifferentSchemaDocsAsUnchanged() {
        this.assertUnchanged(this.full, SCHEMA_A, SCHEMA_A_WITH_DOC);
        this.assertUnchanged(this.full, SCHEMA_B, SCHEMA_B_WITH_DOC);
    }

    @Test
    public void backwardCompatibilityShouldConsiderDifferentSchemaOptionalityAsUnchanged() {
        this.assertUnchanged(this.backward, SCHEMA_A, SCHEMA_A_OPTIONAL);
        this.assertUnchanged(this.backward, SCHEMA_B, SCHEMA_B_OPTIONAL);
    }

    @Test
    public void forwardCompatibilityShouldConsiderDifferentSchemaOptionalityAsUnchanged() {
        this.assertUnchanged(this.forward, SCHEMA_A, SCHEMA_A_OPTIONAL);
        this.assertUnchanged(this.forward, SCHEMA_B, SCHEMA_B_OPTIONAL);
    }

    @Test
    public void fullCompatibilityShouldConsiderDifferentSchemaOptionalityAsUnchanged() {
        this.assertUnchanged(this.full, SCHEMA_A, SCHEMA_A_OPTIONAL);
        this.assertUnchanged(this.full, SCHEMA_B, SCHEMA_B_OPTIONAL);
    }

    @Test
    public void backwardCompatibilityShouldConsiderDifferentFieldsAsUnchanged() {
        this.assertUnchanged(this.backward, SCHEMA_B, SCHEMA_B_EXTRA_OPTIONAL_FIELD);
        this.assertUnchanged(this.backward, SCHEMA_B_EXTRA_OPTIONAL_FIELD, SCHEMA_B);
        this.assertUnchanged(this.backward, SCHEMA_B_EXTRA_REQUIRED_FIELD, SCHEMA_B);
    }

    @Test
    public void forwardCompatibilityShouldConsiderDifferentFieldsAsUnchanged() {
        this.assertUnchanged(this.forward, SCHEMA_B, SCHEMA_B_EXTRA_OPTIONAL_FIELD);
        this.assertUnchanged(this.forward, SCHEMA_B_EXTRA_OPTIONAL_FIELD, SCHEMA_B);
        this.assertUnchanged(this.forward, SCHEMA_B_EXTRA_REQUIRED_FIELD, SCHEMA_B);
    }

    @Test
    public void fullCompatibilityShouldConsiderDifferentFieldsAsUnchanged() {
        this.assertUnchanged(this.full, SCHEMA_B, SCHEMA_B_EXTRA_OPTIONAL_FIELD);
        this.assertUnchanged(this.full, SCHEMA_B_EXTRA_OPTIONAL_FIELD, SCHEMA_B);
        this.assertUnchanged(this.full, SCHEMA_B_EXTRA_REQUIRED_FIELD, SCHEMA_B);
    }

    @Test
    public void allCompatibilitiesShouldConsiderExtraRequiredFieldsAsUnchangedButNotProjectable() {
        this.assertUnchanged(this.backward, SCHEMA_B, SCHEMA_B_EXTRA_REQUIRED_FIELD, false);
        this.assertUnchanged(this.forward, SCHEMA_B, SCHEMA_B_EXTRA_REQUIRED_FIELD, false);
        this.assertUnchanged(this.full, SCHEMA_B, SCHEMA_B_EXTRA_REQUIRED_FIELD, false);
    }

    protected void assertUnchanged(StorageSchemaCompatibility compatibility, Schema recordSchema, Schema currentSchema) {
        this.assertUnchanged(compatibility, recordSchema, currentSchema, true);
    }

    protected void assertUnchanged(StorageSchemaCompatibility compatibility, Schema recordSchema, Schema currentSchema, boolean isProjectable) {
        Assert.assertFalse((String)("Expected " + currentSchema + " to not be change in order to project " + recordSchema), (boolean)compatibility.validateAndCheck(recordSchema, currentSchema));
        this.assertProjectable(compatibility, recordSchema, currentSchema, isProjectable);
    }

    protected void assertChanged(StorageSchemaCompatibility compatibility, Schema recordSchema, Schema currentSchema) {
        Assert.assertTrue((String)("Expected " + currentSchema + " to change in order to project " + recordSchema), (boolean)compatibility.validateAndCheck(recordSchema, currentSchema));
    }

    protected void assertProjectable(StorageSchemaCompatibility compatibility, Schema recordSchema, Schema currentSchema, boolean isProjectable) {
        if (isProjectable) {
            compatibility.project(this.sinkRecordWith(recordSchema), null, currentSchema);
            compatibility.project(this.sourceRecordWith(recordSchema), null, currentSchema);
        } else {
            try {
                compatibility.project(this.sinkRecordWith(recordSchema), null, currentSchema);
                Assert.fail((String)("Expected " + recordSchema + " to not be able to be projected to " + currentSchema));
            }
            catch (ConnectException connectException) {
                // empty catch block
            }
            try {
                compatibility.project(this.sourceRecordWith(recordSchema), null, currentSchema);
                Assert.fail((String)("Expected " + recordSchema + " to not be able to be projected to " + currentSchema));
            }
            catch (ConnectException connectException) {
                // empty catch block
            }
        }
    }

    protected SinkRecord sinkRecordWith(Schema valueSchema) {
        return new SinkRecord("topic", 0, null, null, valueSchema, this.valueFor(valueSchema), 0L);
    }

    protected SourceRecord sourceRecordWith(Schema valueSchema) {
        Map empty = Collections.emptyMap();
        return new SourceRecord(empty, empty, "topic", null, null, valueSchema, this.valueFor(valueSchema));
    }

    protected Object valueFor(Schema schema) {
        switch (schema.type()) {
            case INT8: {
                return (byte)100;
            }
            case INT16: {
                return (short)100;
            }
            case INT32: {
                return 100;
            }
            case INT64: {
                return 100L;
            }
            case FLOAT32: {
                return 101.1;
            }
            case FLOAT64: {
                return 101.2;
            }
            case ARRAY: {
                return new ArrayList();
            }
            case MAP: {
                return new HashMap();
            }
            case BOOLEAN: {
                return true;
            }
            case BYTES: {
                return "hello".getBytes(StandardCharsets.UTF_8);
            }
            case STRING: {
                return "hello";
            }
            case STRUCT: {
                Struct struct = new Struct(schema);
                for (Field field : schema.fields()) {
                    struct.put(field, this.valueFor(field.schema()));
                }
                return struct;
            }
        }
        return null;
    }
}

