/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.storage.util;

import io.confluent.connect.storage.util.DateTimeUtils;
import java.util.concurrent.TimeUnit;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.junit.Assert;
import org.junit.Test;

public class DateTimeUtilsTest {
    private static final DateTimeZone DATE_TIME_ZONE = DateTimeZone.forID((String)"America/Los_Angeles");
    private final DateTime midnight = DateTime.now().withTimeAtStartOfDay();

    private DateTime calc(DateTime current, long periodMs) {
        return new DateTime(DateTimeUtils.getNextTimeAdjustedByDay((long)current.getMillis(), (long)periodMs, (DateTimeZone)current.getZone()));
    }

    private DateTime calcHourPeriod(DateTime current) {
        return this.calc(current, TimeUnit.HOURS.toMillis(1L));
    }

    @Test
    public void testGetNextTimeAdjustedByDayWOTimeZone() {
        Assert.assertEquals((Object)this.calcHourPeriod(this.midnight), (Object)this.midnight.plusHours(1));
        Assert.assertEquals((Object)this.calcHourPeriod(this.midnight.minusSeconds(1)), (Object)this.midnight);
        Assert.assertEquals((Object)this.calcHourPeriod(this.midnight.plusSeconds(1)), (Object)this.midnight.plusHours(1));
        Assert.assertEquals((Object)this.calcHourPeriod(this.midnight.plusHours(1)), (Object)this.midnight.plusHours(2));
        Assert.assertEquals((Object)this.calcHourPeriod(this.midnight.plusHours(1).minusSeconds(1)), (Object)this.midnight.plusHours(1));
    }

    @Test
    public void testGetNextTimeAdjustedByDayPeriodDoesNotFitIntoDay() {
        DateTime midnight = DateTime.now().withTimeAtStartOfDay();
        long sevenHoursMs = TimeUnit.HOURS.toMillis(7L);
        Assert.assertEquals((Object)this.calc(midnight, sevenHoursMs), (Object)midnight.plusHours(7));
        Assert.assertEquals((Object)this.calc(midnight.plusSeconds(1), sevenHoursMs), (Object)midnight.plusHours(7));
        Assert.assertEquals((Object)this.calc(midnight.plusSeconds(1), sevenHoursMs), (Object)midnight.plusHours(7));
        Assert.assertEquals((Object)this.calc(midnight.minusSeconds(1), sevenHoursMs), (Object)midnight);
        Assert.assertEquals((Object)this.calc(midnight.minusHours(7).minusSeconds(1), sevenHoursMs), (Object)midnight.minusDays(1).plusHours(21));
    }

    @Test
    public void testDaylightSavingTime() {
        DateTime time = new DateTime(2015, 11, 1, 2, 1, DATE_TIME_ZONE);
        String pathFormat = "'year='YYYY/'month='MMMM/'day='dd/'hour='H/";
        DateTimeFormatter formatter = DateTimeFormat.forPattern((String)pathFormat).withZone(DATE_TIME_ZONE);
        long utc1 = DATE_TIME_ZONE.convertLocalToUTC(time.getMillis() - TimeUnit.MINUTES.toMillis(60L), false);
        long utc2 = DATE_TIME_ZONE.convertLocalToUTC(time.getMillis() - TimeUnit.MINUTES.toMillis(120L), false);
        DateTime time1 = new DateTime(DATE_TIME_ZONE.convertUTCToLocal(utc1));
        DateTime time2 = new DateTime(DATE_TIME_ZONE.convertUTCToLocal(utc2));
        Assert.assertEquals((Object)time1.toString(formatter), (Object)time2.toString(formatter));
    }
}

