/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.storage.util;

import io.confluent.connect.storage.util.DateTimeUtils;
import java.util.concurrent.TimeUnit;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.junit.Assert;
import org.junit.Test;

public class DateTimeUtilsTest {
    private final DateTime midnight = DateTime.now().withTimeAtStartOfDay();

    private DateTime calc(DateTime current, long periodMs) {
        return new DateTime(DateTimeUtils.getNextTimeAdjustedByDay((long)current.getMillis(), (long)periodMs, (DateTimeZone)current.getZone()));
    }

    private DateTime calcHourPeriod(DateTime current) {
        return this.calc(current, TimeUnit.HOURS.toMillis(1L));
    }

    @Test
    public void testGetNextTimeAdjustedByDayWOTimeZone() {
        Assert.assertEquals((Object)this.calcHourPeriod(this.midnight), (Object)this.midnight.plusHours(1));
        Assert.assertEquals((Object)this.calcHourPeriod(this.midnight.minusSeconds(1)), (Object)this.midnight);
        Assert.assertEquals((Object)this.calcHourPeriod(this.midnight.plusSeconds(1)), (Object)this.midnight.plusHours(1));
        Assert.assertEquals((Object)this.calcHourPeriod(this.midnight.plusHours(1)), (Object)this.midnight.plusHours(2));
        Assert.assertEquals((Object)this.calcHourPeriod(this.midnight.plusHours(1).minusSeconds(1)), (Object)this.midnight.plusHours(1));
    }

    @Test
    public void testGetNextTimeAdjustedByDayPeriodDoesNotFitIntoDay() {
        DateTime midnight = DateTime.now().withTimeAtStartOfDay();
        long sevenHoursMs = TimeUnit.HOURS.toMillis(7L);
        Assert.assertEquals((Object)this.calc(midnight, sevenHoursMs), (Object)midnight.plusHours(7));
        Assert.assertEquals((Object)this.calc(midnight.plusSeconds(1), sevenHoursMs), (Object)midnight.plusHours(7));
        Assert.assertEquals((Object)this.calc(midnight.plusSeconds(1), sevenHoursMs), (Object)midnight.plusHours(7));
        Assert.assertEquals((Object)this.calc(midnight.minusSeconds(1), sevenHoursMs), (Object)midnight);
        Assert.assertEquals((Object)this.calc(midnight.minusHours(7).minusSeconds(1), sevenHoursMs), (Object)midnight.minusDays(1).plusHours(21));
    }
}

