/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.storage.util;

import io.confluent.connect.storage.StorageSinkTestBase;
import io.confluent.connect.storage.util.DataUtils;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.data.Timestamp;
import org.apache.kafka.connect.errors.ConnectException;
import org.apache.kafka.connect.errors.DataException;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;

public class DataUtilsTest
extends StorageSinkTestBase {
    private static final Date DATE = new Date(12L);

    private void assertDate(Object o, Date value) {
        MatcherAssert.assertThat((Object)o, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        MatcherAssert.assertThat((Object)o, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(Date.class)));
        MatcherAssert.assertThat((Object)((Date)o), (Matcher)CoreMatchers.is((Object)value));
    }

    private void assertLong(Object o, Long value) {
        MatcherAssert.assertThat((Object)o, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        MatcherAssert.assertThat((Object)o, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(Long.class)));
        MatcherAssert.assertThat((Object)((Long)o), (Matcher)CoreMatchers.is((Object)value));
    }

    private void assertStruct(Object o, Struct value) {
        MatcherAssert.assertThat((Object)o, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        MatcherAssert.assertThat((Object)o, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(Struct.class)));
        MatcherAssert.assertThat((Object)((Struct)o), (Matcher)CoreMatchers.is((Object)value));
    }

    private void assertMap(Object o, Map<?, ?> value) {
        MatcherAssert.assertThat((Object)o, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        MatcherAssert.assertThat((Object)o, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(Map.class)));
        MatcherAssert.assertThat((Object)o, (Matcher)CoreMatchers.is(value));
    }

    @Test
    public void testGetDateFieldStruct() {
        Schema schema = this.createSchemaWithTimestampField(Timestamp.SCHEMA);
        Struct struct = this.createRecordWithTimestampField(schema, DATE);
        Object timeField = DataUtils.getNestedFieldValue((Object)struct, (String)"timestamp");
        this.assertDate(timeField, DATE);
    }

    @Test
    public void testGetLongFieldStruct() {
        Schema schema = this.createSchemaWithTimestampField();
        Struct struct = this.createRecordWithTimestampField(schema, 12L);
        Object timeField = DataUtils.getNestedFieldValue((Object)struct, (String)"timestamp");
        this.assertLong(timeField, DATE.getTime());
    }

    @Test
    public void testNestedGetFieldStruct() {
        Struct struct = this.createRecordWithNestedTimestampField(12L);
        Struct expectedNestedStruct = (Struct)struct.get("nested");
        MatcherAssert.assertThat((Object)expectedNestedStruct, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Object actualNestedStruct = DataUtils.getField((Object)struct, (String)"nested");
        this.assertStruct(actualNestedStruct, expectedNestedStruct);
        Object timeField = DataUtils.getNestedFieldValue((Object)struct, (String)"nested.timestamp");
        this.assertLong(timeField, DATE.getTime());
    }

    @Test
    public void testGetFieldMap() {
        Map map = this.createMapWithTimestampField(12L);
        Object timeField = DataUtils.getNestedFieldValue((Object)map, (String)"timestamp");
        this.assertLong(timeField, 12L);
    }

    @Test
    public void testNestedGetFieldMap() {
        Map expectedNestedMap = this.createMapWithTimestampField(12L);
        HashMap<String, Map> map = new HashMap<String, Map>();
        map.put("nested", expectedNestedMap);
        Object actualNestedMap = DataUtils.getField(map, (String)"nested");
        this.assertMap(actualNestedMap, expectedNestedMap);
        Object timeField = DataUtils.getNestedFieldValue(map, (String)"nested.timestamp");
        this.assertLong(timeField, 12L);
    }

    @Test
    public void testDoubleNestedGetFieldMap() {
        Map expectedNestedMap = this.createMapWithTimestampField(12L);
        HashMap<String, Map> middleMap = new HashMap<String, Map>();
        middleMap.put("nested", expectedNestedMap);
        HashMap<String, HashMap<String, Map>> map = new HashMap<String, HashMap<String, Map>>();
        map.put("top", middleMap);
        Object actualMiddleMap = DataUtils.getField(map, (String)"top");
        this.assertMap(actualMiddleMap, middleMap);
        Object actualNestedMap = DataUtils.getNestedFieldValue(map, (String)"top.nested");
        this.assertMap(actualNestedMap, expectedNestedMap);
        Object timeField = DataUtils.getNestedFieldValue(map, (String)"top.nested.timestamp");
        this.assertLong(timeField, 12L);
    }

    @Test
    public void testGetFieldSchema() {
        Schema schema = this.createSchemaWithTimestampField();
        Field timeField = DataUtils.getNestedField((Schema)schema, (String)"timestamp");
        MatcherAssert.assertThat((Object)timeField, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        MatcherAssert.assertThat((Object)timeField.schema(), (Matcher)CoreMatchers.is((Object)Schema.INT64_SCHEMA));
    }

    @Test
    public void testGetNestedFieldSchema() {
        Schema nestedChildSchema = this.createSchemaWithTimestampField();
        SchemaBuilder schema = SchemaBuilder.struct().field("nested", nestedChildSchema);
        Field nestedField = DataUtils.getNestedField((Schema)schema, (String)"nested");
        MatcherAssert.assertThat((Object)nestedField, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        MatcherAssert.assertThat((Object)nestedField.index(), (Matcher)CoreMatchers.is((Object)0));
        MatcherAssert.assertThat((Object)nestedField.schema().type(), (Matcher)CoreMatchers.is((Object)Schema.Type.STRUCT));
        nestedField = DataUtils.getNestedField((Schema)schema, (String)"nested.timestamp");
        MatcherAssert.assertThat((Object)nestedField, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        MatcherAssert.assertThat((Object)nestedField.schema(), (Matcher)CoreMatchers.is((Object)Schema.INT64_SCHEMA));
    }

    @Test
    public void testMissingTopFieldSchema() {
        Schema schema = this.createSchemaWithTimestampField();
        Field f = DataUtils.getNestedField((Schema)schema, (String)"foo");
        MatcherAssert.assertThat((Object)f, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void testValidateNullObject() throws ConnectException {
        Exception e = (Exception)Assert.assertThrows(ConnectException.class, () -> DataUtils.getNestedField(null, (String)"foo"));
        Assert.assertEquals((Object)"Attempted to extract a field from a null object.", (Object)e.getMessage());
    }

    @Test
    public void testValidateNullField() throws ConnectException {
        Schema schema = this.createSchemaWithTimestampField();
        Exception e = (Exception)Assert.assertThrows(ConnectException.class, () -> DataUtils.getNestedField((Schema)schema, null));
        Assert.assertEquals((Object)"The field to extract cannot be null or empty.", (Object)e.getMessage());
    }

    @Test
    public void testValidateEmptyField() throws ConnectException {
        Schema schema = this.createSchemaWithTimestampField();
        Exception e = (Exception)Assert.assertThrows(ConnectException.class, () -> DataUtils.getNestedField((Schema)schema, (String)""));
        Assert.assertEquals((Object)"The field to extract cannot be null or empty.", (Object)e.getMessage());
    }

    @Test
    public void testWrongDataStructure() throws DataException {
        List<Integer> x = Arrays.asList(1, 2, 3);
        Exception e = (Exception)Assert.assertThrows(DataException.class, () -> DataUtils.getField((Object)x, (String)"foo"));
        MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.startsWith((String)"Argument not a Struct or Map"));
    }

    @Test
    public void testMissingTopField() throws DataException {
        String fieldName = "foo";
        Map map = this.createMapWithTimestampField(12L);
        Exception e = (Exception)Assert.assertThrows(DataException.class, () -> DataUtils.getNestedFieldValue((Object)map, (String)fieldName));
        MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.startsWith((String)String.format("The field '%s' does not exist", fieldName)));
    }

    @Test
    public void testMissingNestedField() throws DataException {
        String topField = "nested";
        String fieldName = "foo";
        Map innerMap = this.createMapWithTimestampField(12L);
        HashMap<String, Map> map = new HashMap<String, Map>();
        map.put(topField, innerMap);
        Exception e = (Exception)Assert.assertThrows(DataException.class, () -> DataUtils.getNestedFieldValue((Object)map, (String)(topField + "." + fieldName)));
        MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.startsWith((String)String.format("The field '%s.%s' does not exist", topField, fieldName)));
    }

    @Test
    public void testNestedFieldSchemaWrongType() throws DataException {
        Schema schema = this.createSchemaWithTimestampField();
        Field f = DataUtils.getNestedField((Schema)schema, (String)"string");
        Exception e = (Exception)Assert.assertThrows(DataException.class, () -> DataUtils.getNestedField((Schema)f.schema(), (String)"foo"));
        MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.startsWith((String)"Unable to get field"));
    }
}

