/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.replicator.util;

import io.confluent.connect.replicator.util.Utils;
import org.apache.kafka.connect.errors.ConnectException;
import org.junit.Assert;
import org.junit.Test;

public class UtilsTest {
    @Test
    public void testSimpleRename() {
        Assert.assertEquals((Object)"dc.foo", (Object)Utils.renameTopic((String)"dc.${topic}", (String)"foo"));
    }

    @Test(expected=ConnectException.class)
    public void testIllegalRename() {
        Utils.renameTopic((String)"dc_$${topic}", (String)"topic");
    }

    @Test
    public void testNextDeadline() {
        Assert.assertEquals((long)5L, (long)Utils.nextDeadline((Long[])new Long[]{5L, null}));
        Assert.assertEquals((long)5L, (long)Utils.nextDeadline((Long[])new Long[]{null, 5L}));
        Assert.assertEquals((long)1L, (long)Utils.nextDeadline((Long[])new Long[]{1L, 5L}));
        Assert.assertEquals((long)1L, (long)Utils.nextDeadline((Long[])new Long[]{5L, 1L}));
        Assert.assertEquals((long)Long.MAX_VALUE, (long)Utils.nextDeadline((Long[])new Long[]{null, null}));
    }
}

