/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.replicator.util;

import io.confluent.connect.replicator.util.TrialPeriod;
import kafka.utils.ZkUtils;
import org.apache.curator.test.TestingServer;
import org.easymock.EasyMockSupport;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TrialPeriodTest
extends EasyMockSupport {
    private TestingServer zkServer;
    private ZkUtils zkUtils;

    @Before
    public void startup() throws Exception {
        this.zkServer = new TestingServer();
        this.zkUtils = ZkUtils.apply((String)this.zkServer.getConnectString(), (int)6000, (int)10000, (boolean)false);
    }

    @After
    public void shutdown() throws Exception {
        if (this.zkUtils != null) {
            this.zkUtils.close();
        }
        if (this.zkServer != null) {
            this.zkServer.close();
        }
    }

    @Test
    public void startOrVerify() {
        Assert.assertFalse((boolean)this.zkUtils.pathExists("/confluent-replicator"));
        Assert.assertTrue((boolean)TrialPeriod.startOrVerify((long)System.currentTimeMillis(), (ZkUtils)this.zkUtils));
        Assert.assertTrue((boolean)this.zkUtils.pathExists("/confluent-replicator"));
        Assert.assertTrue((boolean)TrialPeriod.startOrVerify((long)System.currentTimeMillis(), (ZkUtils)this.zkUtils));
        Assert.assertFalse((boolean)TrialPeriod.startOrVerify((long)(System.currentTimeMillis() + TrialPeriod.TRIAL_LIMIT_MILLIS), (ZkUtils)this.zkUtils));
    }
}

