/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.replicator.util;

import io.confluent.connect.replicator.util.NewReplicatorAdminClient;
import io.confluent.connect.replicator.util.ReplicatorAdminClient;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeoutException;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.AlterConfigsResult;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.clients.admin.CreatePartitionsResult;
import org.apache.kafka.clients.admin.CreateTopicsResult;
import org.apache.kafka.clients.admin.DescribeClusterResult;
import org.apache.kafka.clients.admin.DescribeConfigsResult;
import org.apache.kafka.clients.admin.DescribeTopicsResult;
import org.apache.kafka.clients.admin.NewPartitions;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.TopicPartitionInfo;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.errors.TopicExistsException;
import org.apache.kafka.common.utils.SystemTime;
import org.apache.kafka.common.utils.Time;
import org.easymock.Capture;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.powermock.reflect.Whitebox;

public class ReplicatorAdminClientTest {
    private ReplicatorAdminClient client;
    private AdminClient adminClient;
    private static final ConfigEntryComparator CONFIG_ENTRY_CMP = new ConfigEntryComparator();
    private final String taskId = "replicator-1";

    @Before
    public void startup() throws Exception {
        this.adminClient = (AdminClient)EasyMock.createMock(AdminClient.class);
        this.client = new NewReplicatorAdminClient(this.adminClient, (Time)new SystemTime(), 60000L, "replicator-1");
    }

    @Test
    public void testClusterId() throws Exception {
        DescribeClusterResult describeClusterResult = (DescribeClusterResult)EasyMock.mock(DescribeClusterResult.class);
        EasyMock.expect((Object)this.adminClient.describeCluster()).andReturn((Object)describeClusterResult).once();
        EasyMock.expect((Object)describeClusterResult.clusterId()).andReturn((Object)KafkaFuture.completedFuture((Object)"myclusterid"));
        EasyMock.replay((Object[])new Object[]{this.adminClient, describeClusterResult});
        Assert.assertEquals((Object)"myclusterid", (Object)this.client.clusterId());
        EasyMock.verify((Object[])new Object[]{this.adminClient, describeClusterResult});
    }

    @Test
    public void testTopicConfig() throws InterruptedException, ExecutionException, TimeoutException {
        DescribeConfigsResult describeConfigsResult = (DescribeConfigsResult)EasyMock.mock(DescribeConfigsResult.class);
        EasyMock.expect((Object)this.adminClient.describeConfigs((Collection)EasyMock.anyObject(Collection.class))).andReturn((Object)describeConfigsResult).once();
        Set<ConfigEntry> topicConfig = this.createTopicConfig();
        Map<ConfigResource, Config> topicConfigs = Collections.singletonMap(new ConfigResource(ConfigResource.Type.TOPIC, "foo"), new Config(topicConfig));
        Properties topicProps = this.createTopicProperties(topicConfig);
        EasyMock.expect((Object)describeConfigsResult.all()).andReturn((Object)KafkaFuture.completedFuture(topicConfigs));
        EasyMock.replay((Object[])new Object[]{this.adminClient, describeConfigsResult});
        Assert.assertEquals((Object)topicProps, (Object)this.client.topicConfig("foo"));
        EasyMock.verify((Object[])new Object[]{this.adminClient, describeConfigsResult});
    }

    @Test
    public void testChangeTopicConfig() throws InterruptedException, ExecutionException, TimeoutException {
        HashSet<ConfigEntry> origTopicConfig = new HashSet<ConfigEntry>(Arrays.asList(new ConfigEntry("compression.type", "gzip"), new ConfigEntry("flush.ms", "500000")));
        HashSet<ConfigEntry> newTopicConfig = new HashSet<ConfigEntry>(Arrays.asList(new ConfigEntry("compression.type", "snappy"), new ConfigEntry("yet.another", "rando prop")));
        Properties newTopicProps = new Properties();
        for (ConfigEntry entry : newTopicConfig) {
            newTopicProps.setProperty(entry.name(), entry.value());
        }
        Map<ConfigResource, Config> origTopicConfigs = Collections.singletonMap(new ConfigResource(ConfigResource.Type.TOPIC, "foo"), new Config(origTopicConfig));
        Map<ConfigResource, Config> newTopicConfigs = Collections.singletonMap(new ConfigResource(ConfigResource.Type.TOPIC, "foo"), new Config(newTopicConfig));
        DescribeConfigsResult describeConfigsResult = (DescribeConfigsResult)EasyMock.mock(DescribeConfigsResult.class);
        EasyMock.expect((Object)this.adminClient.describeConfigs((Collection)EasyMock.anyObject(Collection.class))).andReturn((Object)describeConfigsResult).once();
        EasyMock.expect((Object)describeConfigsResult.all()).andReturn((Object)KafkaFuture.completedFuture(origTopicConfigs));
        AlterConfigsResult alterConfigsResult = (AlterConfigsResult)EasyMock.mock(AlterConfigsResult.class);
        Capture configsMap = EasyMock.newCapture();
        EasyMock.expect((Object)this.adminClient.alterConfigs((Map)EasyMock.capture((Capture)configsMap))).andReturn((Object)alterConfigsResult).once();
        KafkaFuture kafkaFuture = (KafkaFuture)EasyMock.mock(KafkaFuture.class);
        EasyMock.expect((Object)alterConfigsResult.all()).andReturn((Object)kafkaFuture);
        EasyMock.expect((Object)kafkaFuture.get()).andReturn(null);
        EasyMock.replay((Object[])new Object[]{this.adminClient, describeConfigsResult, alterConfigsResult, kafkaFuture});
        this.client.changeTopicConfig("foo", newTopicProps);
        Assert.assertTrue((boolean)configsMap.hasCaptured());
        ReplicatorAdminClientTest.assertMapEquals(newTopicConfigs, (Map)configsMap.getValue());
        EasyMock.verify((Object[])new Object[]{this.adminClient, describeConfigsResult, alterConfigsResult, kafkaFuture});
    }

    @Test
    public void testQueryBrokerMetadata() throws InterruptedException, ExecutionException, TimeoutException {
        DescribeClusterResult describeClusterResult = (DescribeClusterResult)EasyMock.mock(DescribeClusterResult.class);
        EasyMock.expect((Object)this.adminClient.describeCluster()).andReturn((Object)describeClusterResult).once();
        Set<Node> nodes = Collections.singleton(Node.noNode());
        EasyMock.expect((Object)describeClusterResult.nodes()).andReturn((Object)KafkaFuture.completedFuture(nodes));
        EasyMock.replay((Object[])new Object[]{this.adminClient, describeClusterResult});
        Assert.assertEquals((long)1L, (long)this.client.aliveBrokers());
        EasyMock.verify((Object[])new Object[]{this.adminClient, describeClusterResult});
    }

    @Test
    public void testQueryNonExistingTopic() {
        DescribeTopicsResult describeTopicsResult = (DescribeTopicsResult)EasyMock.mock(DescribeTopicsResult.class);
        TopicPartitionInfo partitionInfo = (TopicPartitionInfo)EasyMock.mock(TopicPartitionInfo.class);
        Map<String, TopicDescription> topicDescriptions = Collections.singletonMap("foo", new TopicDescription("foo", false, Arrays.asList(partitionInfo)));
        EasyMock.expect((Object)this.adminClient.describeTopics((Collection)EasyMock.anyObject(Collection.class))).andReturn((Object)describeTopicsResult).once();
        EasyMock.expect((Object)describeTopicsResult.all()).andReturn((Object)KafkaFuture.completedFuture(topicDescriptions));
        EasyMock.replay((Object[])new Object[]{this.adminClient, describeTopicsResult, partitionInfo});
        this.client.setInterestedTopics(Collections.singleton("bar"), new ReplicatorAdminClient.TopicMetadataListener(){

            public void onTopicMetadataRefresh() {
            }
        });
        Assert.assertFalse((boolean)this.client.topicExists("bar"));
        EasyMock.verify((Object[])new Object[]{this.adminClient, describeTopicsResult, partitionInfo});
    }

    @Test
    public void testQueryNonExistingPartition() {
        DescribeTopicsResult describeTopicsResult = (DescribeTopicsResult)EasyMock.mock(DescribeTopicsResult.class);
        TopicPartitionInfo partitionInfo = (TopicPartitionInfo)EasyMock.mock(TopicPartitionInfo.class);
        Map<String, TopicDescription> topicDescriptions = Collections.singletonMap("foo", new TopicDescription("foo", false, Arrays.asList(partitionInfo, partitionInfo, partitionInfo, partitionInfo)));
        EasyMock.expect((Object)this.adminClient.describeTopics((Collection)EasyMock.anyObject(Collection.class))).andReturn((Object)describeTopicsResult).once();
        EasyMock.expect((Object)describeTopicsResult.all()).andReturn((Object)KafkaFuture.completedFuture(topicDescriptions));
        EasyMock.replay((Object[])new Object[]{this.adminClient, describeTopicsResult, partitionInfo});
        this.client.setInterestedTopics(Collections.singleton("foo"), new ReplicatorAdminClient.TopicMetadataListener(){

            public void onTopicMetadataRefresh() {
            }
        });
        Assert.assertFalse((boolean)this.client.partitionExists(new TopicPartition("foo", 4)));
        EasyMock.verify((Object[])new Object[]{this.adminClient, describeTopicsResult, partitionInfo});
    }

    @Test
    public void testCreateTopic() throws Exception {
        int numPartitions = 4;
        int replicationFactor = 1;
        Set<ConfigEntry> topicConfig = this.createTopicConfig();
        Properties topicProps = this.createTopicProperties(topicConfig);
        Capture topicRequest = EasyMock.newCapture();
        CreateTopicsResult createTopicsResult = (CreateTopicsResult)EasyMock.mock(CreateTopicsResult.class);
        EasyMock.expect((Object)this.adminClient.createTopics((Collection)EasyMock.capture((Capture)topicRequest))).andReturn((Object)createTopicsResult).once();
        KafkaFuture kafkaFuture = (KafkaFuture)EasyMock.mock(KafkaFuture.class);
        EasyMock.expect((Object)createTopicsResult.all()).andReturn((Object)kafkaFuture);
        EasyMock.expect((Object)kafkaFuture.get()).andReturn(null);
        NewTopic newTopicRequest = new NewTopic("foo", numPartitions, (short)replicationFactor);
        HashMap<String, String> topicPropsCopy = new HashMap<String, String>();
        for (String name : topicProps.stringPropertyNames()) {
            topicPropsCopy.put(name, topicProps.getProperty(name));
        }
        newTopicRequest.configs(Collections.unmodifiableMap(topicPropsCopy));
        Set<NewTopic> expectedRequest = Collections.singleton(newTopicRequest);
        EasyMock.replay((Object[])new Object[]{this.adminClient, createTopicsResult, kafkaFuture});
        Assert.assertTrue((boolean)this.client.createTopic("foo", numPartitions, replicationFactor, topicProps));
        Assert.assertTrue((boolean)topicRequest.hasCaptured());
        Assert.assertEquals((Object)expectedRequest.toString(), (Object)((Collection)topicRequest.getValue()).toString());
        EasyMock.verify((Object[])new Object[]{this.adminClient, createTopicsResult, kafkaFuture});
    }

    @Test
    public void testCreateTopicOnExistingTopic() throws Exception {
        int numPartitions = 4;
        int replicationFactor = 1;
        Set<ConfigEntry> topicConfig = this.createTopicConfig();
        Properties topicProps = this.createTopicProperties(topicConfig);
        Capture topicRequest = EasyMock.newCapture();
        CreateTopicsResult createTopicsResult = (CreateTopicsResult)EasyMock.mock(CreateTopicsResult.class);
        ExecutionException expectedException = new ExecutionException((Throwable)new TopicExistsException("Here!Here!"));
        EasyMock.expect((Object)this.adminClient.createTopics((Collection)EasyMock.capture((Capture)topicRequest))).andReturn((Object)createTopicsResult).once();
        KafkaFuture kafkaFuture = (KafkaFuture)EasyMock.mock(KafkaFuture.class);
        EasyMock.expect((Object)createTopicsResult.all()).andReturn((Object)kafkaFuture);
        EasyMock.expect((Object)kafkaFuture.get()).andThrow((Throwable)expectedException);
        NewTopic newTopicRequest = new NewTopic("foo", numPartitions, (short)replicationFactor);
        HashMap<String, String> topicPropsCopy = new HashMap<String, String>();
        for (String name : topicProps.stringPropertyNames()) {
            topicPropsCopy.put(name, topicProps.getProperty(name));
        }
        newTopicRequest.configs(Collections.unmodifiableMap(topicPropsCopy));
        Set<NewTopic> expectedRequest = Collections.singleton(newTopicRequest);
        EasyMock.replay((Object[])new Object[]{this.adminClient, createTopicsResult, kafkaFuture});
        Assert.assertFalse((boolean)this.client.createTopic("foo", numPartitions, replicationFactor, topicProps));
        Assert.assertTrue((boolean)topicRequest.hasCaptured());
        Assert.assertEquals((Object)expectedRequest.toString(), (Object)((Collection)topicRequest.getValue()).toString());
        EasyMock.verify((Object[])new Object[]{this.adminClient, createTopicsResult, kafkaFuture});
    }

    @Test
    public void testCreateTopicWithDownConversionUnsupported() throws Exception {
        int numPartitions = 4;
        int replicationFactor = 1;
        Set<ConfigEntry> topicConfig = this.createTopicConfig();
        topicConfig.add(new ConfigEntry("message.downconversion.enable", "false"));
        Properties topicProps = this.createTopicProperties(topicConfig);
        Capture failedTopicRequest = EasyMock.newCapture();
        CreateTopicsResult createTopicsResult = (CreateTopicsResult)EasyMock.mock(CreateTopicsResult.class);
        ExecutionException expectedException = new ExecutionException((Throwable)new InvalidConfigurationException("Unknown topic config name: message.downconversion.enable"));
        EasyMock.expect((Object)this.adminClient.createTopics((Collection)EasyMock.capture((Capture)failedTopicRequest))).andReturn((Object)createTopicsResult).once();
        KafkaFuture kafkaFuture = (KafkaFuture)EasyMock.mock(KafkaFuture.class);
        EasyMock.expect((Object)createTopicsResult.all()).andReturn((Object)kafkaFuture);
        EasyMock.expect((Object)kafkaFuture.get()).andThrow((Throwable)expectedException);
        Capture topicRequest = EasyMock.newCapture();
        EasyMock.expect((Object)this.adminClient.createTopics((Collection)EasyMock.capture((Capture)topicRequest))).andReturn((Object)createTopicsResult).once();
        EasyMock.expect((Object)createTopicsResult.all()).andReturn((Object)kafkaFuture);
        EasyMock.expect((Object)kafkaFuture.get()).andReturn(null);
        NewTopic newTopicRequest = new NewTopic("foo", numPartitions, (short)replicationFactor);
        HashMap<String, String> topicPropsCopy = new HashMap<String, String>();
        for (String name : topicProps.stringPropertyNames()) {
            topicPropsCopy.put(name, topicProps.getProperty(name));
        }
        newTopicRequest.configs(Collections.unmodifiableMap(topicPropsCopy));
        Set<NewTopic> expectedFailedRequest = Collections.singleton(newTopicRequest);
        topicPropsCopy.remove("message.downconversion.enable");
        newTopicRequest.configs(Collections.unmodifiableMap(topicPropsCopy));
        Set<NewTopic> expectedRequest = Collections.singleton(newTopicRequest);
        EasyMock.replay((Object[])new Object[]{this.adminClient, createTopicsResult, kafkaFuture});
        Assert.assertTrue((boolean)this.client.createTopic("foo", numPartitions, replicationFactor, topicProps));
        Assert.assertTrue((boolean)failedTopicRequest.hasCaptured());
        Assert.assertEquals((Object)expectedFailedRequest.toString(), (Object)((Collection)topicRequest.getValue()).toString());
        Assert.assertTrue((boolean)topicRequest.hasCaptured());
        Assert.assertEquals((Object)expectedRequest.toString(), (Object)((Collection)topicRequest.getValue()).toString());
        EasyMock.verify((Object[])new Object[]{this.adminClient, createTopicsResult, kafkaFuture});
    }

    @Test(expected=ExecutionException.class)
    public void testCreateTopicTimesOut() throws Exception {
        int numPartitions = 4;
        int replicationFactor = 1;
        Set<ConfigEntry> topicConfig = this.createTopicConfig();
        Properties topicProps = this.createTopicProperties(topicConfig);
        CreateTopicsResult createTopicsResult = (CreateTopicsResult)EasyMock.mock(CreateTopicsResult.class);
        ExecutionException expectedException = new ExecutionException(new TimeoutException());
        EasyMock.expect((Object)this.adminClient.createTopics((Collection)EasyMock.anyObject(Collection.class))).andReturn((Object)createTopicsResult).once();
        KafkaFuture kafkaFuture = (KafkaFuture)EasyMock.mock(KafkaFuture.class);
        EasyMock.expect((Object)createTopicsResult.all()).andReturn((Object)kafkaFuture);
        EasyMock.expect((Object)kafkaFuture.get()).andThrow((Throwable)expectedException);
        EasyMock.replay((Object[])new Object[]{this.adminClient, createTopicsResult, kafkaFuture});
        this.client.createTopic("foo", numPartitions, replicationFactor, topicProps);
        EasyMock.verify((Object[])new Object[]{this.adminClient, createTopicsResult, kafkaFuture});
    }

    @Test
    public void testCreatePartitions() throws Exception {
        int numPartitions = 4;
        Capture newPartitionsRequest = EasyMock.newCapture();
        CreatePartitionsResult createPartitionsResult = (CreatePartitionsResult)EasyMock.mock(CreatePartitionsResult.class);
        EasyMock.expect((Object)this.adminClient.createPartitions((Map)EasyMock.capture((Capture)newPartitionsRequest))).andReturn((Object)createPartitionsResult).once();
        KafkaFuture kafkaFuture = (KafkaFuture)EasyMock.mock(KafkaFuture.class);
        EasyMock.expect((Object)createPartitionsResult.all()).andReturn((Object)kafkaFuture);
        EasyMock.expect((Object)kafkaFuture.get()).andReturn(null);
        Map<String, NewPartitions> expectedRequest = Collections.singletonMap("foo", NewPartitions.increaseTo((int)numPartitions));
        EasyMock.replay((Object[])new Object[]{this.adminClient, createPartitionsResult, kafkaFuture});
        this.client.addPartitions("foo", numPartitions);
        Assert.assertTrue((boolean)newPartitionsRequest.hasCaptured());
        Assert.assertEquals((Object)expectedRequest.toString(), (Object)((Map)newPartitionsRequest.getValue()).toString());
        EasyMock.verify((Object[])new Object[]{this.adminClient, createPartitionsResult, kafkaFuture});
    }

    @Test
    public void testNoThreadsSpawnedIfMaxAgeIsZero() throws Exception {
        NewReplicatorAdminClient client = new NewReplicatorAdminClient(this.adminClient, (Time)new SystemTime(), 0L, "replicator-1");
        ScheduledExecutorService metadataFetcher = client.metadataFetcher();
        ThreadPoolExecutor internalExecutor = (ThreadPoolExecutor)Whitebox.getInternalState((Object)metadataFetcher, (String)"e");
        Assert.assertEquals((long)0L, (long)internalExecutor.getPoolSize());
    }

    @Test
    public void testClose() throws Exception {
        this.adminClient.close();
        EasyMock.expectLastCall().once();
        EasyMock.replay((Object[])new Object[]{this.adminClient});
        this.client.close();
        EasyMock.verify((Object[])new Object[]{this.adminClient});
    }

    private static <K, V> void assertMapEquals(Map<K, V> left, Map<K, V> right) {
        Assert.assertEquals((long)left.size(), (long)right.size());
        HashMap<K, V> leftMutable = new HashMap<K, V>(left);
        HashMap<K, V> rightMutable = new HashMap<K, V>(right);
        for (Map.Entry entry : leftMutable.entrySet()) {
            if (entry.getValue() instanceof Config) {
                ArrayList leftValue = new ArrayList(((Config)entry.getValue()).entries());
                Config rightConfig = (Config)rightMutable.remove(entry.getKey());
                Assert.assertNotNull((Object)rightConfig);
                ArrayList rightValue = new ArrayList(rightConfig.entries());
                Collections.sort(leftValue, CONFIG_ENTRY_CMP);
                Collections.sort(rightValue, CONFIG_ENTRY_CMP);
                Assert.assertEquals((long)leftValue.size(), (long)rightValue.size());
                for (ConfigEntry configEntry : leftValue) {
                    Assert.assertTrue((CONFIG_ENTRY_CMP.compare(configEntry, (ConfigEntry)rightValue.remove(0)) == 0 ? 1 : 0) != 0);
                }
                continue;
            }
            Assert.assertEquals(entry.getValue(), rightMutable.remove(entry.getKey()));
        }
        Assert.assertTrue((boolean)rightMutable.isEmpty());
    }

    Set<ConfigEntry> createTopicConfig() {
        return new HashSet<ConfigEntry>(Arrays.asList(new ConfigEntry("compression.type", "gzip"), new ConfigEntry("flush.ms", "500000"), new ConfigEntry("yet.another", "rando prop")));
    }

    Properties createTopicProperties(Set<ConfigEntry> topicConfig) {
        Properties topicProps = new Properties();
        for (ConfigEntry entry : topicConfig) {
            topicProps.setProperty(entry.name(), entry.value());
        }
        return topicProps;
    }

    private static class ConfigEntryComparator
    implements Comparator<ConfigEntry> {
        private ConfigEntryComparator() {
        }

        @Override
        public int compare(ConfigEntry left, ConfigEntry right) {
            int isReadOnlyCmp;
            int isDefaultCmp;
            int valueCmp;
            int nameCmp = left.name().compareTo(right.name());
            return nameCmp != 0 ? nameCmp : ((valueCmp = left.value().compareTo(right.value())) != 0 ? valueCmp : ((isDefaultCmp = Boolean.compare(left.isDefault(), right.isDefault())) != 0 ? isDefaultCmp : ((isReadOnlyCmp = Boolean.compare(left.isReadOnly(), right.isReadOnly())) != 0 ? isReadOnlyCmp : Boolean.compare(left.isSensitive(), right.isSensitive()))));
        }
    }
}

