/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.replicator.util;

import io.confluent.connect.replicator.util.LicenseValidation;
import io.confluent.license.License;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.util.concurrent.TimeUnit;
import org.jose4j.lang.JoseException;
import org.junit.Test;

public class LicenseValidationTest {
    public static final KeyPair KEYPAIR = LicenseValidationTest.generateKeyPair();

    public static String generateLicense() {
        return LicenseValidationTest.generateLicense(System.currentTimeMillis() + TimeUnit.DAYS.toMillis(365L));
    }

    public static String generateLicense(long expiryMs) {
        try {
            return License.sign((PrivateKey)KEYPAIR.getPrivate(), (String)"CP Replicator Test", (long)expiryMs, (boolean)true);
        }
        catch (JoseException e) {
            throw new RuntimeException(e);
        }
    }

    private static KeyPair generateKeyPair() {
        KeyPairGenerator keyGen;
        try {
            keyGen = KeyPairGenerator.getInstance("RSA");
            keyGen.initialize(2048, SecureRandom.getInstance("SHA1PRNG"));
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        return keyGen.generateKeyPair();
    }

    @Test(expected=LicenseValidation.Failure.class)
    public void invalidLicense() throws LicenseValidation.Failure {
        LicenseValidation.verify((PublicKey)KEYPAIR.getPublic(), (String)"fake");
    }

    @Test
    public void validLicense() throws LicenseValidation.Failure {
        LicenseValidation.verify((PublicKey)KEYPAIR.getPublic(), (String)LicenseValidationTest.generateLicense());
    }

    @Test(expected=LicenseValidation.Failure.class)
    public void expiredLicense() throws LicenseValidation.Failure {
        LicenseValidation.verify((PublicKey)KEYPAIR.getPublic(), (String)LicenseValidationTest.generateLicense(System.currentTimeMillis() - TimeUnit.HOURS.toMillis(1L)));
    }
}

