/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.replicator.util;

import io.confluent.connect.replicator.util.ByteArrayConverter;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaAndValue;
import org.apache.kafka.connect.errors.DataException;
import org.junit.Assert;
import org.junit.Test;

public class ByteArrayConverterTest {
    private static final String TOPIC = "topic";
    private static final byte[] SAMPLE_BYTES = "sample string".getBytes(StandardCharsets.UTF_8);
    private ByteArrayConverter converter = new ByteArrayConverter();

    @Test
    public void testBytesToBytes() {
        Assert.assertArrayEquals((byte[])SAMPLE_BYTES, (byte[])this.converter.fromConnectData(TOPIC, Schema.BYTES_SCHEMA, (Object)SAMPLE_BYTES));
    }

    @Test
    public void testToBytesIgnoresSchema() {
        Assert.assertArrayEquals((byte[])SAMPLE_BYTES, (byte[])this.converter.fromConnectData(TOPIC, null, (Object)SAMPLE_BYTES));
    }

    @Test(expected=DataException.class)
    public void testNonByteArrayToBytes() {
        this.converter.fromConnectData(TOPIC, Schema.BYTES_SCHEMA, (Object)new Thread());
    }

    @Test
    public void testNullToBytes() {
        Assert.assertEquals(null, (Object)this.converter.fromConnectData(TOPIC, Schema.BYTES_SCHEMA, null));
    }

    @Test
    public void testBytesToString() {
        SchemaAndValue data = this.converter.toConnectData(TOPIC, SAMPLE_BYTES);
        Assert.assertEquals((Object)Schema.OPTIONAL_BYTES_SCHEMA, (Object)data.schema());
        Assert.assertTrue((boolean)Arrays.equals(SAMPLE_BYTES, (byte[])data.value()));
    }

    @Test
    public void testBytesNullToString() {
        SchemaAndValue data = this.converter.toConnectData(TOPIC, null);
        Assert.assertEquals((Object)Schema.OPTIONAL_BYTES_SCHEMA, (Object)data.schema());
        Assert.assertEquals(null, (Object)data.value());
    }
}

