/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.replicator.exec;

import io.confluent.connect.replicator.KafkaConfigs;
import io.confluent.connect.replicator.exec.ReplicatorCli;
import java.util.Arrays;
import java.util.Map;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ReplicatorCliTest {
    private ReplicatorCli cli;
    private String[] args;

    @Before
    public void setup() {
        this.cli = new ReplicatorCli();
        this.args = Arrays.asList("--consumer.config", "./src/test/resources/consumer.properties", "--producer.config", "./src/test/resources/producer.properties", "--cluster.id", "replicator", "--replication.config", "./src/test/resources/replication.properties").toArray(new String[0]);
    }

    @Test
    public void testInterceptorProps() {
        Map parsedProps = this.cli.parse(this.args);
        for (String prop : parsedProps.keySet()) {
            Assert.assertFalse((String)("Replicator properties should not include " + prop + "without prefix"), (boolean)prop.startsWith("interceptor."));
            Assert.assertFalse((String)("Replicator properties should not include " + prop + "without prefix"), (boolean)prop.startsWith("confluent.monitoring.interceptor."));
            Assert.assertFalse((String)("Replicator properties should not include " + prop), (boolean)prop.startsWith(KafkaConfigs.KafkaCluster.DESTINATION.prefix() + "interceptor."));
            Assert.assertFalse((String)("Replicator properties should not include " + prop), (boolean)prop.startsWith(KafkaConfigs.KafkaCluster.SOURCE.prefix() + "interceptor."));
        }
        Assert.assertEquals((Object)"io.confluent.monitoring.clients.interceptor.MonitoringProducerInterceptor", parsedProps.get("producer.interceptor.classes"));
        Assert.assertEquals((Object)"io.confluent.monitoring.clients.interceptor.MonitoringConsumerInterceptor", parsedProps.get("src.consumer.interceptor.classes"));
        Assert.assertTrue((boolean)((String)parsedProps.get("producer.confluent.monitoring.interceptor.sasl.jaas.config")).contains("bob"));
        Assert.assertTrue((boolean)((String)parsedProps.get("src.consumer.confluent.monitoring.interceptor.sasl.jaas.config")).contains("alice"));
    }
}

