/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.replicator;

import io.confluent.connect.replicator.NewTopicMonitorThread;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.DescribeTopicsResult;
import org.apache.kafka.clients.admin.ListTopicsResult;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.clients.admin.TopicListing;
import org.apache.kafka.clients.consumer.RoundRobinAssignor;
import org.apache.kafka.clients.consumer.internals.PartitionAssignor;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.TopicPartitionInfo;
import org.apache.kafka.connect.connector.ConnectorContext;
import org.easymock.Capture;
import org.easymock.EasyMock;
import org.easymock.EasyMockSupport;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TopicMonitorThreadTest
extends EasyMockSupport {
    private AdminClient adminClient;
    private KafkaFuture<Collection<TopicListing>> listingsFuture;
    private KafkaFuture<Map<String, TopicDescription>> descriptionsFuture;
    private ListTopicsResult listTopicsResult;
    private DescribeTopicsResult describeTopicsResult;
    private ConnectorContext context;
    private long pollIntervalMs;
    private List<Node> nodes;

    @Before
    public void setUp() throws Exception {
        this.adminClient = (AdminClient)this.createMock(AdminClient.class);
        this.listTopicsResult = (ListTopicsResult)this.createMock(ListTopicsResult.class);
        this.describeTopicsResult = (DescribeTopicsResult)this.createMock(DescribeTopicsResult.class);
        this.listingsFuture = (KafkaFuture)this.createMock(KafkaFuture.class);
        this.descriptionsFuture = (KafkaFuture)this.createMock(KafkaFuture.class);
        this.context = (ConnectorContext)this.createMock(ConnectorContext.class);
        this.pollIntervalMs = 10000L;
        this.nodes = Arrays.asList(new Node(0, "localhost", 9092));
    }

    @Test
    public void testBasicAssignment() throws Exception {
        String topic = "topic";
        Set<String> topics = Collections.singleton(topic);
        NewTopicMonitorThread monitorThread = new NewTopicMonitorThread(this.context, "connector", topics, null, Collections.emptySet(), this.pollIntervalMs, 0, false, null, this.adminClient);
        EasyMock.expect((Object)this.adminClient.listTopics()).andReturn((Object)this.listTopicsResult);
        EasyMock.expect((Object)this.listTopicsResult.listings()).andReturn(this.listingsFuture);
        EasyMock.expect((Object)this.listingsFuture.get()).andReturn(Collections.singletonList(new TopicListing(topic, false)));
        EasyMock.expect((Object)this.adminClient.describeTopics((Collection)EasyMock.anyObject(Set.class))).andReturn((Object)this.describeTopicsResult);
        EasyMock.expect((Object)this.describeTopicsResult.all()).andReturn(this.descriptionsFuture);
        EasyMock.expect((Object)this.descriptionsFuture.get()).andReturn(Collections.singletonMap(topic, new TopicDescription(topic, false, this.createPartitionList(2))));
        this.expectShutdown();
        this.replayAll();
        monitorThread.start();
        Map assignments = monitorThread.assignments(2);
        Assert.assertEquals((long)2L, (long)assignments.size());
        Set<TopicPartition> partitions = this.verifyAndCollectAssignedPartitions(assignments.values());
        Assert.assertEquals((long)2L, (long)partitions.size());
        Assert.assertTrue((boolean)partitions.contains(new TopicPartition(topic, 0)));
        Assert.assertTrue((boolean)partitions.contains(new TopicPartition(topic, 1)));
        monitorThread.shutdown();
        this.verifyAll();
    }

    @Test
    public void testEmptyAssignment() throws Exception {
        String topic = "topic";
        Set<String> topics = Collections.singleton(topic);
        NewTopicMonitorThread monitorThread = new NewTopicMonitorThread(this.context, "connector", topics, null, Collections.emptySet(), this.pollIntervalMs, 0, false, null, this.adminClient);
        EasyMock.expect((Object)this.adminClient.listTopics()).andReturn((Object)this.listTopicsResult);
        EasyMock.expect((Object)this.listTopicsResult.listings()).andReturn(this.listingsFuture);
        EasyMock.expect((Object)this.listingsFuture.get()).andReturn(Collections.emptyList());
        this.expectShutdown();
        this.replayAll();
        monitorThread.start();
        Map assignments = monitorThread.assignments(2);
        Assert.assertEquals((long)0L, (long)assignments.size());
        monitorThread.shutdown();
        this.verifyAll();
    }

    @Test
    public void testNoEmptyTaskAssignments() throws Exception {
        String topic = "topic";
        Set<String> topics = Collections.singleton(topic);
        NewTopicMonitorThread monitorThread = new NewTopicMonitorThread(this.context, "connector", topics, null, Collections.emptySet(), this.pollIntervalMs, 0, false, null, this.adminClient);
        EasyMock.expect((Object)this.adminClient.listTopics()).andReturn((Object)this.listTopicsResult);
        EasyMock.expect((Object)this.listTopicsResult.listings()).andReturn(this.listingsFuture);
        EasyMock.expect((Object)this.listingsFuture.get()).andReturn(Collections.singletonList(new TopicListing(topic, false)));
        EasyMock.expect((Object)this.adminClient.describeTopics((Collection)EasyMock.anyObject(Set.class))).andReturn((Object)this.describeTopicsResult);
        EasyMock.expect((Object)this.describeTopicsResult.all()).andReturn(this.descriptionsFuture);
        EasyMock.expect((Object)this.descriptionsFuture.get()).andReturn(Collections.singletonMap(topic, new TopicDescription(topic, false, this.createPartitionList(2))));
        this.expectShutdown();
        this.replayAll();
        monitorThread.start();
        Map assignments = monitorThread.assignments(5);
        Assert.assertEquals((long)2L, (long)assignments.size());
        monitorThread.shutdown();
        this.verifyAll();
    }

    @Test
    public void testRegexAssignment() throws Exception {
        String matchingTopic = "foo";
        String nonMatchingTopic = "boo";
        NewTopicMonitorThread monitorThread = new NewTopicMonitorThread(this.context, "connector", Collections.emptySet(), Pattern.compile("f.*"), Collections.emptySet(), this.pollIntervalMs, 0, false, null, this.adminClient);
        EasyMock.expect((Object)this.adminClient.listTopics()).andReturn((Object)this.listTopicsResult);
        EasyMock.expect((Object)this.listTopicsResult.listings()).andReturn(this.listingsFuture);
        EasyMock.expect((Object)this.listingsFuture.get()).andReturn(new ArrayList<TopicListing>(Arrays.asList(new TopicListing(matchingTopic, false), new TopicListing(nonMatchingTopic, false))));
        EasyMock.expect((Object)this.adminClient.describeTopics((Collection)EasyMock.anyObject(Set.class))).andReturn((Object)this.describeTopicsResult);
        EasyMock.expect((Object)this.describeTopicsResult.all()).andReturn(this.descriptionsFuture);
        EasyMock.expect((Object)this.descriptionsFuture.get()).andReturn(Collections.singletonMap(matchingTopic, new TopicDescription(matchingTopic, false, this.createPartitionList(2))));
        this.expectShutdown();
        this.replayAll();
        monitorThread.start();
        Map assignments = monitorThread.assignments(2);
        Assert.assertEquals((long)2L, (long)assignments.size());
        Set<TopicPartition> partitions = this.verifyAndCollectAssignedPartitions(assignments.values());
        Assert.assertEquals((long)2L, (long)partitions.size());
        Assert.assertTrue((boolean)partitions.contains(new TopicPartition(matchingTopic, 0)));
        Assert.assertTrue((boolean)partitions.contains(new TopicPartition(matchingTopic, 1)));
        monitorThread.shutdown();
        this.verifyAll();
    }

    @Test
    public void testWhitelistInternalTopic() throws Exception {
        String topic = "__consumer_offsets";
        Set<String> topics = Collections.singleton(topic);
        NewTopicMonitorThread monitorThread = new NewTopicMonitorThread(this.context, "connector", topics, null, Collections.emptySet(), this.pollIntervalMs, 0, false, null, this.adminClient);
        EasyMock.expect((Object)this.adminClient.listTopics()).andReturn((Object)this.listTopicsResult);
        EasyMock.expect((Object)this.listTopicsResult.listings()).andReturn(this.listingsFuture);
        EasyMock.expect((Object)this.listingsFuture.get()).andReturn(Collections.singletonList(new TopicListing(topic, true)));
        EasyMock.expect((Object)this.adminClient.describeTopics((Collection)EasyMock.anyObject(Set.class))).andReturn((Object)this.describeTopicsResult);
        EasyMock.expect((Object)this.describeTopicsResult.all()).andReturn(this.descriptionsFuture);
        EasyMock.expect((Object)this.descriptionsFuture.get()).andReturn(Collections.singletonMap(topic, new TopicDescription(topic, true, this.createPartitionList(2))));
        this.expectShutdown();
        this.replayAll();
        monitorThread.start();
        Map assignments = monitorThread.assignments(2);
        Assert.assertEquals((long)2L, (long)assignments.size());
        Set<TopicPartition> partitions = this.verifyAndCollectAssignedPartitions(assignments.values());
        Assert.assertEquals((long)2L, (long)partitions.size());
        Assert.assertTrue((boolean)partitions.contains(new TopicPartition(topic, 0)));
        Assert.assertTrue((boolean)partitions.contains(new TopicPartition(topic, 1)));
        monitorThread.shutdown();
        this.verifyAll();
    }

    @Test
    public void testExcludeInternalTopics() throws Exception {
        String matchingTopic = "foo";
        String internalTopic = "__consumer_offsets";
        NewTopicMonitorThread monitorThread = new NewTopicMonitorThread(this.context, "connector", Collections.emptySet(), Pattern.compile(".*"), Collections.emptySet(), this.pollIntervalMs, 0, false, null, this.adminClient);
        EasyMock.expect((Object)this.adminClient.listTopics()).andReturn((Object)this.listTopicsResult);
        EasyMock.expect((Object)this.listTopicsResult.listings()).andReturn(this.listingsFuture);
        EasyMock.expect((Object)this.listingsFuture.get()).andReturn(new ArrayList<TopicListing>(Arrays.asList(new TopicListing(matchingTopic, false), new TopicListing(internalTopic, true))));
        EasyMock.expect((Object)this.adminClient.describeTopics((Collection)EasyMock.anyObject(Set.class))).andReturn((Object)this.describeTopicsResult);
        EasyMock.expect((Object)this.describeTopicsResult.all()).andReturn(this.descriptionsFuture);
        EasyMock.expect((Object)this.descriptionsFuture.get()).andReturn(Collections.singletonMap(matchingTopic, new TopicDescription(matchingTopic, false, this.createPartitionList(2))));
        this.expectShutdown();
        this.replayAll();
        monitorThread.start();
        Map assignments = monitorThread.assignments(2);
        Assert.assertEquals((long)2L, (long)assignments.size());
        Set<TopicPartition> partitions = this.verifyAndCollectAssignedPartitions(assignments.values());
        Assert.assertEquals((long)2L, (long)partitions.size());
        Assert.assertTrue((boolean)partitions.contains(new TopicPartition(matchingTopic, 0)));
        Assert.assertTrue((boolean)partitions.contains(new TopicPartition(matchingTopic, 1)));
        monitorThread.shutdown();
        this.verifyAll();
    }

    @Test
    public void testBlacklistTopicsFiltered() throws Exception {
        String topic = "topic";
        String blackListTopic = "blacklisted";
        Set<String> blackListTopics = Collections.singleton(blackListTopic);
        NewTopicMonitorThread monitorThread = new NewTopicMonitorThread(this.context, "connector", Collections.emptySet(), Pattern.compile(".*"), blackListTopics, this.pollIntervalMs, 0, false, null, this.adminClient);
        EasyMock.expect((Object)this.adminClient.listTopics()).andReturn((Object)this.listTopicsResult);
        EasyMock.expect((Object)this.listTopicsResult.listings()).andReturn(this.listingsFuture);
        EasyMock.expect((Object)this.listingsFuture.get()).andReturn(new ArrayList<TopicListing>(Arrays.asList(new TopicListing(topic, false), new TopicListing(blackListTopic, false))));
        EasyMock.expect((Object)this.adminClient.describeTopics((Collection)EasyMock.anyObject(Set.class))).andReturn((Object)this.describeTopicsResult);
        EasyMock.expect((Object)this.describeTopicsResult.all()).andReturn(this.descriptionsFuture);
        EasyMock.expect((Object)this.descriptionsFuture.get()).andReturn(Collections.singletonMap(topic, new TopicDescription(topic, false, this.createPartitionList(2))));
        this.expectShutdown();
        this.replayAll();
        monitorThread.start();
        Map assignments = monitorThread.assignments(2);
        Assert.assertEquals((long)2L, (long)assignments.size());
        Set<TopicPartition> partitions = this.verifyAndCollectAssignedPartitions(assignments.values());
        Assert.assertEquals((long)2L, (long)partitions.size());
        Assert.assertTrue((boolean)partitions.contains(new TopicPartition(topic, 0)));
        Assert.assertTrue((boolean)partitions.contains(new TopicPartition(topic, 1)));
        monitorThread.shutdown();
        this.verifyAll();
    }

    @Test
    public void testMetadataChangeTriggersReconfiguration() throws Exception {
        String topic = "topic";
        String otherTopic = "other";
        NewTopicMonitorThread monitorThread = new NewTopicMonitorThread(this.context, "connector", Collections.emptySet(), Pattern.compile(".*"), Collections.emptySet(), 100L, 0, false, null, this.adminClient);
        Node leader = new Node(0, "localhost", 9092);
        EasyMock.expect((Object)this.adminClient.listTopics()).andReturn((Object)this.listTopicsResult).anyTimes();
        EasyMock.expect((Object)this.listTopicsResult.listings()).andReturn(this.listingsFuture).anyTimes();
        EasyMock.expect((Object)this.listingsFuture.get()).andReturn(new ArrayList<TopicListing>(Arrays.asList(new TopicListing(topic, false)))).andStubReturn(new ArrayList<TopicListing>(Arrays.asList(new TopicListing(topic, false), new TopicListing(otherTopic, false))));
        HashMap<String, TopicDescription> refreshedDescriptions = new HashMap<String, TopicDescription>();
        refreshedDescriptions.put(topic, new TopicDescription(topic, false, this.createPartitionList(2)));
        refreshedDescriptions.put(otherTopic, new TopicDescription(otherTopic, false, this.createPartitionList(2)));
        EasyMock.expect((Object)this.adminClient.describeTopics((Collection)EasyMock.anyObject(Set.class))).andReturn((Object)this.describeTopicsResult).anyTimes();
        EasyMock.expect((Object)this.describeTopicsResult.all()).andReturn(this.descriptionsFuture).anyTimes();
        EasyMock.expect((Object)this.descriptionsFuture.get()).andReturn(Collections.singletonMap(topic, new TopicDescription(topic, false, this.createPartitionList(2)))).andStubReturn(refreshedDescriptions);
        HashMap<String, List<PartitionInfo>> refreshedTopicMetadata = new HashMap<String, List<PartitionInfo>>();
        refreshedTopicMetadata.put(topic, Arrays.asList(new PartitionInfo(topic, 0, leader, new Node[]{leader}, new Node[]{leader}), new PartitionInfo(topic, 1, leader, new Node[]{leader}, new Node[]{leader})));
        refreshedTopicMetadata.put(otherTopic, Arrays.asList(new PartitionInfo(otherTopic, 0, leader, new Node[]{leader}, new Node[]{leader}), new PartitionInfo(otherTopic, 1, leader, new Node[]{leader}, new Node[]{leader})));
        this.context.requestTaskReconfiguration();
        EasyMock.expectLastCall();
        this.expectShutdown();
        this.replayAll();
        monitorThread.start();
        Map assignments = monitorThread.assignments(2);
        Assert.assertEquals((long)2L, (long)assignments.size());
        Set<TopicPartition> partitions = this.verifyAndCollectAssignedPartitions(assignments.values());
        Assert.assertEquals((long)2L, (long)partitions.size());
        Assert.assertTrue((boolean)partitions.contains(new TopicPartition(topic, 0)));
        Assert.assertTrue((boolean)partitions.contains(new TopicPartition(topic, 1)));
        Thread.sleep(200L);
        monitorThread.shutdown();
        this.verifyAll();
    }

    @Test
    public void testMonitorThreadsWaitIsInterrupted() throws Exception {
        String topic = "topic";
        Set<String> topics = Collections.singleton(topic);
        CountDownLatch shutdownLatch = (CountDownLatch)this.createMock(CountDownLatch.class);
        this.pollIntervalMs = 1000L;
        NewTopicMonitorThread monitorThread = new NewTopicMonitorThread(this.context, "connector", topics, null, Collections.emptySet(), this.pollIntervalMs, 0, false, null, this.adminClient, (PartitionAssignor)new RoundRobinAssignor(), new CountDownLatch(1), shutdownLatch);
        EasyMock.expect((Object)shutdownLatch.getCount()).andReturn((Object)1L).anyTimes();
        EasyMock.expect((Object)this.adminClient.listTopics()).andReturn((Object)this.listTopicsResult).anyTimes();
        EasyMock.expect((Object)this.listTopicsResult.listings()).andReturn(this.listingsFuture).anyTimes();
        EasyMock.expect((Object)this.listingsFuture.get()).andReturn(Collections.singletonList(new TopicListing(topic, false))).anyTimes();
        EasyMock.expect((Object)this.adminClient.describeTopics((Collection)EasyMock.anyObject(Set.class))).andReturn((Object)this.describeTopicsResult).anyTimes();
        EasyMock.expect((Object)this.describeTopicsResult.all()).andReturn(this.descriptionsFuture).anyTimes();
        EasyMock.expect((Object)this.descriptionsFuture.get()).andReturn(Collections.singletonMap(topic, new TopicDescription(topic, false, this.createPartitionList(2)))).anyTimes();
        EasyMock.expect((Object)shutdownLatch.await(EasyMock.eq((long)this.pollIntervalMs), (TimeUnit)((Object)EasyMock.eq((Object)((Object)TimeUnit.MILLISECONDS))))).andThrow((Throwable)new InterruptedException());
        EasyMock.expect((Object)shutdownLatch.await(EasyMock.eq((long)this.pollIntervalMs), (TimeUnit)((Object)EasyMock.eq((Object)((Object)TimeUnit.MILLISECONDS))))).andReturn((Object)true).anyTimes();
        this.expectShutdown();
        shutdownLatch.countDown();
        EasyMock.expectLastCall();
        this.replayAll();
        monitorThread.start();
        Thread.sleep(this.pollIntervalMs);
        monitorThread.shutdown();
        this.verifyAll();
    }

    @Test
    public void testMonitorThreadsWaitIsCancelled() throws Exception {
        String topic = "topic";
        Set<String> topics = Collections.singleton(topic);
        CountDownLatch shutdownLatch = (CountDownLatch)this.createMock(CountDownLatch.class);
        this.pollIntervalMs = 1000L;
        NewTopicMonitorThread monitorThread = new NewTopicMonitorThread(this.context, "connector", topics, null, Collections.emptySet(), this.pollIntervalMs, 0, false, null, this.adminClient, (PartitionAssignor)new RoundRobinAssignor(), new CountDownLatch(1), shutdownLatch);
        EasyMock.expect((Object)shutdownLatch.getCount()).andReturn((Object)1L).anyTimes();
        EasyMock.expect((Object)this.adminClient.listTopics()).andReturn((Object)this.listTopicsResult).anyTimes();
        EasyMock.expect((Object)this.listTopicsResult.listings()).andReturn(this.listingsFuture).anyTimes();
        EasyMock.expect((Object)this.listingsFuture.get()).andReturn(Collections.singletonList(new TopicListing(topic, false))).anyTimes();
        EasyMock.expect((Object)this.adminClient.describeTopics((Collection)EasyMock.anyObject(Set.class))).andReturn((Object)this.describeTopicsResult).anyTimes();
        EasyMock.expect((Object)this.describeTopicsResult.all()).andReturn(this.descriptionsFuture).anyTimes();
        EasyMock.expect((Object)this.descriptionsFuture.get()).andReturn(Collections.singletonMap(topic, new TopicDescription(topic, false, this.createPartitionList(2)))).anyTimes();
        EasyMock.expect((Object)shutdownLatch.await(EasyMock.eq((long)this.pollIntervalMs), (TimeUnit)((Object)EasyMock.eq((Object)((Object)TimeUnit.MILLISECONDS))))).andThrow((Throwable)new CancellationException());
        this.replayAll();
        monitorThread.start();
        Thread.sleep(this.pollIntervalMs);
        this.verifyAll();
    }

    @Test
    public void testMonitorThreadsWaitThrowsUnknownException() throws Exception {
        String topic = "topic";
        Set<String> topics = Collections.singleton(topic);
        CountDownLatch shutdownLatch = (CountDownLatch)this.createMock(CountDownLatch.class);
        this.pollIntervalMs = 1000L;
        NewTopicMonitorThread monitorThread = new NewTopicMonitorThread(this.context, "connector", topics, null, Collections.emptySet(), this.pollIntervalMs, 0, false, null, this.adminClient, (PartitionAssignor)new RoundRobinAssignor(), new CountDownLatch(1), shutdownLatch);
        EasyMock.expect((Object)shutdownLatch.getCount()).andReturn((Object)1L).anyTimes();
        EasyMock.expect((Object)this.adminClient.listTopics()).andReturn((Object)this.listTopicsResult).anyTimes();
        EasyMock.expect((Object)this.listTopicsResult.listings()).andReturn(this.listingsFuture).anyTimes();
        EasyMock.expect((Object)this.listingsFuture.get()).andReturn(Collections.singletonList(new TopicListing(topic, false))).anyTimes();
        EasyMock.expect((Object)this.adminClient.describeTopics((Collection)EasyMock.anyObject(Set.class))).andReturn((Object)this.describeTopicsResult).anyTimes();
        EasyMock.expect((Object)this.describeTopicsResult.all()).andReturn(this.descriptionsFuture).anyTimes();
        EasyMock.expect((Object)this.descriptionsFuture.get()).andReturn(Collections.singletonMap(topic, new TopicDescription(topic, false, this.createPartitionList(2)))).anyTimes();
        EasyMock.expect((Object)shutdownLatch.await(EasyMock.eq((long)this.pollIntervalMs), (TimeUnit)((Object)EasyMock.eq((Object)((Object)TimeUnit.MILLISECONDS))))).andThrow((Throwable)new IllegalStateException());
        Capture exception = EasyMock.newCapture();
        this.context.raiseError((Exception)EasyMock.capture((Capture)exception));
        EasyMock.expectLastCall();
        this.replayAll();
        monitorThread.start();
        Thread.sleep(this.pollIntervalMs);
        Assert.assertTrue((boolean)exception.hasCaptured());
        Assert.assertTrue((boolean)(exception.getValue() instanceof IllegalStateException));
        this.verifyAll();
    }

    @Test
    public void testJointOffsetTranslationTasks() throws Exception {
        String topic = "topic";
        Set<String> topics = Collections.singleton("topic");
        NewTopicMonitorThread monitorThread = new NewTopicMonitorThread(this.context, "connector", topics, null, Collections.emptySet(), this.pollIntervalMs, -1, false, Collections.singletonList("localhost:9092"), this.adminClient);
        EasyMock.expect((Object)this.adminClient.listTopics()).andReturn((Object)this.listTopicsResult);
        EasyMock.expect((Object)this.listTopicsResult.listings()).andReturn(this.listingsFuture);
        EasyMock.expect((Object)this.listingsFuture.get()).andReturn(Arrays.asList(new TopicListing("topic", false), new TopicListing("__consumer_timestamps", true)));
        EasyMock.expect((Object)this.adminClient.describeTopics((Collection)EasyMock.anyObject(Set.class))).andReturn((Object)this.describeTopicsResult);
        EasyMock.expect((Object)this.describeTopicsResult.all()).andReturn(this.descriptionsFuture);
        EasyMock.expect((Object)this.descriptionsFuture.get()).andReturn((Object)new HashMap<String, TopicDescription>(){
            {
                this.put("topic", new TopicDescription("topic", false, TopicMonitorThreadTest.this.createPartitionList(2)));
                this.put("__consumer_timestamps", new TopicDescription("__consumer_timestamps", true, TopicMonitorThreadTest.this.createPartitionList(2)));
            }
        });
        this.expectShutdown();
        this.replayAll();
        monitorThread.start();
        Map assignments = monitorThread.assignments(2);
        Assert.assertEquals((long)2L, (long)assignments.size());
        List partitions = ((PartitionAssignor.Assignment)assignments.get("connector-0")).partitions();
        Assert.assertTrue((boolean)partitions.contains(new TopicPartition("topic", 0)));
        Assert.assertTrue((boolean)partitions.contains(new TopicPartition("__consumer_timestamps", 0)));
        partitions = ((PartitionAssignor.Assignment)assignments.get("connector-1")).partitions();
        Assert.assertTrue((boolean)partitions.contains(new TopicPartition("topic", 1)));
        Assert.assertTrue((boolean)partitions.contains(new TopicPartition("__consumer_timestamps", 1)));
        monitorThread.shutdown();
        this.verifyAll();
    }

    @Test
    public void testPartialJointOffsetTranslationTasks() throws Exception {
        String topic = "topic";
        Set<String> topics = Collections.singleton("topic");
        NewTopicMonitorThread monitorThread = new NewTopicMonitorThread(this.context, "connector", topics, null, Collections.emptySet(), this.pollIntervalMs, 1, false, Collections.singletonList("localhost:9092"), this.adminClient);
        EasyMock.expect((Object)this.adminClient.listTopics()).andReturn((Object)this.listTopicsResult);
        EasyMock.expect((Object)this.listTopicsResult.listings()).andReturn(this.listingsFuture);
        EasyMock.expect((Object)this.listingsFuture.get()).andReturn(Arrays.asList(new TopicListing("topic", false), new TopicListing("__consumer_timestamps", true)));
        EasyMock.expect((Object)this.adminClient.describeTopics((Collection)EasyMock.anyObject(Set.class))).andReturn((Object)this.describeTopicsResult);
        EasyMock.expect((Object)this.describeTopicsResult.all()).andReturn(this.descriptionsFuture);
        EasyMock.expect((Object)this.descriptionsFuture.get()).andReturn((Object)new HashMap<String, TopicDescription>(){
            {
                this.put("topic", new TopicDescription("topic", false, TopicMonitorThreadTest.this.createPartitionList(2)));
                this.put("__consumer_timestamps", new TopicDescription("__consumer_timestamps", true, TopicMonitorThreadTest.this.createPartitionList(2)));
            }
        });
        this.expectShutdown();
        this.replayAll();
        monitorThread.start();
        Map assignments = monitorThread.assignments(2);
        Assert.assertEquals((long)2L, (long)assignments.size());
        List partitions = ((PartitionAssignor.Assignment)assignments.get("connector-0")).partitions();
        Assert.assertTrue((boolean)partitions.contains(new TopicPartition("topic", 0)));
        partitions = ((PartitionAssignor.Assignment)assignments.get("connector-1")).partitions();
        Assert.assertTrue((boolean)partitions.contains(new TopicPartition("topic", 1)));
        Assert.assertTrue((boolean)partitions.contains(new TopicPartition("__consumer_timestamps", 0)));
        Assert.assertTrue((boolean)partitions.contains(new TopicPartition("__consumer_timestamps", 1)));
        monitorThread.shutdown();
        this.verifyAll();
    }

    @Test
    public void testJointOffsetTranslationTasksUsingLessThanMaxTasks() throws Exception {
        String topic = "topic";
        Set<String> topics = Collections.singleton("topic");
        NewTopicMonitorThread monitorThread = new NewTopicMonitorThread(this.context, "connector", topics, null, Collections.emptySet(), this.pollIntervalMs, 1, false, Collections.singletonList("localhost:9092"), this.adminClient);
        EasyMock.expect((Object)this.adminClient.listTopics()).andReturn((Object)this.listTopicsResult);
        EasyMock.expect((Object)this.listTopicsResult.listings()).andReturn(this.listingsFuture);
        EasyMock.expect((Object)this.listingsFuture.get()).andReturn(Arrays.asList(new TopicListing("topic", false), new TopicListing("__consumer_timestamps", true)));
        EasyMock.expect((Object)this.adminClient.describeTopics((Collection)EasyMock.anyObject(Set.class))).andReturn((Object)this.describeTopicsResult);
        EasyMock.expect((Object)this.describeTopicsResult.all()).andReturn(this.descriptionsFuture);
        EasyMock.expect((Object)this.descriptionsFuture.get()).andReturn((Object)new HashMap<String, TopicDescription>(){
            {
                this.put("topic", new TopicDescription("topic", false, TopicMonitorThreadTest.this.createPartitionList(2)));
                this.put("__consumer_timestamps", new TopicDescription("__consumer_timestamps", true, TopicMonitorThreadTest.this.createPartitionList(2)));
            }
        });
        this.expectShutdown();
        this.replayAll();
        monitorThread.start();
        Map assignments = monitorThread.assignments(10);
        Assert.assertEquals((long)3L, (long)assignments.size());
        List partitions = ((PartitionAssignor.Assignment)assignments.get("connector-0")).partitions();
        Assert.assertTrue((boolean)partitions.contains(new TopicPartition("topic", 0)));
        partitions = ((PartitionAssignor.Assignment)assignments.get("connector-1")).partitions();
        Assert.assertTrue((boolean)partitions.contains(new TopicPartition("topic", 1)));
        partitions = ((PartitionAssignor.Assignment)assignments.get("connector-2")).partitions();
        Assert.assertTrue((boolean)partitions.contains(new TopicPartition("__consumer_timestamps", 0)));
        Assert.assertTrue((boolean)partitions.contains(new TopicPartition("__consumer_timestamps", 1)));
        monitorThread.shutdown();
        this.verifyAll();
    }

    @Test
    public void testJointOffsetTranslationTasksUsingLessThanMaxOffsetTranslatorTasks() throws Exception {
        String topic = "topic";
        Set<String> topics = Collections.singleton("topic");
        NewTopicMonitorThread monitorThread = new NewTopicMonitorThread(this.context, "connector", topics, null, Collections.emptySet(), this.pollIntervalMs, 2, false, Collections.singletonList("localhost:9092"), this.adminClient);
        EasyMock.expect((Object)this.adminClient.listTopics()).andReturn((Object)this.listTopicsResult);
        EasyMock.expect((Object)this.listTopicsResult.listings()).andReturn(this.listingsFuture);
        EasyMock.expect((Object)this.listingsFuture.get()).andReturn(Arrays.asList(new TopicListing("topic", false), new TopicListing("__consumer_timestamps", true)));
        EasyMock.expect((Object)this.adminClient.describeTopics((Collection)EasyMock.anyObject(Set.class))).andReturn((Object)this.describeTopicsResult);
        EasyMock.expect((Object)this.describeTopicsResult.all()).andReturn(this.descriptionsFuture);
        EasyMock.expect((Object)this.descriptionsFuture.get()).andReturn((Object)new HashMap<String, TopicDescription>(){
            {
                this.put("topic", new TopicDescription("topic", false, TopicMonitorThreadTest.this.createPartitionList(2)));
                this.put("__consumer_timestamps", new TopicDescription("__consumer_timestamps", true, TopicMonitorThreadTest.this.createPartitionList(1)));
            }
        });
        this.expectShutdown();
        this.replayAll();
        monitorThread.start();
        Map assignments = monitorThread.assignments(10);
        Assert.assertEquals((long)3L, (long)assignments.size());
        List partitions = ((PartitionAssignor.Assignment)assignments.get("connector-0")).partitions();
        Assert.assertTrue((boolean)partitions.contains(new TopicPartition("topic", 0)));
        partitions = ((PartitionAssignor.Assignment)assignments.get("connector-1")).partitions();
        Assert.assertTrue((boolean)partitions.contains(new TopicPartition("topic", 1)));
        partitions = ((PartitionAssignor.Assignment)assignments.get("connector-2")).partitions();
        Assert.assertTrue((boolean)partitions.contains(new TopicPartition("__consumer_timestamps", 0)));
        monitorThread.shutdown();
        this.verifyAll();
    }

    @Test
    public void testSeparateOffsetTranslationTasks() throws Exception {
        String topic = "topic";
        Set<String> topics = Collections.singleton("topic");
        NewTopicMonitorThread monitorThread = new NewTopicMonitorThread(this.context, "connector", topics, null, Collections.emptySet(), this.pollIntervalMs, 1, true, Collections.singletonList("localhost:9092"), this.adminClient);
        EasyMock.expect((Object)this.adminClient.listTopics()).andReturn((Object)this.listTopicsResult);
        EasyMock.expect((Object)this.listTopicsResult.listings()).andReturn(this.listingsFuture);
        EasyMock.expect((Object)this.listingsFuture.get()).andReturn(Arrays.asList(new TopicListing("topic", false), new TopicListing("__consumer_timestamps", true)));
        EasyMock.expect((Object)this.adminClient.describeTopics((Collection)EasyMock.anyObject(Set.class))).andReturn((Object)this.describeTopicsResult);
        EasyMock.expect((Object)this.describeTopicsResult.all()).andReturn(this.descriptionsFuture);
        EasyMock.expect((Object)this.descriptionsFuture.get()).andReturn((Object)new HashMap<String, TopicDescription>(){
            {
                this.put("topic", new TopicDescription("topic", false, TopicMonitorThreadTest.this.createPartitionList(2)));
                this.put("__consumer_timestamps", new TopicDescription("__consumer_timestamps", true, TopicMonitorThreadTest.this.createPartitionList(2)));
            }
        });
        this.expectShutdown();
        this.replayAll();
        monitorThread.start();
        Map assignments = monitorThread.assignments(2);
        Assert.assertEquals((long)2L, (long)assignments.size());
        List partitions = ((PartitionAssignor.Assignment)assignments.get("connector-0")).partitions();
        Assert.assertTrue((boolean)partitions.contains(new TopicPartition("topic", 0)));
        Assert.assertTrue((boolean)partitions.contains(new TopicPartition("topic", 1)));
        partitions = ((PartitionAssignor.Assignment)assignments.get("connector-1")).partitions();
        Assert.assertTrue((boolean)partitions.contains(new TopicPartition("__consumer_timestamps", 0)));
        Assert.assertTrue((boolean)partitions.contains(new TopicPartition("__consumer_timestamps", 1)));
        monitorThread.shutdown();
        this.verifyAll();
    }

    @Test
    public void testSeparateOffsetTranslationTasksUsingLessThanMaxTasks() throws Exception {
        String topic = "topic";
        Set<String> topics = Collections.singleton("topic");
        NewTopicMonitorThread monitorThread = new NewTopicMonitorThread(this.context, "connector", topics, null, Collections.emptySet(), this.pollIntervalMs, 1, true, Collections.singletonList("localhost:9092"), this.adminClient);
        EasyMock.expect((Object)this.adminClient.listTopics()).andReturn((Object)this.listTopicsResult);
        EasyMock.expect((Object)this.listTopicsResult.listings()).andReturn(this.listingsFuture);
        EasyMock.expect((Object)this.listingsFuture.get()).andReturn(Arrays.asList(new TopicListing("topic", false), new TopicListing("__consumer_timestamps", true)));
        EasyMock.expect((Object)this.adminClient.describeTopics((Collection)EasyMock.anyObject(Set.class))).andReturn((Object)this.describeTopicsResult);
        EasyMock.expect((Object)this.describeTopicsResult.all()).andReturn(this.descriptionsFuture);
        EasyMock.expect((Object)this.descriptionsFuture.get()).andReturn((Object)new HashMap<String, TopicDescription>(){
            {
                this.put("topic", new TopicDescription("topic", false, TopicMonitorThreadTest.this.createPartitionList(2)));
                this.put("__consumer_timestamps", new TopicDescription("__consumer_timestamps", true, TopicMonitorThreadTest.this.createPartitionList(2)));
            }
        });
        this.expectShutdown();
        this.replayAll();
        monitorThread.start();
        Map assignments = monitorThread.assignments(10);
        Assert.assertEquals((long)3L, (long)assignments.size());
        List partitions = ((PartitionAssignor.Assignment)assignments.get("connector-0")).partitions();
        Assert.assertTrue((boolean)partitions.contains(new TopicPartition("topic", 0)));
        partitions = ((PartitionAssignor.Assignment)assignments.get("connector-1")).partitions();
        Assert.assertTrue((boolean)partitions.contains(new TopicPartition("topic", 1)));
        partitions = ((PartitionAssignor.Assignment)assignments.get("connector-2")).partitions();
        Assert.assertTrue((boolean)partitions.contains(new TopicPartition("__consumer_timestamps", 0)));
        Assert.assertTrue((boolean)partitions.contains(new TopicPartition("__consumer_timestamps", 1)));
        monitorThread.shutdown();
        this.verifyAll();
    }

    @Test
    public void testSeparateOffsetTranslationTasksUsingLessThanMaxOffsetTranslatorTasks() throws Exception {
        String topic = "topic";
        Set<String> topics = Collections.singleton("topic");
        NewTopicMonitorThread monitorThread = new NewTopicMonitorThread(this.context, "connector", topics, null, Collections.emptySet(), this.pollIntervalMs, 2, true, Collections.singletonList("localhost:9092"), this.adminClient);
        EasyMock.expect((Object)this.adminClient.listTopics()).andReturn((Object)this.listTopicsResult);
        EasyMock.expect((Object)this.listTopicsResult.listings()).andReturn(this.listingsFuture);
        EasyMock.expect((Object)this.listingsFuture.get()).andReturn(Arrays.asList(new TopicListing("topic", false), new TopicListing("__consumer_timestamps", true)));
        EasyMock.expect((Object)this.adminClient.describeTopics((Collection)EasyMock.anyObject(Set.class))).andReturn((Object)this.describeTopicsResult);
        EasyMock.expect((Object)this.describeTopicsResult.all()).andReturn(this.descriptionsFuture);
        EasyMock.expect((Object)this.descriptionsFuture.get()).andReturn((Object)new HashMap<String, TopicDescription>(){
            {
                this.put("topic", new TopicDescription("topic", false, TopicMonitorThreadTest.this.createPartitionList(2)));
                this.put("__consumer_timestamps", new TopicDescription("__consumer_timestamps", true, TopicMonitorThreadTest.this.createPartitionList(1)));
            }
        });
        this.expectShutdown();
        this.replayAll();
        monitorThread.start();
        Map assignments = monitorThread.assignments(10);
        Assert.assertEquals((long)3L, (long)assignments.size());
        List partitions = ((PartitionAssignor.Assignment)assignments.get("connector-0")).partitions();
        Assert.assertTrue((boolean)partitions.contains(new TopicPartition("topic", 0)));
        partitions = ((PartitionAssignor.Assignment)assignments.get("connector-1")).partitions();
        Assert.assertTrue((boolean)partitions.contains(new TopicPartition("topic", 1)));
        partitions = ((PartitionAssignor.Assignment)assignments.get("connector-2")).partitions();
        Assert.assertTrue((boolean)partitions.contains(new TopicPartition("__consumer_timestamps", 0)));
        monitorThread.shutdown();
        this.verifyAll();
    }

    private List<TopicPartitionInfo> createPartitionList(int numPartitions) {
        ArrayList<TopicPartitionInfo> partitionInfos = new ArrayList<TopicPartitionInfo>(numPartitions);
        for (int i = 0; i < numPartitions; ++i) {
            partitionInfos.add(new TopicPartitionInfo(i, this.nodes.get(0), this.nodes, this.nodes));
        }
        return Collections.unmodifiableList(partitionInfos);
    }

    private void expectShutdown() {
        this.adminClient.close(EasyMock.eq((long)0L), (TimeUnit)((Object)EasyMock.anyObject(TimeUnit.class)));
        EasyMock.expectLastCall();
    }

    private Set<TopicPartition> verifyAndCollectAssignedPartitions(Collection<PartitionAssignor.Assignment> assignments) {
        HashSet<TopicPartition> partitions = new HashSet<TopicPartition>();
        for (PartitionAssignor.Assignment assignment : assignments) {
            for (TopicPartition partition : assignment.partitions()) {
                Assert.assertFalse((boolean)partitions.contains(partition));
                partitions.add(partition);
            }
        }
        return partitions;
    }
}

