/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.replicator;

import io.confluent.connect.replicator.ReplicatorSourceTask;
import io.confluent.connect.replicator.util.ByteArrayConverter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.connect.header.ConnectHeaders;
import org.apache.kafka.connect.storage.HeaderConverter;
import org.easymock.EasyMockSupport;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.theories.Theories;
import org.junit.runner.RunWith;

@RunWith(value=Theories.class)
public class ReplicatorSourceProvenanceHeadersTest
extends EasyMockSupport {
    @Test
    public void testParseSimpleFilterOverride() throws Exception {
        String overrides = "dc-1,topic-1,0-1000";
        ArrayList filterOverrides = new ArrayList();
        ReplicatorSourceTask.parseFilterOverrides((String)overrides, filterOverrides);
        Assert.assertEquals((long)1L, (long)filterOverrides.size());
        Assert.assertEquals((Object)"dc-1", (Object)((ReplicatorSourceTask.FilterOverride)filterOverrides.get(0)).clusterId().toString());
        Assert.assertEquals((Object)"topic-1", (Object)((ReplicatorSourceTask.FilterOverride)filterOverrides.get(0)).topic().toString());
        Assert.assertEquals((long)0L, (long)((ReplicatorSourceTask.FilterOverride)filterOverrides.get(0)).startTsInclusive());
        Assert.assertEquals((long)1000L, (long)((ReplicatorSourceTask.FilterOverride)filterOverrides.get(0)).endTsExclusive());
    }

    @Test
    public void testParseFilterOverrideMissingTimestamps() throws Exception {
        String overrides = "dc-1,topic-1,-";
        ArrayList filterOverrides = new ArrayList();
        ReplicatorSourceTask.parseFilterOverrides((String)overrides, filterOverrides);
        Assert.assertEquals((long)1L, (long)filterOverrides.size());
        Assert.assertEquals((Object)"dc-1", (Object)((ReplicatorSourceTask.FilterOverride)filterOverrides.get(0)).clusterId().toString());
        Assert.assertEquals((Object)"topic-1", (Object)((ReplicatorSourceTask.FilterOverride)filterOverrides.get(0)).topic().toString());
        Assert.assertEquals((long)0L, (long)((ReplicatorSourceTask.FilterOverride)filterOverrides.get(0)).startTsInclusive());
        Assert.assertEquals((long)Long.MAX_VALUE, (long)((ReplicatorSourceTask.FilterOverride)filterOverrides.get(0)).endTsExclusive());
    }

    @Test
    public void testParseFilterOverrideMissingStartTimestamp() throws Exception {
        String overrides = "dc-1,topic-1,-1000";
        ArrayList filterOverrides = new ArrayList();
        ReplicatorSourceTask.parseFilterOverrides((String)overrides, filterOverrides);
        Assert.assertEquals((long)1L, (long)filterOverrides.size());
        Assert.assertEquals((Object)"dc-1", (Object)((ReplicatorSourceTask.FilterOverride)filterOverrides.get(0)).clusterId().toString());
        Assert.assertEquals((Object)"topic-1", (Object)((ReplicatorSourceTask.FilterOverride)filterOverrides.get(0)).topic().toString());
        Assert.assertEquals((long)0L, (long)((ReplicatorSourceTask.FilterOverride)filterOverrides.get(0)).startTsInclusive());
        Assert.assertEquals((long)1000L, (long)((ReplicatorSourceTask.FilterOverride)filterOverrides.get(0)).endTsExclusive());
    }

    @Test
    public void testParseFilterOverrideMissingEndTimestamp() throws Exception {
        String overrides = "dc-1,topic-1,0-";
        ArrayList filterOverrides = new ArrayList();
        ReplicatorSourceTask.parseFilterOverrides((String)overrides, filterOverrides);
        Assert.assertEquals((long)1L, (long)filterOverrides.size());
        Assert.assertEquals((Object)"dc-1", (Object)((ReplicatorSourceTask.FilterOverride)filterOverrides.get(0)).clusterId().toString());
        Assert.assertEquals((Object)"topic-1", (Object)((ReplicatorSourceTask.FilterOverride)filterOverrides.get(0)).topic().toString());
        Assert.assertEquals((long)0L, (long)((ReplicatorSourceTask.FilterOverride)filterOverrides.get(0)).startTsInclusive());
        Assert.assertEquals((long)Long.MAX_VALUE, (long)((ReplicatorSourceTask.FilterOverride)filterOverrides.get(0)).endTsExclusive());
    }

    @Test
    public void testParseMultipleFilterOverrides() throws Exception {
        String overrides = "dc-1,topic-1,0-1000;dc-2,topic-2,1000-2000";
        ArrayList filterOverrides = new ArrayList();
        ReplicatorSourceTask.parseFilterOverrides((String)overrides, filterOverrides);
        Assert.assertEquals((long)2L, (long)filterOverrides.size());
        Assert.assertEquals((Object)"dc-1", (Object)((ReplicatorSourceTask.FilterOverride)filterOverrides.get(0)).clusterId().toString());
        Assert.assertEquals((Object)"topic-1", (Object)((ReplicatorSourceTask.FilterOverride)filterOverrides.get(0)).topic().toString());
        Assert.assertEquals((long)0L, (long)((ReplicatorSourceTask.FilterOverride)filterOverrides.get(0)).startTsInclusive());
        Assert.assertEquals((long)1000L, (long)((ReplicatorSourceTask.FilterOverride)filterOverrides.get(0)).endTsExclusive());
        Assert.assertEquals((Object)"dc-2", (Object)((ReplicatorSourceTask.FilterOverride)filterOverrides.get(1)).clusterId().toString());
        Assert.assertEquals((Object)"topic-2", (Object)((ReplicatorSourceTask.FilterOverride)filterOverrides.get(1)).topic().toString());
        Assert.assertEquals((long)1000L, (long)((ReplicatorSourceTask.FilterOverride)filterOverrides.get(1)).startTsInclusive());
        Assert.assertEquals((long)2000L, (long)((ReplicatorSourceTask.FilterOverride)filterOverrides.get(1)).endTsExclusive());
    }

    @Test
    public void testParseNullFilterOverride() throws Exception {
        String overrides = null;
        ArrayList filterOverrides = new ArrayList();
        ReplicatorSourceTask.parseFilterOverrides(overrides, filterOverrides);
        Assert.assertEquals((long)0L, (long)filterOverrides.size());
    }

    @Test
    public void testParseEmptyFilterOverride() throws Exception {
        String overrides = "";
        ArrayList filterOverrides = new ArrayList();
        ReplicatorSourceTask.parseFilterOverrides((String)overrides, filterOverrides);
        Assert.assertEquals((long)0L, (long)filterOverrides.size());
    }

    @Test
    public void testSimpleFilterOverrideWithMatch() throws Exception {
        String overrides = "dc-2,topic-2,0-1000";
        ArrayList filterOverrides = new ArrayList();
        ReplicatorSourceTask.parseFilterOverrides((String)overrides, filterOverrides);
        String sourceClusterId = "dc-1";
        String destClusterId = "dc-2";
        String sourceTopic = "topic-1";
        String destTopic = "topic-2";
        ConsumerRecord record = new ConsumerRecord(sourceTopic, 0, 0L, -1L, TimestampType.CREATE_TIME, 0L, 0, 0, (Object)new byte[0], (Object)new byte[0]);
        record.headers().add("__replicator_id", ReplicatorSourceTask.formatProvenanceHeader((String)destClusterId, (String)destTopic, (Long)0L));
        boolean found = ReplicatorSourceTask.shouldFilterRecord((ConsumerRecord)record, (String)destClusterId, (String)destTopic, filterOverrides);
        Assert.assertFalse((boolean)found);
    }

    @Test
    public void testSimpleFilterOverrideWithNoMatchClusterId() throws Exception {
        String overrides = "dc-1,topic-1,0-1000";
        ArrayList filterOverrides = new ArrayList();
        ReplicatorSourceTask.parseFilterOverrides((String)overrides, filterOverrides);
        String sourceClusterId = "dc-1";
        String destClusterId = "dc-2";
        String sourceTopic = "topic-1";
        String destTopic = "topic-2";
        ConsumerRecord record = new ConsumerRecord(sourceTopic, 0, 0L, -1L, TimestampType.CREATE_TIME, 0L, 0, 0, (Object)new byte[0], (Object)new byte[0]);
        record.headers().add("__replicator_id", ReplicatorSourceTask.formatProvenanceHeader((String)destClusterId, (String)destTopic, (Long)0L));
        boolean found = ReplicatorSourceTask.shouldFilterRecord((ConsumerRecord)record, (String)destClusterId, (String)destTopic, filterOverrides);
        Assert.assertTrue((boolean)found);
    }

    @Test
    public void testSimpleFilterOverrideWithNoMatchTopic() throws Exception {
        String overrides = "dc-2,topic-3,0-1000";
        ArrayList filterOverrides = new ArrayList();
        ReplicatorSourceTask.parseFilterOverrides((String)overrides, filterOverrides);
        String sourceClusterId = "dc-1";
        String destClusterId = "dc-2";
        String sourceTopic = "topic-1";
        String destTopic = "topic-2";
        ConsumerRecord record = new ConsumerRecord(sourceTopic, 0, 0L, -1L, TimestampType.CREATE_TIME, 0L, 0, 0, (Object)new byte[0], (Object)new byte[0]);
        record.headers().add("__replicator_id", ReplicatorSourceTask.formatProvenanceHeader((String)destClusterId, (String)destTopic, (Long)0L));
        boolean found = ReplicatorSourceTask.shouldFilterRecord((ConsumerRecord)record, (String)destClusterId, (String)destTopic, filterOverrides);
        Assert.assertTrue((boolean)found);
    }

    @Test
    public void testSimpleFilterOverrideWithNoMatchTimestamp() throws Exception {
        String overrides = "dc-2,topic-2,1000-2000";
        ArrayList filterOverrides = new ArrayList();
        ReplicatorSourceTask.parseFilterOverrides((String)overrides, filterOverrides);
        String sourceClusterId = "dc-1";
        String destClusterId = "dc-2";
        String sourceTopic = "topic-1";
        String destTopic = "topic-2";
        ConsumerRecord record = new ConsumerRecord(sourceTopic, 0, 0L, -1L, TimestampType.CREATE_TIME, 0L, 0, 0, (Object)new byte[0], (Object)new byte[0]);
        record.headers().add("__replicator_id", ReplicatorSourceTask.formatProvenanceHeader((String)destClusterId, (String)destTopic, (Long)0L));
        boolean found = ReplicatorSourceTask.shouldFilterRecord((ConsumerRecord)record, (String)destClusterId, (String)destTopic, filterOverrides);
        Assert.assertTrue((boolean)found);
    }

    @Test
    public void testFilterOverrideWithOldHeaderAndMatch() throws Exception {
        String overrides = "rep-1,topic-1,0-1000";
        ArrayList filterOverrides = new ArrayList();
        ReplicatorSourceTask.parseFilterOverrides((String)overrides, filterOverrides);
        String sourceClusterId = "dc-1";
        String destClusterId = "dc-2";
        String sourceTopic = "topic-1";
        String destTopic = "topic-2";
        ConsumerRecord record = new ConsumerRecord(sourceTopic, 0, 0L, -1L, TimestampType.CREATE_TIME, 0L, 0, 0, (Object)new byte[0], (Object)new byte[0]);
        record.headers().add("__replicator_id", new String("rep-1").getBytes(StandardCharsets.UTF_8));
        boolean found = ReplicatorSourceTask.shouldFilterRecord((ConsumerRecord)record, (String)destClusterId, (String)destTopic, filterOverrides);
        Assert.assertFalse((boolean)found);
    }

    @Test
    public void testFilterOverrideWithOldHeaderAndNoMatch() throws Exception {
        String overrides = "rep-2,topic-1,0-1000";
        ArrayList filterOverrides = new ArrayList();
        ReplicatorSourceTask.parseFilterOverrides((String)overrides, filterOverrides);
        String sourceClusterId = "dc-1";
        String destClusterId = "dc-2";
        String sourceTopic = "topic-1";
        String destTopic = "topic-2";
        ConsumerRecord record = new ConsumerRecord(sourceTopic, 0, 0L, -1L, TimestampType.CREATE_TIME, 0L, 0, 0, (Object)new byte[0], (Object)new byte[0]);
        record.headers().add("__replicator_id", new String("rep-1").getBytes(StandardCharsets.UTF_8));
        boolean found = ReplicatorSourceTask.shouldFilterRecord((ConsumerRecord)record, (String)destClusterId, (String)destTopic, filterOverrides);
        Assert.assertTrue((boolean)found);
    }

    @Test
    public void testFilterOverrideWithOldHeaderOnly() throws Exception {
        String overrides = "rep-1,.*,0-";
        ArrayList filterOverrides = new ArrayList();
        ReplicatorSourceTask.parseFilterOverrides((String)overrides, filterOverrides);
        String sourceClusterId = "dc-1";
        String destClusterId = "dc-2";
        String sourceTopic = "topic-1";
        String destTopic = "topic-2";
        ConsumerRecord record = new ConsumerRecord(sourceTopic, 0, 0L, -1L, TimestampType.CREATE_TIME, 0L, 0, 0, (Object)new byte[0], (Object)new byte[0]);
        record.headers().add("__replicator_id", new String("rep-1").getBytes(StandardCharsets.UTF_8));
        boolean found = ReplicatorSourceTask.shouldFilterRecord((ConsumerRecord)record, (String)destClusterId, (String)destTopic, filterOverrides);
        Assert.assertFalse((boolean)found);
    }

    @Test
    public void testFilterOverrideUsesRecordTimestamp() throws Exception {
        String overrides = "rep-1,.*,1000-2000";
        ArrayList filterOverrides = new ArrayList();
        ReplicatorSourceTask.parseFilterOverrides((String)overrides, filterOverrides);
        String sourceClusterId = "dc-1";
        String destClusterId = "dc-2";
        String sourceTopic = "topic-1";
        String destTopic = "topic-2";
        ConsumerRecord record = new ConsumerRecord(sourceTopic, 0, 0L, 1000L, TimestampType.CREATE_TIME, 0L, 0, 0, (Object)new byte[0], (Object)new byte[0]);
        record.headers().add("__replicator_id", new String("rep-1").getBytes(StandardCharsets.UTF_8));
        boolean found = ReplicatorSourceTask.shouldFilterRecord((ConsumerRecord)record, (String)destClusterId, (String)destTopic, filterOverrides);
        Assert.assertFalse((boolean)found);
    }

    @Test
    public void testClusterIdRegexFilterOverrideWithMatch() throws Exception {
        String overrides = "dc-.*,topic-2,0-1000";
        ArrayList filterOverrides = new ArrayList();
        ReplicatorSourceTask.parseFilterOverrides((String)overrides, filterOverrides);
        String sourceClusterId = "dc-1";
        String destClusterId = "dc-2";
        String sourceTopic = "topic-1";
        String destTopic = "topic-2";
        ConsumerRecord record = new ConsumerRecord(sourceTopic, 0, 0L, -1L, TimestampType.CREATE_TIME, 0L, 0, 0, (Object)new byte[0], (Object)new byte[0]);
        record.headers().add("__replicator_id", ReplicatorSourceTask.formatProvenanceHeader((String)destClusterId, (String)destTopic, (Long)0L));
        boolean found = ReplicatorSourceTask.shouldFilterRecord((ConsumerRecord)record, (String)destClusterId, (String)destTopic, filterOverrides);
        Assert.assertFalse((boolean)found);
    }

    @Test
    public void testTopicIdRegexFilterOverrideWithMatch() throws Exception {
        String overrides = "dc-2,topic-.*,0-1000";
        ArrayList filterOverrides = new ArrayList();
        ReplicatorSourceTask.parseFilterOverrides((String)overrides, filterOverrides);
        String sourceClusterId = "dc-1";
        String destClusterId = "dc-2";
        String sourceTopic = "topic-1";
        String destTopic = "topic-2";
        ConsumerRecord record = new ConsumerRecord(sourceTopic, 0, 0L, -1L, TimestampType.CREATE_TIME, 0L, 0, 0, (Object)new byte[0], (Object)new byte[0]);
        record.headers().add("__replicator_id", ReplicatorSourceTask.formatProvenanceHeader((String)destClusterId, (String)destTopic, (Long)0L));
        boolean found = ReplicatorSourceTask.shouldFilterRecord((ConsumerRecord)record, (String)destClusterId, (String)destTopic, filterOverrides);
        Assert.assertFalse((boolean)found);
    }

    @Test
    public void testFilterOverrideWithMultipleHeadersAndMatch() throws Exception {
        String overrides = "dc-2,topic-2,1000-2000";
        ArrayList filterOverrides = new ArrayList();
        ReplicatorSourceTask.parseFilterOverrides((String)overrides, filterOverrides);
        String sourceClusterId = "dc-1";
        String destClusterId = "dc-2";
        String sourceTopic = "topic-1";
        String destTopic = "topic-2";
        ConsumerRecord record = new ConsumerRecord(sourceTopic, 0, 0L, -1L, TimestampType.CREATE_TIME, 0L, 0, 0, (Object)new byte[0], (Object)new byte[0]);
        record.headers().add("__replicator_id", ReplicatorSourceTask.formatProvenanceHeader((String)sourceClusterId, (String)sourceTopic, (Long)0L));
        record.headers().add("__replicator_id", ReplicatorSourceTask.formatProvenanceHeader((String)destClusterId, (String)destTopic, (Long)1000L));
        boolean found = ReplicatorSourceTask.shouldFilterRecord((ConsumerRecord)record, (String)destClusterId, (String)destTopic, filterOverrides);
        Assert.assertFalse((boolean)found);
    }

    @Test
    public void testFilterOverrideWithMultipleHeadersAndNoMatch() throws Exception {
        String overrides = "dc-3,topic-3,2000-3000";
        ArrayList filterOverrides = new ArrayList();
        ReplicatorSourceTask.parseFilterOverrides((String)overrides, filterOverrides);
        String sourceClusterId = "dc-1";
        String destClusterId = "dc-2";
        String sourceTopic = "topic-1";
        String destTopic = "topic-2";
        ConsumerRecord record = new ConsumerRecord(sourceTopic, 0, 0L, -1L, TimestampType.CREATE_TIME, 0L, 0, 0, (Object)new byte[0], (Object)new byte[0]);
        record.headers().add("__replicator_id", ReplicatorSourceTask.formatProvenanceHeader((String)sourceClusterId, (String)sourceTopic, (Long)0L));
        record.headers().add("__replicator_id", ReplicatorSourceTask.formatProvenanceHeader((String)destClusterId, (String)destTopic, (Long)1000L));
        boolean found = ReplicatorSourceTask.shouldFilterRecord((ConsumerRecord)record, (String)destClusterId, (String)destTopic, filterOverrides);
        Assert.assertTrue((boolean)found);
    }

    @Test
    public void testNoCopyProvenanceHeader() throws Exception {
        String overrides = "dc-1,topic-1,0-1000";
        ArrayList filterOverrides = new ArrayList();
        ReplicatorSourceTask.parseFilterOverrides((String)overrides, filterOverrides);
        String sourceClusterId = "dc-1";
        String destClusterId = "dc-2";
        String sourceTopic = "topic-1";
        String destTopic = "topic-2";
        ConsumerRecord record = new ConsumerRecord(sourceTopic, 0, 0L, -1L, TimestampType.CREATE_TIME, 0L, 0, 0, (Object)new byte[0], (Object)new byte[0]);
        record.headers().add("__replicator_id", ReplicatorSourceTask.formatProvenanceHeader((String)sourceClusterId, (String)sourceTopic, (Long)0L));
        boolean found = ReplicatorSourceTask.shouldFilterRecord((ConsumerRecord)record, (String)destClusterId, (String)destTopic, filterOverrides);
        Assert.assertFalse((boolean)found);
        ConnectHeaders connectHeaders = ReplicatorSourceTask.toConnectHeaders((String)sourceClusterId, (String)sourceTopic, (ConsumerRecord)record, (HeaderConverter)new ByteArrayConverter(), (boolean)true);
        Assert.assertEquals((long)0L, (long)connectHeaders.size());
    }

    @Test
    public void testCopyProvenanceHeader() throws Exception {
        String overrides = "dc-1,topic-1,0-1000";
        ArrayList filterOverrides = new ArrayList();
        ReplicatorSourceTask.parseFilterOverrides((String)overrides, filterOverrides);
        String sourceClusterId = "dc-1";
        String destClusterId = "dc-2";
        String sourceTopic = "topic-1";
        String destTopic = "topic-2";
        ConsumerRecord record = new ConsumerRecord(sourceTopic, 0, 0L, -1L, TimestampType.CREATE_TIME, 0L, 0, 0, (Object)new byte[0], (Object)new byte[0]);
        record.headers().add("__replicator_id", ReplicatorSourceTask.formatProvenanceHeader((String)sourceClusterId, (String)sourceTopic, (Long)0L));
        boolean found = ReplicatorSourceTask.shouldFilterRecord((ConsumerRecord)record, (String)destClusterId, (String)destTopic, filterOverrides);
        Assert.assertFalse((boolean)found);
        ConnectHeaders connectHeaders = ReplicatorSourceTask.toConnectHeaders((String)sourceClusterId, (String)sourceTopic, (ConsumerRecord)record, (HeaderConverter)new ByteArrayConverter(), (boolean)false);
        Assert.assertEquals((long)1L, (long)connectHeaders.size());
    }
}

