/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.replicator;

import io.confluent.connect.replicator.KafkaConfigs;
import io.confluent.connect.replicator.ReplicatorSourceConnector;
import io.confluent.connect.replicator.ReplicatorSourceConnectorConfig;
import io.confluent.connect.replicator.ReplicatorSourceTaskConfig;
import io.confluent.connect.replicator.TopicMonitorThread;
import io.confluent.connect.replicator.util.TrialPeriod;
import io.confluent.license.LicenseManager;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kafka.utils.ZkUtils;
import org.I0Itec.zkclient.exception.ZkNodeExistsException;
import org.apache.kafka.clients.consumer.internals.PartitionAssignor;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.connect.errors.ConnectException;
import org.apache.zookeeper.data.Stat;
import org.easymock.EasyMock;
import org.easymock.EasyMockSupport;
import org.easymock.Mock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.Tuple2;

public class ReplicatorSourceConnectorTest
extends EasyMockSupport {
    @Mock
    private ReplicatorSourceConnectorConfig config;
    @Mock
    private TopicMonitorThread monitorThread;
    @Mock
    private LicenseManager licenseManager;

    @Before
    public void startup() {
        this.config = (ReplicatorSourceConnectorConfig)this.createMock(ReplicatorSourceConnectorConfig.class);
        this.monitorThread = (TopicMonitorThread)this.createMock(TopicMonitorThread.class);
        this.licenseManager = (LicenseManager)this.createMock(LicenseManager.class);
    }

    @Test
    public void testVersion() {
        String version = new ReplicatorSourceConnector(this.config, this.monitorThread, this.licenseManager).version();
        Assert.assertNotNull((Object)version);
        Assert.assertFalse((boolean)version.isEmpty());
    }

    @Test
    public void testTaskConfigs() {
        String topic = "topic";
        int maxTasks = 2;
        HashMap<String, String> configOriginals = new HashMap<String, String>();
        configOriginals.put(KafkaConfigs.KafkaCluster.SOURCE.prefix() + "bootstrap.servers", "foo:9092");
        configOriginals.put(KafkaConfigs.KafkaCluster.DESTINATION.prefix() + "bootstrap.servers", "bar:9092");
        configOriginals.put("topic.regex", ".*");
        EasyMock.expect((Object)this.config.originalsStrings()).andStubReturn(configOriginals);
        EasyMock.expect((Object)this.config.getOffsetTranslatorTasksMax()).andStubReturn((Object)-1);
        EasyMock.expect((Object)this.config.areOffsetTranslatorTasksSeparate()).andStubReturn((Object)false);
        HashMap<String, PartitionAssignor.Assignment> assignments = new HashMap<String, PartitionAssignor.Assignment>();
        List<TopicPartition> assignment1 = Collections.singletonList(new TopicPartition(topic, 0));
        List<TopicPartition> assignment2 = Collections.singletonList(new TopicPartition(topic, 1));
        assignments.put("task1", new PartitionAssignor.Assignment(assignment1));
        assignments.put("task2", new PartitionAssignor.Assignment(assignment2));
        EasyMock.expect((Object)this.monitorThread.assignments(maxTasks)).andReturn(assignments);
        this.replayAll();
        ReplicatorSourceConnector connector = new ReplicatorSourceConnector(this.config, this.monitorThread, this.licenseManager);
        List taskConfigs = connector.taskConfigs(maxTasks);
        Assert.assertEquals((long)2L, (long)taskConfigs.size());
        ReplicatorSourceTaskConfig config1 = new ReplicatorSourceTaskConfig((Map)taskConfigs.get(0));
        Assert.assertEquals(assignment1, (Object)config1.getPartitionAssignment().partitions());
        Assert.assertEquals((Object)"task1", (Object)config1.getTaskId());
        ReplicatorSourceTaskConfig config2 = new ReplicatorSourceTaskConfig((Map)taskConfigs.get(1));
        Assert.assertEquals(assignment2, (Object)config2.getPartitionAssignment().partitions());
        Assert.assertEquals((Object)"task2", (Object)config2.getTaskId());
        this.verifyAll();
    }

    @Test
    public void testConnectorStart() throws Exception {
        HashMap<String, String> configOriginals = new HashMap<String, String>();
        configOriginals.put(KafkaConfigs.KafkaCluster.SOURCE.prefix() + "bootstrap.servers", "foo:9092");
        configOriginals.put(KafkaConfigs.KafkaCluster.DESTINATION.prefix() + "bootstrap.servers", "bar:9092");
        configOriginals.put("topic.regex", ".*");
        configOriginals.put("confluent.topic", "_confluent_custom_topic");
        EasyMock.expect((Object)this.config.originalsStrings()).andStubReturn(configOriginals);
        EasyMock.expect((Object)this.config.getName()).andReturn((Object)"replicator");
        EasyMock.expect((Object)this.config.getString("confluent.topic")).andReturn((Object)"_confluent_custom_topic");
        EasyMock.expect((Object)this.config.getString(EasyMock.anyString())).andReturn((Object)"").times(2);
        EasyMock.expect((Object)this.config.originalsWithPrefix(EasyMock.anyString())).andReturn(new HashMap());
        EasyMock.expect((Object)this.config.originalsWithPrefix(EasyMock.anyString())).andReturn(new HashMap());
        EasyMock.expect((Object)this.config.originalsWithPrefix(EasyMock.anyString())).andReturn(new HashMap());
        EasyMock.expect((Object)this.config.originalsWithPrefix(EasyMock.anyString())).andReturn(new HashMap());
        EasyMock.expect((Object)this.licenseManager.registerOrValidateLicense(EasyMock.anyString())).andReturn(null);
        EasyMock.expect((Object)this.config.getString(EasyMock.anyString())).andReturn(null);
        this.monitorThread.start();
        EasyMock.expectLastCall();
        this.replayAll();
        ReplicatorSourceConnector connector = new ReplicatorSourceConnector(this.config, this.monitorThread, this.licenseManager);
        connector.start(configOriginals);
        this.verifyAll();
    }

    @Test(expected=ConnectException.class)
    public void testConnectorStartWithSourceZk() {
        HashMap<String, String> configOriginals = new HashMap<String, String>();
        configOriginals.put(KafkaConfigs.KafkaCluster.SOURCE.prefix() + "bootstrap.servers", "foo:9092");
        configOriginals.put(KafkaConfigs.KafkaCluster.DESTINATION.prefix() + "bootstrap.servers", "bar:9092");
        configOriginals.put("topic.regex", ".*");
        EasyMock.expect((Object)this.config.originalsStrings()).andStubReturn(configOriginals);
        EasyMock.expect((Object)this.config.getName()).andReturn((Object)"replicator");
        EasyMock.expect((Object)this.config.getString(EasyMock.anyString())).andReturn((Object)"");
        EasyMock.expect((Object)this.config.getString(EasyMock.anyString())).andReturn((Object)"foo:2181");
        EasyMock.expect((Object)this.config.isTrial()).andReturn((Object)true);
        ZkUtils zkUtils = (ZkUtils)this.createMock(ZkUtils.class);
        EasyMock.expect((Object)this.config.buildDestZkUtils()).andReturn((Object)zkUtils);
        zkUtils.close();
        EasyMock.expectLastCall();
        EasyMock.expect((Object)zkUtils.defaultAcls("/confluent-replicator")).andReturn(null);
        zkUtils.createPersistentPath(EasyMock.anyString(), EasyMock.anyString(), (List)EasyMock.anyObject(List.class));
        EasyMock.expectLastCall().andThrow((Throwable)new ZkNodeExistsException());
        Tuple2 zkTuple = (Tuple2)this.createMock(Tuple2.class);
        EasyMock.expect((Object)zkUtils.readData(EasyMock.anyString())).andReturn((Object)zkTuple);
        Stat zkStat = (Stat)this.createMock(Stat.class);
        EasyMock.expect((Object)zkTuple._2()).andReturn((Object)zkStat);
        EasyMock.expect((Object)zkStat.getCtime()).andReturn((Object)(System.currentTimeMillis() - (TrialPeriod.TRIAL_LIMIT_MILLIS + 1000000L)));
        this.replayAll();
        ReplicatorSourceConnector connector = new ReplicatorSourceConnector(this.config, this.monitorThread, this.licenseManager);
        connector.start(configOriginals);
        this.verifyAll();
    }

    @Test
    public void testConnectorStop() {
        HashMap<String, String> configOriginals = new HashMap<String, String>();
        configOriginals.put(KafkaConfigs.KafkaCluster.SOURCE.prefix() + "bootstrap.servers", "foo:9092");
        configOriginals.put(KafkaConfigs.KafkaCluster.DESTINATION.prefix() + "bootstrap.servers", "bar:9092");
        configOriginals.put("topic.regex", ".*");
        EasyMock.expect((Object)this.config.originalsStrings()).andStubReturn(configOriginals);
        this.licenseManager.stop();
        EasyMock.expectLastCall();
        EasyMock.expect((Object)this.config.getName()).andReturn((Object)"replicator");
        this.monitorThread.shutdown();
        EasyMock.expectLastCall();
        this.replayAll();
        ReplicatorSourceConnector connector = new ReplicatorSourceConnector(this.config, this.monitorThread, this.licenseManager);
        connector.stop();
        this.verifyAll();
    }
}

