/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.replicator;

import io.confluent.connect.replicator.ReplicatorSourceConnectorConfig;
import io.confluent.connect.replicator.ReplicatorSourceTaskConfig;
import io.confluent.connect.replicator.util.ByteArrayConverter;
import io.confluent.connect.replicator.util.Utils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.clients.consumer.internals.PartitionAssignor;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaAndValue;
import org.apache.kafka.connect.json.JsonConverter;
import org.apache.kafka.connect.storage.Converter;
import org.apache.kafka.connect.storage.HeaderConverter;
import org.apache.kafka.connect.storage.StringConverter;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ReplicatorSourceConnectorConfigTest {
    private Map<String, String> props;

    @Before
    public void createDefaults() {
        this.props = new HashMap<String, String>();
        this.props.put("src.kafka.bootstrap.servers", "foo:9092");
        this.props.put("dest.kafka.bootstrap.servers", "bar:9092");
    }

    private Map<String, String> configure(String key, String value) {
        this.props.put(key, value);
        return this.props;
    }

    @Test
    public void testCollectConsumerConfigs() {
        ReplicatorSourceConnectorConfig config = new ReplicatorSourceConnectorConfig(this.configure("src.consumer.max.poll.records", "200"));
        Map consumerConfigs = config.getSourceConsumerConfigs();
        Assert.assertEquals((Object)"200", consumerConfigs.get("max.poll.records"));
    }

    @Test
    public void testDefaultTopicRenameFormat() {
        ReplicatorSourceConnectorConfig config = new ReplicatorSourceConnectorConfig(this.props);
        Assert.assertEquals((Object)"foo", (Object)Utils.renameTopic((String)config.getTopicRenameFormat(), (String)"foo"));
    }

    @Test
    public void testDefaultTimestampType() {
        ReplicatorSourceConnectorConfig config = new ReplicatorSourceConnectorConfig(this.props);
        Assert.assertEquals((Object)TimestampType.CREATE_TIME.toString(), (Object)config.getTopicTimestampType());
    }

    @Test(expected=ConfigException.class)
    public void testInvalidLicense() {
        this.configure("confluent.license", "magic");
        new ReplicatorSourceConnectorConfig(this.props);
    }

    @Test
    public void testConfluentTopic() {
        ReplicatorSourceConnectorConfig config = new ReplicatorSourceConnectorConfig(this.props);
        Assert.assertEquals((Object)"_confluent-command", (Object)config.getString("confluent.topic"));
        String customTopic = "_confluent-config-topic";
        this.configure("confluent.topic", customTopic);
        config = new ReplicatorSourceConnectorConfig(this.props);
        Assert.assertEquals((Object)customTopic, (Object)config.getString("confluent.topic"));
    }

    @Test(expected=ConfigException.class)
    public void testStarTopicReqex() {
        this.configure("topic.regex", "*");
        new ReplicatorSourceConnectorConfig(this.props);
    }

    @Test(expected=ConfigException.class)
    public void testInvalidReqex() {
        this.configure("topic.regex", "[1-9.*");
        new ReplicatorSourceConnectorConfig(this.props);
    }

    @Test
    public void testValidReqex() {
        ReplicatorSourceConnectorConfig config = new ReplicatorSourceConnectorConfig(this.configure("topic.regex", "[1-9].*"));
        Assert.assertEquals((Object)"[1-9].*", (Object)config.getString("topic.regex"));
    }

    @Test(expected=ConfigException.class)
    public void testInvalidFilterOverride() {
        ReplicatorSourceConnectorConfig config = new ReplicatorSourceConnectorConfig(this.configure("provenance.header.filter.overrides", "dc-1"));
    }

    @Test
    public void testValidFilterOverride() {
        ReplicatorSourceConnectorConfig config = new ReplicatorSourceConnectorConfig(this.configure("provenance.header.filter.overrides", "dc-1,topic-1,0-1000"));
        Assert.assertEquals((Object)"dc-1,topic-1,0-1000", (Object)config.getString("provenance.header.filter.overrides"));
    }

    @Test
    public void testValidFilterOverrides() {
        ReplicatorSourceConnectorConfig config = new ReplicatorSourceConnectorConfig(this.configure("provenance.header.filter.overrides", "dc-1,topic-1,0-1000;dc-2,topic-2,1000-2000"));
        Assert.assertEquals((Object)"dc-1,topic-1,0-1000;dc-2,topic-2,1000-2000", (Object)config.getString("provenance.header.filter.overrides"));
    }

    @Test
    public void testWithOldZKConfigs() {
        this.configure("src.zookeeper.connect", "foo:2181");
        this.configure("dest.zookeeper.connect", "bar:2181");
        this.props.remove("dest.kafka.bootstrap.servers");
        ReplicatorSourceConnectorConfig config = new ReplicatorSourceConnectorConfig(this.props);
        Assert.assertEquals((Object)"foo:2181", (Object)config.getString("src.zookeeper.connect"));
        Assert.assertEquals((Object)"bar:2181", (Object)config.getString("dest.zookeeper.connect"));
    }

    @Test
    public void testDefaultHeaderConverterProperty() {
        ReplicatorSourceTaskConfig config = ReplicatorSourceTaskConfig.builder((ReplicatorSourceConnectorConfig)new ReplicatorSourceConnectorConfig(this.props)).setTaskId("1").setAssignment(new PartitionAssignor.Assignment(Collections.emptyList())).build();
        Assert.assertTrue((boolean)(config.getSourceHeaderConverter() instanceof ByteArrayConverter));
    }

    @Test
    public void testUsingJsonConverterForKeyAndValue() {
        this.configure("src.key.converter", JsonConverter.class.getName());
        this.configure("src.key.converter.schemas.enable", "false");
        this.configure("src.value.converter", JsonConverter.class.getName());
        this.configure("src.value.converter.schemas.enable", "true");
        ReplicatorSourceTaskConfig config = ReplicatorSourceTaskConfig.builder((ReplicatorSourceConnectorConfig)new ReplicatorSourceConnectorConfig(this.props)).setTaskId("1").setAssignment(new PartitionAssignor.Assignment(Collections.emptyList())).build();
        Assert.assertTrue((boolean)(config.getSourceKeyConverter() instanceof JsonConverter));
        Assert.assertTrue((boolean)(config.getSourceValueConverter() instanceof JsonConverter));
    }

    @Test
    public void testUsinStringConverterForKeyAndValue() {
        this.configure("src.key.converter", StringConverter.class.getName());
        this.configure("src.value.converter", StringConverter.class.getName());
        ReplicatorSourceTaskConfig config = ReplicatorSourceTaskConfig.builder((ReplicatorSourceConnectorConfig)new ReplicatorSourceConnectorConfig(this.props)).setTaskId("1").setAssignment(new PartitionAssignor.Assignment(Collections.emptyList())).build();
        Assert.assertTrue((boolean)(config.getSourceKeyConverter() instanceof StringConverter));
        Assert.assertTrue((boolean)(config.getSourceValueConverter() instanceof StringConverter));
    }

    @Test
    public void testUsingNonDefaultByteArrayConverterForKeyAndValue() {
        this.configure("src.key.converter", ByteArrayConverter.class.getName());
        this.configure("src.value.converter", ByteArrayConverter.class.getName());
        ReplicatorSourceTaskConfig config = ReplicatorSourceTaskConfig.builder((ReplicatorSourceConnectorConfig)new ReplicatorSourceConnectorConfig(this.props)).setTaskId("1").setAssignment(new PartitionAssignor.Assignment(Collections.emptyList())).build();
        Assert.assertTrue((boolean)(config.getSourceKeyConverter() instanceof ByteArrayConverter));
        Assert.assertTrue((boolean)(config.getSourceValueConverter() instanceof ByteArrayConverter));
    }

    @Test(expected=KafkaException.class)
    public void testBadHeaderConverterProperty() {
        ReplicatorSourceTaskConfig config = ReplicatorSourceTaskConfig.builder((ReplicatorSourceConnectorConfig)new ReplicatorSourceConnectorConfig(this.configure("src.header.converter", "java.lang.String"))).setTaskId("1").setAssignment(new PartitionAssignor.Assignment(new ArrayList())).build();
        config.getSourceHeaderConverter();
    }

    @Test
    public void testConverterConfigureShouldBeCalled() {
        this.props.put("src.key.converter", TestConverter.class.getName());
        this.props.put("src.key.converter.test", "true");
        this.props.put("src.value.converter", TestConverter.class.getName());
        this.props.put("src.value.converter.test", "false");
        this.props.put("src.header.converter", TestHeaderConverter.class.getName());
        this.props.put("src.header.converter.test", "true");
        ReplicatorSourceConnectorConfig config = new ReplicatorSourceConnectorConfig(this.props);
        Assert.assertTrue((boolean)(config.getSourceKeyConverter() instanceof TestConverter));
        Assert.assertTrue((boolean)(config.getSourceValueConverter() instanceof TestConverter));
        Assert.assertTrue((boolean)(config.getSourceHeaderConverter() instanceof TestHeaderConverter));
        TestConverter keyConverter = (TestConverter)config.getSourceKeyConverter();
        TestConverter valueConverter = (TestConverter)config.getSourceValueConverter();
        TestHeaderConverter headerConverter = (TestHeaderConverter)config.getSourceHeaderConverter();
        Assert.assertTrue((boolean)keyConverter.configureCalled);
        Assert.assertTrue((boolean)valueConverter.configureCalled);
        Assert.assertTrue((boolean)headerConverter.configureCalled);
        Assert.assertTrue((boolean)keyConverter.isKey);
        Assert.assertFalse((boolean)valueConverter.isKey);
        Assert.assertNotNull(keyConverter.settings);
        Assert.assertFalse((boolean)keyConverter.settings.isEmpty());
        Assert.assertNotNull(valueConverter.settings);
        Assert.assertFalse((boolean)valueConverter.settings.isEmpty());
        Assert.assertNotNull(headerConverter.settings);
        Assert.assertFalse((boolean)headerConverter.settings.isEmpty());
        Assert.assertEquals((Object)"true", keyConverter.settings.get("test"));
        Assert.assertEquals((Object)"false", valueConverter.settings.get("test"));
        Assert.assertEquals((Object)"true", headerConverter.settings.get("test"));
    }

    public static class TestHeaderConverter
    implements HeaderConverter {
        boolean configureCalled;
        Map<String, ?> settings;

        public void configure(Map<String, ?> map) {
            this.settings = map;
            this.configureCalled = true;
        }

        public SchemaAndValue toConnectHeader(String s, String s1, byte[] bytes) {
            return null;
        }

        public byte[] fromConnectHeader(String s, String s1, Schema schema, Object o) {
            return new byte[0];
        }

        public ConfigDef config() {
            return new ConfigDef();
        }

        public void close() throws IOException {
        }
    }

    public static class TestConverter
    implements Converter {
        boolean isKey;
        boolean configureCalled;
        Map<String, ?> settings;

        public void configure(Map<String, ?> map, boolean b) {
            this.settings = map;
            this.configureCalled = true;
            this.isKey = b;
        }

        public byte[] fromConnectData(String s, Schema schema, Object o) {
            return new byte[0];
        }

        public SchemaAndValue toConnectData(String s, byte[] bytes) {
            return null;
        }
    }
}

