/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.ImmutableMap;
import io.confluent.connect.json.JsonSchemaConverter;
import io.confluent.connect.json.ResourceLoader;
import io.confluent.kafka.schemaregistry.ParsedSchema;
import io.confluent.kafka.schemaregistry.client.MockSchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.rest.exceptions.RestClientException;
import io.confluent.kafka.schemaregistry.json.JsonSchema;
import io.confluent.kafka.schemaregistry.json.JsonSchemaUtils;
import io.confluent.kafka.serializers.json.KafkaJsonSchemaSerializer;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaAndValue;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class JsonSchemaConverterTest {
    private final ResourceLoader loader = ResourceLoader.DEFAULT;
    private static final String TOPIC = "topic";
    private static final Map<String, ?> SR_CONFIG = Collections.singletonMap("schema.registry.url", "localhost");
    private final SchemaRegistryClient schemaRegistry = new MockSchemaRegistryClient();
    private final JsonSchemaConverter converter = new JsonSchemaConverter(this.schemaRegistry);

    @Before
    public void setUp() {
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("schema.registry.url", "http://fake-url");
        this.converter.configure(config, false);
    }

    @Test
    public void testPrimitive() {
        SchemaAndValue original = new SchemaAndValue(Schema.BOOLEAN_SCHEMA, (Object)true);
        byte[] converted = this.converter.fromConnectData(TOPIC, original.schema(), original.value());
        SchemaAndValue schemaAndValue = this.converter.toConnectData(TOPIC, converted);
        SchemaAndValue expected = new SchemaAndValue(SchemaBuilder.bool().version(Integer.valueOf(1)).build(), (Object)true);
        Assert.assertEquals((Object)expected, (Object)schemaAndValue);
    }

    @Test
    public void testComplex() {
        SchemaBuilder builder = SchemaBuilder.struct().field("int8", Schema.INT8_SCHEMA).field("int16", Schema.INT16_SCHEMA).field("int32", Schema.INT32_SCHEMA).field("int64", Schema.INT64_SCHEMA).field("float32", Schema.FLOAT32_SCHEMA).field("float64", Schema.FLOAT64_SCHEMA).field("boolean", Schema.BOOLEAN_SCHEMA).field("string", Schema.STRING_SCHEMA).field("bytes", Schema.BYTES_SCHEMA).field("array", SchemaBuilder.array((Schema)Schema.STRING_SCHEMA).build()).field("map", SchemaBuilder.map((Schema)Schema.STRING_SCHEMA, (Schema)Schema.INT32_SCHEMA).build());
        Schema schema = builder.build();
        Struct original = new Struct(schema).put("int8", (Object)12).put("int16", (Object)12).put("int32", (Object)12).put("int64", (Object)12L).put("float32", (Object)Float.valueOf(12.2f)).put("float64", (Object)12.2).put("boolean", (Object)true).put("string", (Object)"foo").put("bytes", (Object)"foo".getBytes()).put("array", Arrays.asList("a", "b", "c")).put("map", Collections.singletonMap("field", 1));
        Schema expectedSchema = builder.version(Integer.valueOf(1)).build();
        Struct expected = new Struct(expectedSchema).put("int8", (Object)12).put("int16", (Object)12).put("int32", (Object)12).put("int64", (Object)12L).put("float32", (Object)Float.valueOf(12.2f)).put("float64", (Object)12.2).put("boolean", (Object)true).put("string", (Object)"foo").put("bytes", (Object)"foo".getBytes()).put("array", Arrays.asList("a", "b", "c")).put("map", Collections.singletonMap("field", 1));
        byte[] converted = this.converter.fromConnectData(TOPIC, original.schema(), (Object)original);
        SchemaAndValue schemaAndValue = this.converter.toConnectData(TOPIC, converted);
        Assert.assertEquals((Object)expected, (Object)schemaAndValue.value());
    }

    @Test
    public void testNull() {
        byte[] converted = this.converter.fromConnectData(TOPIC, Schema.OPTIONAL_BOOLEAN_SCHEMA, null);
        SchemaAndValue schemaAndValue = this.converter.toConnectData(TOPIC, converted);
        Assert.assertEquals((Object)new SchemaAndValue(SchemaBuilder.bool().version(Integer.valueOf(1)).optional().build(), null), (Object)schemaAndValue);
    }

    @Test
    public void testVersionExtractedForDefaultSubjectNameStrategy() throws Exception {
        String subject = "topic-value";
        KafkaJsonSchemaSerializer serializer = new KafkaJsonSchemaSerializer(this.schemaRegistry, (Map)ImmutableMap.of((Object)"schema.registry.url", (Object)"http://fake-url"));
        JsonSchemaConverter jsonConverter = new JsonSchemaConverter(this.schemaRegistry);
        jsonConverter.configure(Collections.singletonMap("schema.registry.url", "http://fake-url"), false);
        this.testVersionExtracted(subject, serializer, jsonConverter);
    }

    private void testVersionExtracted(String subject, KafkaJsonSchemaSerializer serializer, JsonSchemaConverter jsonConverter) throws IOException, RestClientException {
        JsonNode rawSchemaJson1 = this.loader.readJsonNode("key.json");
        JsonNode rawSchemaJson2 = this.loader.readJsonNode("keyvalue.json");
        this.schemaRegistry.register(subject, (ParsedSchema)new JsonSchema(rawSchemaJson1));
        this.schemaRegistry.register(subject, (ParsedSchema)new JsonSchema(rawSchemaJson2));
        ObjectMapper mapper = new ObjectMapper();
        ObjectNode objectNode1 = mapper.createObjectNode();
        objectNode1.put("key", 15);
        ObjectNode objectNode2 = mapper.createObjectNode();
        objectNode2.put("key", 15);
        objectNode2.put("value", "bar");
        byte[] serializedRecord1 = serializer.serialize(TOPIC, (Object)JsonSchemaUtils.envelope((JsonNode)rawSchemaJson1, (JsonNode)objectNode1));
        byte[] serializedRecord2 = serializer.serialize(TOPIC, (Object)JsonSchemaUtils.envelope((JsonNode)rawSchemaJson2, (JsonNode)objectNode2));
        SchemaAndValue converted1 = jsonConverter.toConnectData(TOPIC, serializedRecord1);
        Assert.assertEquals((long)1L, (long)converted1.schema().version().intValue());
        SchemaAndValue converted2 = jsonConverter.toConnectData(TOPIC, serializedRecord2);
        Assert.assertEquals((long)2L, (long)converted2.schema().version().intValue());
    }

    @Test
    public void testVersionMaintained() {
        Schema newerSchema = SchemaBuilder.struct().version(Integer.valueOf(2)).field("orig", Schema.OPTIONAL_INT16_SCHEMA).field("new", Schema.OPTIONAL_INT16_SCHEMA).build();
        SchemaAndValue newer = new SchemaAndValue(newerSchema, (Object)new Struct(newerSchema).put("orig", (Object)1).put("new", (Object)2));
        byte[] newerSerialized = this.converter.fromConnectData(TOPIC, newer.schema(), newer.value());
        Schema olderSchema = SchemaBuilder.struct().version(Integer.valueOf(1)).field("orig", Schema.OPTIONAL_INT16_SCHEMA).build();
        SchemaAndValue older = new SchemaAndValue(olderSchema, (Object)new Struct(olderSchema).put("orig", (Object)1));
        byte[] olderSerialized = this.converter.fromConnectData(TOPIC, older.schema(), older.value());
        Assert.assertEquals((long)2L, (long)this.converter.toConnectData(TOPIC, newerSerialized).schema().version().intValue());
        Assert.assertEquals((long)1L, (long)this.converter.toConnectData(TOPIC, olderSerialized).schema().version().intValue());
    }

    @Test
    public void testSameSchemaMultipleTopicForValue() throws IOException, RestClientException {
        MockSchemaRegistryClient schemaRegistry = new MockSchemaRegistryClient();
        JsonSchemaConverter jsonConverter = new JsonSchemaConverter((SchemaRegistryClient)schemaRegistry);
        jsonConverter.configure(SR_CONFIG, false);
        this.assertSameSchemaMultipleTopic(jsonConverter, (SchemaRegistryClient)schemaRegistry, false);
    }

    @Test
    public void testSameSchemaMultipleTopicForKey() throws IOException, RestClientException {
        MockSchemaRegistryClient schemaRegistry = new MockSchemaRegistryClient();
        JsonSchemaConverter jsonConverter = new JsonSchemaConverter((SchemaRegistryClient)schemaRegistry);
        jsonConverter.configure(SR_CONFIG, true);
        this.assertSameSchemaMultipleTopic(jsonConverter, (SchemaRegistryClient)schemaRegistry, true);
    }

    @Test
    public void testExplicitlyNamedNestedMapsWithNonStringKeys() {
        Schema schema = SchemaBuilder.map((Schema)Schema.OPTIONAL_STRING_SCHEMA, (Schema)SchemaBuilder.map((Schema)Schema.OPTIONAL_STRING_SCHEMA, (Schema)Schema.OPTIONAL_INT32_SCHEMA).name("foo.bar").build()).name("biz.baz").version(Integer.valueOf(1)).build();
        JsonSchemaConverter jsonConverter = new JsonSchemaConverter((SchemaRegistryClient)new MockSchemaRegistryClient());
        jsonConverter.configure(Collections.singletonMap("schema.registry.url", "localhost"), false);
        Map<String, Map<String, Integer>> value = Collections.singletonMap("foo", Collections.singletonMap("bar", 1));
        byte[] bytes = jsonConverter.fromConnectData(TOPIC, schema, value);
        SchemaAndValue schemaAndValue = jsonConverter.toConnectData(TOPIC, bytes);
        Assert.assertEquals((Object)schemaAndValue.schema(), (Object)schema);
        Assert.assertEquals((Object)schemaAndValue.value(), value);
    }

    private void assertSameSchemaMultipleTopic(JsonSchemaConverter converter, SchemaRegistryClient schemaRegistry, boolean isKey) throws IOException, RestClientException {
        JsonNode rawSchemaJson1 = this.loader.readJsonNode("key.json");
        JsonNode rawSchemaJson2_1 = this.loader.readJsonNode("keyvalue.json");
        JsonNode rawSchemaJson2_2 = this.loader.readJsonNode("keyvalue.json");
        String subjectSuffix = isKey ? "key" : "value";
        schemaRegistry.register("topic1-" + subjectSuffix, (ParsedSchema)new JsonSchema(rawSchemaJson2_1));
        schemaRegistry.register("topic2-" + subjectSuffix, (ParsedSchema)new JsonSchema(rawSchemaJson1));
        schemaRegistry.register("topic2-" + subjectSuffix, (ParsedSchema)new JsonSchema(rawSchemaJson2_2));
        ObjectMapper mapper = new ObjectMapper();
        ObjectNode objectNode1 = mapper.createObjectNode();
        objectNode1.put("key", 15);
        objectNode1.put("value", "bar");
        ObjectNode objectNode2 = mapper.createObjectNode();
        objectNode2.put("key", 15);
        objectNode2.put("value", "bar");
        KafkaJsonSchemaSerializer serializer = new KafkaJsonSchemaSerializer(schemaRegistry, (Map)ImmutableMap.of((Object)"schema.registry.url", (Object)"http://fake-url"));
        byte[] serializedRecord1 = serializer.serialize("topic1", (Object)JsonSchemaUtils.envelope((JsonNode)rawSchemaJson2_1, (JsonNode)objectNode1));
        byte[] serializedRecord2 = serializer.serialize("topic2", (Object)JsonSchemaUtils.envelope((JsonNode)rawSchemaJson2_2, (JsonNode)objectNode2));
        SchemaAndValue converted1 = converter.toConnectData("topic1", serializedRecord1);
        Assert.assertEquals((long)1L, (long)converted1.schema().version().intValue());
        SchemaAndValue converted2 = converter.toConnectData("topic2", serializedRecord2);
        Assert.assertEquals((long)2L, (long)converted2.schema().version().intValue());
        converted2 = converter.toConnectData("topic2", serializedRecord2);
        Assert.assertEquals((long)2L, (long)converted2.schema().version().intValue());
    }
}

