/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.BinaryNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.DecimalNode;
import com.fasterxml.jackson.databind.node.DoubleNode;
import com.fasterxml.jackson.databind.node.FloatNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.LongNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.ShortNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.confluent.connect.json.JsonSchemaData;
import io.confluent.connect.json.JsonSchemaDataConfig;
import io.confluent.kafka.schemaregistry.json.JsonSchema;
import io.confluent.kafka.schemaregistry.json.jackson.Jackson;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.kafka.connect.data.ConnectSchema;
import org.apache.kafka.connect.data.Decimal;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.errors.DataException;
import org.apache.kafka.connect.json.DecimalFormat;
import org.everit.json.schema.ArraySchema;
import org.everit.json.schema.BooleanSchema;
import org.everit.json.schema.CombinedSchema;
import org.everit.json.schema.EnumSchema;
import org.everit.json.schema.NullSchema;
import org.everit.json.schema.NumberSchema;
import org.everit.json.schema.ObjectSchema;
import org.everit.json.schema.Schema;
import org.everit.json.schema.StringSchema;
import org.junit.Assert;
import org.junit.Test;

public class JsonSchemaDataTest {
    private static final org.apache.kafka.connect.data.Schema NAMED_MAP_SCHEMA = SchemaBuilder.map((org.apache.kafka.connect.data.Schema)org.apache.kafka.connect.data.Schema.STRING_SCHEMA, (org.apache.kafka.connect.data.Schema)org.apache.kafka.connect.data.Schema.INT32_SCHEMA).name("foo.bar").build();
    private static final Schema NAMED_JSON_MAP_SCHEMA = ObjectSchema.builder().schemaOfAdditionalProperties(NumberSchema.builder().requiresInteger(true).unprocessedProperties(Collections.singletonMap("connect.type", "int32")).build()).unprocessedProperties(Collections.singletonMap("connect.type", "map")).title("foo.bar").build();
    private JsonSchemaData jsonSchemaData = new JsonSchemaData();

    @Test
    public void testFromConnectNull() throws Exception {
        BooleanSchema booleanSchema = BooleanSchema.builder().build();
        CombinedSchema expectedSchema = CombinedSchema.oneOf((Collection)ImmutableList.of((Object)NullSchema.INSTANCE, (Object)booleanSchema)).build();
        org.apache.kafka.connect.data.Schema schema = org.apache.kafka.connect.data.Schema.OPTIONAL_BOOLEAN_SCHEMA;
        this.checkNonObjectConversion((Schema)expectedSchema, (Object)NullNode.getInstance(), schema, null);
        this.checkNonObjectConversion(null, null, (org.apache.kafka.connect.data.Schema)null, null);
    }

    @Test
    public void testFromConnectBoolean() {
        BooleanSchema schema = BooleanSchema.builder().build();
        this.checkNonObjectConversion((Schema)schema, (Object)BooleanNode.getTrue(), org.apache.kafka.connect.data.Schema.BOOLEAN_SCHEMA, true);
    }

    @Test
    public void testFromConnectByte() {
        NumberSchema schema = (NumberSchema)NumberSchema.builder().requiresInteger(true).unprocessedProperties(Collections.singletonMap("connect.type", "int8")).build();
        this.checkNonObjectConversion((Schema)schema, (Object)ShortNode.valueOf((short)12), org.apache.kafka.connect.data.Schema.INT8_SCHEMA, (byte)12);
    }

    @Test
    public void testFromConnectShort() {
        NumberSchema schema = (NumberSchema)NumberSchema.builder().requiresInteger(true).unprocessedProperties(Collections.singletonMap("connect.type", "int16")).build();
        this.checkNonObjectConversion((Schema)schema, (Object)ShortNode.valueOf((short)12), org.apache.kafka.connect.data.Schema.INT16_SCHEMA, (short)12);
    }

    @Test
    public void testFromConnectInteger() {
        NumberSchema schema = (NumberSchema)NumberSchema.builder().requiresInteger(true).unprocessedProperties(Collections.singletonMap("connect.type", "int32")).build();
        this.checkNonObjectConversion((Schema)schema, (Object)IntNode.valueOf((int)12), org.apache.kafka.connect.data.Schema.INT32_SCHEMA, 12);
    }

    @Test
    public void testFromConnectLong() {
        NumberSchema schema = (NumberSchema)NumberSchema.builder().requiresInteger(true).unprocessedProperties(Collections.singletonMap("connect.type", "int64")).build();
        this.checkNonObjectConversion((Schema)schema, (Object)LongNode.valueOf((long)12L), org.apache.kafka.connect.data.Schema.INT64_SCHEMA, 12L);
    }

    @Test
    public void testFromConnectFloat() {
        NumberSchema schema = (NumberSchema)NumberSchema.builder().unprocessedProperties(Collections.singletonMap("connect.type", "float32")).build();
        this.checkNonObjectConversion((Schema)schema, (Object)FloatNode.valueOf((float)12.2f), org.apache.kafka.connect.data.Schema.FLOAT32_SCHEMA, Float.valueOf(12.2f));
    }

    @Test
    public void testFromConnectDouble() {
        NumberSchema schema = (NumberSchema)NumberSchema.builder().unprocessedProperties(Collections.singletonMap("connect.type", "float64")).build();
        this.checkNonObjectConversion((Schema)schema, (Object)DoubleNode.valueOf((double)12.2), org.apache.kafka.connect.data.Schema.FLOAT64_SCHEMA, 12.2);
    }

    @Test
    public void testFromConnectBytes() throws Exception {
        StringSchema schema = (StringSchema)StringSchema.builder().unprocessedProperties(Collections.singletonMap("connect.type", "bytes")).build();
        this.checkNonObjectConversion((Schema)schema, (Object)BinaryNode.valueOf((byte[])"foo".getBytes()), org.apache.kafka.connect.data.Schema.BYTES_SCHEMA, "foo".getBytes());
    }

    @Test
    public void testFromConnectString() {
        StringSchema schema = StringSchema.builder().build();
        this.checkNonObjectConversion((Schema)schema, (Object)TextNode.valueOf((String)"string"), org.apache.kafka.connect.data.Schema.STRING_SCHEMA, "string");
    }

    @Test
    public void testFromConnectEnum() {
        EnumSchema schema = EnumSchema.builder().possibleValue((Object)"one").possibleValue((Object)"two").possibleValue((Object)"three").build();
        org.apache.kafka.connect.data.Schema connectSchema = new SchemaBuilder(Schema.Type.STRING).parameter("io.confluent.connect.json.Enum", "").parameter("io.confluent.connect.json.Enum.one", "one").parameter("io.confluent.connect.json.Enum.two", "two").parameter("io.confluent.connect.json.Enum.three", "three").build();
        this.checkNonObjectConversion((Schema)schema, (Object)TextNode.valueOf((String)"one"), connectSchema, "one");
    }

    @Test
    public void testFromConnectUnion() {
        NumberSchema firstSchema = (NumberSchema)NumberSchema.builder().requiresInteger(true).unprocessedProperties((Map)ImmutableMap.of((Object)"connect.type", (Object)"int8", (Object)"connect.index", (Object)0)).build();
        NumberSchema secondSchema = (NumberSchema)NumberSchema.builder().requiresInteger(true).unprocessedProperties((Map)ImmutableMap.of((Object)"connect.type", (Object)"int16", (Object)"connect.index", (Object)1)).build();
        CombinedSchema schema = CombinedSchema.oneOf((Collection)ImmutableList.of((Object)firstSchema, (Object)secondSchema)).build();
        SchemaBuilder builder = SchemaBuilder.struct().name("io.confluent.connect.json.OneOf");
        builder.field("io.confluent.connect.json.OneOf.field.0", org.apache.kafka.connect.data.Schema.INT8_SCHEMA);
        builder.field("io.confluent.connect.json.OneOf.field.1", org.apache.kafka.connect.data.Schema.INT16_SCHEMA);
        org.apache.kafka.connect.data.Schema connectSchema = builder.build();
        Struct actual = new Struct(connectSchema).put("io.confluent.connect.json.OneOf.field.0", (Object)12);
        this.checkNonObjectConversion((Schema)schema, (Object)ShortNode.valueOf((short)12), connectSchema, actual);
    }

    @Test
    public void testFromConnectUnionDifferentStruct() {
        NumberSchema numberSchema = (NumberSchema)NumberSchema.builder().requiresInteger(true).unprocessedProperties((Map)ImmutableMap.of((Object)"connect.index", (Object)0, (Object)"connect.type", (Object)"int8")).build();
        StringSchema stringSchema = (StringSchema)StringSchema.builder().unprocessedProperties((Map)ImmutableMap.of((Object)"connect.index", (Object)1)).build();
        ObjectSchema firstSchema = (ObjectSchema)ObjectSchema.builder().addPropertySchema("a", (Schema)numberSchema).addPropertySchema("b", (Schema)stringSchema).title("field0").unprocessedProperties((Map)ImmutableMap.of((Object)"connect.index", (Object)0)).build();
        ObjectSchema secondSchema = (ObjectSchema)ObjectSchema.builder().addPropertySchema("c", (Schema)numberSchema).addPropertySchema("d", (Schema)stringSchema).title("field1").unprocessedProperties((Map)ImmutableMap.of((Object)"connect.index", (Object)1)).build();
        CombinedSchema schema = CombinedSchema.oneOf((Collection)ImmutableList.of((Object)firstSchema, (Object)secondSchema)).build();
        org.apache.kafka.connect.data.Schema field0 = SchemaBuilder.struct().name("field0").field("a", org.apache.kafka.connect.data.Schema.INT8_SCHEMA).field("b", org.apache.kafka.connect.data.Schema.STRING_SCHEMA).optional().build();
        org.apache.kafka.connect.data.Schema field1 = SchemaBuilder.struct().name("field1").field("c", org.apache.kafka.connect.data.Schema.INT8_SCHEMA).field("d", org.apache.kafka.connect.data.Schema.STRING_SCHEMA).optional().build();
        SchemaBuilder builder = SchemaBuilder.struct().name("io.confluent.connect.json.OneOf");
        builder.field("io.confluent.connect.json.OneOf.field.0", field0);
        builder.field("io.confluent.connect.json.OneOf.field.1", field1);
        org.apache.kafka.connect.data.Schema connectSchema = builder.build();
        ObjectNode obj = JsonNodeFactory.instance.objectNode();
        obj.set("a", (JsonNode)ShortNode.valueOf((short)12));
        obj.set("b", (JsonNode)TextNode.valueOf((String)"sample string"));
        Struct struct = new Struct(field0).put("a", (Object)12).put("b", (Object)"sample string");
        Struct actual = new Struct(connectSchema).put("io.confluent.connect.json.OneOf.field.0", (Object)struct);
        this.checkNonObjectConversion((Schema)schema, (Object)obj, connectSchema, actual);
        obj = JsonNodeFactory.instance.objectNode();
        obj.set("c", (JsonNode)ShortNode.valueOf((short)12));
        obj.set("d", (JsonNode)TextNode.valueOf((String)"sample string"));
        struct = new Struct(field1).put("c", (Object)12).put("d", (Object)"sample string");
        actual = new Struct(connectSchema).put("io.confluent.connect.json.OneOf.field.1", (Object)struct);
        this.checkNonObjectConversion((Schema)schema, (Object)obj, connectSchema, actual);
    }

    @Test
    public void testFromConnectBase64Decimal() {
        this.jsonSchemaData = new JsonSchemaData(new JsonSchemaDataConfig(Collections.singletonMap("decimal.format", DecimalFormat.BASE64.name())));
        NumberSchema schema = (NumberSchema)NumberSchema.builder().title("org.apache.kafka.connect.data.Decimal").unprocessedProperties((Map)ImmutableMap.of((Object)"connect.type", (Object)"bytes", (Object)"connect.version", (Object)1, (Object)"connect.parameters", (Object)ImmutableMap.of((Object)"scale", (Object)"2"))).build();
        this.checkNonObjectConversion((Schema)schema, (Object)BinaryNode.valueOf((byte[])new byte[]{0, -100}), Decimal.schema((int)2), new BigDecimal(new BigInteger("156"), 2));
        this.jsonSchemaData = new JsonSchemaData();
    }

    @Test
    public void testFromConnectNumericDecimal() {
        this.jsonSchemaData = new JsonSchemaData(new JsonSchemaDataConfig(Collections.singletonMap("decimal.format", DecimalFormat.NUMERIC.name())));
        NumberSchema schema = (NumberSchema)NumberSchema.builder().title("org.apache.kafka.connect.data.Decimal").unprocessedProperties((Map)ImmutableMap.of((Object)"connect.type", (Object)"bytes", (Object)"connect.version", (Object)1, (Object)"connect.parameters", (Object)ImmutableMap.of((Object)"scale", (Object)"2"))).build();
        this.checkNonObjectConversion((Schema)schema, (Object)DecimalNode.valueOf((BigDecimal)new BigDecimal("1.56")), Decimal.schema((int)2), new BigDecimal(new BigInteger("156"), 2));
        this.jsonSchemaData = new JsonSchemaData();
    }

    @Test
    public void testFromConnectNumericDecimalWithTrailingZeros() {
        this.jsonSchemaData = new JsonSchemaData(new JsonSchemaDataConfig(Collections.singletonMap("decimal.format", DecimalFormat.NUMERIC.name())));
        NumberSchema schema = (NumberSchema)NumberSchema.builder().title("org.apache.kafka.connect.data.Decimal").unprocessedProperties((Map)ImmutableMap.of((Object)"connect.type", (Object)"bytes", (Object)"connect.version", (Object)1, (Object)"connect.parameters", (Object)ImmutableMap.of((Object)"scale", (Object)"4"))).build();
        this.checkNonObjectConversion((Schema)schema, (Object)DecimalNode.valueOf((BigDecimal)new BigDecimal("1.5600")), Decimal.schema((int)4), new BigDecimal(new BigInteger("15600"), 4));
        this.jsonSchemaData = new JsonSchemaData();
    }

    @Test
    public void testFromConnectMapWithStringKey() {
        SchemaBuilder connectSchema = SchemaBuilder.map((org.apache.kafka.connect.data.Schema)org.apache.kafka.connect.data.Schema.STRING_SCHEMA, (org.apache.kafka.connect.data.Schema)org.apache.kafka.connect.data.Schema.INT32_SCHEMA);
        NumberSchema numberSchema = (NumberSchema)NumberSchema.builder().requiresInteger(true).unprocessedProperties(Collections.singletonMap("connect.type", "int32")).build();
        ObjectSchema expected = (ObjectSchema)ObjectSchema.builder().schemaOfAdditionalProperties((Schema)numberSchema).unprocessedProperties(Collections.singletonMap("connect.type", "map")).build();
        ObjectNode obj = JsonNodeFactory.instance.objectNode();
        obj.set("hi", (JsonNode)IntNode.valueOf((int)32));
        this.checkNonObjectConversion((Schema)expected, (Object)obj, (org.apache.kafka.connect.data.Schema)connectSchema, Collections.singletonMap("hi", 32));
    }

    @Test
    public void testFromConnectMapWithOptionalKey() {
        SchemaBuilder connectSchema = SchemaBuilder.map((org.apache.kafka.connect.data.Schema)org.apache.kafka.connect.data.Schema.OPTIONAL_STRING_SCHEMA, (org.apache.kafka.connect.data.Schema)org.apache.kafka.connect.data.Schema.INT32_SCHEMA);
        StringSchema stringSchema = StringSchema.builder().build();
        CombinedSchema keySchema = (CombinedSchema)CombinedSchema.oneOf((Collection)ImmutableList.of((Object)NullSchema.INSTANCE, (Object)stringSchema)).unprocessedProperties((Map)ImmutableMap.of((Object)"connect.index", (Object)0)).build();
        NumberSchema valueSchema = (NumberSchema)NumberSchema.builder().requiresInteger(true).unprocessedProperties((Map)ImmutableMap.of((Object)"connect.index", (Object)1, (Object)"connect.type", (Object)"int32")).build();
        ObjectSchema entrySchema = ObjectSchema.builder().addPropertySchema("key", (Schema)keySchema).addPropertySchema("value", (Schema)valueSchema).build();
        ArraySchema expected = (ArraySchema)ArraySchema.builder().allItemSchema((Schema)entrySchema).unprocessedProperties(Collections.singletonMap("connect.type", "map")).build();
        ObjectNode entry = JsonNodeFactory.instance.objectNode();
        entry.set("key", (JsonNode)TextNode.valueOf((String)"hi"));
        entry.set("value", (JsonNode)IntNode.valueOf((int)32));
        ArrayNode array = JsonNodeFactory.instance.arrayNode().add((JsonNode)entry);
        this.checkNonObjectConversion((Schema)expected, (Object)array, (org.apache.kafka.connect.data.Schema)connectSchema, Collections.singletonMap("hi", 32));
    }

    @Test
    public void testFromConnectMapWithNonStringKey() {
        SchemaBuilder connectSchema = SchemaBuilder.map((org.apache.kafka.connect.data.Schema)org.apache.kafka.connect.data.Schema.INT32_SCHEMA, (org.apache.kafka.connect.data.Schema)org.apache.kafka.connect.data.Schema.INT32_SCHEMA);
        NumberSchema keySchema = (NumberSchema)NumberSchema.builder().requiresInteger(true).unprocessedProperties((Map)ImmutableMap.of((Object)"connect.index", (Object)0, (Object)"connect.type", (Object)"int32")).build();
        NumberSchema valueSchema = (NumberSchema)NumberSchema.builder().requiresInteger(true).unprocessedProperties((Map)ImmutableMap.of((Object)"connect.index", (Object)1, (Object)"connect.type", (Object)"int32")).build();
        ObjectSchema entrySchema = ObjectSchema.builder().addPropertySchema("key", (Schema)keySchema).addPropertySchema("value", (Schema)valueSchema).build();
        ArraySchema expected = (ArraySchema)ArraySchema.builder().allItemSchema((Schema)entrySchema).unprocessedProperties(Collections.singletonMap("connect.type", "map")).build();
        ObjectNode entry = JsonNodeFactory.instance.objectNode();
        entry.set("key", (JsonNode)IntNode.valueOf((int)54));
        entry.set("value", (JsonNode)IntNode.valueOf((int)32));
        ArrayNode array = JsonNodeFactory.instance.arrayNode().add((JsonNode)entry);
        this.checkNonObjectConversion((Schema)expected, (Object)array, (org.apache.kafka.connect.data.Schema)connectSchema, Collections.singletonMap(54, 32));
    }

    @Test
    public void testFromNamedConnectMap() {
        Assert.assertEquals((Object)this.jsonSchemaData.fromConnectSchema(NAMED_MAP_SCHEMA).rawSchema(), (Object)NAMED_JSON_MAP_SCHEMA);
    }

    @Test
    public void testFromConnectRecordWithMissingNonoptional() {
        NumberSchema numberSchema = (NumberSchema)NumberSchema.builder().requiresInteger(true).unprocessedProperties((Map)ImmutableMap.of((Object)"connect.index", (Object)0, (Object)"connect.type", (Object)"int8")).build();
        StringSchema stringSchema = (StringSchema)StringSchema.builder().unprocessedProperties((Map)ImmutableMap.of((Object)"connect.index", (Object)1)).build();
        ObjectSchema schema = (ObjectSchema)ObjectSchema.builder().addPropertySchema("int8", (Schema)numberSchema).addPropertySchema("string", (Schema)stringSchema).title("Record").build();
        ObjectNode obj = JsonNodeFactory.instance.objectNode();
        obj.set("int8", (JsonNode)ShortNode.valueOf((short)12));
        org.apache.kafka.connect.data.Schema actualSchema = SchemaBuilder.struct().name("Record").field("int8", org.apache.kafka.connect.data.Schema.INT8_SCHEMA).field("string", org.apache.kafka.connect.data.Schema.STRING_SCHEMA).build();
        Struct struct = new Struct(actualSchema).put("int8", (Object)12);
        this.checkNonObjectConversion((Schema)schema, (Object)obj, actualSchema, struct);
    }

    private void checkNonObjectConversion(Schema expectedSchema, Object expected, org.apache.kafka.connect.data.Schema schema, Object value) {
        JsonSchema jsonSchema = this.jsonSchemaData.fromConnectSchema(schema);
        JsonNode jsonValue = this.jsonSchemaData.fromConnectData(schema, value);
        Assert.assertEquals((Object)expectedSchema, (Object)(jsonSchema != null ? jsonSchema.rawSchema() : null));
        Assert.assertEquals((Object)expected, (Object)jsonValue);
    }

    @Test
    public void testToConnectNull() {
        BooleanSchema booleanSchema = BooleanSchema.builder().build();
        CombinedSchema schema = CombinedSchema.oneOf((Collection)ImmutableList.of((Object)NullSchema.INSTANCE, (Object)booleanSchema)).build();
        org.apache.kafka.connect.data.Schema expectedSchema = org.apache.kafka.connect.data.Schema.OPTIONAL_BOOLEAN_SCHEMA;
        this.checkNonObjectConversion(expectedSchema, null, (Schema)schema, null);
        this.checkNonObjectConversion((org.apache.kafka.connect.data.Schema)null, null, null, null);
    }

    @Test
    public void testToConnectBoolean() {
        BooleanSchema schema = BooleanSchema.builder().build();
        org.apache.kafka.connect.data.Schema expectedSchema = org.apache.kafka.connect.data.Schema.BOOLEAN_SCHEMA;
        this.checkNonObjectConversion(expectedSchema, (Object)true, (Schema)schema, (JsonNode)BooleanNode.getTrue());
    }

    @Test
    public void testToConnectInt8() {
        NumberSchema schema = (NumberSchema)NumberSchema.builder().requiresInteger(true).unprocessedProperties(Collections.singletonMap("connect.type", "int8")).build();
        org.apache.kafka.connect.data.Schema expectedSchema = org.apache.kafka.connect.data.Schema.INT8_SCHEMA;
        this.checkNonObjectConversion(expectedSchema, (Object)12, (Schema)schema, (JsonNode)ShortNode.valueOf((short)12));
    }

    @Test
    public void testToConnectInt8WithDefault() {
        NumberSchema schema = (NumberSchema)NumberSchema.builder().requiresInteger(true).unprocessedProperties(Collections.singletonMap("connect.type", "int8")).defaultValue((Object)34).build();
        org.apache.kafka.connect.data.Schema expectedSchema = SchemaBuilder.int8().defaultValue((Object)34).build();
        this.checkNonObjectConversion(expectedSchema, (Object)12, (Schema)schema, (JsonNode)ShortNode.valueOf((short)12));
    }

    @Test
    public void testToConnectInt8WithDefaultConversion() {
        NumberSchema schema = (NumberSchema)NumberSchema.builder().requiresInteger(true).unprocessedProperties(Collections.singletonMap("connect.type", "int8")).defaultValue((Object)34).build();
        org.apache.kafka.connect.data.Schema expectedSchema = SchemaBuilder.int8().defaultValue((Object)34).build();
        this.checkNonObjectConversion(expectedSchema, (Object)12, (Schema)schema, (JsonNode)IntNode.valueOf((int)12));
    }

    @Test
    public void testToConnectInt16() {
        NumberSchema schema = (NumberSchema)NumberSchema.builder().requiresInteger(true).unprocessedProperties(Collections.singletonMap("connect.type", "int16")).build();
        org.apache.kafka.connect.data.Schema expectedSchema = org.apache.kafka.connect.data.Schema.INT16_SCHEMA;
        this.checkNonObjectConversion(expectedSchema, (Object)12, (Schema)schema, (JsonNode)ShortNode.valueOf((short)12));
    }

    @Test
    public void testToConnectInt32() {
        NumberSchema schema = (NumberSchema)NumberSchema.builder().requiresInteger(true).unprocessedProperties(Collections.singletonMap("connect.type", "int32")).build();
        org.apache.kafka.connect.data.Schema expectedSchema = org.apache.kafka.connect.data.Schema.INT32_SCHEMA;
        this.checkNonObjectConversion(expectedSchema, (Object)12, (Schema)schema, (JsonNode)IntNode.valueOf((int)12));
    }

    @Test
    public void testToConnectInt64() {
        NumberSchema schema = (NumberSchema)NumberSchema.builder().requiresInteger(true).unprocessedProperties(Collections.singletonMap("connect.type", "int64")).build();
        org.apache.kafka.connect.data.Schema expectedSchema = org.apache.kafka.connect.data.Schema.INT64_SCHEMA;
        this.checkNonObjectConversion(expectedSchema, (Object)12L, (Schema)schema, (JsonNode)LongNode.valueOf((long)12L));
    }

    @Test
    public void testToConnectFloat32() {
        NumberSchema schema = (NumberSchema)NumberSchema.builder().unprocessedProperties(Collections.singletonMap("connect.type", "float32")).build();
        org.apache.kafka.connect.data.Schema expectedSchema = org.apache.kafka.connect.data.Schema.FLOAT32_SCHEMA;
        this.checkNonObjectConversion(expectedSchema, (Object)Float.valueOf(12.0f), (Schema)schema, (JsonNode)FloatNode.valueOf((float)12.0f));
    }

    @Test
    public void testToConnectFloat64() {
        NumberSchema schema = (NumberSchema)NumberSchema.builder().unprocessedProperties(Collections.singletonMap("connect.type", "float64")).build();
        org.apache.kafka.connect.data.Schema expectedSchema = org.apache.kafka.connect.data.Schema.FLOAT64_SCHEMA;
        this.checkNonObjectConversion(expectedSchema, (Object)12.0, (Schema)schema, (JsonNode)DoubleNode.valueOf((double)12.0));
    }

    @Test
    public void testToConnectNullableStringNullvalue() {
        CombinedSchema schema = CombinedSchema.builder().criterion(CombinedSchema.ONE_CRITERION).subschema((Schema)NullSchema.INSTANCE).subschema((Schema)StringSchema.builder().build()).build();
        org.apache.kafka.connect.data.Schema expectedSchema = org.apache.kafka.connect.data.Schema.OPTIONAL_STRING_SCHEMA;
        this.checkNonObjectConversion(expectedSchema, null, (Schema)schema, (JsonNode)NullNode.getInstance());
    }

    @Test
    public void testToConnectNullableString() {
        CombinedSchema schema = CombinedSchema.builder().criterion(CombinedSchema.ONE_CRITERION).subschema((Schema)NullSchema.INSTANCE).subschema((Schema)StringSchema.builder().build()).build();
        org.apache.kafka.connect.data.Schema expectedSchema = org.apache.kafka.connect.data.Schema.OPTIONAL_STRING_SCHEMA;
        this.checkNonObjectConversion(expectedSchema, (Object)"teststring", (Schema)schema, (JsonNode)TextNode.valueOf((String)"teststring"));
    }

    @Test
    public void testToConnectString() {
        StringSchema schema = StringSchema.builder().build();
        org.apache.kafka.connect.data.Schema expectedSchema = org.apache.kafka.connect.data.Schema.STRING_SCHEMA;
        this.checkNonObjectConversion(expectedSchema, (Object)"teststring", (Schema)schema, (JsonNode)TextNode.valueOf((String)"teststring"));
    }

    @Test
    public void testToConnectBytes() {
        StringSchema schema = (StringSchema)StringSchema.builder().unprocessedProperties(Collections.singletonMap("connect.type", "bytes")).build();
        org.apache.kafka.connect.data.Schema expectedSchema = org.apache.kafka.connect.data.Schema.BYTES_SCHEMA;
        this.checkNonObjectConversion(expectedSchema, (Object)"teststring".getBytes(), (Schema)schema, (JsonNode)BinaryNode.valueOf((byte[])"teststring".getBytes()));
    }

    @Test
    public void testToConnectArray() {
        NumberSchema numberSchema = (NumberSchema)NumberSchema.builder().requiresInteger(true).unprocessedProperties(Collections.singletonMap("connect.type", "int8")).build();
        ArraySchema schema = ArraySchema.builder().allItemSchema((Schema)numberSchema).build();
        org.apache.kafka.connect.data.Schema expectedSchema = SchemaBuilder.array((org.apache.kafka.connect.data.Schema)org.apache.kafka.connect.data.Schema.INT8_SCHEMA).build();
        ArrayNode array = JsonNodeFactory.instance.arrayNode();
        array.add(12).add(13);
        this.checkNonObjectConversion(expectedSchema, Arrays.asList((byte)12, (byte)13), (Schema)schema, (JsonNode)array);
    }

    @Test
    public void testToConnectMapStringKeys() {
        NumberSchema numberSchema = (NumberSchema)NumberSchema.builder().requiresInteger(true).unprocessedProperties(Collections.singletonMap("connect.type", "int8")).build();
        ObjectSchema schema = (ObjectSchema)ObjectSchema.builder().schemaOfAdditionalProperties((Schema)numberSchema).unprocessedProperties(Collections.singletonMap("connect.type", "map")).build();
        org.apache.kafka.connect.data.Schema expectedSchema = SchemaBuilder.map((org.apache.kafka.connect.data.Schema)org.apache.kafka.connect.data.Schema.STRING_SCHEMA, (org.apache.kafka.connect.data.Schema)org.apache.kafka.connect.data.Schema.INT8_SCHEMA).build();
        ObjectNode map = JsonNodeFactory.instance.objectNode();
        map.set("field", (JsonNode)IntNode.valueOf((int)12));
        this.checkNonObjectConversion(expectedSchema, Collections.singletonMap("field", (byte)12), (Schema)schema, (JsonNode)map);
    }

    @Test
    public void testToConnectMapNonStringKeys() {
        NumberSchema keySchema = (NumberSchema)NumberSchema.builder().requiresInteger(true).unprocessedProperties(Collections.singletonMap("connect.type", "int8")).build();
        NumberSchema valueSchema = (NumberSchema)NumberSchema.builder().requiresInteger(true).unprocessedProperties(Collections.singletonMap("connect.type", "int16")).build();
        ObjectSchema mapSchema = ObjectSchema.builder().addPropertySchema("key", (Schema)keySchema).addPropertySchema("value", (Schema)valueSchema).build();
        ArraySchema schema = (ArraySchema)ArraySchema.builder().allItemSchema((Schema)mapSchema).unprocessedProperties(Collections.singletonMap("connect.type", "map")).build();
        org.apache.kafka.connect.data.Schema expectedSchema = SchemaBuilder.map((org.apache.kafka.connect.data.Schema)org.apache.kafka.connect.data.Schema.INT8_SCHEMA, (org.apache.kafka.connect.data.Schema)org.apache.kafka.connect.data.Schema.INT16_SCHEMA).build();
        ObjectNode map = JsonNodeFactory.instance.objectNode();
        map.set("key", (JsonNode)IntNode.valueOf((int)12));
        map.set("value", (JsonNode)ShortNode.valueOf((short)16));
        ArrayNode array = JsonNodeFactory.instance.arrayNode();
        array.add((JsonNode)map);
        this.checkNonObjectConversion(expectedSchema, Collections.singletonMap((byte)12, (short)16), (Schema)schema, (JsonNode)array);
    }

    @Test
    public void testToConnectRecord() {
        NumberSchema numberSchema = (NumberSchema)NumberSchema.builder().requiresInteger(true).unprocessedProperties((Map)ImmutableMap.of((Object)"connect.index", (Object)0, (Object)"connect.type", (Object)"int8")).build();
        StringSchema stringSchema = (StringSchema)StringSchema.builder().unprocessedProperties((Map)ImmutableMap.of((Object)"connect.index", (Object)1)).build();
        ObjectSchema schema = (ObjectSchema)ObjectSchema.builder().addPropertySchema("int8", (Schema)numberSchema).addPropertySchema("string", (Schema)stringSchema).title("Record").build();
        ObjectNode obj = JsonNodeFactory.instance.objectNode();
        obj.set("int8", (JsonNode)ShortNode.valueOf((short)12));
        obj.set("string", (JsonNode)TextNode.valueOf((String)"sample string"));
        org.apache.kafka.connect.data.Schema expectedSchema = SchemaBuilder.struct().name("Record").field("int8", org.apache.kafka.connect.data.Schema.INT8_SCHEMA).field("string", org.apache.kafka.connect.data.Schema.STRING_SCHEMA).build();
        Struct struct = new Struct(expectedSchema).put("int8", (Object)12).put("string", (Object)"sample string");
        this.checkNonObjectConversion(expectedSchema, (Object)struct, (Schema)schema, (JsonNode)obj);
    }

    @Test
    public void testToConnectRecordWithOptionalValue() {
        this.testToConnectRecordWithOptional("sample string");
    }

    @Test
    public void testToConnectRecordWithOptionalNullValue() {
        this.testToConnectRecordWithOptional(null);
    }

    private void testToConnectRecordWithOptional(String value) {
        NumberSchema numberSchema = (NumberSchema)NumberSchema.builder().requiresInteger(true).unprocessedProperties((Map)ImmutableMap.of((Object)"connect.index", (Object)0, (Object)"connect.type", (Object)"int8")).build();
        StringSchema stringSchema = StringSchema.builder().build();
        CombinedSchema combinedSchema = (CombinedSchema)CombinedSchema.oneOf((Collection)ImmutableList.of((Object)NullSchema.INSTANCE, (Object)stringSchema)).unprocessedProperties((Map)ImmutableMap.of((Object)"connect.index", (Object)1)).build();
        ObjectSchema schema = (ObjectSchema)ObjectSchema.builder().addPropertySchema("int8", (Schema)numberSchema).addPropertySchema("string", (Schema)combinedSchema).title("Record").build();
        ObjectNode obj = JsonNodeFactory.instance.objectNode();
        obj.set("int8", (JsonNode)ShortNode.valueOf((short)12));
        if (value == null) {
            obj.set("string", (JsonNode)NullNode.getInstance());
        } else {
            obj.set("string", (JsonNode)TextNode.valueOf((String)value));
        }
        org.apache.kafka.connect.data.Schema expectedSchema = SchemaBuilder.struct().name("Record").field("int8", org.apache.kafka.connect.data.Schema.INT8_SCHEMA).field("string", org.apache.kafka.connect.data.Schema.OPTIONAL_STRING_SCHEMA).build();
        Struct struct = new Struct(expectedSchema).put("int8", (Object)12).put("string", (Object)value);
        this.checkNonObjectConversion(expectedSchema, (Object)struct, (Schema)schema, (JsonNode)obj);
    }

    @Test
    public void testToConnectRecordWithNoAdditionalProperties() {
        NumberSchema numberSchema = (NumberSchema)NumberSchema.builder().requiresInteger(true).unprocessedProperties((Map)ImmutableMap.of((Object)"connect.index", (Object)0, (Object)"connect.type", (Object)"int8")).build();
        StringSchema stringSchema = (StringSchema)StringSchema.builder().unprocessedProperties((Map)ImmutableMap.of((Object)"connect.index", (Object)1)).build();
        ObjectSchema schema = (ObjectSchema)ObjectSchema.builder().addPropertySchema("int8", (Schema)numberSchema).addPropertySchema("string", (Schema)stringSchema).additionalProperties(false).title("Record").build();
        ObjectNode obj = JsonNodeFactory.instance.objectNode();
        obj.set("int8", (JsonNode)ShortNode.valueOf((short)12));
        org.apache.kafka.connect.data.Schema expectedSchema = SchemaBuilder.struct().name("Record").field("int8", org.apache.kafka.connect.data.Schema.INT8_SCHEMA).field("string", org.apache.kafka.connect.data.Schema.STRING_SCHEMA).build();
        Struct struct = new Struct(expectedSchema).put("int8", (Object)12);
        JsonSchemaDataConfig jsonSchemaDataConfig = new JsonSchemaDataConfig.Builder().with("object.additional.properties", (Object)false).build();
        JsonSchemaData jsonSchemaData = new JsonSchemaData(jsonSchemaDataConfig);
        this.checkNonObjectConversion(jsonSchemaData, expectedSchema, struct, (Schema)schema, (JsonNode)obj);
    }

    @Test
    public void testToConnectRecordWithOptionalAndRequired() {
        NumberSchema numberSchema = (NumberSchema)NumberSchema.builder().requiresInteger(true).unprocessedProperties((Map)ImmutableMap.of((Object)"connect.index", (Object)0, (Object)"connect.type", (Object)"int8")).build();
        StringSchema stringSchema = (StringSchema)StringSchema.builder().unprocessedProperties((Map)ImmutableMap.of((Object)"connect.index", (Object)1)).build();
        ObjectSchema schema = (ObjectSchema)ObjectSchema.builder().addPropertySchema("int8", (Schema)numberSchema).addPropertySchema("string", (Schema)stringSchema).addRequiredProperty("int8").title("Record").build();
        ObjectNode obj = JsonNodeFactory.instance.objectNode();
        obj.set("int8", (JsonNode)ShortNode.valueOf((short)12));
        org.apache.kafka.connect.data.Schema expectedSchema = SchemaBuilder.struct().name("Record").field("int8", org.apache.kafka.connect.data.Schema.INT8_SCHEMA).field("string", org.apache.kafka.connect.data.Schema.OPTIONAL_STRING_SCHEMA).build();
        Struct struct = new Struct(expectedSchema).put("int8", (Object)12);
        JsonSchemaDataConfig jsonSchemaDataConfig = new JsonSchemaDataConfig.Builder().with("use.optional.for.nonrequired", (Object)true).build();
        JsonSchemaData jsonSchemaData = new JsonSchemaData(jsonSchemaDataConfig);
        this.checkNonObjectConversion(jsonSchemaData, expectedSchema, struct, (Schema)schema, (JsonNode)obj);
    }

    @Test
    public void testToConnectRecordWithOptionalReference() throws Exception {
        String schemaString = "{\n  \"$schema\": \"http://json-schema.org/draft-04/schema#\",\n  \"title\": \"Event\",\n  \"type\": \"object\",\n  \"properties\": {\n    \"vehicle\": {\n      \"$ref\": \"#/definitions/VehicleDto\"\n    }\n  },\n  \"definitions\": {\n    \"PriceDto\": {\n      \"type\": \"object\",\n      \"required\": [\n        \"amount\"\n      ],\n      \"properties\": {\n        \"amount\": {\n          \"type\": \"number\",\n          \"format\": \"decimal\"\n        }\n      }\n    },\n    \"VehicleDto\": {\n      \"type\": \"object\",\n      \"required\": [\n        \"offerPrice\",\n        \"firstRegistrationDate\"\n      ],\n      \"properties\": {\n        \"offerPrice\": {\n          \"connect.index\": 1,\n          \"$ref\": \"#/definitions/PriceDto\"\n        },\n        \"catalogPrice\": {\n          \"connect.index\": 2,\n          \"oneOf\": [\n            {\n              \"type\": \"null\"\n            },\n            {\n              \"$ref\": \"#/definitions/PriceDto\"\n            }\n          ]\n        },\n        \"firstRegistrationDate\": {\n          \"connect.index\": 3,\n          \"type\": \"string\",\n          \"format\": \"date-time\"\n        }\n      }\n    }\n  }\n}\n";
        JsonSchema jsonSchema = new JsonSchema(schemaString);
        ObjectSchema schema = (ObjectSchema)jsonSchema.rawSchema();
        String json = "{\"vehicle\":{\"offerPrice\":{\"amount\":20000},\"firstRegistrationDate\":\"2020-08-19T12:05:15.953Z\"}}";
        ObjectNode obj = (ObjectNode)Jackson.newObjectMapper().readTree(json);
        JsonSchemaDataConfig jsonSchemaDataConfig = new JsonSchemaDataConfig.Builder().with("use.optional.for.nonrequired", (Object)true).build();
        JsonSchemaData jsonSchemaData = new JsonSchemaData(jsonSchemaDataConfig);
        org.apache.kafka.connect.data.Schema connectSchema = jsonSchemaData.toConnectSchema((Schema)schema);
        Struct connectStruct = (Struct)JsonSchemaData.toConnectData((org.apache.kafka.connect.data.Schema)connectSchema, (JsonNode)obj);
        org.apache.kafka.connect.data.Schema vehicleSchema = connectSchema.field("vehicle").schema();
        org.apache.kafka.connect.data.Schema offerPriceSchema = vehicleSchema.field("offerPrice").schema();
        org.apache.kafka.connect.data.Schema catalogPriceSchema = vehicleSchema.field("catalogPrice").schema();
        Assert.assertFalse((boolean)offerPriceSchema.isOptional());
        Assert.assertTrue((boolean)catalogPriceSchema.isOptional());
        Struct vehicleStruct = (Struct)connectStruct.get("vehicle");
        Struct offerPriceStruct = (Struct)vehicleStruct.get("offerPrice");
        Struct catalogPriceStruct = (Struct)vehicleStruct.get("catalogPrice");
        Assert.assertNotNull((Object)offerPriceStruct);
        Assert.assertNull((Object)catalogPriceStruct);
    }

    @Test
    public void testToConnectRecordWithMissingNonoptional() {
        NumberSchema numberSchema = (NumberSchema)NumberSchema.builder().requiresInteger(true).unprocessedProperties((Map)ImmutableMap.of((Object)"connect.index", (Object)0, (Object)"connect.type", (Object)"int8")).build();
        StringSchema stringSchema = (StringSchema)StringSchema.builder().unprocessedProperties((Map)ImmutableMap.of((Object)"connect.index", (Object)1)).build();
        ObjectSchema schema = (ObjectSchema)ObjectSchema.builder().addPropertySchema("int8", (Schema)numberSchema).addPropertySchema("string", (Schema)stringSchema).title("Record").build();
        ObjectNode obj = JsonNodeFactory.instance.objectNode();
        obj.set("int8", (JsonNode)ShortNode.valueOf((short)12));
        org.apache.kafka.connect.data.Schema expectedSchema = SchemaBuilder.struct().name("Record").field("int8", org.apache.kafka.connect.data.Schema.INT8_SCHEMA).field("string", org.apache.kafka.connect.data.Schema.STRING_SCHEMA).build();
        Struct struct = new Struct(expectedSchema).put("int8", (Object)12);
        this.checkNonObjectConversion(expectedSchema, (Object)struct, (Schema)schema, (JsonNode)obj);
    }

    @Test
    public void testToConnectRecordWithOptionalArrayValue() {
        this.testToConnectRecordWithOptionalArray(Arrays.asList("test"));
    }

    @Test
    public void testToConnectRecordWithOptionalArrayNullValue() {
        this.testToConnectRecordWithOptionalArray(null);
    }

    private void testToConnectRecordWithOptionalArray(List<String> value) {
        StringSchema stringSchema = StringSchema.builder().build();
        CombinedSchema combinedSchema1 = (CombinedSchema)CombinedSchema.oneOf((Collection)ImmutableList.of((Object)NullSchema.INSTANCE, (Object)stringSchema)).unprocessedProperties((Map)ImmutableMap.of((Object)"connect.index", (Object)0)).build();
        ArraySchema arraySchema = ArraySchema.builder().allItemSchema((Schema)stringSchema).build();
        CombinedSchema combinedSchema2 = (CombinedSchema)CombinedSchema.oneOf((Collection)ImmutableList.of((Object)NullSchema.INSTANCE, (Object)arraySchema)).unprocessedProperties((Map)ImmutableMap.of((Object)"connect.index", (Object)1)).build();
        ObjectSchema schema = (ObjectSchema)ObjectSchema.builder().addPropertySchema("string", (Schema)combinedSchema1).addPropertySchema("array", (Schema)combinedSchema2).title("Record").build();
        ObjectNode obj = JsonNodeFactory.instance.objectNode();
        obj.set("string", (JsonNode)TextNode.valueOf((String)"xx"));
        if (value == null) {
            obj.set("array", (JsonNode)NullNode.getInstance());
        } else {
            ArrayNode arrayNode = JsonNodeFactory.instance.arrayNode();
            for (String s : value) {
                arrayNode.add(s);
            }
            obj.set("array", (JsonNode)arrayNode);
        }
        org.apache.kafka.connect.data.Schema expectedSchema = SchemaBuilder.struct().name("Record").field("string", org.apache.kafka.connect.data.Schema.OPTIONAL_STRING_SCHEMA).field("array", SchemaBuilder.array((org.apache.kafka.connect.data.Schema)org.apache.kafka.connect.data.Schema.STRING_SCHEMA).optional().build()).build();
        Struct struct = new Struct(expectedSchema).put("string", (Object)"xx").put("array", value);
        this.checkNonObjectConversion(expectedSchema, (Object)struct, (Schema)schema, (JsonNode)obj);
    }

    @Test
    public void testToConnectNestedRecordWithOptionalRecordValue() {
        ObjectSchema nested = (ObjectSchema)ObjectSchema.builder().addPropertySchema("string", StringSchema.builder().unprocessedProperties((Map)ImmutableMap.of((Object)"connect.index", (Object)0)).build()).title("nestedRecord").build();
        CombinedSchema combinedSchema = (CombinedSchema)CombinedSchema.oneOf((Collection)ImmutableList.of((Object)NullSchema.INSTANCE, (Object)nested)).unprocessedProperties((Map)ImmutableMap.of((Object)"connect.index", (Object)0)).build();
        ObjectSchema schema = (ObjectSchema)ObjectSchema.builder().addPropertySchema("nestedRecord", (Schema)combinedSchema).title("Record").build();
        org.apache.kafka.connect.data.Schema expectedSchema = this.nestedRecordSchema();
        ObjectNode nestedObj = JsonNodeFactory.instance.objectNode();
        nestedObj.set("string", (JsonNode)TextNode.valueOf((String)"xx"));
        ObjectNode obj = JsonNodeFactory.instance.objectNode();
        obj.set("nestedRecord", (JsonNode)nestedObj);
        Struct struct = new Struct(expectedSchema).put("nestedRecord", (Object)new Struct(this.recordWithStringSchema()).put("string", (Object)"xx"));
        this.checkNonObjectConversion(expectedSchema, (Object)struct, (Schema)schema, (JsonNode)obj);
    }

    @Test
    public void testToConnectNestedRecordWithOptionalRecordNullValue() {
        ObjectSchema nested = (ObjectSchema)ObjectSchema.builder().addPropertySchema("string", StringSchema.builder().unprocessedProperties((Map)ImmutableMap.of((Object)"connect.index", (Object)0)).build()).title("nestedRecord").build();
        CombinedSchema combinedSchema = (CombinedSchema)CombinedSchema.oneOf((Collection)ImmutableList.of((Object)NullSchema.INSTANCE, (Object)nested)).unprocessedProperties((Map)ImmutableMap.of((Object)"connect.index", (Object)0)).build();
        ObjectSchema schema = (ObjectSchema)ObjectSchema.builder().addPropertySchema("nestedRecord", (Schema)combinedSchema).title("Record").build();
        org.apache.kafka.connect.data.Schema expectedSchema = this.nestedRecordSchema();
        ObjectNode obj = JsonNodeFactory.instance.objectNode();
        obj.set("nestedRecord", (JsonNode)NullNode.getInstance());
        Struct struct = new Struct(expectedSchema).put("nestedRecord", null);
        this.checkNonObjectConversion(expectedSchema, (Object)struct, (Schema)schema, (JsonNode)obj);
    }

    private org.apache.kafka.connect.data.Schema recordWithStringSchema() {
        return SchemaBuilder.struct().optional().name("nestedRecord").field("string", org.apache.kafka.connect.data.Schema.STRING_SCHEMA).build();
    }

    private org.apache.kafka.connect.data.Schema nestedRecordSchema() {
        return SchemaBuilder.struct().name("Record").field("nestedRecord", this.recordWithStringSchema()).build();
    }

    @Test
    public void testToConnectBase64Decimal() {
        NumberSchema schema = (NumberSchema)NumberSchema.builder().title("org.apache.kafka.connect.data.Decimal").unprocessedProperties((Map)ImmutableMap.of((Object)"connect.type", (Object)"bytes", (Object)"connect.parameters", (Object)ImmutableMap.of((Object)"scale", (Object)"2"))).build();
        BigDecimal reference = new BigDecimal(new BigInteger("156"), 2);
        org.apache.kafka.connect.data.Schema expectedSchema = SchemaBuilder.bytes().name("org.apache.kafka.connect.data.Decimal").parameter("scale", Integer.toString(2)).build();
        this.checkNonObjectConversion(expectedSchema, (Object)reference, (Schema)schema, (JsonNode)BinaryNode.valueOf((byte[])new byte[]{0, -100}));
    }

    @Test
    public void testToConnectNumericDecimal() {
        NumberSchema schema = (NumberSchema)NumberSchema.builder().title("org.apache.kafka.connect.data.Decimal").unprocessedProperties((Map)ImmutableMap.of((Object)"connect.type", (Object)"bytes", (Object)"connect.parameters", (Object)ImmutableMap.of((Object)"scale", (Object)"2"))).build();
        BigDecimal reference = new BigDecimal(new BigInteger("156"), 2);
        org.apache.kafka.connect.data.Schema expectedSchema = SchemaBuilder.bytes().name("org.apache.kafka.connect.data.Decimal").parameter("scale", Integer.toString(2)).build();
        this.checkNonObjectConversion(expectedSchema, (Object)reference, (Schema)schema, (JsonNode)DecimalNode.valueOf((BigDecimal)reference));
    }

    @Test
    public void testToConnectNumericDecimalWithTrailingZeros() {
        NumberSchema schema = (NumberSchema)NumberSchema.builder().title("org.apache.kafka.connect.data.Decimal").unprocessedProperties((Map)ImmutableMap.of((Object)"connect.type", (Object)"bytes", (Object)"connect.parameters", (Object)ImmutableMap.of((Object)"scale", (Object)"4"))).build();
        BigDecimal reference = new BigDecimal(new BigInteger("15600"), 4);
        org.apache.kafka.connect.data.Schema expectedSchema = SchemaBuilder.bytes().name("org.apache.kafka.connect.data.Decimal").parameter("scale", Integer.toString(4)).build();
        this.checkNonObjectConversion(expectedSchema, (Object)reference, (Schema)schema, (JsonNode)DecimalNode.valueOf((BigDecimal)reference));
    }

    @Test
    public void testToConnectHighPrecisionNumericDecimal() {
        NumberSchema schema = (NumberSchema)NumberSchema.builder().title("org.apache.kafka.connect.data.Decimal").unprocessedProperties((Map)ImmutableMap.of((Object)"connect.type", (Object)"bytes", (Object)"connect.parameters", (Object)ImmutableMap.of((Object)"scale", (Object)"17"))).build();
        BigDecimal reference = new BigDecimal("1.23456789123456789");
        org.apache.kafka.connect.data.Schema expectedSchema = SchemaBuilder.bytes().name("org.apache.kafka.connect.data.Decimal").parameter("scale", Integer.toString(17)).build();
        this.checkNonObjectConversion(expectedSchema, (Object)reference, (Schema)schema, (JsonNode)DecimalNode.valueOf((BigDecimal)reference));
    }

    @Test
    public void testToConnectEnum() {
        EnumSchema schema = EnumSchema.builder().possibleValue((Object)"one").possibleValue((Object)"two").possibleValue((Object)"three").build();
        org.apache.kafka.connect.data.Schema expectedSchema = new SchemaBuilder(Schema.Type.STRING).parameter("io.confluent.connect.json.Enum", "").parameter("io.confluent.connect.json.Enum.one", "one").parameter("io.confluent.connect.json.Enum.two", "two").parameter("io.confluent.connect.json.Enum.three", "three").build();
        this.checkNonObjectConversion(expectedSchema, (Object)"one", (Schema)schema, (JsonNode)TextNode.valueOf((String)"one"));
    }

    @Test
    public void testToConnectEnumInAllOf() {
        StringSchema stringSchema = StringSchema.builder().build();
        EnumSchema enumSchema = EnumSchema.builder().possibleValue((Object)"one").possibleValue((Object)"two").possibleValue((Object)"three").build();
        ArrayList<Object> schemas = new ArrayList<Object>();
        schemas.add(stringSchema);
        schemas.add(enumSchema);
        CombinedSchema schema = CombinedSchema.allOf(schemas).build();
        org.apache.kafka.connect.data.Schema expectedSchema = new SchemaBuilder(Schema.Type.STRING).parameter("io.confluent.connect.json.Enum", "").parameter("io.confluent.connect.json.Enum.one", "one").parameter("io.confluent.connect.json.Enum.two", "two").parameter("io.confluent.connect.json.Enum.three", "three").build();
        this.checkNonObjectConversion(expectedSchema, (Object)"one", (Schema)schema, (JsonNode)TextNode.valueOf((String)"one"));
    }

    @Test
    public void testToConnectIntEnumInAllOfIsValid() {
        NumberSchema numberSchema = NumberSchema.builder().build();
        EnumSchema enumSchema = EnumSchema.builder().possibleValue((Object)1).possibleValue((Object)2).possibleValue((Object)3).build();
        ArrayList<Object> schemas = new ArrayList<Object>();
        schemas.add(numberSchema);
        schemas.add(enumSchema);
        CombinedSchema schema = CombinedSchema.allOf(schemas).build();
        org.apache.kafka.connect.data.Schema expectedSchema = new SchemaBuilder(Schema.Type.FLOAT64).build();
        this.checkNonObjectConversion(expectedSchema, (Object)123.45, (Schema)schema, (JsonNode)DoubleNode.valueOf((double)123.45));
    }

    @Test
    public void testToConnectUnionEnumInAllOfIsValid() {
        NumberSchema firstSchema = (NumberSchema)NumberSchema.builder().requiresInteger(true).unprocessedProperties(Collections.singletonMap("connect.type", "int8")).build();
        NumberSchema secondSchema = (NumberSchema)NumberSchema.builder().requiresInteger(true).unprocessedProperties(Collections.singletonMap("connect.type", "int16")).build();
        CombinedSchema oneof = CombinedSchema.oneOf((Collection)ImmutableList.of((Object)firstSchema, (Object)secondSchema)).build();
        EnumSchema enumSchema = EnumSchema.builder().possibleValue((Object)1).possibleValue((Object)2).possibleValue((Object)3).build();
        ArrayList<Object> schemas = new ArrayList<Object>();
        schemas.add(oneof);
        schemas.add(enumSchema);
        CombinedSchema schema = CombinedSchema.allOf(schemas).build();
        SchemaBuilder builder = SchemaBuilder.struct().name("io.confluent.connect.json.OneOf");
        builder.field("io.confluent.connect.json.OneOf.field.0", org.apache.kafka.connect.data.Schema.OPTIONAL_INT8_SCHEMA);
        builder.field("io.confluent.connect.json.OneOf.field.1", org.apache.kafka.connect.data.Schema.OPTIONAL_INT16_SCHEMA);
        org.apache.kafka.connect.data.Schema expectedSchema = builder.build();
        Struct expected = new Struct(expectedSchema).put("io.confluent.connect.json.OneOf.field.0", (Object)12);
        this.checkNonObjectConversion(expectedSchema, (Object)expected, (Schema)schema, (JsonNode)ShortNode.valueOf((short)12));
    }

    @Test
    public void testToConnectStringConstInAllOf() {
        JsonSchema jsonSchema = new JsonSchema("{\"const\":\"money\",\"type\":\"string\"}");
        CombinedSchema schema = (CombinedSchema)jsonSchema.rawSchema();
        org.apache.kafka.connect.data.Schema expectedSchema = new SchemaBuilder(Schema.Type.STRING).build();
        this.checkNonObjectConversion(expectedSchema, (Object)"money", (Schema)schema, (JsonNode)TextNode.valueOf((String)"money"));
    }

    @Test
    public void testToConnectIntegerConstInAllOf() {
        JsonSchema jsonSchema = new JsonSchema("{\"const\":123,\"type\":\"integer\"}");
        CombinedSchema schema = (CombinedSchema)jsonSchema.rawSchema();
        org.apache.kafka.connect.data.Schema expectedSchema = new SchemaBuilder(Schema.Type.INT64).build();
        this.checkNonObjectConversion(expectedSchema, (Object)123L, (Schema)schema, (JsonNode)LongNode.valueOf((long)123L));
    }

    @Test
    public void testToConnectNumberConstInAllOf() {
        JsonSchema jsonSchema = new JsonSchema("{\"const\":123.45,\"type\":\"number\"}");
        CombinedSchema schema = (CombinedSchema)jsonSchema.rawSchema();
        org.apache.kafka.connect.data.Schema expectedSchema = new SchemaBuilder(Schema.Type.FLOAT64).build();
        this.checkNonObjectConversion(expectedSchema, (Object)123.45, (Schema)schema, (JsonNode)DoubleNode.valueOf((double)123.45));
    }

    @Test
    public void testToConnectUnion() {
        NumberSchema firstSchema = (NumberSchema)NumberSchema.builder().requiresInteger(true).unprocessedProperties(Collections.singletonMap("connect.type", "int8")).build();
        NumberSchema secondSchema = (NumberSchema)NumberSchema.builder().requiresInteger(true).unprocessedProperties(Collections.singletonMap("connect.type", "int16")).build();
        CombinedSchema schema = CombinedSchema.oneOf((Collection)ImmutableList.of((Object)firstSchema, (Object)secondSchema)).build();
        SchemaBuilder builder = SchemaBuilder.struct().name("io.confluent.connect.json.OneOf");
        builder.field("io.confluent.connect.json.OneOf.field.0", org.apache.kafka.connect.data.Schema.OPTIONAL_INT8_SCHEMA);
        builder.field("io.confluent.connect.json.OneOf.field.1", org.apache.kafka.connect.data.Schema.OPTIONAL_INT16_SCHEMA);
        org.apache.kafka.connect.data.Schema expectedSchema = builder.build();
        Struct expected = new Struct(expectedSchema).put("io.confluent.connect.json.OneOf.field.0", (Object)12);
        this.checkNonObjectConversion(expectedSchema, (Object)expected, (Schema)schema, (JsonNode)ShortNode.valueOf((short)12));
    }

    @Test
    public void testToConnectUnionSecondField() {
        StringSchema firstSchema = StringSchema.builder().build();
        NumberSchema secondSchema = (NumberSchema)NumberSchema.builder().requiresInteger(true).unprocessedProperties(Collections.singletonMap("connect.type", "int32")).build();
        CombinedSchema schema = CombinedSchema.oneOf((Collection)ImmutableList.of((Object)firstSchema, (Object)secondSchema)).build();
        SchemaBuilder builder = SchemaBuilder.struct().name("io.confluent.connect.json.OneOf");
        builder.field("io.confluent.connect.json.OneOf.field.0", org.apache.kafka.connect.data.Schema.OPTIONAL_STRING_SCHEMA);
        builder.field("io.confluent.connect.json.OneOf.field.1", org.apache.kafka.connect.data.Schema.OPTIONAL_INT32_SCHEMA);
        org.apache.kafka.connect.data.Schema expectedSchema = builder.build();
        Struct expected = new Struct(expectedSchema).put("io.confluent.connect.json.OneOf.field.1", (Object)12);
        this.checkNonObjectConversion(expectedSchema, (Object)expected, (Schema)schema, (JsonNode)IntNode.valueOf((int)12));
    }

    @Test
    public void testToConnectUnionDifferentIntegralType() {
        StringSchema firstSchema = StringSchema.builder().build();
        NumberSchema secondSchema = NumberSchema.builder().requiresInteger(true).build();
        CombinedSchema schema = CombinedSchema.oneOf((Collection)ImmutableList.of((Object)firstSchema, (Object)secondSchema)).build();
        SchemaBuilder builder = SchemaBuilder.struct().name("io.confluent.connect.json.OneOf");
        builder.field("io.confluent.connect.json.OneOf.field.0", org.apache.kafka.connect.data.Schema.OPTIONAL_STRING_SCHEMA);
        builder.field("io.confluent.connect.json.OneOf.field.1", org.apache.kafka.connect.data.Schema.OPTIONAL_INT64_SCHEMA);
        org.apache.kafka.connect.data.Schema expectedSchema = builder.build();
        Struct expected = new Struct(expectedSchema).put("io.confluent.connect.json.OneOf.field.1", (Object)123L);
        this.checkNonObjectConversion(expectedSchema, (Object)expected, (Schema)schema, (JsonNode)IntNode.valueOf((int)123));
    }

    @Test
    public void testToConnectUnionDifferentNumericType() {
        StringSchema firstSchema = StringSchema.builder().build();
        NumberSchema secondSchema = NumberSchema.builder().requiresNumber(true).build();
        CombinedSchema schema = CombinedSchema.oneOf((Collection)ImmutableList.of((Object)firstSchema, (Object)secondSchema)).build();
        SchemaBuilder builder = SchemaBuilder.struct().name("io.confluent.connect.json.OneOf");
        builder.field("io.confluent.connect.json.OneOf.field.0", org.apache.kafka.connect.data.Schema.OPTIONAL_STRING_SCHEMA);
        builder.field("io.confluent.connect.json.OneOf.field.1", org.apache.kafka.connect.data.Schema.OPTIONAL_FLOAT64_SCHEMA);
        org.apache.kafka.connect.data.Schema expectedSchema = builder.build();
        Struct expected = new Struct(expectedSchema).put("io.confluent.connect.json.OneOf.field.1", (Object)123.0);
        this.checkNonObjectConversion(expectedSchema, (Object)expected, (Schema)schema, (JsonNode)IntNode.valueOf((int)123));
    }

    @Test
    public void testToConnectUnionFromAnyOf() {
        NumberSchema firstSchema = (NumberSchema)NumberSchema.builder().requiresInteger(true).unprocessedProperties(Collections.singletonMap("connect.type", "int8")).build();
        NumberSchema secondSchema = (NumberSchema)NumberSchema.builder().requiresInteger(true).unprocessedProperties(Collections.singletonMap("connect.type", "int16")).build();
        CombinedSchema schema = CombinedSchema.anyOf((Collection)ImmutableList.of((Object)firstSchema, (Object)secondSchema)).build();
        SchemaBuilder builder = SchemaBuilder.struct().name("io.confluent.connect.json.OneOf");
        builder.field("io.confluent.connect.json.OneOf.field.0", org.apache.kafka.connect.data.Schema.OPTIONAL_INT8_SCHEMA);
        builder.field("io.confluent.connect.json.OneOf.field.1", org.apache.kafka.connect.data.Schema.OPTIONAL_INT16_SCHEMA);
        org.apache.kafka.connect.data.Schema expectedSchema = builder.build();
        Struct expected = new Struct(expectedSchema).put("io.confluent.connect.json.OneOf.field.0", (Object)12);
        this.checkNonObjectConversion(expectedSchema, (Object)expected, (Schema)schema, (JsonNode)ShortNode.valueOf((short)12));
    }

    @Test
    public void testToConnectUnionDifferentStruct() {
        NumberSchema numberSchema = (NumberSchema)NumberSchema.builder().requiresInteger(true).unprocessedProperties((Map)ImmutableMap.of((Object)"connect.index", (Object)0, (Object)"connect.type", (Object)"int8")).build();
        StringSchema stringSchema = (StringSchema)StringSchema.builder().unprocessedProperties((Map)ImmutableMap.of((Object)"connect.index", (Object)1)).build();
        ObjectSchema firstSchema = (ObjectSchema)ObjectSchema.builder().addPropertySchema("a", (Schema)numberSchema).addPropertySchema("b", (Schema)stringSchema).title("field0").unprocessedProperties((Map)ImmutableMap.of((Object)"connect.index", (Object)0)).build();
        ObjectSchema secondSchema = (ObjectSchema)ObjectSchema.builder().addPropertySchema("c", (Schema)numberSchema).addPropertySchema("d", (Schema)stringSchema).title("field1").unprocessedProperties((Map)ImmutableMap.of((Object)"connect.index", (Object)1)).build();
        CombinedSchema schema = CombinedSchema.oneOf((Collection)ImmutableList.of((Object)firstSchema, (Object)secondSchema)).build();
        org.apache.kafka.connect.data.Schema field0 = SchemaBuilder.struct().name("field0").field("a", org.apache.kafka.connect.data.Schema.INT8_SCHEMA).field("b", org.apache.kafka.connect.data.Schema.STRING_SCHEMA).optional().build();
        org.apache.kafka.connect.data.Schema field1 = SchemaBuilder.struct().name("field1").field("c", org.apache.kafka.connect.data.Schema.INT8_SCHEMA).field("d", org.apache.kafka.connect.data.Schema.STRING_SCHEMA).optional().build();
        SchemaBuilder builder = SchemaBuilder.struct().name("io.confluent.connect.json.OneOf");
        builder.field("io.confluent.connect.json.OneOf.field.0", field0);
        builder.field("io.confluent.connect.json.OneOf.field.1", field1);
        org.apache.kafka.connect.data.Schema connectSchema = builder.build();
        ObjectNode obj = JsonNodeFactory.instance.objectNode();
        obj.set("a", (JsonNode)ShortNode.valueOf((short)12));
        obj.set("b", (JsonNode)TextNode.valueOf((String)"sample string"));
        Struct struct = new Struct(field0).put("a", (Object)12).put("b", (Object)"sample string");
        Struct expected = new Struct(connectSchema).put("io.confluent.connect.json.OneOf.field.0", (Object)struct);
        this.checkNonObjectConversion(connectSchema, (Object)expected, (Schema)schema, (JsonNode)obj);
        obj = JsonNodeFactory.instance.objectNode();
        obj.set("c", (JsonNode)ShortNode.valueOf((short)12));
        obj.set("d", (JsonNode)TextNode.valueOf((String)"sample string"));
        struct = new Struct(field1).put("c", (Object)12).put("d", (Object)"sample string");
        expected = new Struct(connectSchema).put("io.confluent.connect.json.OneOf.field.1", (Object)struct);
        this.checkNonObjectConversion(connectSchema, (Object)expected, (Schema)schema, (JsonNode)obj);
    }

    @Test
    public void testToConnectMapOptionalValue() {
        this.testToConnectMapOptional("some value");
    }

    @Test
    public void testToConnectMapOptionalNullValue() {
        this.testToConnectMapOptional(null);
    }

    private void testToConnectMapOptional(String value) {
        NumberSchema numberSchema = (NumberSchema)NumberSchema.builder().requiresInteger(true).unprocessedProperties((Map)ImmutableMap.of((Object)"connect.type", (Object)"int8")).build();
        StringSchema stringSchema = StringSchema.builder().build();
        CombinedSchema combinedSchema = CombinedSchema.oneOf((Collection)ImmutableList.of((Object)NullSchema.INSTANCE, (Object)stringSchema)).build();
        ObjectSchema entrySchema = ObjectSchema.builder().addPropertySchema("key", (Schema)numberSchema).addPropertySchema("value", (Schema)combinedSchema).build();
        ArraySchema schema = (ArraySchema)ArraySchema.builder().allItemSchema((Schema)entrySchema).unprocessedProperties((Map)ImmutableMap.of((Object)"connect.type", (Object)"map")).build();
        ObjectNode obj = JsonNodeFactory.instance.objectNode();
        obj.set("key", (JsonNode)ShortNode.valueOf((short)12));
        if (value == null) {
            obj.set("value", (JsonNode)NullNode.getInstance());
        } else {
            obj.set("value", (JsonNode)TextNode.valueOf((String)value));
        }
        ArrayNode array = JsonNodeFactory.instance.arrayNode();
        array.add((JsonNode)obj);
        org.apache.kafka.connect.data.Schema expectedSchema = SchemaBuilder.map((org.apache.kafka.connect.data.Schema)org.apache.kafka.connect.data.Schema.INT8_SCHEMA, (org.apache.kafka.connect.data.Schema)org.apache.kafka.connect.data.Schema.OPTIONAL_STRING_SCHEMA).build();
        this.checkNonObjectConversion(expectedSchema, Collections.singletonMap((byte)12, value), (Schema)schema, (JsonNode)array);
    }

    @Test
    public void testToNamedConnectMap() {
        Assert.assertEquals((Object)this.jsonSchemaData.toConnectSchema(NAMED_JSON_MAP_SCHEMA), (Object)NAMED_MAP_SCHEMA);
    }

    private void checkNonObjectConversion(org.apache.kafka.connect.data.Schema expectedSchema, Object expected, Schema schema, JsonNode value) {
        this.checkNonObjectConversion(this.jsonSchemaData, expectedSchema, expected, schema, value);
    }

    private void checkNonObjectConversion(JsonSchemaData jsonSchemaData, org.apache.kafka.connect.data.Schema expectedSchema, Object expected, Schema schema, JsonNode value) {
        org.apache.kafka.connect.data.Schema connectSchema = jsonSchemaData.toConnectSchema(schema);
        Object jsonValue = JsonSchemaData.toConnectData((org.apache.kafka.connect.data.Schema)connectSchema, (JsonNode)value);
        if (connectSchema != null) {
            try {
                ConnectSchema.validateValue((org.apache.kafka.connect.data.Schema)connectSchema, (Object)jsonValue);
            }
            catch (DataException e) {
                Assert.assertTrue((boolean)e.getMessage().contains("Invalid value: null used for required field"));
            }
        }
        Assert.assertEquals((Object)expectedSchema, (Object)connectSchema);
        if (expected instanceof byte[]) {
            Assert.assertArrayEquals((byte[])((byte[])expected), (byte[])((byte[])jsonValue));
        } else {
            Assert.assertEquals((Object)expected, (Object)jsonValue);
        }
    }

    @Test
    public void testCombinedSchemaAllOfRef() {
        String schema = "{\n  \"$schema\": \"http://json-schema.org/draft-07/schema#\",\n  \"allOf\": [\n    { \"$ref\": \"#/definitions/MessageBase\" },\n    { \"$ref\": \"#/definitions/MessageBase2\" }\n  ],\n\n  \"title\": \"IdentifyUserMessage\",\n  \"description\": \"An IdentifyUser message\",\n  \"type\": \"object\",\n\n  \"properties\": {\n    \"prevUserId\": {\n      \"type\": \"string\"\n    },\n\n    \"newUserId\": {\n      \"type\": \"string\"\n    }\n  },\n\n  \"definitions\": {\n    \"MessageBase\": {\n      \"properties\": {\n        \"id\": {\n          \"type\": \"string\"\n        },\n\n        \"type\": {\n          \"type\": \"string\"\n        }\n      }\n    },\n    \"MessageBase2\": {\n      \"properties\": {\n        \"id2\": {\n          \"type\": \"string\"\n        }\n      }\n    }\n  }\n}";
        JsonSchema jsonSchema = new JsonSchema(schema);
        JsonSchemaData jsonSchemaData = new JsonSchemaData();
        org.apache.kafka.connect.data.Schema connectSchema = jsonSchemaData.toConnectSchema(jsonSchema);
        Assert.assertNotNull((Object)connectSchema.field("id"));
        Assert.assertNotNull((Object)connectSchema.field("type"));
        Assert.assertNotNull((Object)connectSchema.field("id2"));
        Assert.assertNotNull((Object)connectSchema.field("newUserId"));
        Assert.assertNotNull((Object)connectSchema.field("prevUserId"));
    }

    @Test
    public void testCombinedSchemaTitleAndObject() {
        String schema = "{\n      \"title\": \"Product Identifier\",\n      \"type\": \"object\",\n      \"anyOf\": [\n        {\n          \"type\": \"object\",\n          \"properties\": {\n            \"keycode\": {\n              \"type\": \"string\"\n            }\n          }\n        },\n        {\n          \"type\": \"object\",\n          \"properties\": {\n            \"itemCode\": {\n              \"type\": \"string\"\n            }\n          }\n        }\n      ]\n    }";
        JsonSchema jsonSchema = new JsonSchema(schema);
        JsonSchemaData jsonSchemaData = new JsonSchemaData();
        org.apache.kafka.connect.data.Schema connectSchema = jsonSchemaData.toConnectSchema(jsonSchema);
        Assert.assertEquals((Object)"io.confluent.connect.json.OneOf", (Object)connectSchema.name());
    }

    @Test
    public void testNumericFormats() {
        String schema = "{\n  \"title\": \"numerics with format\",\n  \"type\": \"object\",\n  \"properties\": {\n    \"id\": {\n      \"type\": \"integer\",\n      \"format\": \"int32\"\n    },\n    \"num\": {\n      \"type\": \"number\",\n      \"format\": \"double\"\n    }\n  },\n  \"required\": [\n    \"id\"\n  ],\n  \"additionalProperties\": false\n}";
        JsonSchema jsonSchema = new JsonSchema(schema);
        JsonSchemaData jsonSchemaData = new JsonSchemaData();
        org.apache.kafka.connect.data.Schema connectSchema = jsonSchemaData.toConnectSchema(jsonSchema);
        Assert.assertFalse((boolean)connectSchema.field("id").schema().isOptional());
        Assert.assertFalse((boolean)connectSchema.field("num").schema().isOptional());
    }

    @Test
    public void testOptionalNumericFormats() {
        String schema = "{\n  \"title\": \"numerics with format\",\n  \"type\": \"object\",\n  \"properties\": {\n    \"id\": {\n      \"format\": \"int32\",\n      \"type\": [\n        \"null\",\n        \"number\"\n      ]    },\n    \"num\": {\n      \"format\": \"double\",\n      \"type\": [\n        \"null\",\n        \"integer\"\n      ]    }\n  },\n  \"required\": [\n    \"id\"\n  ],\n  \"additionalProperties\": false\n}";
        JsonSchema jsonSchema = new JsonSchema(schema);
        JsonSchemaData jsonSchemaData = new JsonSchemaData();
        org.apache.kafka.connect.data.Schema connectSchema = jsonSchemaData.toConnectSchema(jsonSchema);
        Assert.assertTrue((boolean)connectSchema.field("id").schema().isOptional());
        Assert.assertTrue((boolean)connectSchema.field("num").schema().isOptional());
    }

    @Test
    public void testStringFormats() {
        String schema = "{\n  \"title\": \"strings with format\",\n  \"type\": \"object\",\n  \"properties\": {\n    \"id\": {\n      \"type\": \"string\",\n      \"format\": \"password\"\n    },\n    \"str\": {\n      \"type\": \"string\",\n      \"format\": \"uuid\"\n    }\n  },\n  \"required\": [\n    \"id\"\n  ],\n  \"additionalProperties\": false\n}";
        JsonSchema jsonSchema = new JsonSchema(schema);
        JsonSchemaData jsonSchemaData = new JsonSchemaData();
        org.apache.kafka.connect.data.Schema connectSchema = jsonSchemaData.toConnectSchema(jsonSchema);
        Assert.assertFalse((boolean)connectSchema.field("id").schema().isOptional());
        Assert.assertFalse((boolean)connectSchema.field("str").schema().isOptional());
    }

    @Test
    public void testOptionalStringFormats() {
        String schema = "{\n  \"title\": \"strings with format\",\n  \"type\": \"object\",\n  \"properties\": {\n    \"id\": {\n      \"type\": \"string\",\n      \"format\": \"password\",\n      \"type\": [\n        \"null\",\n        \"string\"\n      ]    },\n    \"str\": {\n      \"format\": \"uuid\",\n      \"type\": [\n        \"null\",\n        \"string\"\n      ]    }\n  },\n  \"required\": [\n    \"id\"\n  ],\n  \"additionalProperties\": false\n}";
        JsonSchema jsonSchema = new JsonSchema(schema);
        JsonSchemaData jsonSchemaData = new JsonSchemaData();
        org.apache.kafka.connect.data.Schema connectSchema = jsonSchemaData.toConnectSchema(jsonSchema);
        Assert.assertTrue((boolean)connectSchema.field("id").schema().isOptional());
        Assert.assertTrue((boolean)connectSchema.field("str").schema().isOptional());
    }

    @Test
    public void testOptionalReferencedSchema() {
        String schema = "{\n    \"$schema\": \"http://json-schema.org/draft-07/schema#\",\n    \"title\": \"Test\",\n    \"type\": \"object\",\n    \"additionalProperties\": false,\n    \"properties\": {\n        \"id\": {\n            \"type\": \"string\",\n            \"description\": \"unique id\"\n        },\n        \"createById\": {\n            \"oneOf\": [\n                {\n                    \"type\": \"null\",\n                    \"title\": \"Not included\"\n                },\n                {\n                    \"type\": \"string\"\n                }\n            ],\n            \"description\": \"user id\"\n        },\n        \"complexNode\": {\n            \"oneOf\": [\n                {\n                    \"type\": \"null\",\n                    \"title\": \"Not included\"\n                },\n                {\n                    \"$ref\": \"#/definitions/complexNode\"\n                }\n            ]\n        }\n    },\n    \"required\": [\n        \"id\"\n    ],\n    \"definitions\": {\n        \"complexNode\": {\n            \"type\": \"object\",\n            \"additionalProperties\": false,\n            \"properties\": {\n                \"id\": {\n                    \"type\": \"string\",\n                    \"description\": \"unique id\"\n                },\n                \"createById\": {\n                    \"oneOf\": [\n                        {\n                            \"type\": \"null\",\n                            \"title\": \"Not included\"\n                        },\n                        {\n                            \"type\": \"string\"\n                        }\n                    ],\n                    \"description\": \"user id\"\n                }\n            },\n            \"required\": [\n                \"id\"\n            ]\n        }\n    }\n}";
        JsonSchema jsonSchema = new JsonSchema(schema);
        JsonSchemaData jsonSchemaData = new JsonSchemaData();
        org.apache.kafka.connect.data.Schema connectSchema = jsonSchemaData.toConnectSchema(jsonSchema);
        Assert.assertTrue((boolean)connectSchema.field("complexNode").schema().isOptional());
    }

    @Test
    public void testToConnectRecursiveSchema() {
        JsonSchema jsonSchema = this.getRecursiveJsonSchema();
        JsonSchemaData jsonSchemaData = new JsonSchemaData();
        org.apache.kafka.connect.data.Schema expected = this.getRecursiveSchema();
        org.apache.kafka.connect.data.Schema actual = jsonSchemaData.toConnectSchema(jsonSchema);
        Assert.assertEquals((Object)expected.field("title"), (Object)actual.field("title"));
        org.apache.kafka.connect.data.Schema expectedNested = expected.field("parent").schema();
        org.apache.kafka.connect.data.Schema actualNested = actual.field("parent").schema();
        Assert.assertEquals((Object)expectedNested.name(), (Object)actualNested.name());
        Assert.assertEquals((Object)expectedNested.type(), (Object)actualNested.type());
    }

    @Test
    public void testFromConnectRecursiveSchema() {
        JsonSchema expected = this.getRecursiveJsonSchema();
        JsonSchemaData jsonSchemaData = new JsonSchemaData();
        JsonSchema jsonSchema = jsonSchemaData.fromConnectSchema(this.getRecursiveSchema());
        Assert.assertEquals((Object)expected, (Object)jsonSchema);
    }

    private JsonSchema getRecursiveJsonSchema() {
        String schema = "{\n  \"type\": \"object\",\n  \"title\": \"Task\",\n  \"description\": \"A task\",\n  \"id\": \"#id1\",\n  \"properties\": {\n    \"parent\": {\n      \"$ref\": \"#id1\"\n    },\n    \"title\": {\n      \"type\": \"string\",\n      \"description\": \"Task title\",\n      \"connect.index\": 1\n    }\n  }\n}\n";
        return new JsonSchema(schema);
    }

    private org.apache.kafka.connect.data.Schema getRecursiveSchema() {
        SchemaBuilder schemaBuilder = SchemaBuilder.struct();
        schemaBuilder.name("Task");
        schemaBuilder.doc("A task");
        schemaBuilder.parameter("io.confluent.connect.json.Id", "#id1");
        schemaBuilder.field("parent", new JsonSchemaData.SchemaWrapper(schemaBuilder, false).build());
        schemaBuilder.field("title", SchemaBuilder.string().doc("Task title").build());
        return schemaBuilder.build();
    }

    @Test
    public void testToConnectRecursiveSchema2() {
        JsonSchema jsonSchema = this.getRecursiveJsonSchema2();
        JsonSchemaData jsonSchemaData = new JsonSchemaData();
        org.apache.kafka.connect.data.Schema expected = this.getRecursiveSchema2();
        org.apache.kafka.connect.data.Schema actual = jsonSchemaData.toConnectSchema(jsonSchema);
        Assert.assertEquals((Object)expected.field("title"), (Object)actual.field("title"));
        org.apache.kafka.connect.data.Schema expectedNested = expected.field("foos").schema();
        org.apache.kafka.connect.data.Schema actualNested = actual.field("foos").schema();
        Assert.assertEquals((Object)expectedNested.name(), (Object)actualNested.name());
        Assert.assertEquals((Object)expectedNested.type(), (Object)actualNested.type());
    }

    @Test
    public void testFromConnectRecursiveSchema2() {
        JsonSchema expected = this.getRecursiveJsonSchema2();
        JsonSchemaData jsonSchemaData = new JsonSchemaData();
        JsonSchema jsonSchema = jsonSchemaData.fromConnectSchema(this.getRecursiveSchema2());
        Assert.assertEquals((Object)expected.name(), (Object)jsonSchema.name());
    }

    private JsonSchema getRecursiveJsonSchema2() {
        String schema = "{\n    \"title\": \"Foo\",\n    \"$ref\": \"#/$defs/Foo\",\n    \"$defs\": {\n        \"Foo\": {\n            \"properties\": {\n                \"foos\": {\n                    \"oneOf\": [\n                        {\n                            \"items\": {\n                                \"$ref\": \"#/$defs/Foo\"\n                            },\n                            \"type\": \"array\"\n                        },\n                        {\n                            \"type\": \"null\"\n                        }\n                    ],\n                    \"items\": {\n                        \"$ref\": \"#/$defs/Foo\"\n                    },\n                    \"type\": \"array\"\n                }\n            },\n            \"type\": \"object\"\n        }\n    }\n}";
        return new JsonSchema(schema);
    }

    private org.apache.kafka.connect.data.Schema getRecursiveSchema2() {
        SchemaBuilder schemaBuilder = SchemaBuilder.struct();
        schemaBuilder.name("Foo");
        schemaBuilder.parameter("io.confluent.connect.json.Id", "#id1");
        org.apache.kafka.connect.data.Schema arraySchema = SchemaBuilder.array((org.apache.kafka.connect.data.Schema)schemaBuilder).build();
        schemaBuilder.field("foos", arraySchema);
        return schemaBuilder.build();
    }
}

