/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.jdbc.util;

import io.confluent.connect.jdbc.util.IdentifierRules;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class IdentifierRulesTest {
    private IdentifierRules rules;
    private List<String> parts;

    @Before
    public void beforeEach() {
        this.rules = IdentifierRules.DEFAULT;
    }

    @Test
    public void testParsingWithMultiCharacterQuotes() {
        this.rules = new IdentifierRules(".", "'''", "'''");
        this.assertParts("'''p1'''.'''p2'''.'''p3'''", "p1", "p2", "p3");
        this.assertParts("'''p1'''.'''p3'''", "p1", "p3");
        this.assertParts("'''p1'''", "p1");
        this.assertParts("'''p1.1.2.3'''", "p1.1.2.3");
        this.assertParts("'''p1.1.2.3.'''", "p1.1.2.3.");
        this.assertParts("", "");
        this.assertParsingFailure("'''p1.p2");
        this.assertParsingFailure("'''p1'''.'''p3'''.");
    }

    @Test
    public void testParsingWithDifferentLeadingAndTrailingQuotes() {
        this.rules = new IdentifierRules(".", "[", "]");
        this.assertParts("[p1].[p2].[p3]", "p1", "p2", "p3");
        this.assertParts("[p1].[p3]", "p1", "p3");
        this.assertParts("[p1]", "p1");
        this.assertParts("[p1.1.2.3]", "p1.1.2.3");
        this.assertParts("[p1[.[1.[2.3]", "p1[.[1.[2.3");
        this.assertParts("", "");
        this.assertParsingFailure("[p1].[p3].");
    }

    @Test
    public void testParsingWithSingleCharacterQuotes() {
        this.rules = new IdentifierRules(".", "'", "'");
        this.assertParts("'p1'.'p2'.'p3'", "p1", "p2", "p3");
        this.assertParts("'p1'.'p3'", "p1", "p3");
        this.assertParts("'p1'", "p1");
        this.assertParts("'p1.1.2.3'", "p1.1.2.3");
        this.assertParts("", "");
        this.assertParsingFailure("'p1'.'p3'.");
    }

    @Test
    public void testParsingWithoutQuotes() {
        this.rules = new IdentifierRules(".", "'", "'");
        this.assertParts("p1.p2.p3", "p1", "p2", "p3");
        this.assertParts("p1.p3", "p1", "p3");
        this.assertParts("p1", "p1");
        this.assertParts("", "");
        this.assertParsingFailure("'p1'.'p3'.");
        this.assertParsingFailure("p1.p3.");
    }

    @Test
    public void testParsingWithUnsupportedQuotes() {
        this.rules = new IdentifierRules(".", " ", " ");
        this.assertParts("p1.p2.p3", "p1", "p2", "p3");
        this.assertParts("p1.p3", "p1", "p3");
        this.assertParts("p1", "p1");
        this.assertParts("", "");
    }

    protected void assertParts(String fqn, String ... expectedParts) {
        this.parts = this.rules.parseQualifiedIdentifier(fqn);
        Assert.assertEquals((long)expectedParts.length, (long)this.parts.size());
        int index = 0;
        for (String expectedPart : expectedParts) {
            Assert.assertEquals((Object)expectedPart, (Object)this.parts.get(index++));
        }
    }

    protected void assertParsingFailure(String fqn) {
        try {
            this.parts = this.rules.parseQualifiedIdentifier(fqn);
            Assert.fail((String)"expected parsing error");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

