/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.jdbc.util;

import io.confluent.connect.jdbc.dialect.DatabaseDialect;
import io.confluent.connect.jdbc.dialect.DropOptions;
import io.confluent.connect.jdbc.util.TableId;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public final class DatabaseHelper {
    public final DatabaseDialect dialect;
    private Connection connection;

    public DatabaseHelper(DatabaseDialect dialect) {
        this.dialect = dialect;
    }

    public void setUp() throws SQLException, IOException {
        this.connection = this.dialect.getConnection();
    }

    public void tearDown() throws SQLException, IOException {
        try {
            if (this.connection != null) {
                this.connection.close();
            }
        }
        finally {
            if (this.dialect != null) {
                this.dialect.close();
            }
        }
    }

    public void createTable(String createSql) throws SQLException {
        this.execute(createSql);
    }

    public void deleteTable(TableId tableId) throws SQLException {
        this.deleteTable(tableId, new DropOptions().setIfExists(true));
    }

    public void deleteTable(TableId tableId, DropOptions options) throws SQLException {
        String sql = this.dialect.buildDropTableStatement(tableId, options);
        this.execute(sql);
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public int select(String query, ResultSetReadCallback callback) throws SQLException {
        int count = 0;
        try (Statement stmt = this.connection.createStatement();
             ResultSet rs = stmt.executeQuery(query);){
            while (rs.next()) {
                callback.read(rs);
                ++count;
            }
        }
        return count;
    }

    public void execute(String sql) throws SQLException {
        try (Statement stmt = this.connection.createStatement();){
            stmt.executeUpdate(sql);
            if (!this.connection.getAutoCommit()) {
                this.connection.commit();
            }
        }
    }

    public static interface ResultSetReadCallback {
        public void read(ResultSet var1) throws SQLException;
    }
}

