/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.jdbc.util;

import io.confluent.connect.jdbc.util.CachedConnectionProvider;
import io.confluent.connect.jdbc.util.ConnectionProvider;
import java.sql.Connection;
import java.sql.SQLException;
import org.apache.kafka.connect.errors.ConnectException;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.powermock.api.easymock.PowerMock;
import org.powermock.api.easymock.annotation.Mock;
import org.powermock.core.classloader.annotations.PowerMockIgnore;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={CachedConnectionProviderTest.class})
@PowerMockIgnore(value={"javax.management.*"})
public class CachedConnectionProviderTest {
    @Mock
    private ConnectionProvider provider;

    @Test
    public void retryTillFailure() throws SQLException {
        int retries = 15;
        CachedConnectionProvider connectionProvider = new CachedConnectionProvider(this.provider, retries, 100L);
        EasyMock.expect((Object)this.provider.getConnection()).andThrow((Throwable)new SQLException("test")).times(retries);
        PowerMock.replayAll((Object[])new Object[0]);
        try {
            connectionProvider.getConnection();
        }
        catch (ConnectException ce) {
            Assert.assertNotNull((Object)((Object)ce));
        }
        PowerMock.verifyAll();
    }

    @Test
    public void retryTillConnect() throws SQLException {
        Connection connection = (Connection)EasyMock.createMock(Connection.class);
        int retries = 15;
        CachedConnectionProvider connectionProvider = new CachedConnectionProvider(this.provider, retries, 100L);
        EasyMock.expect((Object)this.provider.getConnection()).andThrow((Throwable)new SQLException("test")).times(retries - 1).andReturn((Object)connection);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertNotNull((Object)connectionProvider.getConnection());
        PowerMock.verifyAll();
    }
}

