/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.jdbc.source;

import io.confluent.connect.jdbc.source.TimestampIncrementingOffset;
import java.sql.Timestamp;
import java.util.Map;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TimestampIncrementingOffsetTest {
    private final Timestamp ts = new Timestamp(100L);
    private final long id = 1000L;
    private final TimestampIncrementingOffset unset = new TimestampIncrementingOffset(null, null);
    private final TimestampIncrementingOffset tsOnly = new TimestampIncrementingOffset(this.ts, null);
    private final TimestampIncrementingOffset incOnly = new TimestampIncrementingOffset(null, Long.valueOf(1000L));
    private final TimestampIncrementingOffset tsInc = new TimestampIncrementingOffset(this.ts, Long.valueOf(1000L));
    private Timestamp nanos;
    private TimestampIncrementingOffset nanosOffset;

    @Before
    public void setUp() {
        long millis = System.currentTimeMillis();
        this.nanos = new Timestamp(millis);
        this.nanos.setNanos((int)(millis % 1000L) * 1000000 + 123456);
        Assert.assertEquals((long)millis, (long)this.nanos.getTime());
        this.nanosOffset = new TimestampIncrementingOffset(this.nanos, null);
    }

    @Test
    public void testDefaults() {
        Assert.assertEquals((long)-1L, (long)this.unset.getIncrementingOffset());
        Assert.assertNotNull((Object)this.unset.getTimestampOffset());
        Assert.assertEquals((long)0L, (long)this.unset.getTimestampOffset().getTime());
        Assert.assertEquals((long)0L, (long)this.unset.getTimestampOffset().getNanos());
    }

    @Test
    public void testToMap() {
        Assert.assertEquals((long)0L, (long)this.unset.toMap().size());
        Assert.assertEquals((long)2L, (long)this.tsOnly.toMap().size());
        Assert.assertEquals((long)1L, (long)this.incOnly.toMap().size());
        Assert.assertEquals((long)3L, (long)this.tsInc.toMap().size());
        Assert.assertEquals((long)2L, (long)this.nanosOffset.toMap().size());
    }

    @Test
    public void testGetIncrementingOffset() {
        Assert.assertEquals((long)-1L, (long)this.unset.getIncrementingOffset());
        Assert.assertEquals((long)-1L, (long)this.tsOnly.getIncrementingOffset());
        Assert.assertEquals((long)1000L, (long)this.incOnly.getIncrementingOffset());
        Assert.assertEquals((long)1000L, (long)this.tsInc.getIncrementingOffset());
        Assert.assertEquals((long)-1L, (long)this.nanosOffset.getIncrementingOffset());
    }

    @Test
    public void testGetTimestampOffset() {
        Assert.assertNotNull((Object)this.unset.getTimestampOffset());
        Timestamp zero = new Timestamp(0L);
        Assert.assertEquals((Object)zero, (Object)this.unset.getTimestampOffset());
        Assert.assertEquals((Object)this.ts, (Object)this.tsOnly.getTimestampOffset());
        Assert.assertEquals((Object)zero, (Object)this.incOnly.getTimestampOffset());
        Assert.assertEquals((Object)this.ts, (Object)this.tsInc.getTimestampOffset());
        Assert.assertEquals((Object)this.nanos, (Object)this.nanosOffset.getTimestampOffset());
    }

    @Test
    public void testFromMap() {
        Assert.assertEquals((Object)this.unset, (Object)TimestampIncrementingOffset.fromMap((Map)this.unset.toMap()));
        Assert.assertEquals((Object)this.tsOnly, (Object)TimestampIncrementingOffset.fromMap((Map)this.tsOnly.toMap()));
        Assert.assertEquals((Object)this.incOnly, (Object)TimestampIncrementingOffset.fromMap((Map)this.incOnly.toMap()));
        Assert.assertEquals((Object)this.tsInc, (Object)TimestampIncrementingOffset.fromMap((Map)this.tsInc.toMap()));
        Assert.assertEquals((Object)this.nanosOffset, (Object)TimestampIncrementingOffset.fromMap((Map)this.nanosOffset.toMap()));
    }

    @Test
    public void testEquals() {
        Assert.assertEquals((Object)this.nanosOffset, (Object)this.nanosOffset);
        Assert.assertEquals((Object)new TimestampIncrementingOffset(null, null), (Object)new TimestampIncrementingOffset(null, null));
        Assert.assertEquals((Object)this.unset, (Object)new TimestampIncrementingOffset(null, null));
        TimestampIncrementingOffset x = new TimestampIncrementingOffset(null, Long.valueOf(1000L));
        Assert.assertEquals((Object)x, (Object)this.incOnly);
        x = new TimestampIncrementingOffset(this.ts, null);
        Assert.assertEquals((Object)x, (Object)this.tsOnly);
        x = new TimestampIncrementingOffset(this.ts, Long.valueOf(1000L));
        Assert.assertEquals((Object)x, (Object)this.tsInc);
        x = new TimestampIncrementingOffset(this.nanos, null);
        Assert.assertEquals((Object)x, (Object)this.nanosOffset);
    }
}

