/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.jdbc.source;

import io.confluent.connect.jdbc.source.TimestampIncrementingCriteria;
import io.confluent.connect.jdbc.source.TimestampIncrementingOffset;
import io.confluent.connect.jdbc.util.ColumnId;
import io.confluent.connect.jdbc.util.TableId;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import org.apache.kafka.connect.data.Decimal;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.data.Timestamp;
import org.apache.kafka.connect.errors.ConnectException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TimestampIncrementingCriteriaTest {
    private static final TableId TABLE_ID = new TableId(null, null, "myTable");
    private static final ColumnId INCREMENTING_COLUMN = new ColumnId(TABLE_ID, "id");
    private static final ColumnId TS1_COLUMN = new ColumnId(TABLE_ID, "ts1");
    private static final ColumnId TS2_COLUMN = new ColumnId(TABLE_ID, "ts2");
    private static final List<ColumnId> TS_COLUMNS = Arrays.asList(TS1_COLUMN, TS2_COLUMN);
    private TimestampIncrementingCriteria criteria;
    private TimestampIncrementingCriteria criteriaInc;
    private TimestampIncrementingCriteria criteriaTs;
    private TimestampIncrementingCriteria criteriaIncTs;
    private Schema schema;
    private Struct record;

    @Before
    public void beforeEach() {
        this.criteria = new TimestampIncrementingCriteria(null, null);
        this.criteriaInc = new TimestampIncrementingCriteria(INCREMENTING_COLUMN, null);
        this.criteriaTs = new TimestampIncrementingCriteria(null, TS_COLUMNS);
        this.criteriaIncTs = new TimestampIncrementingCriteria(INCREMENTING_COLUMN, TS_COLUMNS);
    }

    protected void assertExtractedOffset(long expected, Schema schema, Struct record) {
        TimestampIncrementingCriteria criteria = null;
        criteria = schema.field(INCREMENTING_COLUMN.name()) != null ? (schema.field(TS1_COLUMN.name()) != null ? this.criteriaIncTs : this.criteriaInc) : (schema.field(TS1_COLUMN.name()) != null ? this.criteriaTs : this.criteria);
        TimestampIncrementingOffset offset = criteria.extractValues(schema, record, null);
        Assert.assertEquals((long)expected, (long)offset.getIncrementingOffset());
    }

    @Test
    public void extractIntOffset() throws SQLException {
        this.schema = SchemaBuilder.struct().field("id", SchemaBuilder.INT32_SCHEMA).build();
        this.record = new Struct(this.schema).put("id", (Object)42);
        this.assertExtractedOffset(42L, this.schema, this.record);
    }

    @Test
    public void extractLongOffset() throws SQLException {
        this.schema = SchemaBuilder.struct().field("id", SchemaBuilder.INT64_SCHEMA).build();
        this.record = new Struct(this.schema).put("id", (Object)42L);
        this.assertExtractedOffset(42L, this.schema, this.record);
    }

    @Test
    public void extractDecimalOffset() throws SQLException {
        Schema decimalSchema = Decimal.schema((int)0);
        this.schema = SchemaBuilder.struct().field("id", decimalSchema).build();
        this.record = new Struct(this.schema).put("id", (Object)new BigDecimal(42));
        this.assertExtractedOffset(42L, this.schema, this.record);
    }

    @Test(expected=ConnectException.class)
    public void extractTooLargeDecimalOffset() throws SQLException {
        Schema decimalSchema = Decimal.schema((int)0);
        this.schema = SchemaBuilder.struct().field("id", decimalSchema).build();
        this.record = new Struct(this.schema).put("id", (Object)new BigDecimal(Long.MAX_VALUE).add(new BigDecimal(1)));
        this.assertExtractedOffset(42L, this.schema, this.record);
    }

    @Test(expected=ConnectException.class)
    public void extractFractionalDecimalOffset() throws SQLException {
        Schema decimalSchema = Decimal.schema((int)2);
        this.schema = SchemaBuilder.struct().field("id", decimalSchema).build();
        this.record = new Struct(this.schema).put("id", (Object)new BigDecimal("42.42"));
        this.assertExtractedOffset(42L, this.schema, this.record);
    }

    @Test
    public void extractWithIncColumn() throws SQLException {
        this.schema = SchemaBuilder.struct().field("id", SchemaBuilder.INT32_SCHEMA).field(TS1_COLUMN.name(), Timestamp.SCHEMA).field(TS2_COLUMN.name(), Timestamp.SCHEMA).build();
        this.record = new Struct(this.schema).put("id", (Object)42);
        this.assertExtractedOffset(42L, this.schema, this.record);
    }
}

