/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.jdbc.source;

import io.confluent.connect.jdbc.dialect.DatabaseDialect;
import io.confluent.connect.jdbc.source.JdbcSourceTask;
import io.confluent.connect.jdbc.source.TableMonitorThread;
import io.confluent.connect.jdbc.util.ConnectionProvider;
import io.confluent.connect.jdbc.util.ExpressionBuilder;
import io.confluent.connect.jdbc.util.TableId;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.kafka.connect.connector.ConnectorContext;
import org.apache.kafka.connect.errors.ConnectException;
import org.easymock.EasyMock;
import org.easymock.IAnswer;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.powermock.api.easymock.annotation.Mock;
import org.powermock.core.classloader.annotations.PowerMockIgnore;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={JdbcSourceTask.class})
@PowerMockIgnore(value={"javax.management.*"})
public class TableMonitorThreadTest {
    private static final long POLL_INTERVAL = 100L;
    private static final TableId FOO = new TableId(null, null, "foo");
    private static final TableId BAR = new TableId(null, null, "bar");
    private static final TableId BAZ = new TableId(null, null, "baz");
    private static final TableId DUP1 = new TableId(null, "dup1", "dup");
    private static final TableId DUP2 = new TableId(null, "dup2", "dup");
    private static final List<TableId> LIST_EMPTY = Collections.emptyList();
    private static final List<TableId> LIST_FOO = Collections.singletonList(FOO);
    private static final List<TableId> LIST_FOO_BAR = Arrays.asList(FOO, BAR);
    private static final List<TableId> LIST_FOO_BAR_BAZ = Arrays.asList(FOO, BAR, BAZ);
    private static final List<TableId> LIST_DUP_ONLY = Arrays.asList(DUP1, DUP2);
    private static final List<TableId> LIST_DUP_WITH_ALL = Arrays.asList(DUP1, FOO, DUP2, BAR, BAZ);
    private static final List<String> FIRST_TOPIC_LIST = Arrays.asList("foo");
    private static final List<String> VIEW_TOPIC_LIST = Arrays.asList("");
    private static final List<String> SECOND_TOPIC_LIST = Arrays.asList("foo", "bar");
    private static final List<String> THIRD_TOPIC_LIST = Arrays.asList("foo", "bar", "baz");
    public static final Set<String> DEFAULT_TABLE_TYPES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("TABLE")));
    public static final Set<String> VIEW_TABLE_TYPES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("VIEW")));
    private TableMonitorThread tableMonitorThread;
    @Mock
    private ConnectionProvider connectionProvider;
    @Mock
    private Connection connection;
    @Mock
    private DatabaseDialect dialect;
    @Mock
    private ConnectorContext context;

    @Test
    public void testSingleLookup() throws Exception {
        EasyMock.expect((Object)this.dialect.expressionBuilder()).andReturn((Object)ExpressionBuilder.create()).anyTimes();
        this.tableMonitorThread = new TableMonitorThread(this.dialect, this.connectionProvider, this.context, 100L, null, null);
        this.expectTableNames(LIST_FOO, this.shutdownThread());
        EasyMock.replay((Object[])new Object[]{this.connectionProvider, this.dialect});
        this.tableMonitorThread.start();
        this.tableMonitorThread.join();
        this.checkTableNames("foo").execute();
        EasyMock.verify((Object[])new Object[]{this.connectionProvider, this.dialect});
    }

    @Test
    public void testWhitelist() throws Exception {
        HashSet<String> whitelist = new HashSet<String>(Arrays.asList("foo", "bar"));
        EasyMock.expect((Object)this.dialect.expressionBuilder()).andReturn((Object)ExpressionBuilder.create()).anyTimes();
        this.tableMonitorThread = new TableMonitorThread(this.dialect, this.connectionProvider, this.context, 100L, whitelist, null);
        this.expectTableNames(LIST_FOO_BAR, this.shutdownThread());
        EasyMock.replay((Object[])new Object[]{this.connectionProvider, this.dialect});
        this.tableMonitorThread.start();
        this.tableMonitorThread.join();
        this.checkTableNames("foo", "bar").execute();
        EasyMock.verify((Object[])new Object[]{this.connectionProvider, this.dialect});
    }

    @Test
    public void testBlacklist() throws Exception {
        HashSet<String> blacklist = new HashSet<String>(Arrays.asList("bar", "baz"));
        EasyMock.expect((Object)this.dialect.expressionBuilder()).andReturn((Object)ExpressionBuilder.create()).anyTimes();
        this.tableMonitorThread = new TableMonitorThread(this.dialect, this.connectionProvider, this.context, 100L, null, blacklist);
        this.expectTableNames(LIST_FOO_BAR_BAZ, this.shutdownThread());
        EasyMock.replay((Object[])new Object[]{this.connectionProvider, this.dialect});
        this.tableMonitorThread.start();
        this.tableMonitorThread.join();
        this.checkTableNames("foo").execute();
        EasyMock.verify((Object[])new Object[]{this.connectionProvider, this.dialect});
    }

    @Test
    public void testReconfigOnUpdate() throws Exception {
        EasyMock.expect((Object)this.dialect.expressionBuilder()).andReturn((Object)ExpressionBuilder.create()).anyTimes();
        this.tableMonitorThread = new TableMonitorThread(this.dialect, this.connectionProvider, this.context, 100L, null, null);
        this.expectTableNames(LIST_FOO, new Op[0]);
        this.expectTableNames(LIST_FOO, this.checkTableNames("foo"));
        this.expectTableNames(LIST_FOO_BAR, new Op[0]);
        this.context.requestTaskReconfiguration();
        EasyMock.expectLastCall();
        this.expectTableNames(LIST_FOO, this.checkTableNames("foo", "bar"), this.shutdownThread());
        this.context.requestTaskReconfiguration();
        EasyMock.expectLastCall();
        EasyMock.replay((Object[])new Object[]{this.connectionProvider, this.dialect});
        this.tableMonitorThread.start();
        this.tableMonitorThread.join();
        this.checkTableNames("foo").execute();
        EasyMock.verify((Object[])new Object[]{this.connectionProvider, this.dialect});
    }

    @Test
    public void testInvalidConnection() throws Exception {
        this.tableMonitorThread = new TableMonitorThread(this.dialect, this.connectionProvider, this.context, 100L, null, null);
        EasyMock.expect((Object)this.connectionProvider.getConnection()).andAnswer((IAnswer)new IAnswer<Connection>(){

            public Connection answer() throws Throwable {
                TableMonitorThreadTest.this.tableMonitorThread.shutdown();
                throw new ConnectException("Simulated error with the db.");
            }
        });
        this.connectionProvider.close();
        EasyMock.expectLastCall().anyTimes();
        EasyMock.replay((Object[])new Object[]{this.connectionProvider});
        this.tableMonitorThread.start();
        this.tableMonitorThread.join();
        EasyMock.verify((Object[])new Object[]{this.connectionProvider});
    }

    @Test(expected=ConnectException.class)
    public void testDuplicates() throws Exception {
        EasyMock.expect((Object)this.dialect.expressionBuilder()).andReturn((Object)ExpressionBuilder.create()).anyTimes();
        this.tableMonitorThread = new TableMonitorThread(this.dialect, this.connectionProvider, this.context, 100L, null, null);
        this.expectTableNames(LIST_DUP_WITH_ALL, this.shutdownThread());
        EasyMock.replay((Object[])new Object[]{this.connectionProvider, this.dialect});
        this.tableMonitorThread.start();
        this.tableMonitorThread.join();
        this.tableMonitorThread.tables();
        EasyMock.verify((Object[])new Object[]{this.connectionProvider, this.dialect});
    }

    @Test(expected=ConnectException.class)
    public void testDuplicateWithUnqualifiedWhitelist() throws Exception {
        HashSet<String> whitelist = new HashSet<String>(Arrays.asList("dup"));
        EasyMock.expect((Object)this.dialect.expressionBuilder()).andReturn((Object)ExpressionBuilder.create()).anyTimes();
        this.tableMonitorThread = new TableMonitorThread(this.dialect, this.connectionProvider, this.context, 100L, whitelist, null);
        this.expectTableNames(LIST_DUP_ONLY, this.shutdownThread());
        EasyMock.replay((Object[])new Object[]{this.connectionProvider, this.dialect});
        this.tableMonitorThread.start();
        this.tableMonitorThread.join();
        this.tableMonitorThread.tables();
        EasyMock.verify((Object[])new Object[]{this.connectionProvider, this.dialect});
    }

    @Test(expected=ConnectException.class)
    public void testDuplicateWithUnqualifiedBlacklist() throws Exception {
        HashSet<String> blacklist = new HashSet<String>(Arrays.asList("foo"));
        EasyMock.expect((Object)this.dialect.expressionBuilder()).andReturn((Object)ExpressionBuilder.create()).anyTimes();
        this.tableMonitorThread = new TableMonitorThread(this.dialect, this.connectionProvider, this.context, 100L, null, blacklist);
        this.expectTableNames(LIST_DUP_WITH_ALL, this.shutdownThread());
        EasyMock.replay((Object[])new Object[]{this.connectionProvider, this.dialect});
        this.tableMonitorThread.start();
        this.tableMonitorThread.join();
        this.tableMonitorThread.tables();
        EasyMock.verify((Object[])new Object[]{this.connectionProvider, this.dialect});
    }

    @Test
    public void testDuplicateWithQualifiedWhitelist() throws Exception {
        HashSet<String> whitelist = new HashSet<String>(Arrays.asList("dup1.dup", "foo"));
        EasyMock.expect((Object)this.dialect.expressionBuilder()).andReturn((Object)ExpressionBuilder.create()).anyTimes();
        this.tableMonitorThread = new TableMonitorThread(this.dialect, this.connectionProvider, this.context, 100L, whitelist, null);
        this.expectTableNames(LIST_DUP_WITH_ALL, this.shutdownThread());
        EasyMock.replay((Object[])new Object[]{this.connectionProvider, this.dialect});
        this.tableMonitorThread.start();
        this.tableMonitorThread.join();
        this.checkTableIds(DUP1, FOO);
        EasyMock.verify((Object[])new Object[]{this.connectionProvider, this.dialect});
    }

    @Test
    public void testDuplicateWithQualifiedBlacklist() throws Exception {
        HashSet<String> blacklist = new HashSet<String>(Arrays.asList("dup1.dup", "foo"));
        EasyMock.expect((Object)this.dialect.expressionBuilder()).andReturn((Object)ExpressionBuilder.create()).anyTimes();
        this.tableMonitorThread = new TableMonitorThread(this.dialect, this.connectionProvider, this.context, 100L, null, blacklist);
        this.expectTableNames(LIST_DUP_WITH_ALL, this.shutdownThread());
        EasyMock.replay((Object[])new Object[]{this.connectionProvider, this.dialect});
        this.tableMonitorThread.start();
        this.tableMonitorThread.join();
        this.checkTableIds(DUP2, BAR, BAZ);
        EasyMock.verify((Object[])new Object[]{this.connectionProvider, this.dialect});
    }

    protected Op shutdownThread() {
        return new Op(){

            @Override
            public void execute() {
                TableMonitorThreadTest.this.tableMonitorThread.shutdown();
            }
        };
    }

    protected Op checkTableNames(final String ... expectedTableNames) {
        return new Op(){

            @Override
            public void execute() {
                ArrayList<TableId> expectedTableIds = new ArrayList<TableId>();
                for (String expectedTableName : expectedTableNames) {
                    TableId id = new TableId(null, null, expectedTableName);
                    expectedTableIds.add(id);
                }
                Assert.assertEquals(expectedTableIds, (Object)TableMonitorThreadTest.this.tableMonitorThread.tables());
            }
        };
    }

    protected void checkTableIds(TableId ... expectedTables) {
        Assert.assertEquals(Arrays.asList(expectedTables), (Object)this.tableMonitorThread.tables());
    }

    protected void expectTableNames(final List<TableId> expectedTableIds, final Op ... operations) throws SQLException {
        EasyMock.expect((Object)this.connectionProvider.getConnection()).andReturn((Object)this.connection);
        EasyMock.expect((Object)this.dialect.tableIds((Connection)EasyMock.eq((Object)this.connection))).andAnswer((IAnswer)new IAnswer<List<TableId>>(){

            public List<TableId> answer() throws Throwable {
                if (operations != null) {
                    for (Op op : operations) {
                        op.execute();
                    }
                }
                return expectedTableIds;
            }
        });
    }

    private static interface Op {
        public void execute();
    }
}

