/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.jdbc.source;

import io.confluent.connect.jdbc.source.JdbcSourceConnectorConfig;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class NumericMappingConfigTest {
    private Map<String, String> props;
    @Parameterized.Parameter(value=0)
    public JdbcSourceConnectorConfig.NumericMapping expected;
    @Parameterized.Parameter(value=1)
    public boolean precisionMapping;
    @Parameterized.Parameter(value=2)
    public String extendedMapping;

    @Parameterized.Parameters
    public static Iterable<Object[]> mapping() {
        return Arrays.asList({JdbcSourceConnectorConfig.NumericMapping.NONE, false, null}, {JdbcSourceConnectorConfig.NumericMapping.NONE, false, "none"}, {JdbcSourceConnectorConfig.NumericMapping.NONE, false, "NONE"}, {JdbcSourceConnectorConfig.NumericMapping.PRECISION_ONLY, false, "precision_only"}, {JdbcSourceConnectorConfig.NumericMapping.PRECISION_ONLY, false, "PRECISION_ONLY"}, {JdbcSourceConnectorConfig.NumericMapping.BEST_FIT, false, "best_fit"}, {JdbcSourceConnectorConfig.NumericMapping.BEST_FIT, false, "BEST_FIT"}, {JdbcSourceConnectorConfig.NumericMapping.PRECISION_ONLY, true, null}, {JdbcSourceConnectorConfig.NumericMapping.NONE, true, "none"}, {JdbcSourceConnectorConfig.NumericMapping.NONE, true, "NONE"}, {JdbcSourceConnectorConfig.NumericMapping.PRECISION_ONLY, true, "precision_only"}, {JdbcSourceConnectorConfig.NumericMapping.PRECISION_ONLY, true, "PRECISION_ONLY"}, {JdbcSourceConnectorConfig.NumericMapping.BEST_FIT, true, "best_fit"}, {JdbcSourceConnectorConfig.NumericMapping.BEST_FIT, true, "BEST_FIT"});
    }

    @Before
    public void setup() throws Exception {
        this.props = new HashMap<String, String>();
    }

    @Test
    public void testNumericMapping() throws Exception {
        this.props.put("connection.url", "jdbc:foo:bar");
        this.props.put("mode", "bulk");
        this.props.put("topic.prefix", "test-");
        this.props.put("numeric.precision.mapping", String.valueOf(this.precisionMapping));
        if (this.extendedMapping != null) {
            this.props.put("numeric.mapping", this.extendedMapping);
        }
        JdbcSourceConnectorConfig config = new JdbcSourceConnectorConfig(this.props);
        Assert.assertEquals((Object)this.expected, (Object)JdbcSourceConnectorConfig.NumericMapping.get((JdbcSourceConnectorConfig)config));
    }
}

