/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.jdbc.source;

import io.confluent.connect.jdbc.source.EmbeddedDerby;
import io.confluent.connect.jdbc.source.JdbcSourceConnectorConfig;
import io.confluent.connect.jdbc.source.JdbcSourceTask;
import io.confluent.connect.jdbc.source.MockTime;
import io.confluent.connect.jdbc.source.OffsetProtocols;
import io.confluent.connect.jdbc.util.TableId;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.connect.source.SourceTaskContext;
import org.apache.kafka.connect.storage.OffsetStorageReader;
import org.easymock.EasyMock;
import org.junit.After;
import org.junit.Before;
import org.powermock.api.easymock.annotation.Mock;

public class JdbcSourceTaskTestBase {
    protected static String SINGLE_TABLE_NAME = "test";
    protected static TableId SINGLE_TABLE_ID = new TableId(null, null, SINGLE_TABLE_NAME);
    protected static Map<String, String> SINGLE_TABLE_PARTITION = OffsetProtocols.sourcePartitionForProtocolV0((TableId)SINGLE_TABLE_ID);
    protected static Map<String, String> SINGLE_TABLE_PARTITION_WITH_VERSION = OffsetProtocols.sourcePartitionForProtocolV1((TableId)SINGLE_TABLE_ID);
    protected static EmbeddedDerby.TableName SINGLE_TABLE = new EmbeddedDerby.TableName(SINGLE_TABLE_NAME);
    protected static String SECOND_TABLE_NAME = "test2";
    protected static Map<String, Object> SECOND_TABLE_PARTITION = new HashMap<String, Object>();
    protected static EmbeddedDerby.TableName SECOND_TABLE;
    protected static String JOIN_TABLE_NAME;
    protected static Map<String, Object> JOIN_QUERY_PARTITION;
    protected static EmbeddedDerby.TableName JOIN_TABLE;
    protected static final String TOPIC_PREFIX = "test-";
    protected Time time;
    @Mock
    protected SourceTaskContext taskContext;
    protected JdbcSourceTask task;
    protected EmbeddedDerby db;
    @Mock
    private OffsetStorageReader reader;

    @Before
    public void setup() throws Exception {
        this.time = new MockTime();
        this.task = new JdbcSourceTask(this.time);
        this.db = new EmbeddedDerby();
    }

    @After
    public void tearDown() throws Exception {
        this.db.close();
        this.db.dropDatabase();
    }

    protected Map<String, String> singleTableConfig() {
        return this.singleTableConfig(false);
    }

    protected Map<String, String> singleTableConfig(boolean completeMapping) {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("connection.url", this.db.getUrl());
        props.put("tables", SINGLE_TABLE_NAME);
        props.put("mode", "bulk");
        props.put("topic.prefix", TOPIC_PREFIX);
        if (completeMapping) {
            props.put("numeric.mapping", JdbcSourceConnectorConfig.NumericMapping.BEST_FIT.toString());
        } else {
            props.put("numeric.precision.mapping", "true");
        }
        return props;
    }

    protected Map<String, String> twoTableConfig() {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("connection.url", this.db.getUrl());
        props.put("tables", SINGLE_TABLE_NAME + "," + SECOND_TABLE_NAME);
        props.put("mode", "bulk");
        props.put("topic.prefix", TOPIC_PREFIX);
        return props;
    }

    protected <T> void expectInitialize(Collection<Map<String, T>> partitions, Map<Map<String, T>, Map<String, Object>> offsets) {
        EasyMock.expect((Object)this.taskContext.offsetStorageReader()).andReturn((Object)this.reader);
        EasyMock.expect((Object)this.reader.offsets((Collection)EasyMock.eq(partitions))).andReturn(offsets);
    }

    protected <T> void expectInitializeNoOffsets(Collection<Map<String, T>> partitions) {
        HashMap<Map<String, T>, Map<String, Object>> offsets = new HashMap<Map<String, T>, Map<String, Object>>();
        for (Map<String, T> partition : partitions) {
            offsets.put(partition, null);
        }
        this.expectInitialize(partitions, offsets);
    }

    protected void initializeTask() {
        this.task.initialize(this.taskContext);
    }

    static {
        SECOND_TABLE_PARTITION.put("table", SECOND_TABLE_NAME);
        SECOND_TABLE = new EmbeddedDerby.TableName(SECOND_TABLE_NAME);
        JOIN_TABLE_NAME = "users";
        JOIN_QUERY_PARTITION = new HashMap<String, Object>();
        JOIN_QUERY_PARTITION.put("query", "query");
        JOIN_TABLE = new EmbeddedDerby.TableName(JOIN_TABLE_NAME);
    }
}

