/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.jdbc.source;

import io.confluent.connect.jdbc.dialect.DatabaseDialect;
import io.confluent.connect.jdbc.source.JdbcSourceTask;
import io.confluent.connect.jdbc.source.JdbcSourceTaskTestBase;
import io.confluent.connect.jdbc.util.CachedConnectionProvider;
import java.sql.Connection;
import java.util.List;
import java.util.Map;
import org.apache.kafka.connect.errors.ConnectException;
import org.apache.kafka.connect.source.SourceRecord;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.powermock.api.easymock.PowerMock;
import org.powermock.api.easymock.annotation.Mock;
import org.powermock.core.classloader.annotations.PowerMockIgnore;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={JdbcSourceTask.class})
@PowerMockIgnore(value={"javax.management.*"})
public class JdbcSourceTaskLifecycleTest
extends JdbcSourceTaskTestBase {
    @Mock
    private CachedConnectionProvider mockCachedConnectionProvider;
    @Mock
    private Connection conn;

    @Test(expected=ConnectException.class)
    public void testMissingParentConfig() {
        Map<String, String> props = this.singleTableConfig();
        props.remove("connection.url");
        this.task.start(props);
    }

    @Test(expected=ConnectException.class)
    public void testMissingTables() {
        Map<String, String> props = this.singleTableConfig();
        props.remove("tables");
        this.task.start(props);
    }

    @Test
    public void testStartStop() throws Exception {
        PowerMock.expectNew(CachedConnectionProvider.class, (Object[])new Object[]{EasyMock.anyObject(DatabaseDialect.class), EasyMock.eq((int)3), EasyMock.eq((long)10000L)}).andReturn((Object)this.mockCachedConnectionProvider);
        EasyMock.expect((Object)this.mockCachedConnectionProvider.getConnection()).andReturn((Object)this.db.getConnection());
        this.mockCachedConnectionProvider.close();
        PowerMock.expectLastCall();
        PowerMock.replayAll((Object[])new Object[0]);
        this.task.start(this.singleTableConfig());
        this.task.stop();
        PowerMock.verifyAll();
    }

    @Test
    public void testPollInterval() throws Exception {
        this.db.createTable(SINGLE_TABLE_NAME, "id", "INT");
        this.db.insert(SINGLE_TABLE_NAME, "id", 1);
        long startTime = this.time.milliseconds();
        this.task.start(this.singleTableConfig());
        this.task.poll();
        Assert.assertEquals((long)startTime, (long)this.time.milliseconds());
        this.task.poll();
        Assert.assertEquals((long)(startTime + 5000L), (long)this.time.milliseconds());
        this.task.poll();
        Assert.assertEquals((long)(startTime + 10000L), (long)this.time.milliseconds());
        this.task.stop();
    }

    @Test
    public void testSingleUpdateMultiplePoll() throws Exception {
        this.db.createTable(SINGLE_TABLE_NAME, "id", "INT");
        Map<String, String> taskConfig = this.singleTableConfig();
        taskConfig.put("batch.max.rows", "1");
        long startTime = this.time.milliseconds();
        this.task.start(taskConfig);
        this.db.insert(SINGLE_TABLE_NAME, "id", 1);
        this.db.insert(SINGLE_TABLE_NAME, "id", 2);
        List records = this.task.poll();
        Assert.assertEquals((long)startTime, (long)this.time.milliseconds());
        Assert.assertEquals((long)1L, (long)records.size());
        records = this.task.poll();
        Assert.assertEquals((long)startTime, (long)this.time.milliseconds());
        Assert.assertEquals((long)1L, (long)records.size());
        this.task.poll();
        Assert.assertEquals((long)(startTime + 5000L), (long)this.time.milliseconds());
    }

    @Test
    public void testMultipleTables() throws Exception {
        this.db.createTable(SINGLE_TABLE_NAME, "id", "INT");
        this.db.createTable(SECOND_TABLE_NAME, "id", "INT");
        long startTime = this.time.milliseconds();
        this.task.start(this.twoTableConfig());
        this.db.insert(SINGLE_TABLE_NAME, "id", 1);
        this.db.insert(SECOND_TABLE_NAME, "id", 2);
        List records = this.task.poll();
        Assert.assertEquals((long)startTime, (long)this.time.milliseconds());
        Assert.assertEquals((long)1L, (long)records.size());
        Assert.assertEquals((Object)SINGLE_TABLE_PARTITION, (Object)((SourceRecord)records.get(0)).sourcePartition());
        records = this.task.poll();
        Assert.assertEquals((long)startTime, (long)this.time.milliseconds());
        Assert.assertEquals((long)1L, (long)records.size());
        Assert.assertEquals((Object)SECOND_TABLE_PARTITION, (Object)((SourceRecord)records.get(0)).sourcePartition());
        records = this.task.poll();
        Assert.assertEquals((long)(startTime + 5000L), (long)this.time.milliseconds());
        JdbcSourceTaskLifecycleTest.validatePollResultTable(records, 1, SINGLE_TABLE_NAME);
        records = this.task.poll();
        Assert.assertEquals((long)(startTime + 5000L), (long)this.time.milliseconds());
        JdbcSourceTaskLifecycleTest.validatePollResultTable(records, 1, SECOND_TABLE_NAME);
    }

    @Test
    public void testMultipleTablesMultiplePolls() throws Exception {
        List records;
        int i;
        this.db.createTable(SINGLE_TABLE_NAME, "id", "INT");
        this.db.createTable(SECOND_TABLE_NAME, "id", "INT");
        Map<String, String> taskConfig = this.twoTableConfig();
        taskConfig.put("batch.max.rows", "1");
        long startTime = this.time.milliseconds();
        this.task.start(taskConfig);
        this.db.insert(SINGLE_TABLE_NAME, "id", 1);
        this.db.insert(SINGLE_TABLE_NAME, "id", 2);
        this.db.insert(SECOND_TABLE_NAME, "id", 3);
        this.db.insert(SECOND_TABLE_NAME, "id", 4);
        for (i = 0; i < 2; ++i) {
            records = this.task.poll();
            Assert.assertEquals((long)startTime, (long)this.time.milliseconds());
            JdbcSourceTaskLifecycleTest.validatePollResultTable(records, 1, SINGLE_TABLE_NAME);
        }
        for (i = 0; i < 2; ++i) {
            records = this.task.poll();
            Assert.assertEquals((long)startTime, (long)this.time.milliseconds());
            JdbcSourceTaskLifecycleTest.validatePollResultTable(records, 1, SECOND_TABLE_NAME);
        }
        for (i = 0; i < 2; ++i) {
            records = this.task.poll();
            Assert.assertEquals((long)(startTime + 5000L), (long)this.time.milliseconds());
            JdbcSourceTaskLifecycleTest.validatePollResultTable(records, 1, SINGLE_TABLE_NAME);
        }
        for (i = 0; i < 2; ++i) {
            records = this.task.poll();
            Assert.assertEquals((long)(startTime + 5000L), (long)this.time.milliseconds());
            JdbcSourceTaskLifecycleTest.validatePollResultTable(records, 1, SECOND_TABLE_NAME);
        }
    }

    private static void validatePollResultTable(List<SourceRecord> records, int expected, String table) {
        Assert.assertEquals((long)expected, (long)records.size());
        for (SourceRecord record : records) {
            Assert.assertEquals((Object)table, record.sourcePartition().get("table"));
        }
    }
}

