/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.jdbc.source;

import io.confluent.connect.jdbc.source.EmbeddedDerby;
import io.confluent.connect.jdbc.source.JdbcSourceTaskTestBase;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.TimeZone;
import javax.sql.rowset.serial.SerialBlob;
import org.apache.kafka.connect.data.Date;
import org.apache.kafka.connect.data.Decimal;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.data.Time;
import org.apache.kafka.connect.data.Timestamp;
import org.apache.kafka.connect.source.SourceRecord;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class JdbcSourceTaskConversionTest
extends JdbcSourceTaskTestBase {
    @Parameterized.Parameter
    public boolean extendedMapping;

    @Parameterized.Parameters
    public static Object[] mapping() {
        return new Object[]{false, true};
    }

    @Override
    @Before
    public void setup() throws Exception {
        super.setup();
        this.task.start(this.singleTableConfig(this.extendedMapping));
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.task.stop();
        super.tearDown();
    }

    @Test
    public void testBoolean() throws Exception {
        this.typeConversion("BOOLEAN", false, false, Schema.BOOLEAN_SCHEMA, false);
    }

    @Test
    public void testNullableBoolean() throws Exception {
        this.typeConversion("BOOLEAN", true, false, Schema.OPTIONAL_BOOLEAN_SCHEMA, false);
        this.typeConversion("BOOLEAN", true, null, Schema.OPTIONAL_BOOLEAN_SCHEMA, null);
    }

    @Test
    public void testSmallInt() throws Exception {
        this.typeConversion("SMALLINT", false, 1, Schema.INT16_SCHEMA, (short)1);
    }

    @Test
    public void testNullableSmallInt() throws Exception {
        this.typeConversion("SMALLINT", true, 1, Schema.OPTIONAL_INT16_SCHEMA, (short)1);
        this.typeConversion("SMALLINT", true, null, Schema.OPTIONAL_INT16_SCHEMA, null);
    }

    @Test
    public void testInt() throws Exception {
        this.typeConversion("INTEGER", false, 1, Schema.INT32_SCHEMA, 1);
    }

    @Test
    public void testNullableInt() throws Exception {
        this.typeConversion("INTEGER", true, 1, Schema.OPTIONAL_INT32_SCHEMA, 1);
        this.typeConversion("INTEGER", true, null, Schema.OPTIONAL_INT32_SCHEMA, null);
    }

    @Test
    public void testBigInt() throws Exception {
        this.typeConversion("BIGINT", false, Long.MAX_VALUE, Schema.INT64_SCHEMA, Long.MAX_VALUE);
    }

    @Test
    public void testNullableBigInt() throws Exception {
        this.typeConversion("BIGINT", true, Long.MAX_VALUE, Schema.OPTIONAL_INT64_SCHEMA, Long.MAX_VALUE);
        this.typeConversion("BIGINT", true, null, Schema.OPTIONAL_INT64_SCHEMA, null);
    }

    @Test
    public void testReal() throws Exception {
        this.typeConversion("REAL", false, 1, Schema.FLOAT32_SCHEMA, Float.valueOf(1.0f));
    }

    @Test
    public void testNullableReal() throws Exception {
        this.typeConversion("REAL", true, 1, Schema.OPTIONAL_FLOAT32_SCHEMA, Float.valueOf(1.0f));
        this.typeConversion("REAL", true, null, Schema.OPTIONAL_FLOAT32_SCHEMA, null);
    }

    @Test
    public void testDouble() throws Exception {
        this.typeConversion("DOUBLE", false, 1, Schema.FLOAT64_SCHEMA, 1.0);
    }

    @Test
    public void testNullableDouble() throws Exception {
        this.typeConversion("DOUBLE", true, 1, Schema.OPTIONAL_FLOAT64_SCHEMA, 1.0);
        this.typeConversion("DOUBLE", true, null, Schema.OPTIONAL_FLOAT64_SCHEMA, null);
    }

    @Test
    public void testChar() throws Exception {
        this.typeConversion("CHAR(5)", false, "a", Schema.STRING_SCHEMA, "a    ");
    }

    @Test
    public void testNullableChar() throws Exception {
        this.typeConversion("CHAR(5)", true, "a", Schema.OPTIONAL_STRING_SCHEMA, "a    ");
        this.typeConversion("CHAR(5)", true, null, Schema.OPTIONAL_STRING_SCHEMA, null);
    }

    @Test
    public void testVarChar() throws Exception {
        this.typeConversion("VARCHAR(5)", false, "a", Schema.STRING_SCHEMA, "a");
    }

    @Test
    public void testNullableVarChar() throws Exception {
        this.typeConversion("VARCHAR(5)", true, "a", Schema.OPTIONAL_STRING_SCHEMA, "a");
        this.typeConversion("VARCHAR(5)", true, null, Schema.OPTIONAL_STRING_SCHEMA, null);
    }

    @Test
    public void testBlob() throws Exception {
        this.typeConversion("BLOB(5)", false, new SerialBlob("a".getBytes()), Schema.BYTES_SCHEMA, "a".getBytes());
    }

    @Test
    public void testNullableBlob() throws Exception {
        this.typeConversion("BLOB(5)", true, new SerialBlob("a".getBytes()), Schema.OPTIONAL_BYTES_SCHEMA, "a".getBytes());
        this.typeConversion("BLOB(5)", true, null, Schema.OPTIONAL_BYTES_SCHEMA, null);
    }

    @Test
    public void testClob() throws Exception {
        this.typeConversion("CLOB(5)", false, "a", Schema.STRING_SCHEMA, "a");
    }

    @Test
    public void testNullableClob() throws Exception {
        this.typeConversion("CLOB(5)", true, "a", Schema.OPTIONAL_STRING_SCHEMA, "a");
        this.typeConversion("CLOB(5)", true, null, Schema.OPTIONAL_STRING_SCHEMA, null);
    }

    @Test
    public void testBinary() throws Exception {
        this.typeConversion("CHAR(5) FOR BIT DATA", false, "a".getBytes(), Schema.BYTES_SCHEMA, "a    ".getBytes());
    }

    @Test
    public void testNullableBinary() throws Exception {
        this.typeConversion("CHAR(5) FOR BIT DATA", true, "a".getBytes(), Schema.OPTIONAL_BYTES_SCHEMA, "a    ".getBytes());
        this.typeConversion("CHAR(5) FOR BIT DATA", true, null, Schema.OPTIONAL_BYTES_SCHEMA, null);
    }

    @Test
    public void testNumeric() throws Exception {
        this.typeConversion("NUMERIC(1)", false, new EmbeddedDerby.Literal("CAST (1 AS NUMERIC)"), Schema.INT8_SCHEMA, new Byte("1"));
        this.typeConversion("NUMERIC(3)", false, new EmbeddedDerby.Literal("CAST (123 AS NUMERIC)"), Schema.INT16_SCHEMA, new Short("123"));
        this.typeConversion("NUMERIC(5)", false, new EmbeddedDerby.Literal("CAST (12345 AS NUMERIC)"), Schema.INT32_SCHEMA, new Integer("12345"));
        this.typeConversion("NUMERIC(10)", false, new EmbeddedDerby.Literal("CAST (1234567890 AS NUMERIC(10))"), Schema.INT64_SCHEMA, new Long("1234567890"));
    }

    @Test
    public void testDecimal() throws Exception {
        this.typeConversion("DECIMAL(5,2)", false, new EmbeddedDerby.Literal("CAST (123.45 AS DECIMAL(5,2))"), Decimal.schema((int)2), new BigDecimal(new BigInteger("12345"), 2));
    }

    @Test
    public void testNullableDecimal() throws Exception {
        this.typeConversion("DECIMAL(5,2)", true, new EmbeddedDerby.Literal("CAST(123.45 AS DECIMAL(5,2))"), Decimal.builder((int)2).optional().build(), new BigDecimal(new BigInteger("12345"), 2));
        this.typeConversion("DECIMAL(5,2)", true, null, Decimal.builder((int)2).optional().build(), null);
    }

    @Test
    public void testDate() throws Exception {
        GregorianCalendar expected = new GregorianCalendar(1977, 1, 13, 0, 0, 0);
        expected.setTimeZone(TimeZone.getTimeZone("UTC"));
        this.typeConversion("DATE", false, "1977-02-13", Date.builder().build(), expected.getTime());
    }

    @Test
    public void testNullableDate() throws Exception {
        GregorianCalendar expected = new GregorianCalendar(1977, 1, 13, 0, 0, 0);
        expected.setTimeZone(TimeZone.getTimeZone("UTC"));
        this.typeConversion("DATE", true, "1977-02-13", Date.builder().optional().build(), expected.getTime());
        this.typeConversion("DATE", true, null, Date.builder().optional().build(), null);
    }

    @Test
    public void testTime() throws Exception {
        GregorianCalendar expected = new GregorianCalendar(1970, 0, 1, 23, 3, 20);
        expected.setTimeZone(TimeZone.getTimeZone("UTC"));
        this.typeConversion("TIME", false, "23:03:20", Time.builder().build(), expected.getTime());
    }

    @Test
    public void testNullableTime() throws Exception {
        GregorianCalendar expected = new GregorianCalendar(1970, 0, 1, 23, 3, 20);
        expected.setTimeZone(TimeZone.getTimeZone("UTC"));
        this.typeConversion("TIME", true, "23:03:20", Time.builder().optional().build(), expected.getTime());
        this.typeConversion("TIME", true, null, Time.builder().optional().build(), null);
    }

    @Test
    public void testTimestamp() throws Exception {
        GregorianCalendar expected = new GregorianCalendar(1977, 1, 13, 23, 3, 20);
        expected.setTimeZone(TimeZone.getTimeZone("UTC"));
        this.typeConversion("TIMESTAMP", false, "1977-02-13 23:03:20", Timestamp.builder().build(), expected.getTime());
    }

    @Test
    public void testNullableTimestamp() throws Exception {
        GregorianCalendar expected = new GregorianCalendar(1977, 1, 13, 23, 3, 20);
        expected.setTimeZone(TimeZone.getTimeZone("UTC"));
        this.typeConversion("TIMESTAMP", true, "1977-02-13 23:03:20", Timestamp.builder().optional().build(), expected.getTime());
        this.typeConversion("TIMESTAMP", true, null, Timestamp.builder().optional().build(), null);
    }

    private void typeConversion(String sqlType, boolean nullable, Object sqlValue, Schema convertedSchema, Object convertedValue) throws Exception {
        String sqlColumnSpec = sqlType;
        if (!nullable) {
            sqlColumnSpec = sqlColumnSpec + " NOT NULL";
        }
        this.db.createTable(SINGLE_TABLE_NAME, "id", sqlColumnSpec);
        this.db.insert(SINGLE_TABLE_NAME, "id", sqlValue);
        List records = this.task.poll();
        this.validateRecords(records, convertedSchema, convertedValue);
        this.db.dropTable(SINGLE_TABLE_NAME);
    }

    private void validateRecords(List<SourceRecord> records, Schema expectedFieldSchema, Object expectedValue) {
        Assert.assertEquals((long)1L, (long)records.size());
        Object objValue = records.get(0).value();
        Assert.assertTrue((boolean)(objValue instanceof Struct));
        Struct value = (Struct)objValue;
        Schema schema = value.schema();
        Assert.assertEquals((Object)Schema.Type.STRUCT, (Object)schema.type());
        List fields = schema.fields();
        Assert.assertEquals((long)1L, (long)fields.size());
        Schema fieldSchema = ((Field)fields.get(0)).schema();
        Assert.assertEquals((Object)expectedFieldSchema, (Object)fieldSchema);
        if (expectedValue instanceof byte[]) {
            Assert.assertTrue((boolean)(value.get((Field)fields.get(0)) instanceof byte[]));
            Assert.assertEquals((Object)ByteBuffer.wrap((byte[])expectedValue), (Object)ByteBuffer.wrap((byte[])value.get((Field)fields.get(0))));
        } else {
            Assert.assertEquals((Object)expectedValue, (Object)value.get((Field)fields.get(0)));
        }
    }
}

